<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <title>Group Network Configuration</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- CSS -->
        <link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
        
        <!-- Javascript -->
        <script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
    </head>

    <body>
        <div id="wrapper">
            <div id="page-wrapper">
                <div class="container-fluid">
                	<!-- Page Heading -->
					<div class="row page-title">
	                    <div class="col-lg-12">
	                        <h3 class="page-header">
	                            ${Name}
	                        </h3>
	                    </div>
	                </div>
					<!-- /.row -->
					<br>
                    <sec:authorize access="hasAnyRole(${Access_Configuration})">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4><spring:message code="NodeSetting1"/></h4>
                                </div>
                                <!-- /.panel-heading -->

                                <div class="panel-body">
                                    <div class="dataTable_wrapper">
                                    	<c:set var="xmltext">${XMLString}</c:set>
                    					<x:parse xml="${xmltext}" var="output"/>
                                        <table class="table table-striped table-bordered table-hover">
                                            <thead>
                                                <spring:message code="NodeNetwork1"/>
                                            </thead>
                                            <tbody>
                                                <x:set select="$output/NetworkConfiguration/ipv4" var="item1"/>
                                                <tr>
                                                    <td><button type="button" onclick="ipv4DHCPClicked()" class="btn btn-primary">DHCP</button></td>
                                                </tr>
                                            </tbody>
                                        </table>
										
										<div id="groupIPv6">
	                                        <table class="table table-striped table-bordered table-hover">
	                                            <thead>
	                                                <spring:message code="NodeNetwork2"/>
	                                            </thead>
	                                            <tbody>
	                                                <x:set select="$output/NetworkConfiguration/ipv6" var="item2"/>
	                                                <tr>
	                                                    <td><button type="button" onclick="ipv6DHCPClicked()" class="btn btn-primary">DHCP</button></td>
	                                                </tr>
	                                            </tbody>
	                                        </table>
                                        </div>
                                    </div>
                                    <!-- /.dataTable_wrapper -->
                                </div>
                                <!-- /.panel-body -->
                            </div>
                            <!-- /.panel -->
                        </div>
                        <!-- /.col-lg-12 -->
                    </div>
                    <!-- /.row -->
                    </sec:authorize>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- /#page-wrapper -->
        </div>
        <!-- /#wrapper -->
		
        <script>
	        $(document).ready(function() {
				if("${RackType}" != "")
					checkGroup("${RackType}");
			});
	        
	        function checkGroup(type) {
				if((type == "Standard with CMM") || (type == "Standard with CMC")) {
					$("#groupIPv6").css("display", "none");
				}
			}
	        
            function ipv4DHCPClicked() {
                var ipv4Paras = "&ipv4DHCPEnable=" + "true";
                var ipv6Paras = "&ipv6DHCPEnable=" + "false";
                window.location.href = "./SetGroupNetwork?ID=" + '${ID}' + ipv4Paras + ipv6Paras + "&Filter=GroupList";
            }

            function ipv6DHCPClicked() {
                var ipv4Paras = "&ipv4DHCPEnable=" + "false";
                var ipv6Paras = "&ipv6DHCPEnable=" + "true";
                window.location.href = "./SetGroupNetwork?ID=" + '${ID}' + ipv4Paras + ipv6Paras + "&Filter=GroupList";
            }
        </script>
    </body>
</html>