<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Monitoring</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-datetimepicker.css" />" rel="stylesheet">
    <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/raphael.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/moment.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-datetimepicker.js" />"></script>
	<script src="<c:url value="/resources/js/Chart.min.js" />"></script>
	
	<style>
		.detailText {
			text-align: left;
			margin-right: 34px;
			display: inline;
		}
		.detailSwitch {
			position: relative;
			display: inline-block;
			width: 32px;
			height: 18px;
		}
		.detailSwitch input {
			display:none;
		}
		.detailSlider {
			position: absolute;
			cursor: pointer;
			top: 0;
			left: 0;
			right: 0;
			bottom: 0;
			background-color: #ccc;
			-webkit-transition: .4s;
			transition: .4s;
			border-radius: 34px;
		}
		.detailSlider:before {
			position: absolute;
			content: "";
			height: 14px;
			width: 14px;
			left: 2px;
			bottom: 2px;
			background-color: white;
			-webkit-transition: .4s;
			transition: .4s;
			border-radius: 50%;
		}
		input:checked + .detailSlider {
			background-color: #337ab7;
		}
		input:focus + .detailSlider {
			box-shadow: 0 0 1px #337ab7;
		}
		input:checked + .detailSlider:before {
			-webkit-transform: translateX(14px);
			-ms-transform: translateX(14px);
			transform: translateX(14px);
		}
		.modal-process-dialog {
			margin-top: 260px !important;
			width: 95px !important;
		}
	</style>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
                
				<br>
				
				<div class="row" id="sdrBlock">
					<div class="col-lg-12">
						<div class="panel panel-default" id="summaryPanel">
							<div class="panel-heading">
								<div class="row">
									<div class="col-sm-1">
										<h4 class="panel-title"><i class="fa fa-bar-chart-o fa-fw"></i>SDR</h4>
									</div>
								</div>
							</div>
							<div class="panel-body">
								<table class="table table-striped table-bordered table-hover dt-responsive" id="sdrSummaryDataTable" width="100%">
									<thead>
										<tr>
											<th><spring:message code="Status"/></th>
											<th><spring:message code="Sensortype"/></th>
											<th></th>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
							</div>
						</div>
						<div class="panel panel-default" id="detailPanel">
							<div class="panel-heading">
								<div class="row">
									<div class="col-sm-1">
										<h4 class="panel-title"><i class="fa fa-bar-chart-o fa-fw"></i>SDR</h4>
									</div>
									<div style="float:right" align="right">
										<p class="detailText" id="sdrDetailText">Show detail</p>
									</div>
									<div class="col-sm-1" style="float:right" align="right">
										<label class="detailSwitch">
											<input type="checkbox" id="sdrDetailSwitch">
											<span class="detailSlider"></span>
										</label>
									</div>
									<div style="float:right" align="right">
										<select id="sel_sensor_type_filter">
											<option id="sensor_type_default" value="" selected="selected">Show all</option>
											<option id="sensor_type_voltage" value="Voltage">Voltage</option>
											<option id="sensor_type_fan" value="Fan">Fan</option>
											<option id="sensor_type_temperature" value="Temperature">Temperature</option>
											<option id="sensor_type_current" value="Current">Current</option>
										</select>
									</div>
									<div style="float:right" align="right">
										<p class="typeText" id="sdrTypeText">Sensor Type:</p>
									</div>
								</div>
							</div>
							<div class="panel-body">
								<table class="table table-striped table-bordered table-hover dt-responsive" id="sdrDataTable" width="100%">
									<thead>
										<tr style="font-weight:bold;">
											<td><spring:message code="Status"/></td>
											<td><spring:message code="ProbeName"/></td>
											<td><spring:message code="Reading"/></td>
											<td style="display:none"><spring:message code="Sensortype"/></td>
											<td><spring:message code="LowerNonCritical"/></td>
											<td><spring:message code="UpperNonCritical"/></td>
											<td><spring:message code="LowerCritical"/></td>
											<td><spring:message code="UpperCritical"/></td>
											<td><spring:message code="LowerNonRecoverable"/></td>
											<td><spring:message code="UpperNonRecoverable"/></td>
											<td></td>
											<td></td>
										</tr>
									</thead>
									<tbody>
									</tbody>
								</table>
								<button type="button" onclick="sdrSummaryDisplay()" class="btn btn-primary">Back</button>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row" id="monitorBlock">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title"><i class="fa fa-bar-chart-o fa-fw"></i><spring:message code="SensorMonitor"/> - <span id="typeStr"></span></h4>
							</div>
							<div class="panel-body">
								<button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
									<i class="fa fa-gear"></i>
								</button>
								<div class="collapse" id="collapseExample">
									<div class="well">
										<div class="row">
											<div id="sdrChartTypeRadio" class="col-xs-6 col-sm-4 col-md-2 col-lg-2">
												<p><spring:message code="Category"/>:</p>
												<div class="radio">
													<label><input type="radio" id="fan" sdrtype="Fan" name="selectType" checked><i class="fa fa-asterisk fa-spin"></i><spring:message code="fan"/></label>
												</div>
												<div class="radio">
													<label><input type="radio" id="temp" sdrtype="Temperature" name="selectType"><i class="fa fa-signal"></i><spring:message code="temp"/></label>
												</div>	
												<div class="radio">
													<label><input type="radio" id="volt" sdrtype="Voltage" name="selectType"><i class="fa fa-plug"></i><spring:message code="voltage"/></label>
												</div>
												<div class="radio">
													<label><input type="radio" id="current" sdrtype="Current" name="selectType"><i class="fa fa-bolt"></i><i class="fa fa-bolt"></i><spring:message code="current"/></label>
												</div>
											</div>
											
											<div class="col-xs-6 col-sm-4 col-md-2 col-lg-2"> 
												<div>
													<p><spring:message code="Display"/>:</p>  
													<select id="sdrChartRangeOption" class="form-control">
														<option value="5"><spring:message code="year"/></option>
														<option value="4"><spring:message code="month"/></option>
														<option value="3"><spring:message code="week"/></option>
														<option value="2"><spring:message code="day"/></option>
														<option value="1" selected><spring:message code="hour"/></option>
														<option value="0"><spring:message code="manual"/></option>
													</select>
												</div>
												<br>
												<div>
													<spring:message code="Refresh"/>:
													<input type=checkbox id="sdrChartRefresh" data-size="mini" class="form-control">
												</div>
											</div>
											
											<div class="col-xs-12 col-sm-4 col-md-4 col-lg-4">
												<div class="form-group">
													<p><spring:message code="Manualdate"/>:</p>
													<div class='input-group date' id='monitorDateTimePickerStart'>
														<input type='text' class="form-control" id="monitorDateTimePickerStartValue"/>
														<span class="input-group-addon"><span class="fa fa-calendar"></span></span>
													</div>
													<div class="input-group date">
														<span class="input-group-addon"><span class="fa fa-arrow-down"></span></span>
													</div>
													<div class="input-group date" id="monitorDateTimePickerEnd">
														<input type="text" class="form-control" id="monitorDateTimePickerEndValue"/>
														<span class="input-group-addon"><span class="fa fa-calendar"></span></span>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div style="width:100%; height:300px;">
										<canvas id="chart-area-chart"></canvas>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div id="phyInformation" class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<div style="display:inline-block;">
									<h4 class="panel-title"><i class="fa fa-bar-chart-o fa-fw"></i>BP Status&nbsp;-&nbsp;ID:&nbsp;</h4>
								</div>
								<div style="display:inline-block;">
									<select id="phyOption" class="form-control" style="height:26px; padding:4px 5px 5px 5px; font-size:13px;" disabled>
									</select>
								</div>
							</div>
							<div class="panel-body">
								<table class="table table-striped table-bordered table-hover dt-responsive" id="phyDataTables" width="100%">
									<thead>
										<tr>
											<th>DeviceName</th>
											<th>PHYID</th>
											<th>LinkSpeed</th>
											<th>DeviceType</th>
											<th>InvWrdCnt</th>
											<th>DispErrCnt</th>
											<th>LossSyncCnt</th>
											<th>RstSeqFailCnt</th>
											<th>RAIDStatus</th>
										</tr>
									</thead>
									<tbody id="phyDataTBody">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row" id="powerStatusBlock" style="display:none;">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<div style="display:inline-block;">
									<h4 class="panel-title"><spring:message code="Nodelist6"/></h4>
								</div>
							</div>
							<div class="panel-body">
								<spring:message code="webErrMsg28"/>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div> 
	
	<div class="modal fade" id="processModal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog modal-process-dialog" role="document">
			<div class="modal-content">
				<div class="alert">
					<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		var bmcIP = "${IP}";
		
		var sdrSummaryDataTable;
		var sdrDataTable;
		
		var phyDataTable;
		var phyLatestData;
		
		var sdrChartStartTime = "";
		var sdrChartEndTime = "";
		var sdrChartMinPeriod = Date.now();
        var sdrChartMaxPeriod = 0;
		var sdrChartLatestData;
		var sdrChartSelectedType = "Fan";
		var sdrChartSelectedRange = 1;
		var sdrChartRefreshEnabled = true;
		var sdrChartRefreshInterval = 10000;
		var sdrChartjsChart;
		var sdrChartjsDatasetMap = {};
		var sdrChartjsColor = ['rgb(255, 99,  132)',
							   'rgb(255, 159, 64)',
							   'rgb(255, 205, 86)',
							   'rgb(75,  192, 192)',
							   'rgb(54,  162, 235)',
							   'rgb(153, 102, 255)',
							   'rgb(201, 203, 207)'];
		
		$(document).ready(function()
		{
			if(checkPowerStatus()) {
				checkNodeSupport();
				
				sdrSummaryDataTable = $('#sdrSummaryDataTable').DataTable({
					"searching": false, 
			        "bFilter": false,
			        "bSort": false,
			        "paging": false,
			        info: false,
			        responsive: true,
				});
				
				sdrDataTable = $('#sdrDataTable').DataTable({
			        info: false,
			        responsive: true,
			        "filter": true,
			        "scrollX": true,
			        "searching": true, 
			        "ordering": true,
					"aaSorting": [[ 1, "asc" ]],
			        "columnDefs": [{"targets": [10],
        							"visible": false,
        							"searchable": false},
        							{"targets": [4,5,6,7,8,9,11],
			        				"visible": false},
			        			    {"type": "html-input",
			        				"targets": [4,5,6,7,8,9,11]}],
       				"createdRow": function(row, data, dataIndex) {
       			    	$(row).find('td:eq(3)').css("display", "none");
       			    }
				});
				$("#detailPanel").hide();
				
				phyDataTable = $('#phyDataTables').DataTable({
			        info: false,
			        responsive: true,
			        "scrollX": true,
			        "order": []
				});
				
				getSdrData();
				
			    $('#monitorDateTimePickerStart').datetimepicker({
			    	showTodayButton : true,
			    	format : "YYYY-MM-DD HH:mm"
			    }).datetimepicker("setDate", new Date());
			    
			    $('#monitorDateTimePickerEnd').datetimepicker({
			    	showTodayButton : true,
			    	format : "YYYY-MM-DD HH:mm",
			    	useCurrent: false
			    });
				
		    	initSdrChartjsChart();
				$("#sdrChartRefresh").bootstrapSwitch('state', true);
		    	$("#sdrChartRangeOption").change();
		    	
		    	setTimeout(refreshSdrChartjsChart, sdrChartRefreshInterval);
			}
		});
		
		$("#sdrChartRefresh").on('switchChange.bootstrapSwitch', function()
		{
			sdrChartRefreshEnabled = $("#sdrChartRefresh").is(":checked");
		});
		
		$("#sdrDetailSwitch").click(function()
		{
			var table = $('#sdrDataTable').DataTable();
			if($("#sdrDetailSwitch").prop("checked")) {
				table.columns( [ 4, 5, 6, 7, 8, 9, 11 ] ).visible(true);
				$("#sdrDetailText").text("Hide detail");
			}
			else {
				table.columns( [ 4, 5, 6, 7, 8, 9, 11 ] ).visible(false);
				$("#sdrDetailText").text("Show detail");
			}
		});
		
		$("#sdrChartTypeRadio input[type=radio]").change(function()
		{
			sdrChartSelectedType = $(this).attr("sdrtype");
			updateSdrChartjsChart();
		});
		
		$("#sdrChartRangeOption").change(function()
		{
			sdrChartSelectedRange = this.value;
            sdrChartMaxPeriod = Date.now();
            sdrChartMinPeriod = Date.now();
			if(sdrChartSelectedRange == 0) {
				$('#monitorDateTimePickerStart').show();
				$('#monitorDateTimePickerEnd').show();
				$("#sdrChartRefresh").bootstrapSwitch('state', false);
				$("#sdrChartRefresh").bootstrapSwitch("disabled", true);
			}
			else {
				$("#sdrChartRefresh").bootstrapSwitch("disabled", false);
				$('#monitorDateTimePickerStart').hide();
				$('#monitorDateTimePickerEnd').hide();
				$('#monitorDateTimePickerStart').data("DateTimePicker").date(null);
				$('#monitorDateTimePickerEnd').data("DateTimePicker").date(null);
				$('#monitorDateTimePickerStartValue').val("");
				$('#monitorDateTimePickerEndValue').val("");
				sdrChartStartTime = "";
				sdrChartEndTime = "";
				updateSdrChartjsChart();
			}
		});
		
		$("#monitorDateTimePickerStart").on("dp.change", function(e)
		{
			sdrChartStartTime = new Date($('#monitorDateTimePickerStartValue').val()).valueOf();
            $('#monitorDateTimePickerEnd').data("DateTimePicker").minDate(e.date);
			
			if((sdrChartStartTime != "") && (sdrChartEndTime != ""))
				updateSdrChartjsChart();
		});
		
		$("#monitorDateTimePickerEnd").on("dp.change", function(e)
		{
			sdrChartEndTime = new Date($('#monitorDateTimePickerEndValue').val()).valueOf();
            $('#monitorDateTimePickerStart').data("DateTimePicker").maxDate(e.date);
			
			if((sdrChartStartTime != "") && (sdrChartEndTime != ""))
				updateSdrChartjsChart();
		});
		
		$("#sdrDataTable>tbody").delegate("input[type=text]", "keyup", function()
		{
			//Input value must be numeric
			this.value = this.value.replace(/[^0-9\.-]/g, '');
			
			//Check value
			var name = $(this).prop("name");
			var sensor = name.substr(name.lastIndexOf("_") + 1);
			var showBTN = false;
			if ($("input[name=lnc_"+ sensor +"]").prop("value") != $("input[name=lnc_"+ sensor +"]").prop("defaultValue")) {
				$("input[name=lnc_"+ sensor +"]").css('color','red');
				showBTN = true;
			}
			else {
				$("input[name=lnc_"+ sensor +"]").css('color','black');
			}
			if ($("input[name=unc_"+ sensor +"]").prop("value") != $("input[name=unc_"+ sensor +"]").prop("defaultValue")) {
				$("input[name=unc_"+ sensor +"]").css('color','red');
				showBTN = true;
			}
			else {
				$("input[name=unc_"+ sensor +"]").css('color','black');
			}
			if ($("input[name=lc_"+ sensor +"]").prop("value") != $("input[name=lc_"+ sensor +"]").prop("defaultValue")) {
				$("input[name=lc_"+ sensor +"]").css('color','red');
				showBTN = true;
			}
			else {
				$("input[name=lc_"+ sensor +"]").css('color','black');
			}
			if ($("input[name=uc_"+ sensor +"]").prop("value") != $("input[name=uc_"+ sensor +"]").prop("defaultValue")) {
				$("input[name=uc_"+ sensor +"]").css('color','red');
				showBTN = true;
			}
			else {
				$("input[name=uc_"+ sensor +"]").css('color','black');
			}
			if ($("input[name=lnr_"+ sensor +"]").prop("value") != $("input[name=lnr_"+ sensor +"]").prop("defaultValue")) {
				$("input[name=lnr_"+ sensor +"]").css('color','red');
				showBTN = true;
			}
			else {
				$("input[name=lnr_"+ sensor +"]").css('color','black');
			}
			if ($("input[name=unr_"+ sensor +"]").prop("value") != $("input[name=unr_"+ sensor +"]").prop("defaultValue")) {
				$("input[name=unr_"+ sensor +"]").css('color','red');
				showBTN = true;
			}
			else {
				$("input[name=unr_"+ sensor +"]").css('color','black');
			}

			if (showBTN) {
				$("button[name=setTHR_"+ sensor+"]").css('visibility','visible');
			}
			else {
				$("button[name=setTHR_"+ sensor+"]").css('visibility','hidden');
			}
		});
		
		$("#sel_sensor_type_filter").on("change", function(){
			filterSdrDataBySenserType();
		});
	    
	    function checkNodeSupport()
		{
			if('${JbodProduct}' == 'true')
				getPHYInfo();
			else
				$("#phyInformation").remove();
		}
		
		function checkPowerStatus()
		{
			if('${powerStatus}' == 'false') {
				$("#sdrBlock").remove();
				$("#monitorBlock").remove();
				$("#phyInformation").remove();
				$("#powerStatusBlock").show();
				
				return false;
			}
			
			return true;
		}
		
		function getSdrData()
		{
			sdrSummaryLoading(true);
			
			$.ajax({
		        url: 'getSDRInfo',
		        data: {nodeIP:'${IP}', dataType:'sdr'},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	if(_data != null) {
		        		var summaryArray = [];
		        		for(key in _data.Summary) {
		        			summaryArray.push([((_data.Summary[key] > 0) ? "NG" : "OK"),
						        				key,
				    		        			'<button name="viewBtn" type="button" class="btn btn-primary" onclick="sdrRowClick(\'' + key + '\')"> View </button>']);
		        		}
		        		
		        		var sdrArray = [];
		        		for(var i=0 ; i<_data.SDR.length ; i++) {
			        		sdrArray.push([_data.SDR[i].SensorStatus,
			        						_data.SDR[i].SensorName,
			    		        			_data.SDR[i].SensorReading,
			    		        			_data.SDR[i].SensorType,
			    		        			'<input type="text" name="lnc_' + _data.SDR[i].id + '"' + (_data.SDR[i].LNCsettable == 0 ? (disabled="disabled " + 'style="border:none;background-color:transparent;"') : "") + 'defaultValue="' + _data.SDR[i].LowerNonCritical + '" value="' + _data.SDR[i].LowerNonCritical + '">',
                                            '<input type="text" name="unc_' + _data.SDR[i].id + '"' + (_data.SDR[i].UNCsettable == 0 ? (disabled="disabled " + 'style="border:none;background-color:transparent;"') : "") + 'defaultValue="' + _data.SDR[i].UpperNonCritical + '" value="' + _data.SDR[i].UpperNonCritical + '">',
                                            '<input type="text" name="lc_' + _data.SDR[i].id + '"' + (_data.SDR[i].LCsettable == 0 ? (disabled="disabled " + 'style="border:none;background-color:transparent;"') : "") + 'defaultValue="' + _data.SDR[i].LowerCritical + '" value="' + _data.SDR[i].LowerCritical + '">',
                                            '<input type="text" name="uc_' + _data.SDR[i].id + '"' + (_data.SDR[i].UCsettable == 0 ? (disabled="disabled " + 'style="border:none;background-color:transparent;"') : "") + 'defaultValue="' + _data.SDR[i].UpperCritical + '" value="' + _data.SDR[i].UpperCritical + '">',
                                            '<input type="text" name="lnr_' + _data.SDR[i].id + '"' + (_data.SDR[i].LNRsettable == 0 ? (disabled="disabled " + 'style="border:none;background-color:transparent;"') : "") + 'defaultValue="' + _data.SDR[i].LowerNonRecoverable + '" value="' + _data.SDR[i].LowerNonRecoverable + '">',
                                            '<input type="text" name="unr_' + _data.SDR[i].id + '"' + (_data.SDR[i].UNRsettable == 0 ? (disabled="disabled " + 'style="border:none;background-color:transparent;"') : "") + 'defaultValue="' + _data.SDR[i].UpperNonRecoverable + '" value="' + _data.SDR[i].UpperNonRecoverable + '">',
                                            _data.SDR[i].id,
                                            '<button name="setTHR_' + _data.SDR[i].id + '" type="button" class="btn btn-primary" style="visibility:hidden;" onclick="setSensorThreshold(\'' + _data.SDR[i].id + '\')"> <spring:message code="Apply"/> </button>']);
                        }
		        		
		        		sdrSummaryLoading(false, {summaryArray: summaryArray, sdrArray: sdrArray});
		        	}
		        	else {
		        		sdrSummaryLoading(false);
		        	}
		        },
		        error: function(xhr, status, error) {
		        	sdrSummaryLoading(false);
		        	console.log("Get the SDR failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		function sdrSummaryLoading(start, dataObj)
		{
			if(start) {
				$("#sdrSummaryDataTable>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			}
			else {
				setTimeout(function(){
					if($("#sdrSummaryDataTable>tbody>tr>td").attr("colspan") == 4) {
						sdrSummaryDataTable.clear().draw(false);
						sdrDataTable.clear().draw(false);
					}
					if(dataObj != null){
						sdrSummaryDataTable.rows.add(dataObj.summaryArray).draw(false);
						sdrDataTable.rows.add(dataObj.sdrArray).draw(false);
					}
				}, 100);
			}
		}
		
		function initSdrChartjsChart()
		{
	  		sdrChartjsChart = new Chart(document.getElementById("chart-area-chart").getContext("2d"), {
	            type: 'line',
	            data: {
	                labels: [],
	                datasets: []
	            },
	            options: {
	                responsive: true,
					maintainAspectRatio: false,
	                legend: {
	                	display: false
	                },
	                title: {
	                    display: false
	                },
	                hover: {
	                    mode: 'point'
	                },
	                tooltips: {
	                	mode: 'point'
	                },
	                scales: {
	                    xAxes: [{
	                        display: true,
	                        type: "time",
	                        scaleLabel: {
	                            display: false
	                        },
	                        ticks: {
	                        },
	                        gridLines: {
	                        	display: false
	                        }
	                        ,time: {
	                        	unit: 'minutes',
	                        	stepSize: 1,
			                    displayFormats: {
			                    	'minutes': 'YYYY-MM-DD HH:mm',
			                    	'hours': 'YYYY-MM-DD HH:mm',
			                    	'days': 'YYYY-MM-DD',
			                    	'months': 'YYYY-MM-DD'
			                    }
	                        }
	                    }],
	                    yAxes: [{
	                        display: true,
	                        scaleLabel: {
	                            display: false
	                        },
	                        ticks: {
	                        	//min: 0
	                        },
	                        gridLines: {
	                        	display:true
	                        }
	                    }]
	                },
	                animation: false
	            }
	        });
		}
		
		function refreshSdrChartjsChart()
		{
			if(sdrChartRefreshEnabled)
				updateSdrChartjsChart();
			
			setTimeout(refreshSdrChartjsChart, sdrChartRefreshInterval);
		}
		
		function updateSdrChartjsChart()
		{
            //Avoid variables that are illegal
            if(isNaN(sdrChartStartTime)) {
                sdrChartStartTime = "";
                sdrChartEndTime = "";
            }
            
			$.ajax({
			    url: 'getSensorHistory',
			    data: {ip: bmcIP, start: sdrChartStartTime, end: sdrChartEndTime, type: sdrChartSelectedType, range: sdrChartSelectedRange},
			    dataType: 'json', 
			    success: function(_data, status, xhr) {
                    if(_data.data.length > 0) {
                        //Hide the none data part.
                        for(var i=0; i<_data.data.length ; i++) {
                            var dataObj = JSON.parse(_data.data[i]);
                            var tempPeriod = 0;
                            var dataChanged = false;
							
                            for(var data in dataObj) {
                                if(dataObj[data] == "-1") {
                                    dataObj[data] = null;
                                    dataChanged = true;
                                }
                                //Get the Minimum period
                                if ((data == "period") && (sdrChartSelectedRange != 0)) {
                                    tempPeriod = dataObj["period"];
                                    if (tempPeriod < sdrChartMinPeriod) {
                                    	sdrChartMinPeriod = tempPeriod;
                                    }
                                    else if(tempPeriod > sdrChartMaxPeriod) {
                                    	sdrChartMaxPeriod = tempPeriod;
                                    }
                                }
                            }
							
                            if(dataChanged)
                                _data.data[i] = JSON.stringify(dataObj);
                        }
						
                        var temp;
                        var diffPeriod = sdrChartMaxPeriod == 0 ? (Date.now() - sdrChartMinPeriod) : (sdrChartMaxPeriod - sdrChartMinPeriod);
                        sdrChartLatestData = JSON.parse(_data.data[0]);
                        for (var data in sdrChartLatestData) {
                            if (sdrChartLatestData[data] != null)
                                sdrChartLatestData[data] = null;
                        }
						
                        if (sdrChartSelectedRange == 1) {
                            if (diffPeriod < 3600000) {                         //1 hour
                                temp = 3600000 - (diffPeriod);
                                sdrChartLatestData["period"] = sdrChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(sdrChartLatestData)); 
                            }
                        }
                        else if (sdrChartSelectedRange == 2) {
                            if (diffPeriod < 86400000) {                        //1 day
                                temp = 86400000 - (diffPeriod);
                                sdrChartLatestData["period"] = sdrChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(sdrChartLatestData)); 
                            }
                        }
                         if (sdrChartSelectedRange == 3) {
                            if (diffPeriod < 604800000) {                       //1 week
                                temp = 604800000 - (diffPeriod);
                                sdrChartLatestData["period"] = sdrChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(sdrChartLatestData));
                            }
                        } 
                        else if (sdrChartSelectedRange == 4) {
                            if (diffPeriod < 2592000000) {                      //1 month
                                temp = 2592000000 - (diffPeriod);
                                sdrChartLatestData["period"] = sdrChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(sdrChartLatestData));
                            }
                        }
                        else if (sdrChartSelectedRange == 5) {
                            if (diffPeriod < 31557600000) {                     //1 year
                                temp = 31557600000 - (diffPeriod);
                                sdrChartLatestData["period"] = sdrChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(sdrChartLatestData));
                            }
                        }
						
                        setSdrChartjsChart(_data);
                        $("#typeStr").text(sdrChartSelectedType);
                    }
                    else {
                    	console.log("There is no SDR information data of ${IP} in the database.");
                    	if(sdrChartSelectedRange == 0) {
                    		setSdrChartjsChart({});
                    	}
                    }
			    },
				error: function(xhr, status, error) {
		            alert("<spring:message code="webAlert2"/>");
		            console.log("Get sensor history failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		  	});
		}
		
		function setSdrChartjsChart(dataset)
		{
			//Reset data
			sdrChartjsChart.config.data.datasets = [];
			sdrChartjsChart.config.data.labels = [];
			sdrChartjsDatasetMap = {};
			
			//Add new dataset config and label of each source data
			if('y_keys' in dataset) {
				var count = 0;
				for(var key in dataset.y_keys) {
		    		sdrChartjsChart.config.data.datasets.push({label:dataset.y_keys[key], borderColor:sdrChartjsColor[count%sdrChartjsColor.length], backgroundColor:sdrChartjsColor[count%sdrChartjsColor.length], data:[], fill:false});
		    		sdrChartjsDatasetMap[dataset.y_keys[key]] = count;
		    		count++;
	    		}
			}
			
			if('data' in dataset) {
				//Sort the source data by date
				dataset.data = dataset.data.sort(function(a, b) {
					a = JSON.parse(a);
					b = JSON.parse(b);
					return a.period > b.period ? 1 : -1;
				});
				
				//Add source data to dataset.
				for(var i=0; i<dataset.data.length ; i++) {
		    		var dataObj = JSON.parse(dataset.data[i]);
		    		
		    		for(var data in dataObj) {
			    		if(data == "period")
			    			sdrChartjsChart.config.data.labels.push(new Date(dataObj["period"]));
			    		else
			    			sdrChartjsChart.config.data.datasets[sdrChartjsDatasetMap[data]].data.push(dataObj[data]);
		    		}
		    	}
			}
			
			var sdrChartSelectedRangeTemp = -1;
			if((sdrChartSelectedRange == 0) && (sdrChartStartTime !== "") && (sdrChartEndTime !== "")) {
				sdrChartSelectedRangeTemp = sdrChartSelectedRange;
				var diffTime = sdrChartEndTime - sdrChartStartTime;
                if (diffTime >= 31557600000) { //year
                	sdrChartSelectedRange = 5;
                }
                else if (diffTime >= 2592000000) { //month
                	sdrChartSelectedRange = 4;
                }
                else if (diffTime >= 604800000) { //week
                	sdrChartSelectedRange = 3;
                }
                else if (diffTime >= 86400000) { //day
                	sdrChartSelectedRange = 2;
                }
        		else { //hour
        			sdrChartSelectedRange = 1;
                }
			}
			
			//Change the x-axis scale label unit and period
			switch(parseInt(sdrChartSelectedRange)) {
				default:
				//manual
				case 0:
				//hour
				case 1: {
					sdrChartjsChart.config.options.scales.xAxes[0].time.unit = "minutes";
					sdrChartjsChart.config.options.scales.xAxes[0].time.stepSize = 5;
					break;
				}
				//day
				case 2: {
					sdrChartjsChart.config.options.scales.xAxes[0].time.unit = "hours";
					sdrChartjsChart.config.options.scales.xAxes[0].time.stepSize = 1;
					break;
				}
				//week
				case 3: {
					sdrChartjsChart.config.options.scales.xAxes[0].time.unit = "days";
					sdrChartjsChart.config.options.scales.xAxes[0].time.stepSize = 1;
					break;
				}
				//month
				case 4: {
					sdrChartjsChart.config.options.scales.xAxes[0].time.unit = "days";
					sdrChartjsChart.config.options.scales.xAxes[0].time.stepSize = 2;
					break;
				}
				//year
				case 5: {
					sdrChartjsChart.config.options.scales.xAxes[0].time.unit = "months";
					sdrChartjsChart.config.options.scales.xAxes[0].time.stepSize = 1;
					break;
				}
			}
			
			if(sdrChartSelectedRangeTemp !== -1)
				sdrChartSelectedRange = sdrChartSelectedRangeTemp;
			
			sdrChartjsChart.update();
		}
		
		function getPHYInfo()
		{
			phyDataTable.row.add(['Loading...', '', '', '', '', '', '', '', '']).draw(false);
			
			$.ajax({
			    url: 'getPHYInfo',
			    data: {IP: bmcIP},
			    dataType: 'json', 
			    success: function(_data, status, xhr) {
			    	if(_data.JBOD == null) {
			    		phyDataTable.clear().draw(false);
			    	}
			    	else {
			    		phyLatestData = _data;
			    		
			    		//Default show data of ID 1.
			    		updatePhyDataTable("1");
			    		
			    		//Add option and change event.
			    		for(var i=0 ; i<phyLatestData.JBOD.length ; i++) {
			    			$("#phyOption").append('<option>' + phyLatestData.JBOD[i].BPID + '</option>');
			    		}
			    		$("#phyOption").attr('disabled', false);
			    		$("#phyOption").on("change", function() {
			    			updatePhyDataTable($("#phyOption option:selected").text());
			    		});
			    	}
			    },
			    error: function(xhr, status, error) {
			        console.log("Get PHY info failed: [" + xhr.status + "] " + xhr.statusText);
			    },
			    cache: false
		  	});
		}
		
		function updatePhyDataTable(id)
		{
			phyDataTable.clear().draw(false);
			
    		for(var i=0 ; i<phyLatestData.JBOD.length ; i++) {
    			for(var j=0 ; j<phyLatestData.JBOD[i].PHYInfo.length ; j++) {
    				if(phyLatestData.JBOD[i].BPID == id) {
    					phyDataTable.row.add([phyLatestData.JBOD[i].PHYInfo[j].DeviceName,
            			                      phyLatestData.JBOD[i].PHYInfo[j].PHYID,
            			                      phyLatestData.JBOD[i].PHYInfo[j].LinkSpeed,
            			                      phyLatestData.JBOD[i].PHYInfo[j].DeviceType,
            			                      phyLatestData.JBOD[i].PHYInfo[j].InvWrdCnt,
            			                      phyLatestData.JBOD[i].PHYInfo[j].DispErrCnt,
            			                      phyLatestData.JBOD[i].PHYInfo[j].LossSyncCnt,
            			                      phyLatestData.JBOD[i].PHYInfo[j].RstSeqFailCnt,
            			                      phyLatestData.JBOD[i].PHYInfo[j].RAIDStatus]).draw(false);
    				}
    			}
    		}
		}
		
		function filterSdrDataBySenserType()
		{
			$("#sdrDataTable thead td").each( function(i) {
				if ($(this).text() !== '') {
					var isEventDirColumn = (($(this).text() == "<spring:message code="Sensortype"/>") ? true : false);
					if (isEventDirColumn) {
						var table = $('#sdrDataTable').DataTable();
						table.columns(i).every( function() {
							if(this.search() !== $("#sel_sensor_type_filter").val()){
								this.search($("#sel_sensor_type_filter").val()).draw();
							}
						});
					}
				}
			});
		}
		
		function sdrRowClick(type)
		{
			$("#summaryPanel").hide();
			$("#detailPanel").show();
			$("#sel_sensor_type_filter").val(type);
			filterSdrDataBySenserType();
		}
		
		function sdrSummaryDisplay()
		{
			$("#detailPanel").hide();
			$("#summaryPanel").show();
		}
		
		function setSensorThreshold(sensor)
		{
			var name = $("td[name="+ sensor+"]").text();
			var lnc = $("input[name=lnc_"+ sensor +"]").prop("value");
			var unc = $("input[name=unc_"+ sensor +"]").prop("value");
			var lc  = $("input[name=lc_"+ sensor +"]").prop("value");
			var uc  = $("input[name=uc_"+ sensor +"]").prop("value");
			var lnr = $("input[name=lnr_"+ sensor +"]").prop("value");
			var unr = $("input[name=unr_"+ sensor +"]").prop("value");

			if (lnc.indexOf("N/A") >= 0) {
				lnc = 0;
			}
			if (unc.indexOf("N/A") >= 0) {
				unc = 0;
			}
			if (lc.indexOf("N/A") >= 0) {
				lc = 0;
			}
			if (uc.indexOf("N/A") >= 0) {
				uc = 0;
			}
			if (lnr.indexOf("N/A") >= 0) {
				lnr = 0;
			}
			if (unr.indexOf("N/A") >= 0) {
				unr = 0;
			}
			
			$('#processModal').modal('show');
			$.ajax({
				url: 'setSensorThreshold',
				type: "POST",
				data: { IP: bmcIP, number:sensor, name:name, lnc:lnc, unc:unc, lc:lc, uc:uc, lnr:lnr, unr:unr },
				dataType: 'json',
				success: function(_data, status, xhr) {
					$("button[name=setTHR_"+ sensor+"]").css('visibility','hidden');
					$('#processModal').modal('hide');
					
					if(_data.status)
						location.reload();
					else
						alert(_data.statusMsg);
				},
		        error: function(xhr, status, error) {
					$('#processModal').modal('hide');
					alert("Set sensor (" + sensor + ": " + name + ") threshold failed:", "[" + xhr.status + "] " + xhr.statusText);
			        console.log("Set sensor (" + sensor + ": " + name + ") threshold failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
	</script>
</body>
</html>
