<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<title>Node Serial Over LAN Terminal</title>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<!-- CSS -->
		<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
		<style>
			.group-input {
				display: inline;
			}
			.group-input:not(:last-child) {
				margin-right: 10px;
			}
			.group-input>input {
    			border-top-right-radius: 0px;
				border-bottom-right-radius: 0px;
				width: 50px !important;
			}
			.group-input>button {
				border-radius: 0px;
			    padding: 8px 10px;;
			    margin-left: -4px;
			}
			.group-input>button:last-child {
    			border-top-right-radius: 4px;
				border-bottom-right-radius: 4px;
			}
			#terminal_block {
				text-align: center;
				position: absolute;
				top: 43px;
				left: 15px;
				width: calc(100% - 30px);
				height: calc(100% - 43px);
				z-index: 100;
				opacity: 0.7;
				color: white;
				background-color: black;
			}
			#terminal {
				margin: 10px auto;
				width: 908px; /* 889px is window, 19px is scroll bar */
			}
		</style>
		
		<!-- Javascript -->
		<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
		<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
		<script src="<c:url value="/resources/js/gsm_date.js"/>"></script>
		
		<!-- Test -->
		<link rel="stylesheet" href="<c:url value="/resources/css/xterm/xterm.css"/>" />
		<script src="<c:url value="/resources/js/xterm/xterm.js"/>"></script>
	</head>
	
	<body>
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="container-fluid">
					<br>
					<div class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-heading">
									<h3 class="panle-title">
										<spring:message code="NodeDetail18"/>
									</h3>
								</div>
								<div class="panel-body">
									<div id="terminal_block">
										<div id="terminal_block_info">
											<p id="terminal_block_text" style="margin: 0px;"></p>
											<button id="terminal_block_reactivate" type="button" onclick="reactivateSol()" class="btn btn-primary" title="Reconnect"><spring:message code="Reconnect"/></button>
										</div>
									</div>
									
									<div class="form-inline" style="text-align: right;">
										<div class="form-inline group-input">
											<label class="control-label"><spring:message code="NodeSol2"/>:&nbsp;</label>
											<select id="terminalChartsetSelect" class="form-control input-sm">
												<option value="UTF-8">UTF-8</option>
												<option value="UTF-16">UTF-16</option>
												<option value="Cp437">Cp437 (MS-DOS)</option>
												<option value="GBK">GBK</option>
												<option value="Big5">Big5</option>
											</select>
										</div>
										<button id="terminal_block_reactivate" type="button" onclick="reactivateSol(true)" class="btn btn-danger input-sm" title="Reconnect"><spring:message code="Reconnect"/></button>
									</div>
									
									<div id="terminal" terminal_window_source="https://xtermjs.org/"></div>
									
									<div class="form-inline" style="text-align: right;">
										<div class="form-inline group-input">
											<label class="control-label"><spring:message code="Columns"/>:&nbsp;</label>
											<input id="terminalColumnsInput" type="text" class="form-control input-sm">
											<button type="button" onclick="calcColumns(this.getAttribute('title'), 10)" class="btn btn-danger input-sm" title="Plus">
												<i class="fa fa-plus"></i>
											</button>
											<button type="button" onclick="calcColumns(this.getAttribute('title'), 10)" class="btn btn-primary input-sm" title="Minus">
												<i class="fa fa-minus"></i>
											</button>
										</div>
										<div class="form-inline group-input">
											<label class="control-label"><spring:message code="Rows"/>:&nbsp;</label>
											<input id="terminalRowsInput" type="text" class="form-control input-sm">
											<button type="button" onclick="calcRows(this.getAttribute('title'), 10)" class="btn btn-danger input-sm" title="Plus">
												<i class="fa fa-plus"></i>
											</button>
											<button type="button" onclick="calcRows(this.getAttribute('title'), 10)" class="btn btn-primary input-sm" title="Minus">
												<i class="fa fa-minus"></i>
											</button>
										</div>
										<div class="form-inline group-input">
											<label class="control-label"><spring:message code="NodeSol1"/>:&nbsp;</label>
											<input id="refreshIntervalInput" type="text" class="form-control input-sm">
											<button type="button" onclick="calcInterval(this.getAttribute('title'), 10)" class="btn btn-danger input-sm" title="Plus">
												<i class="fa fa-plus"></i>
											</button>
											<button type="button" onclick="calcInterval(this.getAttribute('title'), 10)" class="btn btn-primary input-sm" title="Minus">
												<i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<script>
			var terminalCommandMode = "single"; //[single]/[string]
												//[single]: send press key immediately after the press action, and refresh screen
												//[string]: only send command after press "Enter" key, and refresh screen
												// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
												// ! [string] does not support arrow key when edit command string !
												// ! ex. input 'aaa', and want to change to 'abaa',               !
												// !     will send 'aaab' string.                                 !
												// ! Have two options to resolve this issue:                      !
												// ! 1. Just use delete key to rebuild string.                    !
												// ! 2. Listen the arrow key and change the string index to       !
												// !    insert new characters.                                    !
												// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			var terminalCommandType = "key"; //[key]/[keycode]
											 //[key]: send the key string of pressed
											 //[keycode]: send the keycode of pressed
			var terminalRefreshScreenIntervalDefault = 100;
			var terminalRefreshScreenIntervalMin = 10;
			var terminalRefreshScreenInterval = terminalRefreshScreenIntervalDefault; //Refresh the screen every 100ms (default)
			var terminalColsDefault = 100;
			var terminalRowsDefault = 31;
			var terminalCols = terminalColsDefault;
			var terminalRows = terminalRowsDefault;
			var solActivate = false;
			var solSendGate = true; //Avoid sol connection blocking
			var solErrorCount = 0; //Stop refresh screen after error count is above 3 times
			var solIdleThreshold = 5; //Disconnect SOL if idle above 5 minutes
			var solIdleCount = 0;
			var cmdHistory = {
				max: 20,
				index: -1,
				data: []
			};
			var ip = '${IP}';
			var browserSupport = true;
			
			//https://xtermjs.org/js/demo.js
			var xterm = new Terminal({
		        cols: terminalCols,
		        rows: terminalRows,
				cursorBlink: true
			});
			xterm.open(document.getElementById('terminal'));
			
			if(($("#terminal").find("canvas").width() === 0) || ($("#terminal").find("canvas").height() === 0)) {
				browserSupport = false;
			}
			
			function initialTerminal()
			{
				if(xterm._initialized)
			        return;
				else
					xterm._initialized = true;

				$("#terminalColumnsInput").val(terminalCols);
				$("#terminalRowsInput").val(terminalRows);
    			$("#refreshIntervalInput").val(terminalRefreshScreenInterval);
				
				xterm.inputBuffer = '';
			    xterm.inputString = function(type, msg) {
			    	if(type === 'enter') {
			    		xterm.x = 2;
				        xterm.write('\r\n$ ');
				        
			        	cmdHistory.data.push(xterm.inputBuffer);
				        cmdHistory.index++;
				        xterm.inputBuffer = '';
				        if(cmdHistory.data.length > cmdHistory.max) {
				        	cmdHistory.data.splice(0, 1);
				        	cmdHistory.index--;
				        }
			    	}
			    	else if(type === 'tab') {
			    		xterm.x += 4;
		    			xterm.write('    ');
		    			xterm.inputBuffer += '    ';
			    	}
			    	else if(type === 'backspace') {
			    		if(xterm.x > 2) {
					    	xterm.x--;
			                xterm.write('\b \b');
			                xterm.inputBuffer = xterm.inputBuffer.substring(0, xterm.inputBuffer.length - 1);
			            }
			    	}
			    	else if(type === 'paste') {
			    		xterm.x += msg.length;
				        xterm.write(msg);
				        xterm.inputBuffer += msg;
			    	}
			    	else if(type === 'character') {
			    		xterm.x++;
			            xterm.write(msg);
			            xterm.inputBuffer += msg;
			    	}
			    };
				
			    xterm.write('$ ');
			    
			    xterm.attachCustomKeyEventHandler(function(e) {
			    	if(terminalCommandMode === 'string') {
			    		switch(e.keyCode) {
					    	case 67: //Ctrl+C
					    	case 86: //Ctrl+V
					    		return false;
				    	}
			    	}
			    });
				
			    xterm.on('key', function(key, e) {
			    	if(terminalCommandMode === 'string') {
			    		switch(e.keyCode) {
				    		case 8: { //Backspace
				    			xterm.inputString('backspace');
				    			break;
				    		}
				    		case 9: { //Tab
				    			xterm.inputString('tab');
				    			break;
				    		}
				    		case 13: { //Enter
				    			sendCommand(xterm.inputBuffer);
				    			xterm.inputString('enter');
				    			break;
				    		}
				    		default: {
				    			var printable = !e.altKey && !e.altGraphKey && !e.ctrlKey && !e.metaKey;
				    			if(printable) {
				    				xterm.inputString('character', key);
						        }
				    			break;
				    		}
				    	}
			    	}
			    	else {
			    		if(e.keyCode === 8) {
			    			xterm.inputBuffer = xterm.inputBuffer.substring(0, xterm.inputBuffer.length - 1);
			    		}
			    		else if(e.keyCode === 13) {
			    			if((xterm.inputBuffer === "clear") || xterm.inputBuffer === "cls") {
			    				console.log("Clear the terminal buffer");
			    				xterm.clear();
			    			}
			    			
			    			xterm.inputBuffer = '';
			    		}
			    		else {
				    		xterm.inputBuffer += key;
			    		}
			    		
			    		sendCommand(key);
			    	}
			    });
			    
			    xterm.on('paste', function(data) {
			    	if(terminalCommandMode === 'string') {
			    		xterm.inputString('paste', data);
			    	}
			    	else {
			    		xterm.inputBuffer += data;
			    		sendCommand(data);
			    	}
			    });
			}
			
			function reactivateSol(confirmOperation)
			{
				var reconnectSol = false;
				
				if(confirmOperation) {
					reconnectSol = confirm('<spring:message code="NodeSol3"/>');
				}
				else {
					reconnectSol = true;
				}
				
				if(reconnectSol) {
					solActivate = false;
					activateSol("reconnect");
				}
			}
			
			function activateSol(type)
			{
				terminalBlockText('<spring:message code="NodeSol4"/>');
				
				if(type == null)
					type = 'new';
				
				$.ajax({
			        url: 'activateSol',
			        type: 'POST',
			        data: {ip:ip, type:type},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	if(_data.activate) {
			        		solActivate = true;
			    			initialTerminal();
			    			getCharset();
			        		refreshScreen();
			        		terminalBlockText();
			        	}
			        	else {
			        		terminalBlockText(_data.statusMsg);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	console.log("Activate sol failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
			}
			
			function sendCommand(command)
			{
				if(!solActivate) {
					console.log("Sol connection is disabled");
					return false;
				}
				
				if(!solSendGate) {
					return false;
				}
				
				solSendGate = false;
				setTimeout(function() {
					if(!solSendGate)
						solSendGate = true;
				}, 100);
				
				solIdleCount = 0;
				
				$.ajax({
			        url: 'sendSolCommand',
			        type: 'POST',
			        data: {ip:ip, type:terminalCommandType, command:command},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	solSendGate = true;
			        	if(!_data.status) {
			        		console.log("Send sol command (" + command + ") failed: " + _data.statusMsg);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	solSendGate = true;
			        	console.log("Send sol command (" + command + ") failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
			}
			
			function refreshScreen()
			{
				if(!solActivate) {
					console.log("Sol connection is disabled");
					return false;
				}
				
				$.ajax({
			        url: 'getSolResponse',
			        type: 'GET',
			        data: {ip:ip, type:'new'},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
		        		if(_data.status) {
			        		xterm.write(_data.data);
			        		solErrorCount = 0;
			        	}
			        	else {
			        		solErrorCount++;
			        	}
			        	
			        	if(solErrorCount > 3) {
			        		solActivate = false;
			        		terminalBlockText('<spring:message code="NodeSol5"/>');
							console.log("Sol connection is disabled");
			        	}
			        	else {
			        		setTimeout(refreshScreen, terminalRefreshScreenInterval);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	console.log("Refresh screen failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
			}
			
			function setCharset(charset)
			{
				if(!solActivate) {
					console.log("Sol connection is disabled");
					return false;
				}
				
				$.ajax({
			        url: 'setSolCharset',
			        type: 'POST',
			        data: {ip:ip, charset:charset},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	if(_data.status) {
			        		$.ajax({
						        url: 'getSolResponse',
						        type: 'GET',
						        data: {ip:ip, type:'last'},
						        dataType: 'json',
						        success: function(_data, status, xhr) {
						        	if(_data.status) {
						        		xterm.write(_data.data);
						        	}
						        },
						        error: function(xhr, status, error) {
						        	console.log("Update screen failed after change charset: [" + xhr.status + "] " + xhr.statusText);
						        },
							    cache: false
						    });
			        	}
			        	else {
			        		console.log("Set sol charset (" + charset + ") failed: " + _data.statusMsg);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	console.log("Set sol charset (" + charset + ") failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
			}
			
			function getCharset()
			{
				if(!solActivate) {
					console.log("Sol connection is disabled");
					return false;
				}
				
				$.ajax({
			        url: 'getSolCharset',
			        type: 'GET',
			        data: {ip:ip},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	if(!_data.status) {
			        		console.log("Get sol charset failed: " + _data.statusMsg);
			        	}
			        	else {
			        		$("#terminalChartsetSelect").val(_data.charset);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	console.log("Get sol charset failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
			}
			
			$("#terminalChartsetSelect").on("change", function() {
				setCharset($(this).val());
			});
			
			function calcColumns(calcType, calcValue)
			{
				if(calcType === "Plus")
					terminalCols += calcValue;
				else if(calcType === "Minus")
					terminalCols -= calcValue;
				else
					terminalCols = calcValue;
				
				if(terminalCols < terminalColsDefault) {
					terminalCols = terminalColsDefault;
				}
				else if(isNaN(terminalCols)) {
					terminalCols = terminalColsDefault;
				}
				
				xterm.resize(terminalCols, terminalRows);
				
				$("#terminal").css("width", ((terminalCols * 8.89) + 19) + "px");
				
				$("#terminalColumnsInput").val(terminalCols);
			}
			
			$("#terminalColumnsInput").on("change", function() {
				calcColumns(null, parseInt($("#terminalColumnsInput").val()));
			});
			
			function calcRows(calcType, calcValue)
			{
				if(calcType === "Plus")
					terminalRows += calcValue;
				else if(calcType === "Minus")
					terminalRows -= calcValue;
				else
					terminalRows = calcValue;
				
				if(terminalRows < terminalRowsDefault) {
					terminalRows = terminalRowsDefault;
				}
				else if(isNaN(terminalRows)) {
					terminalRows = terminalRowsDefault;
				}
				
				xterm.resize(terminalCols, terminalRows);
				
				$("#terminalRowsInput").val(terminalRows);
			}
			
			$("#terminalRowsInput").on("change", function() {
				calcRows(null, parseInt($("#terminalRowsInput").val()));
			});
			
			function calcInterval(calcType, calcValue)
			{
				if(calcType === "Plus")
					terminalRefreshScreenInterval += calcValue;
				else if(calcType === "Minus")
					terminalRefreshScreenInterval -= calcValue;
				else
					terminalRefreshScreenInterval = calcValue;
				
				if(terminalRefreshScreenInterval < terminalRefreshScreenIntervalMin) {
					terminalRefreshScreenInterval = terminalRefreshScreenIntervalMin;
				}
				else if(isNaN(terminalRefreshScreenInterval)) {
					terminalRefreshScreenInterval = terminalRefreshScreenIntervalDefault;
				}
				
				$("#refreshIntervalInput").val(terminalRefreshScreenInterval);
			}
			
			$("#refreshIntervalInput").on("change", function() {
				calcInterval(null, parseInt($("#refreshIntervalInput").val()));
			});
			
			function terminalBlockText(text)
			{
				if((text == null) || (text === "")) {
					$("#terminal_block").hide();
				}
				else {
					if(text.indexOf('<spring:message code="NodeSol5"/>') !== -1)
						$("#terminal_block_reactivate").show();
					else
						$("#terminal_block_reactivate").hide();
					
					if(text.indexOf("OpenSessionWaiting") !== -1)
						text += "<br>Please wait a few seconds and try again."
					
					$("#terminal_block").show();
					$("#terminal_block_text").html(text);
					$("#terminal_block_info").css("margin-top", ($("#terminal_block").height() - $("#terminal_block_info").height())/2 + "px");
				}
			}
			
			function idleMonitor()
			{
				if(solActivate && (solIdleCount++ > (solIdleThreshold * 60))) {
					solActivate = false;
					solIdleCount = 0;
					terminalBlockText('<spring:message code="NodeSol5"/>: <spring:message code="NodeSol7"/>');
				}
				
				setTimeout(idleMonitor, 1000);
			}
			
			$(document).ready(function() {
				if(browserSupport)
					terminalBlockText('<spring:message code="NodeSol5"/>');
				else
					terminalBlockText('<spring:message code="NodeSol6"/>');
				
				activateSol();
				idleMonitor();
			});
		</script>
	</body>
</html>
