<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>GSM Update</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	<style>
    	.modal-dialog {
    		margin-top: 260px !important;
			width: 95px !important;
		}
		.modal-backdrop {
			opacity: 0 !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
		.alert h1 {
			display: inline !important;
		}
		.slider-selection {
			background: #d9d9d9 !important;
		}
    </style>
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="navside5"/></h4>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-12 col-xs-12">
										<form enctype="multipart/form-data" class="form-inline">
											<div>
											<label><spring:message code="NodeUpdate1"/> (<spring:message code="NodeUpdate9"/> .war)</label>
											</div>
											<div class="well form-group">
												<strong><spring:message code="Version"/>:</strong> <spring:message code="ProjectName"/><br><br>
	                                            <span class="btn btn-primary btn-file">
	                                              <input type="file" name="file" id="fileToUpload">
	                                            </span>
												<input id="updateBtn" type="button" name="submit" class="btn btn-primary" value='<spring:message code="Update"/>'>
											</div>
										</form>
									</div>
								
								</div>
							</div>
							        <div>
							        <h3> <center> <span id="showtime" style="font-weight: bold; visibility: hidden"></span> </center> </h3>
							        </div>	
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				</sec:authorize>
				
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="UpdateServer"/></h4>
							</div>
							<div class="panel-body">
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-12 col-xs-12">
										<form id="updateForm" enctype="multipart/form-data" class="form-inline">
											<div class="well form-group">
												<strong><spring:message code="Nodelist12"/>:</strong><br>
												<input type="text" id="updateIP" name="updateIP" value="${Updater_IP}" />
												<input id="updateServer" type="button" name="submit" class="btn btn-primary" value='<spring:message code="Set"/>'>
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				
				<%-- <div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="NodeUpdate4"/></h4>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-12 col-xs-12">
										<form name="updateLogoForm" enctype="multipart/form-data" class="form-inline">
											<div class="well form-group">
												<div>
												<label><spring:message code="NodeUpdate4-2"/> <br>(<spring:message code="NodeUpdate9"/> .png, <spring:message code="Height"/>: 64, <spring:message code="Width"/>: 502)</label>
												</div>
	                                            <span class="btn btn-primary btn-file">
	                                              <input type="file" name="file" id="fileToUpload" <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>>
	                                            </span>
												<input id="updateLogoBtn" type="button" value="Update" name="submit" class="btn btn-primary" <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>>
												<input id="deleteLogoBtn" type="button" value="Delete" name="submit" class="btn btn-danger" <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>>
											</div>
										</form>
									</div>
								</div>
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div> --%>
				
				<!-- 2017-02-03 XY.Hou, Create UI to upload new keystore -->
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="KeyStoreUpdate"/></h4>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-12 col-xs-12">
										<form id="keystoreForm" enctype="multipart/form-data" class="form-inline">
											<div class="well form-group">
												<strong><spring:message code="KeyStoreFile"/>:</strong> <br><br>
												<span class="btn btn-primary btn-file">
													<input type="file" name="file" id="keystoreToUpload">
												</span> <br><br>
												<strong><spring:message code="KeyStorePwd"/>:</strong> <br><br>
												<input type="password" id="KeyStorePwd" name="KeyStorePwd" /> <br>
												<input id="updateKeyStore" type="button" name="submit" class="btn btn-primary" value='<spring:message code="Update"/>'>
											</div>
										</form>
									</div>
								</div>
							</div>
							<div>
								<h3> <center> <span id="keystoreShowtime" style="font-weight: bold; visibility: hidden"></span> </center> </h3>
							</div>	
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				</sec:authorize>

				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="System"/> <spring:message code="Restore"/></h4>
							</div>
							<!-- /.panel-heading -->
							<div class="panel-body">
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-12 col-xs-12">
										<form enctype="multipart/form-data" class="form-inline">
											<div>
												<label><spring:message code="NodeUpdate10"/></label>
											</div>
											<input id="systemExport" type="button" name="submit" class="btn btn-primary" value='<spring:message code="Export"/>'>
										</form>
									</div>
								</div>
								<br/>
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-12 col-xs-12">
										<form id="systemImportForm" enctype="multipart/form-data" class="form-inline">
											<div>
												<label><spring:message code="NodeUpdate11"/> (<spring:message code="NodeUpdate9"/> .json)</label>
											</div>
											<div class="well form-group">
	                                            <span class="btn btn-primary btn-file">
	                                              <input type="file" name="systemImportFile" id="systemImportFile">
	                                            </span>
												<input id="systemImport" type="button" name="submit" class="btn btn-primary" value='<spring:message code="Import"/>'>
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				</sec:authorize>
				<!-- /.row -->
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /#page-wrapper -->
	</div>
	<!-- /.wrapper -->
    <div class="modal fade" id="updateStatus_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div id="updateStatus_div" class="alert">
					<i id="updateStatus_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>	
</body>
	
<script>
    var count = 150;
    
    function checkServerStatus()
    {
        var img = document.body.appendChild(document.createElement("img"));

        img.onload = function()
        {
           count = 0;
        };
      
        img.src = window.location.protocol+ "//" + window.location.host + "/GSM/GetGSMLogo/gsm_logo.png?" + new Date().getTime();
    }
    
    // PJ: Count down for new GSM reload
    function countdown() {
    	document.getElementById("showtime").style.visibility = "visible";
		document.getElementById("showtime").innerHTML = "<spring:message code="GSMUpdateProcess"/> " + count--;
		T1 = setTimeout(countdown,1000);
		if(count<0) {
			clearTimeout(T1);
			parent.window.location.href = "./Logout";
		}
		if(count < 130) //PJ: at least wait 20 seconds then check if web service running.
			checkServerStatus();      
    }

	var isUpdating = "false";

	$('#updateBtn').click(function() {
	    $('#updateStatus_modal').modal('show');
	    
	    setTimeout(function() {
	    	var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
		    var formData = new FormData($('form')[0]);
		    
	    	$.ajax({
		        url: 'UploadGSMApplication?'+csrfParameter+'='+csrfToken,  //Server script to process data
		        type: 'POST',
		        data: formData,
		        success: function(_data, status, xhr) {
		        	$('#updateStatus_modal').modal('hide');
		        	countdown();
		        },
		        error: function(xhr, status, error) {
		        	$('#updateStatus_modal').modal('hide');
		        	alert(xhr.responseText + ", please try again.");
		            console.log("Upload the GSM firmware failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
	    }, 1000);
	});
	
	/*$("#updateLogoBtn, #deleteLogoBtn").on("click", function() {
		if(($(this).val() == "Delete") && !confirm('<spring:message code="SettingGSM21"/>'))
			return;
		
		var csrfParameter= "${_csrf.parameterName}";
		var csrfToken = "${_csrf.token}";
		var formData = new FormData(document.forms.namedItem("updateLogoForm"));
		formData.append('type', $(this).val());
	    
	    $.ajax({
	    	url: 'UpdateGSMLogo?'+csrfParameter+'='+csrfToken,
	        type: 'POST',
	        data: formData,
	        dataType: 'json',
	        success: function(_data, status, xhr) {
	        	switch(_data.status) {
		        	case '1': alert('<spring:message code="UpdateMsg1"/>'); break;
		        	case '2': alert('<spring:message code="UpdateMsg2"/>'); break;
		        	case '3': alert('<spring:message code="UpdateMsg3"/>'); break;
		        	case '4': alert('<spring:message code="UpdateMsg4"/>'); break;
		        	case '5': alert('<spring:message code="UpdateMsg5"/>'); break;
		        	case '6': alert('<spring:message code="UpdateMsg6"/>'); break;
		        	case '7': alert('<spring:message code="UpdateMsg7"/>'); break;
		        	case '8': alert('<spring:message code="UpdateMsg8"/>'); break;
		        	case '9': alert('<spring:message code="UpdateMsg9"/>'); break;
		        	case '10': alert('<spring:message code="UpdateMsg10"/>'); break;
		        	case '11': alert('<spring:message code="UpdateMsg11"/>'); break;
	        	}
	        	
	        	if(_data.success == "true")
	        		top.window.location.href = "./";
	        },
	        error: function(xhr, status, error) {
	        	alert("Update GSM logo failed, please try again.");
	            console.log("Update GSM logo failed: [" + xhr.status + "] " + xhr.statusText);
			},
	        cache: false,
	        contentType: false,
	        processData: false
	    });
	});*/
	
	/* 2017-02-03 XY.Hou, Create UI to upload new keystore */
	$('#updateKeyStore').click(function() {

		var csrfParameter = "${_csrf.parameterName}";
		var csrfToken = "${_csrf.token}";
		var formId = document.getElementById("keystoreForm");
		var formData = new FormData(formId);

		$.ajax({
			url: 'UploadKeystore?' + csrfParameter + '=' + csrfToken, //Server script to process data
			type: 'POST',
			data: formData,
			success: function(_data, status, xhr) {
				alert("Upload keystore successed. Please restart Tomcat.");
			},
			error: function(xhr, status, error) {
				alert("Upload keystore failed. Please try again.");
		        console.log("Upload keystore failed: [" + xhr.status + "] " + xhr.statusText);
			},
			cache: false,
			contentType: false,
			processData: false
		});
	});
	
	$("#updateServer").click(function() {
		$.ajax({
			url: "SetUpdaterServer",
			type: "POST",
			data: {IP: $("#updateIP").val()},
			dataType: "json",
			success: function(data) {
				if (data.status === "OK")
					alert("Set IP success.");
				else
					alert("Set IP failed");
			},
			error: function(xhr, status, error) {
				alert("Set IP failed.");
			}
		});
	});
	
	$("#systemExport").on("click", function() {
		window.location.href = "./SystemConfigExport";
	});
	
	$("#systemImport").on("click", function() {
		if(confirm("Will overwrite all settings, are you sure to perform the action?")) {
			$('#updateStatus_modal').modal('show');
			
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData($("#systemImportForm")[0]);
			
			$.ajax({
				url: "SystemConfigImport?"+csrfParameter+"="+csrfToken,
				type: 'POST',
				data: formData,
				success: function(_data, status, xhr) {
					alert("Success.");
					parent.window.location.href = "./GSM";
				},
				error: function(xhr, status, error) {
					alert("Upload system config failed, please try again.");
			        console.log("Upload system config failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
			});
		}
	});

	$(document).on('change', '.btn-file :file', function() {
		  var input = $(this),
		      numFiles = input.get(0).files ? input.get(0).files.length : 1,
		      label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
		  input.trigger('fileselect', [numFiles, label]);
	});

</script>
</html>
