/********************************************************************
 * GIGA-BYTE TECHNOLOGY CO.,LTD.
 * No. 6, Bau Chiang Road, Hsin-Tien,
 * New Taipei City, Taiwan, R.O.C.
 * (c) Copyright 2017, GIGA-BYTE TECHNOLOGY CO.,LTD.
 *
 * All rights reserved.
 * Abstract:
 *     JS function for GSM.jsp
 *
 * Revision History:
 * Who         When          What
 * --------    ----------    ---------------------------------------- 
 * Callen      2018-12-18    Create.
 ********************************************************************/

/**
* @param date - Date() object
* @param format - format date string (ex. "yyyy-MM-dd HH:mm:ss.SSS")
* @return date string of converted based on format
*/
function formatDate(date, format)
{
	var formatArray = format.split(/[\s\-\/\:\.]+/);
	for(var i=0 ; i<formatArray.length ; i++) {
		var convertDate = "";
		
		//Parse the date
		switch(formatArray[i]) {
			case "yyyy":
				convertDate = date.getUTCFullYear().toString();
				break;
			case "MM":
				convertDate = (date.getUTCMonth() + 1).toString();
				break;
			case "dd":
				convertDate = date.getUTCDate().toString();
				break;
			case "HH":
				convertDate = date.getUTCHours().toString();
				break;
			case "mm":
				convertDate = date.getUTCMinutes().toString();
				break;
			case "ss":
				convertDate = date.getUTCSeconds().toString();
				break;
			case "SSS":
				convertDate = date.getUTCMilliseconds().toString();
				break;
			default:
				convertDate = "??";
				break;
		}
		
		//Fill zero to insufficient number of date string
		for(j=convertDate.length ; j<formatArray[i].length ; j++)
			convertDate = "0" + convertDate;
		
		format = format.replace(formatArray[i], convertDate);
	}
	
	return format;
}
