/********************************************************************
 * GIGA-BYTE TECHNOLOGY CO.,LTD.
 * No. 6, Bau Chiang Road, Hsin-Tien,
 * New Taipei City, Taiwan, R.O.C.
 * (c) Copyright 2017, GIGA-BYTE TECHNOLOGY CO.,LTD.
 *
 * All rights reserved.
 * Abstract:
 *     JS function for GSM.jsp
 *
 * Revision History:
 * Who         When          What
 * --------    ----------    ---------------------------------------- 
 * Callen      2017-04-27    Create.
 * Callen      2017-04-27    Modify the judge methods of 'includes' 
 *                           to 'indexOf' for support the IE browser.
 * Callen      2017-05-02    Add a function for check the browser.
 * Callen      2017-05-02    Fix the bug of cannot search the new name
 *                           of group after rename it.
 * Terry       2017-06-16    Add VM node.
 * Terry       2017-07-13    Add VM node which doesn't belong to BMC.
 * Callen      2017-07-14    Use different method to get the node list.
 * Terry       2017-07-17    Check VM's user name & password.
 * Callen      2017-08-16    Support IPv6.
 * Callen      2017-09-06    Change the judgment empty list method.
 * Chris       2017-09-18    Support search a server by SN.
 * Chris       2017-12-27    Add function to focus default selection.
 * William     2018-12-17    Add a search item for Node Description.
 ********************************************************************/

var topMenuSelected = "SystemManager";
var filterMenuSelected = "All";
var tabMenuSelected = "NodeInformation";
var sideMenuSelected = "";
var firstNode = "0.0.0.0";
var groupInfo = {};
var nodeInfo = {};
var tabMenuOriginalHtml = {};
var updateInterval = 3 * 60 * 1000;
var searchBoxText = "";
var searchBoxChecking = false;
var searchBoxFirstNode = "";
var nodeUpdateID = "";
var defaultPageJSON = "";
var dataIndex = 0;
var dataLength = 1;
var dataType = "node";
var nodelistisclicked = false;
var connectionInterface = "Auto";
var groupControl_name="";
var webAlert_4="";
var webAlert_5="";

//PJ: Mark nodelistiscliked flag to avoid unnecessary alert window
function marknodelistclick() {
    nodelistisclicked = true;
}

//Check the search box is modified at every 0.5 sec, if the modify is stopped then search it on node list.
function checkSearchBoxFinished(text) {
    if(searchBoxText != text) {
        var nowSearchBoxText = searchBoxText;
        setTimeout(function() {checkSearchBoxFinished(nowSearchBoxText);}, 500);
    }
    else {
        //Restore the node list.
        $("li[nodelisttag]").show();
        
        if(searchBoxText != "") {
            //Search the node of IP and Node Name
            $("ul[id^=NodeList_]>li[nodelisttag='node-control']:not([nodename*='" + searchBoxText + "']):not([description*='" + searchBoxText + "']):not([serial*='" + searchBoxText + "'])").hide();
            
            //Search the node of IP and Node Name in the group (without the group of the name is same as search text, because it should show all nodes under the group).
            $("ul[id^=NodeList_]>li[nodelisttag='group-title']:not([groupname*='" + searchBoxText + "'])>ul>li[nodelisttag='node-control']:not([nodename*='" + searchBoxText + "']):not([description*='" + searchBoxText + "']):not([serial*='" + searchBoxText + "'])").hide();
            
            //If no node name is equal to the search text in the group (without the group of the name is same as search text), then hide it.
            $("ul[id^=NodeList_]>li[nodelisttag='group-title']:not([groupname*='" + searchBoxText + "'])").each(function() {
                if($(this).find("li[nodelisttag='node-control']:not([style*='display: none;'])").length == 0)
                    $(this).hide();
            });
        }
        
        searchBoxFirstNode = $("li[nodelisttag='node-control']:not([style*='display: none;'])").first().attr("id");
        
        searchBoxChecking = false;
    }
}

//Get the node list, each request only get the one node, so one round have multi request then use the "webID" to distinguish every round.
function getNodeList(init) {
    if(init) {
        firstNode = "0.0.0.0";
        dataIndex = 0;
        dataType = "node";
        nodeUpdateID = randomID();
        
        for(var key in groupInfo) {
            groupInfo[key]["groupStatus"] = 4;
            groupInfo[key]["groupCount"] = 0;
            
            if(groupInfo[key]["groupTagID"] != null) {
                $("ul[id^=" + groupInfo[key]["groupTagID"] + "]").parent().find("img[nodelisttag=group-status]").attr("src", "/GSM/resources/img/icon_status_" + groupInfo[key]["groupStatus"] + ".png");
                $("ul[id^=" + groupInfo[key]["groupTagID"] + "]").parent().find("span.badge").text(groupInfo[key]["groupCount"]);
            }
        }
    }
    
    $.ajax({
        url: 'getNodeList',
        data: {dataIndex: dataIndex,
               dataLength: dataLength,
               dataType: dataType},
        dataType: 'json',
        success: function(_data, status, xhr) {
            if(_data.length > 0) {
                try {
                    for(var i=0 ; i<_data.length ; i++) {
                        var appendHtmlString = "";
                        if(_data[i].groupID > 0) {
                            if((groupInfo[_data[i].groupID] != null) && (groupInfo[_data[i].groupID]["groupTagID"] != null)) {
                                if(_data[i].nodeStatus < groupInfo[_data[i].groupID]["groupStatus"]) {
                                    groupInfo[_data[i].groupID]["groupStatus"] = _data[i].nodeStatus;
                                    $("ul[id^=" + groupInfo[_data[i].groupID]["groupTagID"] + "]").parent().find("img[nodelisttag='group-status']").attr("src", "/GSM/resources/img/icon_status_" + _data[i].nodeStatus + ".png");
                                }
                                
                                groupInfo[_data[i].groupID]["groupCount"]++;
                                $("ul[id^=" + groupInfo[_data[i].groupID]["groupTagID"] + "]").parent().find("span.badge").text(groupInfo[_data[i].groupID]["groupCount"]);
                                
                                if(groupInfo[_data[i].groupID]["groupNodeList"].indexOf(_data[i].ip) == -1)
                                    groupInfo[_data[i].groupID]["groupNodeList"].push(_data[i].ip);
                            }
                        }
                        
                        /* Brian 2019/07/23: First use host name, if unknown or empty then use product name */
                        _data.nodeName = _data[i].hostName;
                        if((_data.nodeName == "") || (_data.nodeName == "Unknown"))
                            _data.nodeName = _data[i].productName;
                        
                        if(nodeInfo[_data[i].ip] == null) {
                            nodeInfo[_data[i].ip] = {};
                            nodeInfo[_data[i].ip]["nodeUpdateID"] = nodeUpdateID;
                            nodeInfo[_data[i].ip]["nodeTagID"] = convertIPtoID(_data[i].ip);
                            nodeInfo[_data[i].ip]["nodeStatus"] = _data[i].nodeStatus;
                            nodeInfo[_data[i].ip]["hasvm"] = _data[i].hasVM;
                            
                            //Always can click node link
                            //if (_data[i].isConnected == "true") {
                                appendHtmlString += '<li nodelisttag="node-control" nodename="' + _data.nodeName + ' (' + _data[i].ip + ')" id="'+ nodeInfo[_data[i].ip]["nodeTagID"] + '" description="' + _data[i].description + '" nodetype="' + _data[i].nodeType + '" bmcfirmware="' + _data[i].bmcFirmware + '" nodeplatform="' + _data[i].nodePlatform + '" groupid="' + _data[i].groupID + '" isjbod="' + _data[i].isJBOD + '" hasvm="' + _data[i].hasVM + '" isconn="' + _data[i].isConnected + '" serial="' + _data[i].relatedSN + '"';
                                if((searchBoxText != "") && (!searchBoxChecking)) {
                                    appendHtmlString += ' style="display: none;"';
                                }
                                appendHtmlString += '>';
                                
                                appendHtmlString += '<a href=\'javascript:linkPage("' + _data[i].ip + '")\'>';
                                appendHtmlString += '<img nodelisttag="node-status" src="/GSM/resources/img/icon_status_' + _data[i].nodeStatus + '.png">';
                                appendHtmlString += '&nbsp;&nbsp;&nbsp;' + _data.nodeName + '&nbsp;(' + _data[i].ip + ')';
                                appendHtmlString += '</a>';
                            /*} else {
                                appendHtmlString += '<li nodelisttag="node-control" nodename="' + _data.nodeName + ' (' + _data[i].ip + ')" id="'+ nodeInfo[_data[i].ip]["nodeTagID"] + '" nodetype="' + _data[i].nodeType + '" nodeplatform="' + _data[i].nodePlatform + '" groupid="' + _data[i].groupID + '" isjbod="' + _data[i].isJBOD + '" hasvm="' + _data[i].hasVM + '" isconn="' + _data[i].isConnected + '" serial="' + _data[i].relatedSN + '"';
                                if((searchBoxText != "") && (!searchBoxChecking)) {
                                    appendHtmlString += ' style="display: none;"';
                                }
                                appendHtmlString += '>';
                                
                                appendHtmlString += '<p>';
                                appendHtmlString += '<img nodelisttag="node-status" src="/GSM/resources/img/icon_status_' + _data[i].nodeStatus + '.png">';
                                appendHtmlString += '&nbsp;&nbsp;&nbsp;' + _data.nodeName + '&nbsp;(' + _data[i].ip + ')';
                                appendHtmlString += '</p>';
                            }*/
                            
                            appendHtmlString += '</li>';
                            
                            if (_data[i].vmIP != '0.0.0.0') {
                                if(_data[i].groupID == 0)
                                    appendHtmlString += '<li nodelisttag="vm-control" id="' + nodeInfo[_data[i].ip]["nodeTagID"] + '"';
                                else
                                    appendHtmlString += '<li nodelisttag="sub-vm-control" id="' + nodeInfo[_data[i].ip]["nodeTagID"] + '"';
                                if((searchBoxText != "") && (!searchBoxChecking)) {
                                    appendHtmlString += ' style="display: none;"';
                                }
                                appendHtmlString += '>';
                                appendHtmlString += '<img style="max-width:15px" src="/GSM/resources/img/mainmenu_GroupManager_gray.png">';
                                appendHtmlString += '&nbsp;&nbsp;&nbsp;&nbsp;' + _data[i].vmType + '&nbsp;(' + _data[i].vmIP + ')';
                                appendHtmlString += '</li>';
                            }
                            
                            appendHtml(_data[i], "insert_node", appendHtmlString);
                        }
                        else {
                            nodeInfo[_data[i].ip]["nodeUpdateID"] = nodeUpdateID;
                            
                            var oldGroupID = $("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("groupid");
                            if((oldGroupID > 0) && (oldGroupID != _data[i].groupID)) {
                                groupInfo[oldGroupID]["groupNodeList"].splice(groupInfo[oldGroupID]["groupNodeList"].indexOf(_data[i].ip), 1);
                            }
                            
                            if((nodeInfo[_data[i].ip]["nodeStatus"] != _data[i].nodeStatus) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("nodename") != (_data.nodeName + ' (' + _data.ip + ')')) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("bmcfirmware") != _data[i].bmcFirmware) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("nodeplatform") != _data[i].nodePlatform) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("groupid") != _data[i].groupID) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("isjbod") != _data[i].isJBOD) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("hasvm") != _data[i].hasVM) ||
                               ($("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").attr("description") != _data[i].description)) {
                                nodeInfo[_data[i].ip]["nodeStatus"] = _data[i].nodeStatus;
                                
                                //Always can click node link
                                //if (_data[i].isConnected == "true") {
                                    appendHtmlString += '<li nodelisttag="node-control" nodename="' + _data.nodeName + ' (' + _data[i].ip + ')" id="'+ convertIPtoID(_data[i].ip) + '" description="' + _data[i].description + '" nodetype="' + _data[i].nodeType + '" bmcfirmware="' + _data[i].bmcFirmware + '" nodeplatform="' + _data[i].nodePlatform + '" groupid="' + _data[i].groupID + '" isjbod="' + _data[i].isJBOD + '" hasvm="' + _data[i].hasVM + '" isconn="' + _data[i].isConnected + '" serial="' + _data[i].relatedSN + '"';
                                    if((searchBoxText != "") && (!searchBoxChecking)) {
                                        appendHtmlString += ' style="display: none;"';
                                    }
                                    if(sideMenuSelected == _data[i].ip) {
                                        appendHtmlString += 'class="active"';
                                    }
                                    appendHtmlString += '>';
                                    
                                    appendHtmlString += '<a href=\'javascript:linkPage("' + _data[i].ip + '")\'>';
                                    appendHtmlString += '<img nodelisttag="node-status" src="/GSM/resources/img/icon_status_' + _data[i].nodeStatus + '.png">';
                                    appendHtmlString += '&nbsp;&nbsp;&nbsp;' + _data.nodeName + '&nbsp;(' + _data[i].ip + ')';
                                    appendHtmlString += '</a>';
                                /*} else {
                                    appendHtmlString += '<li nodelisttag="node-control" nodename="' + _data.nodeName + ' (' + _data[i].ip + ')" id="'+ convertIPtoID(_data[i].ip) + '" nodetype="' + _data[i].nodeType + '" nodeplatform="' + _data[i].nodePlatform + '" groupid="' + _data[i].groupID + '" isjbod="' + _data[i].isJBOD + '" hasvm="' + _data[i].hasVM + '" isconn="' + _data[i].isConnected + '" serial="' + _data[i].relatedSN + '"';
                                    if((searchBoxText != "") && (!searchBoxChecking)) {
                                        appendHtmlString += ' style="display: none;"';
                                    }
                                    appendHtmlString += '>';
                                    
                                    appendHtmlString += '<p>';
                                    appendHtmlString += '<img nodelisttag="node-status" src="/GSM/resources/img/icon_status_' + _data[i].nodeStatus + '.png">';
                                    appendHtmlString += '&nbsp;&nbsp;&nbsp;' + _data.nodeName + '&nbsp;(' + _data[i].ip + ')';
                                    appendHtmlString += '</p>';
                                }*/
                                
                                appendHtmlString += '</li>';
                                
                                if (_data[i].vmIP != '0.0.0.0') {
                                    if(_data[i].groupID == 0)
                                        appendHtmlString += '<li nodelisttag="vm-control" id="' + convertIPtoID(_data[i].ip) + '"';
                                    else
                                        appendHtmlString += '<li nodelisttag="sub-vm-control" id="' + convertIPtoID(_data[i].ip) + '"';
                                    
                                    if((searchBoxText != "") && (!searchBoxChecking)) {
                                        appendHtmlString += ' style="display: none;"';
                                    }
                                    appendHtmlString += '>';
                                    appendHtmlString += '<img style="max-width:15px" src="/GSM/resources/img/mainmenu_GroupManager_gray.png">';
                                    appendHtmlString += '&nbsp;&nbsp;&nbsp;&nbsp;' + _data[i].vmType + '&nbsp;(' + _data[i].vmIP + ')';
                                    appendHtmlString += '</li>';
                                }

                                $("li[id=" + nodeInfo[_data[i].ip]["nodeTagID"] + "]").remove();
                                appendHtml(_data[i], "insert_node", appendHtmlString);
                                
                                if(sideMenuSelected == _data[i].ip) {
                                    checkSupportive(_data[i].ip);
                                }
                            }
                        }
                        
                        if(firstNode == "0.0.0.0")
                            firstNode = _data[i].ip;
                        
                        if($("#gsmiframe").attr("src") == "")
                            linkPage(firstNode);
                    }
                }
                catch(e) {
                    console.log("1: Get node list exception, index:  " + dataIndex + ", length: " + dataLength);
                }
                
                dataIndex += dataLength;
                setTimeout(getNodeList, 50);
            }
            else {
                if (dataType == "node") {
                    dataIndex = 0;
                    dataType = "vm";
                    setTimeout(getNodeList, 50);
                } else {
                    try {
                        if(checkNodeInfoHasData()) {
                            //Remove the Node, if node not in the update round, then remove it.
                            var removeQueue = [];
                            for(var key in nodeInfo) {
                                if(nodeInfo[key]["nodeUpdateID"] != nodeUpdateID) {
                                    var removeNodeGroupID = $("li[id=" + nodeInfo[key]["nodeTagID"] + "]").attr("groupid");
                                    if(removeNodeGroupID > 0)
                                        groupInfo[removeNodeGroupID]["groupNodeList"].splice(groupInfo[removeNodeGroupID]["groupNodeList"].indexOf(key), 1);
                                    $("li[nodelisttag='node-control'][id='" + nodeInfo[key]["nodeTagID"] + "']").remove();
                                    removeQueue.push(key);
                                }
                            }
                            for(var i=0 ; i<removeQueue.length ; i++) {
                                delete nodeInfo[removeQueue[i]];
                            }
                        }
                        else {
                            //No any nodes in database, redirects to IP Range page.
                            if(topMenuSelected === "SystemManager") {
                                redirectPreference();
                            }
                        }
                    }
                    catch(e) {
                        console.log("2: Get node list exception, index:  " + dataIndex + ", length: " + dataLength);
                    }

                    //Next update.
                    setTimeout(function() {getNodeList(true);}, updateInterval);
                }
            }
        },
        error: function(xhr, status, error) {
            console.log("Get the node list failed: [" + xhr.status + "] " + xhr.statusText);
        },
        cache: false
    });
}

//Get the group list.
function getGroupList(action) {
    //Set a new id for this update round.
    var groupUpdateID = randomID();
    //Prevent two process use this function at same time, then check the groupUpdateID will get different result casue to remove it.
    var localGroupInfo = groupInfo;
    
    $.ajax({
        url: 'getGroupList',
        data: {},
        dataType: 'json',
        success: function(__data, status, xhr) {
            try {
                //Check the Group, if null then create it, otherwise update the groupUpdateID for check group in the update round.
                if(__data.grouplist.length > 0) {
                    for(var i=0 ; i<__data.grouplist.length ; i++) {
                        var _data = __data.grouplist[i];
                        
                        if(localGroupInfo[_data.groupID] == null) {
                            var appendHtmlString = "";
                            localGroupInfo[_data.groupID] = {};
                            
                            localGroupInfo[_data.groupID]["groupUpdateID"] = groupUpdateID;
                            localGroupInfo[_data.groupID]["groupTagID"] = _data.groupType + "_" + _data.groupID + "_";
                            localGroupInfo[_data.groupID]["groupType"] = _data.groupType;
                            localGroupInfo[_data.groupID]["groupStatus"] = 4;
                            localGroupInfo[_data.groupID]["groupCount"] = 0;
                            localGroupInfo[_data.groupID]["groupNodeList"] = [];
                            
                            appendHtmlString += '<li nodelisttag="group-title" groupname="' + _data.groupName + '" nodetype="' + _data.groupType + '" groupid="' + _data.groupID + '"';
                            if((searchBoxText != "") && (!searchBoxChecking)) {
                                appendHtmlString += ' style="display: none;"';
                            }
                            appendHtmlString += '>';
                            appendHtmlString += '<a href="javascript:;" data-toggle="collapse" data-target="#' + localGroupInfo[_data.groupID]["groupTagID"] + '">';
                            appendHtmlString += '<img nodelisttag="group-status" src="/GSM/resources/img/icon_status_' + localGroupInfo[_data.groupID]["groupStatus"] + '.png">';
                            appendHtmlString += '<span nodelisttag="group-name">' + '&nbsp;&nbsp;&nbsp;' + _data.groupName + '</span>';
                            appendHtmlString += '<i class="fa fa-fw fa-caret-down"></i>';
                            appendHtmlString += '<span nodelisttag="group-count" class="badge float-right">' + localGroupInfo[_data.groupID]["groupCount"] + '</span>';
                            appendHtmlString += '</a>';
                            
                            appendHtmlString += '<ul nodelisttag="group-list" id="' + localGroupInfo[_data.groupID]["groupTagID"] + '" class="collapse">';
                            appendHtmlString += '<li nodelisttag="group-control" id="' + _data.groupID + '">';
                            appendHtmlString += '<a href=\'javascript:linkPage("' + _data.groupID + '")\'>';
                            appendHtmlString += '<img id="GroupManager" style="max-width:15px !important;" src="/GSM/resources/img/mainmenu_GroupManager_gray.png">&nbsp;&nbsp;&nbsp;&nbsp;'+groupControl_name;
                            appendHtmlString += '</a>';
                            appendHtmlString += '</li>';
                            appendHtmlString += '</ul>';
                            appendHtmlString += '</li>';
                            
                            appendHtml(_data, "create_group", appendHtmlString);
                        }
                        else {
                            localGroupInfo[_data.groupID]["groupUpdateID"] = groupUpdateID;
                        }
                    }
                }
                
                //Remove the Group, if group not in the update round, then remove it.
                var removeQueue = [];
                for(var key in localGroupInfo) {
                    if(localGroupInfo[key]["groupUpdateID"] != groupUpdateID) {
                        var groupNodeListHtml = $("li[nodelisttag='group-title'][groupid='" + key + "']>ul[nodelisttag='group-list']").html();
                        $("li[nodelisttag='group-title'][groupid='" + key + "']").remove();
                        $("ul[id='NodeList_All']").append(groupNodeListHtml.slice(groupNodeListHtml.indexOf("</li>")));
                        $("li[nodelisttag='node-control'][groupid='" + key + "']").attr("groupid", '0');
                        removeQueue.push(key);
                    }
                }
                for(var i=0 ; i<removeQueue.length ; i++) {
                    delete localGroupInfo[removeQueue[i]];
                }
                
                if($("#NodeList_GroupList").html() == "")
                    $("#NodeList_GroupList").append("<li nodelisttag=\"empty\"><a><b>Group List is empty</b></a></li>");
                
                groupInfo = localGroupInfo;
            }
            catch(e) {
                console.log("1: Get group list exception, action: " + action);
            }

            //Next update.
            switch(action) {
                case "first":
                    checkDefaultPage();
                    setTimeout(function() {getNodeList(true);}, 500);
                    setTimeout(function() {getGroupList("auto");}, updateInterval);
                    break;
                case "auto":
                    setTimeout(function() {getGroupList("auto");}, updateInterval);
                    break;
                default:
                    break;
            }
        },
        error: function(xhr, status, error) {
            console.log("Get the group list failed: [" + xhr.status + "] " + xhr.statusText);
        },
        cache: false
    });
}

//Get node list by specific group id (for move the node from/to group).
function getNodeList_byGroupID(groupID) {
    //Prevent the id sometimes use different type of 1 or 0001 (integer or string).
    groupID = parseInt(groupID);
    
    $.ajax({
        url: 'getNodeList_byGroupID',
        data: {groupID:groupID},
        dataType: 'json',
        success: function(_data, status, xhr) {
            try {
                if(_data.nodelist.length > groupInfo[groupID]["groupNodeList"].length) {
                    //Add the node to group.
                    var removeQueue = [];
                    for(var i=0 ; i<_data.nodelist.length ; i++) {
                        if(groupInfo[groupID]["groupNodeList"].indexOf(_data.nodelist[i].nodeip) == -1) {
                            var ip = _data.nodelist[i].nodeip;
                            var description = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("description");
                            var nodeType = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("nodetype");
                            var bmcFirmware = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("bmcfirmware");
                            var nodePlatform = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("nodeplatform");
                            var nodeGroupID = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("groupid");
                            var nodeCheckJBOD = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("isjbod");
                            var nodeName = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("nodename");
                            var nodeHide = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("style");
                            var nodeSubHtml = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").html();
                            var nodeCheckVM = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("hasvm");
                            var nodeCheckConn = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("isconn");
                            var nodeSerialData = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("serial");
                            
                            //Change to always can click the node link, so cancel this judgment
                            //if (nodeCheckConn == "true")
                                var nodeStatus = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']>a>img").attr("src");
                            //else 
                            //  var nodeStatus = $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']>p>img").attr("src");
                            nodeStatus = nodeStatus.slice(nodeStatus.indexOf("icon_status_")+"icon_status_".length, nodeStatus.indexOf("icon_status_")+"icon_status_".length+1);
                            
                            var appendHtmlString = "";
                            appendHtmlString += '<li nodelisttag="node-control" nodename="' + nodeName + '" id="'+ nodeInfo[ip]["nodeTagID"] + '" description="' + description + '" nodetype="' + nodeType + '" bmcfirmware="' + bmcFirmware + '" nodeplatform="' + nodePlatform + '" groupid="' + nodeGroupID + '" isjbod="' + nodeCheckJBOD + '" hasvm="' + nodeCheckVM + '" isconn="' + nodeCheckConn + '" serial="' + nodeSerialData + '"';
                            if(nodeHide != null) {
                                appendHtmlString += ' style="' + nodeHide + '"';
                            }
                            appendHtmlString += '>';
                            appendHtmlString += nodeSubHtml;
                            appendHtmlString += '</li>';
                            
                            var vmSubHtml = $("li[nodelisttag='vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").html();
                            if(vmSubHtml == null)
                                vmSubHtml = $("li[nodelisttag='sub-vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").html();
                            if(vmSubHtml != null) {
                                appendHtmlString += '<li nodelisttag="sub-vm-control" id="' + nodeInfo[ip]["nodeTagID"] + '"';
                                if (nodeHide != null) {
                                    appendHtmlString += ' style="' + nodeHide + '"';
                                }
                                appendHtmlString += '>';
                                appendHtmlString += vmSubHtml;
                                appendHtmlString += '</li>';
                            }
                            
                            if((nodeGroupID != 0) && (groupInfo[nodeGroupID] != null) && (groupInfo[nodeGroupID]["groupTagID"] != null)) {
                                $("li[nodelisttag='group-title'][groupid='" + nodeGroupID + "']>ul>li[id='" + nodeInfo[ip]["nodeTagID"] + "']").remove();
                                groupInfo[nodeGroupID]["groupNodeList"].splice(groupInfo[nodeGroupID]["groupNodeList"].indexOf(ip), 1);
                                
                                groupInfo[nodeGroupID]["groupCount"]--;
                                $("ul[id^=" + groupInfo[nodeGroupID]["groupTagID"] + "]").parent().find("span.badge").text(groupInfo[nodeGroupID]["groupCount"]);
                                
                                var groupStatus = 4;
                                for(var j=0 ; j<groupInfo[nodeGroupID]["groupNodeList"].length ; j++) {
                                    if(nodeInfo[groupInfo[nodeGroupID]["groupNodeList"][j]]["nodeStatus"] < groupStatus)
                                        groupStatus = nodeInfo[groupInfo[nodeGroupID]["groupNodeList"][j]]["nodeStatus"];
                                }
                                groupInfo[nodeGroupID]["groupStatus"] = groupStatus;
                                $("ul[id^=" + groupInfo[nodeGroupID]["groupTagID"] + "]").parent().find("img[nodelisttag='group-status']").attr("src", "/GSM/resources/img/icon_status_" + groupStatus + ".png");
                            }
                            else {
                                $("ul[id='NodeList_All']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").remove();
                                $("ul[id='NodeList_All']>li[nodelisttag='vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").remove();
                            }

                            if(groupInfo[groupID]["groupTagID"] != null) {
                                $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").append(appendHtmlString);
                            
                                groupInfo[groupID]["groupNodeList"].push(ip);
                                $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("groupid", groupID);
                                $("li[nodelisttag='sub-vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("groupid", groupID);
                                
                                if(nodeStatus < groupInfo[groupID]["groupStatus"]) {
                                    groupInfo[groupID]["groupStatus"] = nodeStatus;
                                    $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").parent().find("img[nodelisttag='group-status']").attr("src", "/GSM/resources/img/icon_status_" + nodeStatus + ".png");
                                }
                                
                                groupInfo[groupID]["groupCount"]++;
                                $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").parent().find("span.badge").text(groupInfo[groupID]["groupCount"]);
                            }
                        }
                    }
                }
                else if(_data.nodelist.length < groupInfo[groupID]["groupNodeList"].length) {
                    //Remove the node from group.
                    var removeQueue = [];
                    for(var i=0 ; i<groupInfo[groupID]["groupNodeList"].length ; i++) {
                        if((groupInfo[groupID] == null) || (groupInfo[groupID]["groupTagID"] == null)) {
                            continue;
                        }

                        if (getObjectKeyIndex(_data.nodelist, groupInfo[groupID]["groupNodeList"][i]) == -1) {
                            var ip = groupInfo[groupID]["groupNodeList"][i];
                            
                            var nodeDescription = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("description");
                            var nodeType = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("nodetype");
                            var bmcFirmware = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("bmcfirmware");
                            var nodePlatform = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("nodeplatform");
                            var nodeGroupID = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("groupid");
                            var nodeCheckJBOD = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("isjbod");
                            var nodeName = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("nodename");
                            var nodeHide = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("style");
                            var nodeSubHtml= $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").html();
                            var nodeCheckVM = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("hasvm");
                            var nodeCheckConn = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("isconn");
                            var nodeSerialData = $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("serial");
                            
                            var appendHtmlString = "";
                            appendHtmlString += '<li nodelisttag="node-control" nodename="' + nodeName + '" id="'+ nodeInfo[ip]["nodeTagID"] + '" description="'+ nodeDescription + '" nodetype="' + nodeType + '" bmcfirmware="' + bmcFirmware + '" nodeplatform="' + nodePlatform + '" groupid="' + nodeGroupID + '" isjbod="' + nodeCheckJBOD + '" hasvm="' + nodeCheckVM + '" isconn="' + nodeCheckConn + '" serial="' + nodeSerialData + '"';
                            if(nodeHide != null) {
                                appendHtmlString += ' style="' + nodeHide + '"';
                            }
                            appendHtmlString += '>';
                            appendHtmlString += nodeSubHtml;
                            appendHtmlString += '</li>';
                            
                            var vmSubHtml= $("ul[nodelisttag='group-list'][id='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='sub-vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").html();
                            if(vmSubHtml != null) {
                                appendHtmlString += '<li nodelisttag="vm-control" id="' + nodeInfo[ip]["nodeTagID"] + '"';
                                if (nodeHide != null) {
                                    appendHtmlString += ' style="' + nodeHide + '"';
                                }
                                appendHtmlString += '>';
                                appendHtmlString += vmSubHtml;
                                appendHtmlString += '</li>';
                            }
                            
                            $("ul[nodelisttag='group-list'][id^='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").remove();
                            $("ul[nodelisttag='group-list'][id^='" + groupInfo[groupID]["groupTagID"] + "']>li[nodelisttag='sub-vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").remove();
                            $("ul[id='NodeList_All']").append(appendHtmlString);
                            
                            removeQueue.push(ip);
                            $("li[nodelisttag='node-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("groupid", '0');
                            $("li[nodelisttag='vm-control'][id='" + nodeInfo[ip]["nodeTagID"] + "']").attr("groupid", '0');
                            
                            groupInfo[groupID]["groupCount"]--;
                            $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").parent().find("span.badge").text(groupInfo[groupID]["groupCount"]);
                        }
                    }
                    
                    for(var i=0 ; i<removeQueue.length ; i++) {
                        groupInfo[groupID]["groupNodeList"].splice(groupInfo[groupID]["groupNodeList"].indexOf(removeQueue[i]), 1);
                    }
                    
                    var groupStatus = 4;
                    for(var i=0 ; i<groupInfo[groupID]["groupNodeList"].length ; i++) {
                        if(nodeInfo[groupInfo[groupID]["groupNodeList"][i]]["nodeStatus"] < groupStatus)
                            groupStatus = nodeInfo[groupInfo[groupID]["groupNodeList"][i]]["nodeStatus"];
                    }
                    groupInfo[groupID]["groupStatus"] = groupStatus;
                    if(groupInfo[groupID]["groupTagID"] != null) {
                        $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").parent().find("img[nodelisttag='group-status']").attr("src", "/GSM/resources/img/icon_status_" + groupStatus + ".png");
                    }
                }
                
                if((searchBoxText != "") && (!searchBoxChecking)) {
                    checkSearchBoxFinished(searchBoxText);
                }
            }
            catch(e) {
                console.log("1: Get node list by group exception, groupID: " + groupID);
            }
        },
        error: function(xhr, status, error) {
            console.log("Get the node list by Group ID (" + groupID + ") failed: [" + xhr.status + "] " + xhr.statusText);
        },
        cache: false
    });
}

//Get the group name and update to group list after rename the group.
function getGroupName(groupID) {
    //Prevent the id sometimes use different type of 1 or 0001 (integer or string).
    groupID = parseInt(groupID);
    
    $.ajax({
        url: 'getGroupName',
        data: {groupID:groupID},
        dataType: 'json',
        success: function(_data, status, xhr) {
            try {
                if((groupInfo[groupID] != null) && (groupInfo[groupID]["groupTagID"] != null)) {
                    $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").parent().find("span[nodelisttag='group-name']").html("&nbsp;&nbsp;&nbsp;" + _data.groupName);
                    $("ul[id^=" + groupInfo[groupID]["groupTagID"] + "]").parent().attr("groupname", _data.groupName);
                }
                
                if((searchBoxText != "") && (!searchBoxChecking)) {
                    checkSearchBoxFinished(searchBoxText);
                }
            }
            catch(e) {
                console.log("1: Get group name exception, groupID: " + groupID);
            }
        },
        error: function(xhr, status, error) {
            console.log("Get the group (" + groupID + ") name failed: [" + xhr.status + "] " + xhr.statusText);
        },
        cache: false
    });
}

//Check the default page settings (the 'defaultPageJSON' data from the MainDashboard).
function checkDefaultPage() {
    if((defaultPageJSON != null) && (defaultPageJSON != "")) {
        var _data = JSON.parse(defaultPageJSON);
        if(_data.ip == "null")
            return;
        
        if(nodeInfo[_data.ip] == null) {
            var appendHtmlString = "";
            
            nodeInfo[_data.ip] = {};
            nodeInfo[_data.ip]["nodeUpdateID"] = nodeUpdateID;
            nodeInfo[_data.ip]["nodeTagID"] = convertIPtoID(_data.ip);
            nodeInfo[_data.ip]["nodeStatus"] = _data.nodeStatus;
            
            /* Brian 2019/07/23: First use host name, if unknown or empty then use product name */
            _data.nodeName = _data.hostName;
            if((_data.nodeName == "") || (_data.nodeName == "Unknown"))
                _data.nodeName = _data.productName;
            
            //Always can click node link
            //if (_data.isConnected == "true") {
                appendHtmlString += '<li nodelisttag="node-control" nodename="' + _data.nodeName + ' (' + _data.ip + ')" id="'+ nodeInfo[_data.ip]["nodeTagID"] + '" description="' + _data.description + '" nodetype="' + _data.nodeType + '" bmcfirmware="' + _data.bmcFirmware + '" nodeplatform="' + _data.nodePlatform + '" groupid="' + _data.groupID + '" isjbod="' + _data.isJBOD + '" hasvm="' + _data.hasVM + '" isconn="' + _data.isConnected + '">';
                appendHtmlString += '<a href=\'javascript:linkPage("' + _data.ip + '")\'>';
                appendHtmlString += '<img nodelisttag="node-status" src="/GSM/resources/img/icon_status_' + _data.nodeStatus + '.png">';
                appendHtmlString += '&nbsp;&nbsp;&nbsp;' + _data.nodeName + '&nbsp;(' + _data.ip + ')';
                appendHtmlString += '</a>';
                appendHtmlString += '</li>';
            /*} else {
                appendHtmlString += '<li nodelisttag="node-control" nodename="' + _data.nodeName + ' (' + _data.ip + ')" id="'+ nodeInfo[_data.ip]["nodeTagID"] + '" nodetype="' + _data.nodeType + '" nodeplatform="' + _data.nodePlatform + '" groupid="' + _data.groupID + '" isjbod="' + _data.isJBOD + '" hasvm="' + _data.hasVM + '" isconn="' + _data.isConnected + '">';
                appendHtmlString += '<p>';
                appendHtmlString += '<img nodelisttag="node-status" src="/GSM/resources/img/icon_status_' + _data.nodeStatus + '.png">';
                appendHtmlString += '&nbsp;&nbsp;&nbsp;' + _data.nodeName + '&nbsp;(' + _data.ip + ')';
                appendHtmlString += '</p>';
                appendHtmlString += '</li>';
            }*/
            
            appendHtml(_data, "insert_node", appendHtmlString);
        }
        
        switch(_data.defaultPageKey) {
            case "Filter":
                filterMenuSelected = _data.defaultPageValue;
                $("#nodeListFilter").val(filterMenuSelected);
                $("ul[id^=NodeList_]").hide();
                $("#NodeList_" + filterMenuSelected).show();
                if(_data.defaultPageValue != "Health" && _data.defaultPageValue != "Non-Connected")
                    tabMenuSelected = "NodeEventLog";
                else
                    tabMenuSelected = "NodeInformation";
                linkPage(_data.ip);
                break;
            
            case "Power":
                tabMenuSelected = "NodePowerConsumption";
                linkPage(_data.ip);
                break;
        }
    }
}

function redirectPreference() {
    topMenuSelected = "Preference";
    $("#Preference").addClass("active");
    $("#Preference").find("img").attr("src", "/GSM/resources/img/mainmenu_Preference_white.png");
    $(".topbar-nav li").not("#Preference").removeClass("active");
    $(".topbar-nav img").not("#Preference").attr("src", function() {return $(this).attr("src").replace("white", "gray");});
    $("ul[nodelisttag='group-list']").collapse('hide');
    $("li[nodelisttag='node-control']").removeClass("active");
    $("li[nodelisttag='group-control']").removeClass("active");
    $("#tabMenuSelect_" + topMenuSelected).prop('selectedIndex',0);
    tabMenuSelected = $("#tabMenuSelect_" + topMenuSelected).val();
    sideMenuSelected = firstNode;
    $("select[id^=tabMenuSelect_]").hide();
    $("#tabMenuSelect_" + topMenuSelected).show();

    linkPage("top");
}

//Append the node/group to html, according to data to append it to different filter list.
function appendHtml(_data, type, htmlString) {
    var appendIDQueue = [];
    
    if(type == "insert_node") {
        if((_data.groupID != 0)) {
            if((groupInfo[_data.groupID] != null) && (groupInfo[_data.groupID]["groupTagID"] != null)) {
                appendIDQueue.push(groupInfo[_data.groupID]["groupTagID"]);
            }
            
            if(_data.nodeType == "SMC")
                appendIDQueue.push("NodeList_StandardSystem");
        }
        else {
            appendIDQueue.push("NodeList_All");
            
            if(_data.nodeType == "RMC")
                appendIDQueue.push("NodeList_RackList");
            else if(_data.nodeType == "CMC")
                appendIDQueue.push("NodeList_MultiNodeSystem");
            else if(_data.nodeType == "SMC")
                appendIDQueue.push("NodeList_StandardSystem");
            else if(_data.nodeType == "ESX" || _data.nodeType == "HyperV")
                appendIDQueue.push("NodeList_VirtualMachine");
        }
        
        if(_data.isJBOD == "true")
            appendIDQueue.push("NodeList_Storage");
        
        if(_data.nodeStatus == "1")
            appendIDQueue.push("NodeList_Critical");
        else if(_data.nodeStatus == "2")
            appendIDQueue.push("NodeList_Non-Critical");
        else if(_data.nodeStatus == "3")
            appendIDQueue.push("NodeList_Unknown");
        else if(_data.nodeStatus == "4")
            appendIDQueue.push("NodeList_Health");
        else if(_data.nodeStatus == "0")
            appendIDQueue.push("NodeList_Non-Connected");
    }
    else if(type == "create_group") {
        appendIDQueue.push("NodeList_All");
        
        if(_data.groupType == "RMC")
            appendIDQueue.push("NodeList_RackList");
        else if(_data.groupType == "CMC")
            appendIDQueue.push("NodeList_MultiNodeSystem");
        else
            appendIDQueue.push("NodeList_GroupList");
    }
    
    for(var i=0 ; i<appendIDQueue.length ; i++) {
        if($("#" + appendIDQueue[i] + ">li").attr("nodelisttag") == "empty")
            $("#" + appendIDQueue[i]).empty();
        
        if(type == "create_group") {
            if((groupInfo[_data.groupID] != null) && (groupInfo[_data.groupID]["groupTagID"] != null)) {
                if(appendIDQueue[i] == "NodeList_All") {
                    var htmlString_All = "";
                    var insertTag = "All"
                    var insertPosition = htmlString.indexOf(groupInfo[_data.groupID]["groupTagID"]) + groupInfo[_data.groupID]["groupTagID"].length;
                    var insertPosition2 = htmlString.indexOf(groupInfo[_data.groupID]["groupTagID"], htmlString.indexOf(groupInfo[_data.groupID]["groupTagID"]) + 1) + groupInfo[_data.groupID]["groupTagID"].length;
                    
                    htmlString_All = [htmlString.slice(0, insertPosition2), insertTag, htmlString.slice(insertPosition2)].join('');
                    htmlString_All = [htmlString_All.slice(0, insertPosition), insertTag, htmlString_All.slice(insertPosition)].join('');
                    
                    $("#" + appendIDQueue[i]).append(htmlString_All);
                }
                else {
                    $("#" + appendIDQueue[i]).append(htmlString);
                }
            }
        }
        else if(type == "insert_node") {
            $("ul[id^=" + appendIDQueue[i] + "]").append(htmlString);
        }
    }
    
    if((searchBoxText != "") && (!searchBoxChecking)) {
        checkSearchBoxFinished(searchBoxText);
    }
}

//Check the nodeInfo has data (node list not empty).
function checkNodeInfoHasData() {
    for(var key in nodeInfo) {
        return true;
    }
    
    return false;
}

//Get the random ID, the default ID length is 10 bytes.
function randomID(idLength) {
    var id = "";
    
    if((idLength == null) || (idLength == ""))
        idLength = 10;
    
    for(var i=0 ; i<idLength ; i++) {
        switch(Math.floor((Math.random() * 3) + 1)) {
            case 1:
                //0~9
                id += Math.floor((Math.random() * 10));
                break;
            case 2:
                //A~Z
                id += String.fromCharCode(Math.floor((Math.random() * 26) + 65));
                break;
            case 3:
                //a~z
                id += String.fromCharCode(Math.floor((Math.random() * 26) + 97));
                break;
        }
    }
    
    return id;
}

//PJ: change innerHTML for username/password is incorrect
var original_inner;

function IframeReadyStateChanged()
{
    if (document.getElementById('gsmiframe').contentWindow.document.readyState == 'complete') {
        original_inner = document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').innerHTML;
        document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').innerHTML = webAlert_4;                                            
        document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').style.color = 'red';
        document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').style.fontWeight  = 'bold';
    }
}

function IframeReadyStateOriginal()
{
    if (document.getElementById('gsmiframe').contentWindow.document.readyState == 'complete' && original_inner != null) { 
        document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').innerHTML = original_inner;                                            
        document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').style.color = 'black';
        document.getElementById('gsmiframe').contentWindow.document.getElementById('account_notify').style.fontWeight  = 'normal';
    }
}

//Link the page to iframe (id='gsmiframe').
function linkPage(target) {
	if((target != "top") && (target != "tab")) {
        topMenuSelected = "SystemManager";
        sideMenuSelected = target;
        checkSupportive(target);
    }
    
    switch(topMenuSelected) {
        case "SystemManager":
            if(sideMenuSelected === "0.0.0.0") {
                redirectPreference();
                return false;
            }

            if(target == "top") {
                if(filterMenuSelected != "All") {
                    filterMenuSelected = "All";
                    $("#nodeListFilter").val(filterMenuSelected);
                    $("ul[id^=NodeList_]").hide();
                    $("#NodeList_" + filterMenuSelected).show();
                }
                if((searchBoxText != "") && (!searchBoxChecking)) {
                    if((searchBoxFirstNode != null) && (searchBoxFirstNode != "")) {
                        sideMenuSelected = convertIDtoIP(searchBoxFirstNode);
                    }
                    else {
                        searchBoxText = "";
                        $("#searchbox").val(searchBoxText);
                        $("li[nodelisttag]").show();
                    }
                }
            }
            $("select[id^=tabMenuSelect_]").hide();
            $("li[nodelisttag='node-control']").removeClass("active");
            $("li[nodelisttag='group-control']").removeClass("active");
            $(".topbar-nav li").not("#SystemManager").removeClass("active");
            $(".topbar-nav img").not("#SystemManager").attr("src", function() {return $(this).attr("src").replace("white", "gray");});
            $("#SystemManager").addClass("active");
            $("#SystemManager").find("img").attr("src", "/GSM/resources/img/mainmenu_SystemManager_white.png");
            
            if(checkIsIP(sideMenuSelected)) {
                if(target == "top")
                    checkSupportive(sideMenuSelected);
                
                var ipID = convertIPtoID(sideMenuSelected);
                
                $("li[id='" + ipID + "']").addClass("active");
                if($("li[id='" + ipID + "']").parent().attr("nodelisttag") == "group-list")
                    $("li[id='" + ipID + "']").parent().collapse('show');
                
                if((target != "tab") && ($("#tabMenuSelect_SystemManager").html().indexOf("NodeVirtualMachine") >= 0)) {
                    tabMenuSelected = "NodeVirtualMachine";
                }
                
                if($("#tabMenuSelect_SystemManager").html().indexOf(tabMenuSelected) >= 0) {
                    $("#tabMenuSelect_SystemManager").val(tabMenuSelected);
                }
                else {
                    $("#tabMenuSelect_SystemManager").prop('selectedIndex',0);
                    tabMenuSelected = $("#tabMenuSelect_SystemManager").val();
                }
                $("#tabMenuSelect_SystemManager").show();
                
                switch(tabMenuSelected) {
                    case "NodeInformation":
                    case "NodeMonitoring":
                    case "NodeRemoteAccess":
                    case "NodeNetworkConfiguration":
                    case "NodeEventLog":
                    case "NodeAlertManagement":
                    case "NodeUpdate":
                    case "NodePowerConsumption":
                    case "NodeSol":
                    case "NodeSoftware":
                    case "NodeRemoteBIOSSetup":
                    case "NodeVirtualMachine":
                        break;
                    default:
                        $("#tabMenuSelect_SystemManager").prop('selectedIndex',0);
                        tabMenuSelected = "NodeInformation";
                        break;
                }
                
                $.ajax({
                    url: "CheckNodeStatus",
                    type: "POST",
                    data: {IP: sideMenuSelected},
                    dataType: "json",
                    success: function(_data, status, xhr) {
                        if (_data.type == "Node") {
                            
                            /* Brian 2019/07/23: First use host name, if unknown or empty then use product name */
                            _data.nodeName = _data.hostName;
                            if((_data.nodeName == "") || (_data.nodeName == "Unknown"))
                                _data.nodeName = _data.productName;
                            
                            if (_data.isConn) {
                                if (_data.pwdCorr) {
                                    var srcPath = $("li[nodelisttag='node-control'][id='" + convertIPtoID(sideMenuSelected) + "']").find("a").find("img").attr("src");
                                    var nodeStatus = srcPath.substring(srcPath.indexOf("icon_status_") + "icon_status_".length, srcPath.indexOf(".png"));
                                    
                                    if (nodeStatus == "3")
                                        nodeStatus = "4";

                                    if (!_data.hasEvent)
                                        $("li[nodelisttag='node-control'][id='" + convertIPtoID(sideMenuSelected) + "']").find("a").html("<img nodelisttag=\"node-status\" src=\"/GSM/resources/img/icon_status_" + nodeStatus + ".png\">" +
                                            "&nbsp;&nbsp;&nbsp;" +  _data.nodeName + "&nbsp;(" + sideMenuSelected + ")");
                                    $("#gsmiframe").attr('src', "./" + tabMenuSelected + "?IP=" + sideMenuSelected);
                                    if (nodelistisclicked) {                                            
                                        $('#gsmiframe').on('load', IframeReadyStateOriginal);
                                        nodelistisclicked = false;
                                    }
                                } else {                                        
                                    //if (nodelistisclicked) { //PJ: still need to jump remote access from dash board
                                        $("#gsmiframe").attr('src', "./NodeRemoteAccess?IP=" + sideMenuSelected + "#BMCAccount");
                                        $('#gsmiframe').on('load', IframeReadyStateChanged);
                                        nodelistisclicked = false;
                                    //}
                                }
                            } else {
                                $("li[nodelisttag='node-control'][id='" + convertIPtoID(sideMenuSelected) + "']").attr("isconn", "false");
                                //Always can click node link
                                /*$("li[nodelisttag='node-control'][id='" + convertIPtoID(sideMenuSelected) + "']").html("<p><img nodelisttag=\"node-status\" src=\"/GSM/resources/img/icon_status_0.png\">" +
                                        "&nbsp;&nbsp;&nbsp;" +  _data.nodeName + "&nbsp;(" + sideMenuSelected + ")</p>");
                                $("#gsmiframe").attr('src', "./" + tabMenuSelected + "?IP=" + sideMenuSelected);*/
                                $("li[nodelisttag='node-control'][id='" + convertIPtoID(sideMenuSelected) + "']").find("a").html("<img nodelisttag=\"node-status\" src=\"/GSM/resources/img/icon_status_0.png\">" +
                                        "&nbsp;&nbsp;&nbsp;" +  _data.nodeName + "&nbsp;(" + sideMenuSelected + ")");
                                $("#gsmiframe").attr('src', "./" + tabMenuSelected + "?IP=" + sideMenuSelected);
                                if (nodelistisclicked) {                                            
                                    $('#gsmiframe').on('load', IframeReadyStateOriginal);
                                    nodelistisclicked = false;
                                }
                            }
                        } else if (_data.type == "VM") {                                
                            if (_data.pwdCorr)
                                $("#gsmiframe").attr('src', "./" + tabMenuSelected + "?IP=" + sideMenuSelected);
                            else {
                                if (nodelistisclicked) {
                                    alert( "IP " + sideMenuSelected + "'s VM "+ webAlert_5);
                                    $("#gsmiframe").attr('src', "./NodeVirtualMachine?IP=" + sideMenuSelected + "#VMAccount");
                                    nodelistisclicked = false;
                                }
                            }
                        } else {
                            redirectPreference();
                        }
                    },
                    error: function(xhr, status, error) {
                        if (nodelistisclicked) {
                            alert("Something error");
                            redirectPreference();
                            nodelistisclicked = false;
                        }
                        
                        console.log("Check node status failed: [" + xhr.status + "] " + xhr.statusText);
                    }
                });
            }
            else {
                $("li[id='" + sideMenuSelected + "']").addClass("active");
                $("li[id='" + sideMenuSelected + "']").parent().collapse('show');
                if($("#tabMenuSelect_Group").html().indexOf(tabMenuSelected) >= 0) {
                    $("#tabMenuSelect_Group").val(tabMenuSelected);
                }
                else {
                    $("#tabMenuSelect_Group").prop('selectedIndex',0);
                    tabMenuSelected = $("#tabMenuSelect_Group").val();
                }
                $("#tabMenuSelect_Group").show();
                
                switch(tabMenuSelected){
                    case "GroupDashboard":
                    case "GroupRemoteAccess":
                    case "GroupUpdate":
                    case "GroupLog":
                    case "GroupPowerConsumption":
                    case "GroupNetworkConfig":
                    case "GroupAlertManagement":
                        break;
                    default:
                        $("#tabMenuSelect_Group").prop('selectedIndex',0);
                        tabMenuSelected = "GroupDashboard";
                        break;
                }
                
                $("#gsmiframe").attr('src', "./" + tabMenuSelected + "?ID=" + sideMenuSelected);
            }
            break;
        
        case "GroupManager":
            if(filterMenuSelected != "GroupList") {
                filterMenuSelected = "GroupList";
                $("#nodeListFilter").val(filterMenuSelected);
                $("ul[id^=NodeList_]").hide();
                $("#NodeList_" + filterMenuSelected).show();
            }
            
            $("#gsmiframe").attr('src', "./Grouplist");
            break;
        
        case "Deployment":
            $("#gsmiframe").attr('src', "./Deployment");
            break;
        
        case "Alert":
            $("#gsmiframe").attr('src', "./NodeStatus");
            break;
        
        case "Account":
            $("#gsmiframe").attr('src', "./SettingUserManagement");
            break;
        
        case "Preference":
            switch(tabMenuSelected) {
                case "GSMDashboard":
                case "GSMLog":
                case "GSMAlertManagement":
                case "GSMDBUpdate":
                case "GSMProperties":
                case "GSMInteractiveUtility":
                case "SettingUpdate":
                case "GSMLanguage":
                    break;
                default:
                    tabMenuSelected = "GSMDashboard";
                    break;
            }
            
            $("#gsmiframe").attr('src', "./" + tabMenuSelected);
            break;
        
        case "Help":
            $("#gsmiframe").attr('src', "./HelpManual");
            break;
        
        case "Logout":
            window.location.href = "./Logout";
            break;
    }
}

/*function adaptSidebarWidth(id) {
var maxWidth = 0;
$(id + ">li>a>span").each(function() {
    if($(this).width() > 165) {
        if($(this).width() > maxWidth)
            maxWidth = $(this).width();
    }
});
if(maxWidth != 0) {
    var margin_left = 10;
    $(id + ">li>a").each(function() {
        $(this).css("width", maxWidth + margin_left + 86);
    });
}
}*/

//Check the node/group supported feature, and then hide unsupported features.
function checkSupportive(target) {
    if(checkIsIP(target))
        checkNodeSupportive(target);
    else
        checkGroupSupportive(target);
}
function checkNodeSupportive(ip) {
    if(ip === "0.0.0.0") {
        $("#tabMenuSelect_SystemManager").empty();
        $("#tabMenuSelect_SystemManager").prop("disabled", true);
        return false;
    }
    
    if(tabMenuOriginalHtml["SystemManager"] == null)
        tabMenuOriginalHtml["SystemManager"] = $("#tabMenuSelect_SystemManager").html();
    
    $("#tabMenuSelect_SystemManager").empty();
    $("#tabMenuSelect_SystemManager").append(tabMenuOriginalHtml["SystemManager"]);
    $("#tabMenuSelect_SystemManager").prop("disabled", false);
    
    //Redfish only supports very few features.
    if(connectionInterface == "Redfish") {
        $('#NodeNetworkConfiguration').remove();
        $('#NodeAlertManagement').remove();
        $('#NodeUpdate').remove();
        $('#NodePowerConsumption').remove();
        $('#NodeSoftware').remove();
        $('#NodeVirtualMachine').remove();
    }
    
    var ipID = convertIPtoID(ip);
    
    switch ($("#" + ipID).attr("nodetype")) {
        case "RMC":
        case "CMC":
            $('#NodePowerConsumption').remove();
            $('#NodeSoftware').remove();
            break;
        case "SMC":
            break;
        case "ESX":
        case "HyperV":
            $('#NodeInformation').remove();
            $('#NodeMonitoring').remove();
            $('#NodeRemoteAccess').remove();
            $('#NodeNetworkConfiguration').remove();
            $('#NodeEventLog').remove();
            $('#NodeAlertManagement').remove();
            $('#NodeUpdate').remove();
            $('#NodePowerConsumption').remove();
            $('#NodeSol').remove();
            $('#NodeSoftware').remove();
            $('#NodeRemoteBIOSSetup').remove();
            break;
        default:
            $('#NodeInformation').remove();
            $('#NodeMonitoring').remove();
            $('#NodeRemoteAccess').remove();
            $('#NodeNetworkConfiguration').remove();
            $('#NodeEventLog').remove();
            $('#NodeAlertManagement').remove();
            $('#NodeUpdate').remove();
            $('#NodePowerConsumption').remove();
            $('#NodeSol').remove();
            $('#NodeSoftware').remove();
            $('#NodeRemoteBIOSSetup').remove();
            $('#NodeVirtualMachine').remove();
            return;
            break;
    }
    
    switch ($("#" + ipID).attr("nodeplatform")) {
        case "Grantley":
        case "Purley":          
            break;

        default:
            if($("#" + ipID).attr("nodeplatform").toLowerCase().indexOf("amd") >= 0)
                break;
            
            //Cavium/ThunderX/ThunderX2/...
            $('#NodePowerConsumption').remove();
            break;
    }
    
    switch ($("#" + ipID).attr("bmcfirmware")) {
        default:
        case "Vertiv":
        case "OpenBMC":
            $('#NodeRemoteBIOSSetup').remove();
            break;
        case "AMI":
            break;
    }
    
    if ($("#" + ipID).attr("hasvm") == "false")
        $('#NodeVirtualMachine').remove();
    
    if ($("#" + ipID).attr("isconn") == "false") {
        $('#NodeRemoteAccess').remove();
        $('#NodeNetworkConfiguration').remove();
        $('#NodeAlertManagement').remove();
        $('#NodeUpdate').remove();
        $('#NodePowerConsumption').remove();
        $('#NodeSol').remove();
        $('#NodeSoftware').remove();
        $('#NodeRemoteBIOSSetup').remove();
        $('#NodeVirtualMachine').remove();
    }
}
function checkGroupSupportive(id) {
    if(tabMenuOriginalHtml["Group"] == null)
        tabMenuOriginalHtml["Group"] = $("#tabMenuSelect_Group").html();
    
    $("#tabMenuSelect_Group").empty();
    $("#tabMenuSelect_Group").append(tabMenuOriginalHtml["Group"]);
    
    //Redfish only supports very few features.
    if(connectionInterface == "Redfish") {
        $('#GroupUpdate').remove();
        $('#GroupPowerConsumption').remove();
        $('#GroupNetworkConfig').remove();
        $('#GroupAlertManagement').remove();
    }
    
    switch (groupInfo[id]["groupType"]) {
        default:
        case "RMC":
        case "CMC":
            $('#GroupRemoteAccess').remove();
            $('#GroupPowerConsumption').remove();
            break;
        
        case "Group":
            break;
    }
}

//Check the browser name and version, because GSM does not support older versions of IE.
function checkBrowser() {
    var appName  = navigator.appName;
    var userAgent = navigator.userAgent;
    
    if(userAgent.indexOf("MSIE") != -1) {
        var msieStringTag = userAgent.indexOf("MSIE");
        var msieVersion = userAgent.substring((msieStringTag + 5), userAgent.indexOf(";", msieStringTag));
        
        switch(parseInt(msieVersion)) {
            //Not support.
            default:
            case 8:
                alert("Your browser is " + appName + " " + msieVersion + ".\nGSM does not support IE 8 and below, please update to IE 9 and later or download other browsers (Chrome ... etc.).");
                window.location.href = "./";
                break;
            
            //Support.
            case 9:
            case 10:
            //IE 11, the appName is 'Netscape', userAgent keyword is 'Trident', version is 'rv' in userAgent.
            //MS EDGE, the appName is 'Netscape', userAgent keyword is 'Edge'.
                break;
        }
    }
}

//Check the alert count, and show on the top bar.
function checkGSMAlertCount() {
    $.ajax({
        url: 'getGSMAlertCount',
        data: {},
        dataType: 'json',
        success: function(_data, status, xhr) {
            if(_data.countTotal != 0) {
                $("#alertCount").text(_data.countTotal);
                $("#alertCount").show();
            }
            else {
                $("#alertCount").hide();
                $("#alertCount").text("0");
            }
            
            setTimeout(function() {checkGSMAlertCount();}, 5000);
        },
        error: function(xhr, status, error) {
            console.log("Get the alert count failed: [" + xhr.status + "] " + xhr.statusText);
        },
        cache: false
    });
}

//Get the key index of an object.
function getObjectKeyIndex(obj, keyToFind) {
    for (var i = 0;i < obj.length;i++) {
        if (obj[i].nodeip == keyToFind)
            return i
    }
    
    return -1;
}

function convertIPtoID(ip) {
    if(ip.indexOf(".") != -1)
        ip = ip.replace(/\./g, "_");
    else if(ip.indexOf(":") != -1)
        ip = ip.replace(/:/g, "_");
    
    return ip;
}

function convertIDtoIP(ip) {
    //Check the IP is IPv4 or IPv6
    var isIPv4 = false;
    var ipArray = ip.split("_");
    if(ipArray.length == 4) {
        if((0 <= ipArray[0] && ipArray[0] < 256) && (0 <= ipArray[1] && ipArray[1] < 256) && (0 <= ipArray[2] && ipArray[2] < 256) && (0 <= ipArray[3] && ipArray[3] < 256))
            isIPv4 = true;
    }
    
    if(isIPv4)
        return ip.replace(/_/g, ".");
    else
        return ip.replace(/_/g, ":");
}

function checkIsIP(ip) {
    if((ip.indexOf(".") != -1) || (ip.indexOf(":") != -1))
        return true;
    else
        return false;
}

function changeVariableValueManually(selected, value) {
    switch(selected) {
        case "topMenuSelected":
            topMenuSelected = value;
            break;
        case "tabMenuSelected":
            tabMenuSelected = value;
            break;
        default:
            break;
    }
}

function focusTargetNode(target) {
    $("li[id='" + convertIPtoID(target) + "']").addClass("active");
}

function unfocusTargetNode(target) {
    $("li[id='" + convertIPtoID(target) + "']").removeClass("active");
}
