<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!-- Joyce 2016.04.26: Add import for get Database Usage info. -->
<%@ page import = "com.gigabyte.service.thread.SystemMonitor"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>GSM Database</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS-->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<style type="text/css">
		.dl-horizontal {
			margin-bottom: 0px;
		}
	    .btn-file {
		    position: relative;
		    overflow: hidden;
		}
		.btn-file input[type=file] {
		    position: absolute;
		    top: 0;
		    right: 0;
		    min-width: 100%;
		    min-height: 100%;
		    font-size: 100px;
		    text-align: right;
		    filter: alpha(opacity=0);
		    opacity: 0;
		    outline: none;
		    background: white;
		    cursor: inherit;
		    display: block;
		}
		input[readonly] {
		  background-color: white !important;
		  cursor: text !important;
		}
	</style>
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
                            <div class="panel-heading">
                                <h4><spring:message code="dbUsage"/></h4>
                            </div>
                            <!-- /.panel-heading -->

                            <div class="panel-body">
                                <div class="col-lg-8">
                                    <!-- Joyce 2016.04.26: Fix the DataBase Location.
                                    DB location: <strong></strong> -->
                                    <% SystemMonitor mSystemMonitor = new com.gigabyte.service.thread.SystemMonitor();
                                    mSystemMonitor.getDiskUsage(); %>
								
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" style="width:<% out.println(mSystemMonitor.getOtherUsagePercent());%>">
                                            <% out.println(mSystemMonitor.getOtherUsagePercent());%>
                                        </div>
                                        <div class="progress-bar progress-bar-info" role="progressbar" style="width:<% out.println(mSystemMonitor.getDatabaseUsagePercent()); %>">
                                             <% out.println(mSystemMonitor.getDatabaseUsagePercent()); %>
                                        </div>
                                        <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" style="width:<% out.println(mSystemMonitor.getFreePercent()); %>">
                                            <% out.println(mSystemMonitor.getFreePercent()); %>
                                        </div>
                                    </div>

                                    <div>
                                        <dl class="dl-horizontal">
                                        	<dt>
                                                <div class="progress col-lo">
                                                    <div class="progress-bar" role="progressbar" style="width:0%"></div>	
                                                </div>
                                            </dt>
                                            <dd>Total Size: <b><% out.println(mSystemMonitor.getTotalSize()); %></b></dd>
                                            <dt>
                                                <div class="progress col-lo">
                                                    <div class="progress-bar" role="progressbar" style="width:100%"></div>	
                                                </div>
                                            </dt>
                                            <dd>Other Usage: <b><% out.println(mSystemMonitor.getOtherUsageSize()); %></b></dd>
                                            <dt>
                                                <div class="progress">
                                                    <div class="progress-bar progress-bar-info " role="progressbar" style="width:100%"></div>	
                                                </div>
                                            </dt>
                                            <dd>Database Usage: <b><% out.println(mSystemMonitor.getDatabaseUsageSize()); %></b></dd>
                                            <dt>
                                                <div class="progress">
                                                   <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" style="width:100%"></div>	
                                                </div>
                                            </dt>
                                            <dd>Free Space: <b><% out.println(mSystemMonitor.getFreeSize()); %></b></dd>
                                        </dl>
                                    </div>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
	                        
						<sec:authorize access="hasAnyRole(${Access_Configuration})">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="Database"/> <spring:message code="Restore"/>/<spring:message code="Backup"/></h4>
							</div><!-- /.panel-heading -->
							
							<div class="panel-body">
								<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
									<form name="formData_Database" enctype="multipart/form-data" class="form-inline">
										<div class="well">
											<div>
												<label><spring:message code="GSMDBUpdate6"/> (<spring:message code="NodeUpdate9"/> .zip)</label>
											</div>
											<div class="form-group col-lg-10">
												<div class="input-group" style="width: 100%">
											    	<div class="btn-group" style="width: 100%">
											    	<input type="text" class="form-control" style="width: 70%" readonly>
											    	<span class="btn btn-primary btn-file">
											            <i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input id="restoreDatabaseFile" type="file" name="file">
											        </span>
											        <button type="button" id="restoreDatabase" class="btn btn-danger" title="<spring:message code="Restore"/>">
														<i class="fa fa-upload"></i>&nbsp;<spring:message code="Restore"/>
													</button>
													<button type="button" id="backupDatabase" class="btn btn-primary" title="<spring:message code="Backup"/>">
														<i class="fa fa-download"></i>&nbsp;<spring:message code="Backup"/>
													</button>
											    	</div>
												</div>
											</div>
											<div>
												<label style="font-weight: normal"><br/></label>
											</div>
										</div>
									</form>
								</div>
							</div><!-- /.panel-body -->
						</div><!-- /.panel -->
						</sec:authorize>
					</div><!-- /.col-lg-12 -->
				</div><!-- /.row -->
				
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel panel-danger">
							<div class="panel-heading">
								<h4 class="page-header"><spring:message code="Database"/> <spring:message code="Reset"/></h4>
							</div>
							
							<div class="panel-body">
								<blockquote>
									<p><spring:message code="mainMenu4-5"/>
								</blockquote>
								<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
									<button id="resetDatabase" type="submit" class="btn btn-danger">
										<spring:message code="Reset"/>
									</button>
								</div>
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				</sec:authorize>
			</div><!-- /.container-fluid -->
		</div><!-- /.page-wrapper -->
	</div><!-- /#page-wrapper -->
	
	<div style="color:black" class="modal fade" id="loadingModal" tabindex="-1" role="dialog" aria-labelledby="loadingModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<i class="fa fa-5x fa-spinner fa-pulse"></i>&nbsp;&nbsp;<div id="loadingModalMsg" style="display: inline-block;"><spring:message code="GSMDBUpdate3"/></div>
					<br>
				</div>
				
				<!-- <div class="modal-footer">
					<spring:message code="GSMDBUpdate7"/>
					<button type="button" class="btn btn-primary" onclick="goBack()"><spring:message code="Back"/></button>
				</div> -->
			</div>
		</div>
	</div>
	
	<script>
		var isUpdating = "false";
	
		$(document).ready(function() {
			var resetErrCode = '${resetErrCode}';
			if(resetErrCode != 0) {
				if(resetErrCode == 1) {
					alert('Reset the system failed: ${resetErrMsg}');
				}
				else {
					alert("<spring:message code="webErrMsg${resetErrCode}"/>");
					parent.window.location.href = "./Logout";
				}
			}
			
			$('.btn-file :file').on('fileselect', function(event, numFiles, label) {
		        var input = $(this).parents('.input-group').find(':text'),
		            log = numFiles > 1 ? numFiles + ' files selected' : label;
		        
		        if( input.length ) {
		            input.val(log);
		        } else {
		            //if( log ) alert(log);
		        }
		    });
		});
		
		$('#restoreDatabase').click(function(){
			showLoading($(this).attr("id"));
			
			setTimeout(function() {
				var csrfParameter= "${_csrf.parameterName}";
				var csrfToken = "${_csrf.token}";
			    var formData = new FormData($('form')[0]);
			 	
			    $.ajax({
			        url: 'UploadDBFile?'+csrfParameter+'='+csrfToken,  //Server script to process data
			        type: 'POST',
			        data: formData,
			        success: function(_data, status, xhr) {
			        	alert("Update success.");
			        	parent.window.location.href = "./Logout";
			        },
			        error: function(xhr, status, error) {
			        	alert(xhr.responseText);
			            console.log("Upload database file failed: [" + xhr.status + "] " + xhr.statusText);
			        	showLoading();
					},
			        cache: false,
			        contentType: false,
			        processData: false
			    });
			}, 1000);
		});
		
		$('#backupDatabase').on("click", function() {
			showLoading($(this).attr("id"));
			
			setTimeout(function() {
				var csrfParameter= "${_csrf.parameterName}";
				var csrfToken = "${_csrf.token}";
				$.ajax({
			        url: "BackupDatabase" + "?" + csrfParameter + "=" + csrfToken,
			        type: 'POST',
					dataType: 'json',
			        success: function(data, status, xhr) {
			        	var jsonObj = JSON.parse(xhr.responseText);
			        	if(jsonObj.status)
			        		window.location.href = "./DownloadBackupDatabase?tempID=" + jsonObj.tempID;
			        	else
			        		alert(jsonObj.statusMsg);
			        	
			        	showLoading();
			        },
			        error: function(xhr, status, error) {
			            alert(xhr.responseText);
			            console.log("Backup database failed: [" + xhr.status + "] " + xhr.statusText);
			        	showLoading();
					},
			        cache: false,
			        contentType: false,
			        processData: false
			    });
			}, 1000);
		});
		
		$('#resetDatabase').on("click", function() {
			if(!confirm('Reset the database data, all services and thread processes will be shutdown.\n\nAre you sure?'))
				return;
			
			showLoading($(this).attr("id"));
			
        	window.location.href = "./ResetDatabase";
		});
		
		$(document).on('change', '.btn-file :file', function() {
			  var input = $(this),
			      numFiles = input.get(0).files ? input.get(0).files.length : 1,
			      label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
			  input.trigger('fileselect', [numFiles, label]);
		});
		
		function showLoading(id)
		{
			var loadingMsg = "";
			
			switch(id) {
				case "restoreDatabase":
					loadingMsg = '<spring:message code="GSMDBUpdate3"/>';
					break;
				case "backupDatabase":
					loadingMsg = '<spring:message code="GSMDBUpdate4"/>';
					break;
				case "resetDatabase":
					loadingMsg = '<spring:message code="GSMDBUpdate5"/>';
					break;
			}
			
			if(loadingMsg != "") {
				$('#loadingModalMsg').text(loadingMsg);
				if(!$('#loadingModal').hasClass('in'))
					$('#loadingModal').modal({backdrop: 'static', keyboard: false});
			}
			else {
				if($('#loadingModal').hasClass('in'))
					$('#loadingModal').modal('hide');
			}
		}
		
		//go back function
		function goBack() {
		    window.history.back();
		}
	</script>
</body>
</html>