<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Interactive Utility</title>

        <!-- Javascript -->
        <script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
        <!-- CSS-->
        <link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
        <style>
            body,html {
                height:95%;
            }
            .terminal {
                height: 80%;
                border: 2px solid #AAA;
                padding: 10px;
                border-radius: 5px;
                color:#AAA;
                margin-left:5%;
                margin-right:5%;
                margin-bottom:5%;
                overflow:auto;
                border-top-right-radius: 0px;
            }
            .terminal-button {
                border: 1px solid #AAA;
                border-top-left-radius: 5px;
                border-top-right-radius: 5px;
                color:white;
                margin-right:5%;
                margin-left:90%;
                text-align:center;
                cursor: pointer;
            }
            .cursorblink{
               color:#AAA;
               background-color: green;
            }
            .inputpath {
                background-color:black;
                color:#AAA;
                width:100%;
            }
        </style>
    </head>
    <body style="background-color:black;">
        <div class="container-fluid" style="height:100%; min-width:1000px;">
            <div style="margin-left:5%;margin-right:5%;">
                <div class="row" style="color:#AAA;">
                    <strong>GbtUtility Path</strong>
                </div>
                <div>
                    <input id="utilityPathText" type="text" class="inputpath" value="${UtilityPath}" readonly>
                </div>
            </div>
            <br>
            <div id="clearTerminal" class="terminal-button" onmouseover="this.style.color='red'" onmouseout="this.style.color='white'">
                    clear
            </div>
            <div id="Terminal" class="terminal">
                <pre id="console_text"><span id="console_front">GSM~#</span><span id="console_cursor" class="cursorblink">&nbsp;</span><span id="console_back"></span></pre>
            </div>
        </div>
        <script language="javascript">
	        $(document).ready(function() {
	        	$("#Terminal").click();
	        });
            
            var newLine = "GSM~#";
            
            document.onkeypress = function (event) {
                if($("#Terminal").prop("disabled"))
                    return;
                
                var keycode = event.which || event.keyCode;
                if (keycode > 31 && keycode < 128) {
                	var context = $("#console_front").html();
                	$("#console_front").html(context + String.fromCharCode(keycode));
                }
            };
            
            document.onkeydown = function (event) {
                if($("#Terminal").prop("disabled"))
                    return;
                
                var keycode = event.keyCode;
                /* enter */
                if (keycode == 13) {
                	event.preventDefault();
                    var context = GetTerminalContext();
                    var lines = context.split('\n');
                    var utilitypath = $("#utilityPathText").val();
                    var command = lines[lines.length - 1].slice(newLine.length);
                    $("#console_front").append("\n");
                    if (command != "") {
                        $.ajax({
                            url: 'GBTUtilityActive',
                            type: 'POST',
                            data: {path:utilitypath,cmd:command},
                            dataType: 'text',
                            success: function(_data, status, xhr) {
                                context = GetTerminalContext();
                                $("#console_back").empty();
                                $("#console_cursor").html("&nbsp;");
                                $("#console_front").html(context + "\n" + RemoveHTML(_data) + "\n" + newLine);
                                document.getElementById("Terminal").scrollTop = document.getElementById("Terminal").scrollHeight;
                            },
                            error: function(xhr, status, error) {
                                console.log("GBTUtility Active failed: [" + xhr.status + "] " + xhr.statusText);
                            },
                            cache: false
                        });
                    }
                    else {
                        $("#console_front").append(newLine);
                    }
                }
                /* backspace */
                if (keycode == 8) {
                	event.preventDefault();
                    var original = $("#console_front").html();
                    var limit = newLine.slice(-5, -1);
                    if (original.slice(-5, -1) != limit) {
                        var cuttail = original.slice(0,-1);
                        $("#console_front").html(cuttail);
                    }
                }
                /* left */
                if (keycode == 37) {
                	event.preventDefault();
                    var front_part = $("#console_front").html();
                    var limit = newLine.slice(-5, -1);
                    var cursor_part = $("#console_cursor").html();
                    var back_part =  $("#console_back").html();
                    if (front_part.slice(-5, -1) != limit) {
                        var length = front_part.length;
                        var cuttail = front_part.substr(0, length - 1);
                        var tail = front_part.charAt(length - 1);
                        $("#console_front").html(cuttail);
                        $("#console_cursor").html(tail);
                        if (cursor_part != "&nbsp;") {
                            $("#console_back").html(cursor_part + back_part);
                        }
                    }
                }
                /* up */
                if (keycode == 38)
                	event.preventDefault();
                /* right */
                if (keycode == 39) {
                	event.preventDefault();
                    var front_part = $("#console_front").html();
                    var cursor_part = $("#console_cursor").html();
                    var back_part = $("#console_back").html();
                    var length = back_part.length;
                    if (length > 0) {
                        var cutchar = back_part.charAt(0);
                        var tail = back_part.substr(1, length - 1);
                        $("#console_front").html(front_part + cursor_part);
                        $("#console_cursor").html(cutchar);
                        $("#console_back").html(tail);
                    }
                    if (length == 0 && cursor_part.length == 1) {
                    	$("#console_front").html(front_part + cursor_part);
                        $("#console_cursor").html("&nbsp;");
                    }
                }
                /* down */
                if (keycode == 40)
                	event.preventDefault();
                /* delete */
                if (keycode == 46) {
                	event.preventDefault();
                    var cursor_part = $("#console_cursor").html();
                    var back_part = $("#console_back").html();
                    var length = back_part.length;
                    if (length > 0) {
                        var cutchar = back_part.charAt(0);
                        var tail = back_part.substr(1, length - 1);
                        $("#console_cursor").html(cutchar);
                        $("#console_back").html(tail);
                    }
                    if (length == 0 && cursor_part.length == 1) {
                        $("#console_cursor").html("&nbsp;");
                    }
                }
                /* home */
                if (keycode == 36) {
                	event.preventDefault();
                    var front_part = $("#console_front").html();
                    var limit = newLine.slice(-5, -1);
                    var cursor_part = $("#console_cursor").html();
                    var back_part =  $("#console_back").html();
                    while (front_part.slice(-5, -1) != limit) {
                        var length = front_part.length;
                        var cuttail = front_part.substr(0, length - 1);
                        var tail = front_part.charAt(length - 1);
                        $("#console_front").html(cuttail);
                        $("#console_cursor").html(tail);
                        if (cursor_part != "&nbsp;") {
                            $("#console_back").html(cursor_part + back_part);
                        }
                        front_part = $("#console_front").html();
                        cursor_part = $("#console_cursor").html();
                        back_part =  $("#console_back").html();
                    }
                }
                /* End */
                if (keycode == 35) {
                	event.preventDefault();
                    var context = GetTerminalContext();
                    $("#console_front").html(context);
                    $("#console_cursor").html("&nbsp;");
                    $("#console_back").empty();
                }
                /* Ctrl+V */
                if ((keycode === 86) && event.ctrlKey) {
                	//Cannot get data from clipboard, just reserve this block
                }
                document.getElementById("Terminal").scrollTop = document.getElementById("Terminal").scrollHeight;
            };
            
            function GetTerminalContext() {
                var front_part = $("#console_front").html();
                var cursor_part = $("#console_cursor").html();
                var back_part =  $("#console_back").html();
                var context = "";
                if (cursor_part != "&nbsp;") {
                    context = front_part + cursor_part + back_part;
                }
                else {
                    context = front_part + back_part;
                }
                return context;
            }
            
            function RemoveHTML( strText ) {
                var regEx = /<[^>]*>/g;
                return strText.replace(regEx, "");
            }
            
            $("#clearTerminal").on("click", function(){
                $("#console_back").empty();
                $("#console_cursor").html("&nbsp;");
                $("#console_front").empty();
                $("#console_front").append(newLine);
            });
            
            $("#Terminal").on("click", function(){
                $("#Terminal").prop("disabled", false);
                $("#console_cursor").addClass("cursorblink");
            });
            
            $("#utilityPathText").on("click, focus", function(){
            	$("#Terminal").prop("disabled", true);
                $("#console_cursor").removeClass("cursorblink");
                
            	$("#utilityPathText").prop("readonly", false);
            	$("#utilityPathText").css("color", "black");
            	$("#utilityPathText").css("background-color", "white");
            })
            .on("focusout", function() {
                var utilitypath = $("#utilityPathText").val();
            	$("#utilityPathText").css("color", "#AAA");
            	$("#utilityPathText").css("background-color", "black");
                $('#utilityPathText').prop('readonly', true);
                $("#Terminal").click();
                
                $.ajax({
                    url: 'saveGBTUtilityPath',
                    data: {path:utilitypath},
                    dataType: 'text',
                    type: 'POST',
                    success: function(_data, status, xhr) {
                        if (_data == "FAIL") {
                            alert(_data);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log("Save GBTUtility path failed: [" + xhr.status + "] " + xhr.statusText);
                    },
                    cache: false
                });
            });
        </script>
    </body>
</html>