<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Group Update</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style type="text/css">
		.progress {
	    position: relative;
	}
	
	.progress span {
	    position: absolute;
	    display: block;
	    width: 100%;
	    color: black;
	}
	 
    .btn-file {
    	position: relative;
    	overflow: hidden;
	}
	.btn-update {
    	position: relative;
    	overflow: hidden;
	}
	.btn-file input[type=file] {
	    position: absolute;
	    top: 0;
	    right: 0;
	    min-width: 100%;
	    min-height: 100%;
	    font-size: 100px;
	    text-align: right;
	    filter: alpha(opacity=0);
	    opacity: 0;
	    outline: none;
	    background: white;
	    cursor: inherit;
	    display: block;
	}
	
	input[readonly] {
		background-color: white !important;
		cursor: text !important;
	}
    </style>
    
    <!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<div class="row page-title">
					<div class="col-lg-12">
						<h1 class="page-header">	
							${Name} <small><spring:message code="Group"/> <spring:message code="navside5"/></small>
						</h1>
					</div>
				</div>
				<br>
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
				   	<div class="col-lg-12">
				   		<div class="panel panel-default">
							<div class="panel-body">
								<div class="row" id="TFTPSettings">
								   	<div class="col-lg-12">
								   		<div class="panel panel-default">
											<div class="panel-heading">
												<h4 style="display:inline-block;">TFTP</h4>&nbsp;&nbsp;
												<input id="tftpEnableCheckbox" type="checkbox" data-size="mini" />&nbsp;&nbsp;
												<select id="tftpTypeSelect" class="form-control input-sm" style="display:inline-block; font-size:14px; width:90px;">
													<option value="Local">Local</option>
													<!-- <option value="Remote">Remote</option> -->
												</select>&nbsp;&nbsp;
												<div class="input-group" style="display:inline-block;">
													<div class="btn-group">
														<input id="tftpIPInput" type="text" class="form-control input-sm" style="font-size:14px; width:130px;" value="${tftpIP}" />
														<button id="tftpSetButton" type="button" class="btn btn-primary btn-sm">Submit</button>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-12">
										<div class="panel panel-default">
											<div class="panel-heading">
												<h4>Update process: (<label id="TotalCompletedNode"></label> / <label>${TotalNode}</label>) <spring:message code="Completed"/></h4>
											</div>
											<div class="panel-body">
												<div class="row">
													<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
														<div class="well form-group pre-scrollable" style="height:80%;">
															<b><spring:message code="NodeUpdate2"/>:</b>
															<div class="dataTable_wrapper">
																<table class="table table-striped table-bordered table-hover">
																	<thead>
																		<tr >
																			<th>select</th>
																			<th>BMC IP</th>
																			<th>BMC Version</th>
																			<th>BIOS Version</th>
																			<th>Progress</th>
																			<th>Last Log<th>
																		</tr>
																	</thead>
																	<tbody>
																		<c:set var="xmltext">${XMLString}</c:set>
																		<x:parse xml="${xmltext}" var="output"/>
																		<x:forEach select="$output/NodeUpdateList/node" var="item" varStatus="loop">
																			<tr>
																				<td><label class="checkbox-inline"><input id="nodeCheckbox_${loop.index}" type="checkbox" value="<x:out select="$item/bmcIP" />" class="checkboxes"></label></td>
																				<td><x:out select="$item/bmcIP" /></td>
																				<td><x:out select="$item/bmcVersion" /></td>
																				<td><x:out select="$item/biosVersion" /></td>
																				<td name="status_now" value="<x:out select="$item/bmcIP" />"></td>
																				<td><button id="<x:out select="$item/bmcIP" />" type="button" class="btn btn-primary btn-showlog" data-toggle="modal" data-target="#UpdateLog">Watch</button></td>
																			</tr>
																		</x:forEach>
											      					</tbody>
																</table>
															</div>
														</div>
													</div>
													<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
														<div class="well">
															<label for="inputFile"><spring:message code="NodeUpdate1"/> (<spring:message code="NodeUpdate9"/> <label id="firmwareLabel">.zip</label>)</label>
															<form name="updateFirmwareForm" enctype="multipart/form-data" class="form-inline">
																<div class="form-group">
																	<select class="form-control" name="selectFirmwareType" id="firmwareSelect">
																		<option value="BMC">BMC</option>
																		<option value="BIOS">BIOS</option>
																		<option value="CPLD_MB">CPLD_MB</option>
																		<option value="CPLD_BPB">CPLD_BPB</option>
																		<option value="PSU">PSU</option>
																	</select>
																</div>
																<div class="form-group node-side">
																	<input id="updateFilePathText" name="fileContent" type="text" class="form-control" readonly>
																	<span id="updateFileBrowseButton" class="btn btn-primary btn-file">
																            <spring:message code="Browse"/> <input type="file" name="file" id="fileToUpload" multiple>
																    </span>
																</div>
																<div class="form-group">
																	<input type="button" value=<spring:message code="Update"/> name="submit" class="btn btn-danger" id="startUpdateFirmware">
																</div>
															</form>
														</div>
													</div>
													<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12" id="GroupUpdateLogo">
														<div class="well">
															<label><spring:message code="NodeUpdate4-2"/> (<spring:message code="NodeUpdate9"/> .tar)</label>
															<form name="updateLogoForm" enctype="multipart/form-data" class="form-inline">
																<div class="form-group node-side">
																	<input id="updateLogoFilePathText" type="text" class="form-control" readonly>
																	<span id="updateLogoFileBrowseButton" class="btn btn-primary btn-file">
															            <spring:message code="Browse"/> <input type="file" name="file" id="updateLogoFile">
															        </span>
																</div>
																<div class="form-group">
																	<input type="button" value=<spring:message code="Update"/> name="submit" class="btn btn-danger" id="startUpdateLogo">
																</div>
															</form>
															<label style = "font-weight: normal"><spring:message code="NodeUpdate4-3"/></label>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
			</div>
		</div>
	</div>
	<div style="color:black" class="modal fade" id="UpdateLog" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"> Last Update Log</h4>
				</div>
				<div class="modal-body">
					<p id="LogArea">
					</p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	<script>
		var tftpEnable = false;
		var updateLock = false;
		var uploadLock = false;
		var updateType = "";
		
		var checkUpdateStatus;
		
		var checkSupport = function() {
			<%--
            Bit 1: Vertiv exist
            Bit 2: AMI exist
            Bit 3: OpenBMC exist
        	--%>
        	switch ("${GroupCombination}") {
            <%-- pure Vertiv BMC type --%>
            case "1":
                break;
            <%-- pure AMI BMC type --%>
            case "2":
                $("#updateSelect option[value='PSU']").remove();
                $("#GroupUpdateLogo").remove();
                break;
            <%-- pure OBMC type --%>
            case "4":
                $("#updateSelect option[value='PSU']").remove();
                $("#GroupUpdateLogo").remove();
                break;
            <%-- default --%>
            default:
               	break;
        	}
		};
		
		var checkUpdateFirmwareOption = function() {
			switch($("#firmwareSelect").val()) {
			case "BMC":
				$("#firmwareLabel").text(".zip");
				break;
			case "BIOS":
				$("#firmwareLabel").text(".zip");
				break;
			case "PSU":
				$("#firmwareLabel").text(".hex");
				break;
			case "CPLD_MB":
				$("#firmwareLabel").text("xxx.zip / xxx.tgz");
				break;
			case "CPLD_BPB":
				$("#firmwareLabel").text("xxx.zip / xxx.tgz");
				break;
			}
		};
		
		var lockActionButton = function() {
			$("input[id^=nodeCheckbox]").prop("disabled", true);
			$("#updateSelect").prop("disabled", true);
			$("#updateFilePathText").prop("disabled", true);
			$("#updateFileBrowseButton").attr("disabled", true);
			$("#fileToUpload").prop("disabled", true);
			$("#startUpdateFirmware").prop("disabled", true);
			$("#updateLogoFilePathText").prop("disabled", true);
			$("#updateLogoFileBrowseButton").attr("disabled", true);
			$("#updateLogoFile").prop("disabled", true);
			$("#startUpdateLogo").prop("disabled", true);
			
			if (updateLock) {
				$("#tftpLocalLabel").attr("disabled", true);
				$("#tftpRemoteLabel").attr("disabled", true);
				$("#tftpIPInput").prop("disabled", true);
			}
		};
		
		var unlockActionButton = function() {
			if (!updateLock) {
				if (tftpEnable) {
					$("input[id^=nodeCheckbox]").prop("disabled", false);
					$("#updateSelect").prop("disabled", false);
					$("#updateFilePathText").prop("disabled", false);
					$("#updateFileBrowseButton").attr("disabled", false);
					$("#fileToUpload").prop("disabled", false);
					$("#startUpdateFirmware").prop("disabled", false);
					$("#updateLogoFilePathText").prop("disabled", false);
					$("#updateLogoFileBrowseButton").attr("disabled", false);
					$("#updateLogoFile").prop("disabled", false);
					$("#startUpdateLogo").prop("disabled", false);
				}
			}
			
			$("#tftpLocalLabel").attr("disabled", false);
			$("#tftpRemoteLabel").attr("disabled", false);
			$("#tftpIPInput").prop("disabled", false);
		};
		
		var enableTftp = function() {
			$("#tftpTypeSelect").prop("disabled", false);
			$("#tftpIPInput").prop("disabled", false);
			unlockActionButton();
		};
		
		var disableTftp = function() {
			$("#tftpTypeSelect").prop("disabled", true);
			$("#tftpIPInput").prop("disabled", true);
			lockActionButton();
		};
		
		var checkTftpSetting = function() {
			$("#tftpTypeSelect").val("${tftpType}");
			
			if ("${tftpEnable}" === "true") {
				enableTftp();
				tftpEnable = true;
				$("#tftpEnableCheckbox").bootstrapSwitch('state', true);
			} else {
				disableTftp();
				tftpEnable = false;
				$("#tftpEnableCheckbox").bootstrapSwitch('state', false);
			}
			
			if (("${GroupCombination}" === "2") || ("${GroupCombination}" === "4")) {
				$("#TFTPSettings").hide();
				enableTftp();
				tftpEnable = true;
				$("#tftpEnableCheckbox").bootstrapSwitch('state', true);
			}
		};
		
		var getTftpType = function() {
			return $("#tftpTypeSelect").val();
		};
		
		var getUrlIp = function() {
			var hostAddress = window.location.host;
			var ip;
			
			if (hostAddress.includes(":"))
				ip = hostAddress.split(":")[0];
			else
				ip = hostAddress;
			
			if (ip === "localhost")
				ip = "0.0.0.0";
			
			return ip;
		};
		
		var setStatus = function(data) {
			var completeCount = 0;
			
			for (var i = 0;i < data.content.length;i++) {
				if ($('td[value="' + data.content[i].IP + '"]')) {
					$('td[value="' + data.content[i].IP + '"]').html(data.content[i].statusMsg);
					
					if (data.content[i].isComplete)
						completeCount++;
				}
			}
			
			$("#TotalCompletedNode").html(completeCount);
		};
		
		var updateStatus = function(data) {
			if (!uploadLock && data.updateType !== "Unknown") {
				updateType = data.updateType;
				
				if (data.isComplete) {
					if (updateLock) {
						updateLock = false;
						unlockActionButton();
					}
				} else {
					if (!updateLock) {
						updateLock = true;
						lockActionButton();
					}
				}
				
				setStatus(data);
			}
			
			if (updateLock)
				setTimeout(checkUpdateStatus, 1000);
			else
				setTimeout(checkUpdateStatus, 3000);
		};
		
		checkUpdateStatus = function() {
			$.ajax({
				url: 'groupNodeUpdateStatus',
				data: {ID: "${ID}"},
				dataType: 'json',
				success: function(_data, status, xhr) {
					updateStatus(_data);
				},
				error: function(xhr, status, error) {
					console.log("Get the update status failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		};
		
		var setProgress = function(status) {
			for (var i = 0;i < $(".checkboxes").length;i++) {
				if ($(".checkboxes")[i].checked)
					$('td[value="' + $(".checkboxes")[i].value + '"]').html(status);
			}
		};
		
		var initialStatus = function() {
			setProgress("Starting...");
			$("#TotalCompletedNode").html("0");
		};
		
		var uploadFile = function(type, statusArray) {
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var ipStr = "";
			var formData;
			
			if (updateLock)
				return;
			
			uploadLock = true;
			updateType = type;
			initialStatus();
			
			formData = new FormData(document.forms.namedItem("update" + type + "Form"));
			
			for (var i = 0;i < $(".checkboxes").length;i++) {
				if ($(".checkboxes")[i].checked)
					ipStr += $(".checkboxes")[i].value + ",";
			}
			
			formData.append("IP", ipStr);
			formData.append("selectType", type);
			
			$.ajax({
		        url: "UploadUpdateFile?" + csrfParameter + "=" + csrfToken,
		        type: 'POST',
		        data: formData,
				dataType: 'json',
		        xhr: function(xhr, status, error) {
		            var myXhr = $.ajaxSettings.xhr();
		            
		            if (myXhr.upload) {
		                myXhr.upload.addEventListener(
		                	'progress', 
		                	function(e) {
		                		var percent;
			                	if (e.lengthComputable) {
			        		    	percent = Math.ceil(e.loaded / e.total * 100);
			        		  		setProgress("Uploading " + percent + "%...");
			        		    }
		               		}, 
		               		false
		               	);
		            }
		            
		            return myXhr;
		        },
		        success: function(_data, status, xhr) {
		        	var jsonObj = JSON.parse(xhr.responseText);
		        	
		        	if(!jsonObj.status)
    					setProgress(jsonObj.statusMsg);
		        	
		        	uploadLock = false;
		        },
		        error: function(xhr, status, error) {
		        	console.log("Upload " + type + " file to GSM server failed: [" + xhr.status + "] " + xhr.statusText);
		        	uploadLock = false;
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
		};
		
		var resetUpdateStatus = function(clickElement) {
			$.ajax({
				url: 'resetGroupUpdateStatus',
				data: {ID: '${ID}'},
				dataType: 'json',
				success: function(_data, status, xhr) {
					uploadFile(clickElement.attr("id").replace("startUpdate", ""));
				},
				error: function(xhr, status, error) {
					console.log("Reset the update status failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		};
	
		$(document).ready(function() {
			checkSupport();
			checkUpdateFirmwareOption();
			checkTftpSetting();
			checkUpdateStatus();
		});
		
		$("#firmwareSelect").on("change", function() {
			checkUpdateFirmwareOption();
		});
		
		$("#tftpEnableCheckbox").on('switchChange.bootstrapSwitch', function () {
			if ($(this).is(":checked")) {
				enableTftp();
				
				if ($("#tftpIPInput").val() === "0.0.0.0" || $("#tftpIPInput").val() === "") {
					if (getTftpType() === "Local")
						$("#tftpIPInput").val(getUrlIp());
					else
						$("#tftpIPInput").val("0.0.0.0");
				}
			} else
				disableTftp();
		});
		
		$("#tftpTypeSelect").on("change", function() {
			if (getTftpType() === "Local") {
				$("#tftpIPInput").val(getUrlIp());
			}
		});
		
		$("#tftpSetButton").on("click", function() {
			if (!$("#tftpEnableCheckbox").is(":checked")) {
				if(!confirm('<spring:message code="TFTPSettingMsg5"/>'))
					return;
			}
				
			if ("${tftpEnable}" === "true" && $("#tftpEnableCheckbox").is(":checked") && "${tftpType}" !== getTftpType()) {
				if (!confirm('<spring:message code="TFTPSettingMsg6"/>'))
					return;
			}
			
			$.ajax({
			    url: 'setTFTPSettings',
			    data: {
			    	enable: $("#tftpEnableCheckbox").is(":checked"),
			    	ip: $("#tftpIPInput").val(),
			    	//type: getTftpType()
			    	type:"Local"
				},
			    dataType: 'json',
			    success: function(_data, status, xhr) {
					alert(_data.msg);
					window.location.href = "./GroupUpdate?ID=${ID}";
			    },
			    error: function(xhr, status, error) {
			    	alert("Set the TFTP settings failed.");
			        console.log("Set the TFTP settings failed: [" + xhr.status + "] " + xhr.statusText);
			    },
			    cache: false
			});
		});
		
		$('.btn-showlog').click(function(){
			var ip = this.id;
			
			$.ajax({
				url: 'nodeUpdateLog',
				data: {IP: ip},
				dataType: 'json',
				success: function(_data, status, xhr) {
					var logArea = document.getElementById('LogArea');
					logArea.innerHTML = _data.log;
				},
				error: function(xhr, status, error) {
					console.log("Get last log failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		});
		
		$('.btn-file :file').on({
			'change': function() {
				var numFiles = $(this).get(0).files ? $(this).get(0).files.length : 1;
				var label = $(this).val().replace(/\\/g, '/').replace(/.*\//, '');
				$(this).trigger('fileselect', [numFiles, label]);
			},
			'fileselect': function(event, numFiles, label) {
		        var input = $(this).parents('.node-side').find(':text');
		        var log = numFiles > 1 ? numFiles + ' files selected' : label;
		        
		        if (input.length)
		        	input.val(log);
		        else {
		        	if (log) 
		        		alert(log);
		        }
	    	}
		});
		
		$("input[id^='startUpdate']").on("click", function() {
			resetUpdateStatus($(this));
		});
	</script>
</body>
</html>