<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Information</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<style type="text/css">
		.page-title h3, .page-title h4 {
			display:inline-block;
			margin-top: 7px;
			margin-bottom: 7px;
		}
		
		.row>table:not(#NodeDescription):not(rackRowTable):not(#caviumLanBlock)>tbody>tr>td:first-child {
			width: 50%;
		}
		
		#loading_modal>.modal-dialog {
			margin-top: 20% !important;
			width: 95px !important;
		}
		
		#loading_modal .alert {
			margin-bottom: 0px !important;
		}
	</style>
	
	<!-- Java Script -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
					<div class="col-lg-12">
						<h3 class="page-header">
							<A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
						</h3>
						&nbsp;
						<h4>
							${NodeName}
						</h4>
					</div>
				</div>
				<!-- /.row -->

				<div class="row">
					<div class="col-lg-12">
						<!-- <div class="row" style="height:36px"></div> -->
						<sec:authorize access="hasAnyRole(${Access_Configuration})">
						<div class="row">
							<table id="NodeDescription" class="table table-striped table-bordered">
								<tbody>
									<tr>
										<td style="padding-top: 14px; padding-bottom: 14px; width: 10%;"><strong><spring:message code="Common_Description"/></strong></td>
										<td>
											<div class="input-group">
												<input type="text" class="form-control" id="note_${IP}" value='${NodeName}' placeholder='<spring:message code="Node_Infomation_NodeDescription"/>...'>
												<span class="input-group-btn">
													<button id="${IP}" class="btn btn-primary" onclick="btn(this.id)"><spring:message code="Common_Submit"/></button>
												</span>
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
						</sec:authorize>
						
						<div style="float: right;">
							<button id="refreshInfo" class="btn btn-primary"><spring:message code="Common_Refresh"/></button>
						</div>
						
						<!-- FRU and PSU FRU Information -->
						<h1 id="fruRow_hide"><b>FRU</b></h1>
						<div id="fruRow" class="row">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="1"></th></tr>
								</thead>
								<tbody>
									<tr>
										<td><strong><spring:message code="Select_FRU_Device_ID"/></strong></td>
										<td>
											<select id="select_fru_id">
												<option value="0" selected>FRU</option>
												<!-- <option value="1">FRU_1</option> -->
												<option value="2">PSU_0</option>
												<option value="3">PSU_1</option>
												<option value="4">PSU_2</option>
											</select>
										</td>
									</tr>
									<c:set var="xmltext">${XMLString}</c:set>
									<x:parse xml="${xmltext}" var="output"/>
									<x:set select="$output/NodeDetailInfo/fru" var="item"/>
									<tr id="fru0_tr0"><td><strong><spring:message code="Node_Infomation_Fru_Chassis_Type"/></strong></td><td><x:out select="$item/ChassisType"/></td></tr>
									<tr id="fru0_tr1"><td><strong><spring:message code="Node_Infomation_Fru_Chassis_PartNumber"/></strong></td><td><x:out select="$item/ChassisPartNumber"/></td></tr>
									<tr id="fru0_tr2"><td><strong><spring:message code="Node_Infomation_Fru_Chassis_SerialNumber"/></strong></td><td><x:out select="$item/ChassisSerialNumber"/></td></tr>
									<tr id="fru0_tr3"><td><strong><spring:message code="Node_Infomation_Fru_Board_MfgDate"/></strong></td><td><x:out select="$item/BoardMfgDate"/></td></tr>
									<tr id="fru0_tr4"><td><strong><spring:message code="Node_Infomation_Fru_Board_Mfg"/></strong></td><td><x:out select="$item/BoardMfg"/></td></tr>
									<tr id="fru0_tr5"><td><strong><spring:message code="Node_Infomation_Fru_Board_Product"/></strong></td><td><x:out select="$item/BoardProduct"/></td></tr>
									<tr id="fru0_tr6"><td><strong><spring:message code="Node_Infomation_Fru_Board_SerialNumber"/></strong></td><td><x:out select="$item/BoardSerialNumber" /></td></tr>
									<tr id="fru0_tr7"><td><strong><spring:message code="Node_Infomation_Fru_Board_PartNumber"/></strong></td><td><x:out select="$item/BoardPartNumber"/></td></tr>
									<tr id="fru0_tr8"><td><strong><spring:message code="Node_Infomation_Fru_Product_Manufacturer"/></strong></td><td><x:out select="$item/ProductManufacturer" /></td></tr>
									<tr id="fru0_tr9"><td><strong><spring:message code="Node_Infomation_Fru_Product_Name"/></strong></td><td><x:out select="$item/ProductName"/></td></tr>
									<tr id="fru0_tr10"><td><strong><spring:message code="Node_Infomation_Fru_Product_PartNumber"/></strong></td><td><x:out select="$item/ProductPartNumber" /></td></tr>
									<tr id="fru0_tr11"><td><strong><spring:message code="Node_Infomation_Fru_Product_Version"/></strong></td><td><x:out select="$item/ProductVersion"/></td></tr>
									<tr id="fru0_tr12"><td><strong><spring:message code="Node_Infomation_Fru_Product_SerialNumber"/></strong></td><td><x:out select="$item/ProductSerialNumber"/></td></tr>
									<tr id="fru0_tr13"><td><strong><spring:message code="Node_Infomation_Fru_Product_AssetTag"/></strong></td><td><x:out select="$item/ProductAssetTag"/></td></tr>
									
									<c:set var="xmltext">${XMLString}</c:set>
									<x:parse xml="${xmltext}" var="output"/>
									<x:set select="$output/NodeDetailInfo/psuFru_0" var="item"/>
									<tr id="psuFru0_tr0"><td><strong><spring:message code="Node_Infomation_Fru_Product_Manufacturer"/></strong></td><td><x:out select="$item/ProductManufacturer" /></td></tr>
									<tr id="psuFru0_tr1"><td><strong><spring:message code="Node_Infomation_Fru_Product_Name"/></strong></td><td><x:out select="$item/ProductName"/></td></tr>
									<tr id="psuFru0_tr2"><td><strong><spring:message code="Node_Infomation_Fru_Product_PartNumber"/></strong></td><td><x:out select="$item/ProductPartNumber" /></td></tr>
									<tr id="psuFru0_tr3"><td><strong><spring:message code="Node_Infomation_Fru_Product_Version"/></strong></td><td><x:out select="$item/ProductVersion"/></td></tr>
									<tr id="psuFru0_tr4"><td><strong><spring:message code="Node_Infomation_Fru_Product_SerialNumber"/></strong></td><td><x:out select="$item/ProductSerialNumber"/></td></tr>
									<tr id="psuFru0_tr5"><td><strong><spring:message code="Node_Infomation_Fru_Product_AssetTag"/></strong></td><td><x:out select="$item/ProductAssetTag"/></td></tr>
									
									<c:set var="xmltext">${XMLString}</c:set>
									<x:parse xml="${xmltext}" var="output"/>
									<x:set select="$output/NodeDetailInfo/psuFru_1" var="item"/>
									<tr id="psuFru1_tr0"><td><strong><spring:message code="Node_Infomation_Fru_Product_Manufacturer"/></strong></td><td><x:out select="$item/ProductManufacturer" /></td></tr>
									<tr id="psuFru1_tr1"><td><strong><spring:message code="Node_Infomation_Fru_Product_Name"/></strong></td><td><x:out select="$item/ProductName"/></td></tr>
									<tr id="psuFru1_tr2"><td><strong><spring:message code="Node_Infomation_Fru_Product_PartNumber"/></strong></td><td><x:out select="$item/ProductPartNumber" /></td></tr>
									<tr id="psuFru1_tr3"><td><strong><spring:message code="Node_Infomation_Fru_Product_Version"/></strong></td><td><x:out select="$item/ProductVersion"/></td></tr>
									<tr id="psuFru1_tr4"><td><strong><spring:message code="Node_Infomation_Fru_Product_SerialNumber"/></strong></td><td><x:out select="$item/ProductSerialNumber"/></td></tr>
									<tr id="psuFru1_tr5"><td><strong><spring:message code="Node_Infomation_Fru_Product_AssetTag"/></strong></td><td><x:out select="$item/ProductAssetTag"/></td></tr>
									
									<c:set var="xmltext">${XMLString}</c:set>
									<x:parse xml="${xmltext}" var="output"/>
									<x:set select="$output/NodeDetailInfo/psuFru_2" var="item"/>
									<tr id="psuFru2_tr0"><td><strong><spring:message code="Node_Infomation_Fru_Product_Manufacturer"/></strong></td><td><x:out select="$item/ProductManufacturer" /></td></tr>
									<tr id="psuFru2_tr1"><td><strong><spring:message code="Node_Infomation_Fru_Product_Name"/></strong></td><td><x:out select="$item/ProductName"/></td></tr>
									<tr id="psuFru2_tr2"><td><strong><spring:message code="Node_Infomation_Fru_Product_PartNumber"/></strong></td><td><x:out select="$item/ProductPartNumber" /></td></tr>
									<tr id="psuFru2_tr3"><td><strong><spring:message code="Node_Infomation_Fru_Product_Version"/></strong></td><td><x:out select="$item/ProductVersion"/></td></tr>
									<tr id="psuFru2_tr4"><td><strong><spring:message code="Node_Infomation_Fru_Product_SerialNumber"/></strong></td><td><x:out select="$item/ProductSerialNumber"/></td></tr>
									<tr id="psuFru2_tr5"><td><strong><spring:message code="Node_Infomation_Fru_Product_AssetTag"/></strong></td><td><x:out select="$item/ProductAssetTag"/></td></tr>
									
								</tbody>
							</table>
						</div>

						<!-- GPU Information -->
						<div id="gpu_info" style="display:none">
							<h1 id="gpuRow_hide"><b>GPU Info ...</b></h1>
							<div id="gpuRow" class="row" style="display:none">
								<table class="table table-striped table-bordered" style="margin-bottom:0px;">
									<thead><tr><th colspan="2"></th></tr></thead>
									<tbody>
										<tr>
											<td><strong>GPU Device ID</strong></td>
											<td>
												<select id="select_gpu_device_id">
												</select>
											</td>
										</tr>
										<tr id="gpu_name"><td><strong>GPU Device Name</strong></td> <td></td></tr>
									</tbody>
								</table>
								<h3 id="gpuRow_info_hide"><b>&emsp;Detail Info ...</b></h3>
								<div id="gpuRow_info" class="row" style="display:none">
									<table id="gpu_info_table"class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">GPU Information</font></strong></td></tr>
											<tr><td><strong>Board Part Number</strong></td> <td></td></tr>
											<tr><td><strong>OEM Information</strong></td> <td></td></tr>
											<tr><td><strong>Serial Number</strong></td> <td></td></tr>
											<tr><td><strong>Marketing Name</strong></td> <td></td></tr>
											<tr><td><strong>GPU Part Number</strong></td> <td></td></tr>
											
											<tr><td><strong>Memory Vendor</strong></td> <td></td></tr>
											<tr><td><strong>Memory Part Number</strong></td> <td></td></tr>
											<tr><td><strong>Build Date</strong></td> <td></td></tr>
											<tr><td><strong>Firmware Version</strong></td> <td></td></tr>
											<tr><td><strong>PCI Configuration Vendor ID</strong></td> <td></td></tr>
											
											<tr><td><strong>PCI Configuration Device ID</strong></td> <td></td></tr>
											<tr><td><strong>PCI Configuration Subsystem Vendor ID</strong></td> <td></td></tr>
											<tr><td><strong>PCI Configuration Subsystem Device ID</strong></td> <td></td></tr>
											<tr><td><strong>GPU GUID</strong></td> <td></td></tr>
											<tr><td><strong>Info ROM Version</strong></td> <td></td></tr>
											
											<tr><td><strong>Product Length</strong></td> <td></td></tr>
											<tr><td><strong>Product Width</strong></td> <td></td></tr>
											<tr><td><strong>Product Height</strong></td> <td></td></tr>
											<tr><td><strong>PCIe Link Speed</strong></td> <td></td></tr>
											<tr><td><strong>PCIe Link Width</strong></td> <td></td></tr>
											
											<tr><td><strong>TGP Limit</strong></td> <td></td></tr>
										</tbody>
									</table>
									<hr style="border:0;background-color:Black;height:1px;">
									<table id="gpu_cab_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">Capabilities</font></strong></td></tr>
											<tr><td><strong>Primary GPU Temperature</strong></td> <td></td></tr>
											<tr><td><strong>Secondary GPU Temperature</strong></td> <td></td></tr>
											<tr><td><strong>Sensor Monitoring Board</strong></td> <td></td></tr>
											<tr><td><strong>Sensor Monitoring Memory</strong></td> <td></td></tr>
											<tr><td><strong>Total Board Power Consumption</strong></td> <td></td></tr>
											
											<tr><td><strong>Reading GPU Target Temperature</strong></td> <td></td></tr>
											<tr><td><strong>Reading GPU Slowdown Temperature</strong></td> <td></td></tr>
											<tr><td><strong>Reading GPU Shutdown Temperature</strong></td> <td></td></tr>
											<tr><td><strong>Reading Memory Target Temperature</strong></td> <td></td></tr>
											<tr><td><strong>Reading GPU Maximum Operating Temperature</strong></td> <td></td></tr>
											
											<tr><td><strong>Board Part Number V1</strong></td> <td></td></tr>
											<tr><td><strong>OEM Information V1</strong></td> <td></td></tr>
											<tr><td><strong>Serial Number V1</strong></td> <td></td></tr>
											<tr><td><strong>Marketing Name V1</strong></td> <td></td></tr>
											<tr><td><strong>GPU Silicon Revision V1</strong></td> <td></td></tr>
											
											<tr><td><strong>Memory Vendor V1</strong></td> <td></td></tr>
											<tr><td><strong>Memory Part Number V1</strong></td> <td></td></tr>
											<tr><td><strong>Build Date V1</strong></td> <td></td></tr>
											<tr><td><strong>Firmware Version V1</strong></td> <td></td></tr>
											<tr><td><strong>PCI Configuration Vendor ID V1</strong></td> <td></td></tr>
											
											<tr><td><strong>PCI Configuration Device ID V1</strong></td> <td></td></tr>
											<tr><td><strong>PCI Configuration Subsystem Vendor ID V1</strong></td> <td></td></tr>
											<tr><td><strong>PCI Configuration Subsystem Device ID V1</strong></td> <td></td></tr>
											<tr><td><strong>GPU GUID V1</strong></td> <td></td></tr>
											<tr><td><strong>Info ROM Version V1</strong></td> <td></td></tr>
											
											<tr><td><strong>ECC Statistics Data V1</strong></td> <td></td></tr>
											<tr><td><strong>ECC Statistics Data V2</strong></td> <td></td></tr>
											<tr><td><strong>ECC Statistics Data V3</strong></td> <td></td></tr>
											<tr><td><strong>ECC Statistics Data V4</strong></td> <td></td></tr>
											<tr><td><strong>ECC Statistics Data V5</strong></td> <td></td></tr>
											
											<tr><td><strong>Retired Page Count Query</strong></td> <td></td></tr>
											<tr><td><strong>Write Protect Mode</strong></td> <td></td></tr>
											<tr><td><strong>ECC Enabled State</strong></td> <td></td></tr>
											<tr><td><strong>GPU Reset Required State Flag</strong></td> <td></td></tr>
											<tr><td><strong>GPU Accumulated SM Utilization</strong></td> <td></td></tr>
											
											<tr><td><strong>Query NVLink Information</strong></td> <td></td></tr>
											<tr><td><strong>Query NVLink Information Error Counts</strong></td> <td></td></tr>
											<tr><td><strong>Query Clock Frequency Information</strong></td> <td></td></tr>
											<tr><td><strong>Nvidia GPU Driver Not Loaded</strong></td> <td></td></tr>
											<tr><td><strong>Fan Queries V1</strong></td> <td></td></tr>
											
											<tr><td><strong>Product Length V1</strong></td> <td></td></tr>
											<tr><td><strong>Product Width V1</strong></td> <td></td></tr>
											<tr><td><strong>Product Height V1</strong></td> <td></td></tr>
											<tr><td><strong>PCIe Link Speed V1</strong></td> <td></td></tr>
											<tr><td><strong>PCIe Link Width V1</strong></td> <td></td></tr>
											
											<tr><td><strong>TGP Limit V1</strong></td> <td></td></tr>
											<tr><td><strong>Enable Disable Power Supply</strong></td> <td></td></tr>
											<tr><td><strong>Get Power Supply Status</strong></td> <td></td></tr>
											<tr><td><strong>Assert Deassert PCIe Fundamental Reset</strong></td> <td></td></tr>
											<tr><td><strong>Get PCIe Fundamental Reset</strong></td> <td></td></tr>
											
											<tr><td><strong>Set Release Power Brake</strong></td> <td></td></tr>
											<tr><td><strong>Get Power Brake</strong></td> <td></td></tr>
											<tr><td><strong>Get Thermal Alert State</strong></td> <td></td></tr>
											<tr><td><strong>Set Error LED State</strong></td> <td></td></tr>
											<tr><td><strong>Get Board Power Supply Status</strong></td> <td></td></tr>
											
											<tr><td><strong>Set Thermal Alert</strong></td> <td></td></tr>
											<tr><td><strong>Get Set MCUFW Write Protect</strong></td> <td></td></tr>
											<tr><td><strong>Get HW Violation Time Value</strong></td> <td></td></tr>
											<tr><td><strong>Get Global SW Violation Time Value</strong></td> <td></td></tr>
											<tr><td><strong>Get Power Policy Violation Time Value</strong></td> <td></td></tr>
											
											<tr><td><strong>Get Thermal Policy Violation Time Value</strong></td> <td></td></tr>
											<tr><td><strong>Get Current SMMEM Utilization Value</strong></td> <td></td></tr>
											<tr><td><strong>Request Bundling</strong></td> <td></td></tr>
											<tr><td><strong>Scratch Space Size</strong></td> <td></td></tr>
											<tr><td><strong>Scratch Space Bank Size</strong></td> <td></td></tr>
										</tbody>
									</table>
									<hr style="border:0;background-color:Black;height:1px;">
									<table id="gpu_nvlink_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">NVLink Information</font></strong></td></tr>
											<tr><td><strong>NVLinkNumber</strong></td> <td></td></tr>
											<tr><td><strong>NVLinkStatus</strong></td> <td></td></tr>
											<tr><td><strong>NVLinkSpeed</strong></td> <td></td></tr>
										</tbody>
									</table>
								</div>
								<h3 id="gpuRow_temp_hide"><b>&emsp;Temperature Info ...</b></h3>
								<div id="gpuRow_temp" class="row" style="display:none">
									<table id="gpu_temp_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">GPU Temperature</font></strong></td></tr>
											<tr><td><strong>Primary GPU</strong></td> <td></td></tr>
											<tr><td><strong>Secondary GPU</strong></td> <td></td></tr>
											<tr><td><strong>Sensor Monitoring Board</strong></td> <td></td></tr>
											<tr><td><strong>Sensor Monitoring Memory</strong></td> <td></td></tr>
										</tbody>
									</table>
									<hr style="border:0;background-color:Black;height:1px;">
									<table id="gpu_temp_extend_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">Extended Precision GPU Temperature</font></strong></td></tr>
											<tr><td><strong>Primary GPU</strong></td> <td></td></tr>
											<tr><td><strong>Secondary GPU</strong></td> <td></td></tr>
											<tr><td><strong>Sensor Monitoring Board</strong></td> <td></td></tr>
											<tr><td><strong>Sensor Monitoring Memory</strong></td> <td></td></tr>
										</tbody>
									</table>
								</div>
								<h3 id="gpuRow_status_hide"><b>&emsp;Status Info ...</b></h3>
								<div id="gpuRow_status" class="row" style="display:none">
									<table id="gpu_status_accumulated_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">Accumulated Utilization</font></strong></td></tr>
											<tr><td><strong>Context Utilization Time</strong></td> <td></td></tr>
											<tr><td><strong>SMUtilization Time</strong></td> <td></td></tr>
										</tbody>
									</table>
									<hr style="border:0;background-color:Black;height:1px;">
									<table id="gpu_status_power_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">Power Supply</font></strong></td></tr>
											<tr><td><strong>Sufficient External Power</strong></td> <td></td></tr>
											<tr><td><strong>Power Supply Status</strong></td> <td></td></tr>
											<tr><td><strong>Board Power Supply Status</strong></td> <td></td></tr>
										</tbody>
									</table>
								</div>
								<h3 id="gpuRow_power_hide"><b>&emsp;Power Info ...</b></h3>
								<div id="gpuRow_power" class="row" style="display:none">
									<table id="gpu_power_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td colspan="2"><strong><font size="4">Power Consumption</font></strong></td></tr>
											<tr><td><strong>Power</strong></td> <td></td></tr>
										</tbody>
									</table>
								</div>
								<h3 id="gpuRow_clock_hide"><b>&emsp;Clock Info ...</b></h3>
								<div id="gpuRow_clock" class="row" style="display:none">
									<table id="gpu_clock_graphics_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td><strong><font size="4">Graphics</font></strong></td> <td><strong><font size="4">Clock Frequency</font></strong></td></tr>
											<tr><td><strong>Current</strong></td> <td></td></tr>
											<tr><td><strong>Min Programmable</strong></td> <td></td></tr>
											<tr><td><strong>Max Programmable</strong></td> <td></td></tr>
										</tbody>
									</table>
									<hr style="border:0;background-color:Black;height:1px;">
									<table id="gpu_clock_memory_table" class="table table-striped table-bordered" style="margin-bottom:0px;">
										<thead><tr><th colspan="2"></th></tr></thead>
										<tbody>
											<tr><td><strong><font size="4">Memory</font></strong></td> <td><strong><font size="4">Clock Frequency</font></strong></td></tr>
											<tr><td><strong>Current</strong></td> <td></td></tr>
											<tr><td><strong>Min Programmable</strong></td> <td></td></tr>
											<tr><td><strong>Max Programmable</strong></td> <td></td></tr>
										</tbody>
									</table>
								</div>
							</div>
						</div>

						<!-- Rack Information -->
						<h1 id="rackRow_hide"><b>Rack Info ...</b></h1>
						<div id="rackRow" class="row" style="display:none">
							<table id="rackRowTable" class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="1"></th></tr>
								</thead>
								<tbody>
									<tr><td style="padding:0px !important;">
										<div class="scroll-table">
											<table class="table table-striped table-bordered table-hover" id="rackTable">
											</table>
										</div>
									</td></tr>
								</tbody>
							</table>
						</div>

						<!-- Hardware Information -->
						<!-- Iris, 09-06-2017, Modify Information item main item titles use the language format -->
						<h1 id="hardwareRow_hide"><b><spring:message code="Common_Hardware"/> ...</b></h1>
						<div id="hardwareRow" class="row" style="display:none">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"></th></tr>
								</thead>
								<tbody>
									<c:set var="xmltext">${XMLString}</c:set>
									<x:parse xml="${xmltext}" var="output"/>
									<x:set select="$output/NodeDetailInfo/fru" var="item"/>
									<tr>
										<td><strong><spring:message code="Node_Infomation_Hardware_CPU"/></strong></td>
										<td>
											<x:forEach select="$output/NodeDetailInfo/cpuinfo" var="item" varStatus="index">
												<x:out select="$item/CPUInfo"/><br>
											</x:forEach>
										</td>
									</tr>
									<tr>
										<td><strong><spring:message code="Node_Infomation_Hardware_Memory"/></strong></td>
										<td>
											<x:forEach select="$output/NodeDetailInfo/meminfo" var="item" varStatus="index">
												<x:out select="$item/MEMInfo"/><br>
											</x:forEach>
										</td>
									</tr>
									<tr>
										<td><strong><spring:message code="Node_Infomation_Hardware_HDD"/></strong></td>
										<td>
											<x:forEach select="$output/NodeDetailInfo/hddinfo" var="item" varStatus="index">
												<x:out select="$item/HDDInfo"/><br>
											</x:forEach>
										</td>
									</tr>
									<tr>
										<td colspan="2">
											<strong><spring:message code="Node_Infomation_Hardware_PCIE"/></strong><br>
											<div class="scroll-table">
												<table class="table table-striped table-bordered table-hover">
													<tbody>
														<tr><td><strong><spring:message code="Node_Infomation_Hardware_Name"/></strong></td><td><strong><spring:message code="Node_Infomation_Hardware_Manufacturer"/></strong></td><td><strong><spring:message code="Node_Infomation_Hardware_DeviceType"/></strong></td><td><strong><spring:message code="Node_Infomation_Hardware_VendorID"/></strong></td><td><strong><spring:message code="Node_Infomation_Hardware_DeviceID"/></strong></td></tr>
														<x:forEach select="$output/NodeDetailInfo/pciinfo" var="item" varStatus="index">
															<tr><td><x:out select="$item/Name"/></td><td><x:out select="$item/Manufacturer"/></td><td><x:out select="$item/DeviceType"/></td><td><x:out select="$item/VendorID"/></td><td><x:out select="$item/DeviceID"/></td></tr>
														</x:forEach>
													</tbody>
												</table>
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
						
						<!-- Software Information -->
						<h1 id="softwareRow_hide"><b><spring:message code="Common_Software"/> ...</b></h1>
						<div id="softwareRow" class="row" style="display:none">
							<table class="table table-striped table-bordered" style="margin-bottom:0px;">
								<thead>
									<tr><th colspan="2"></th></tr>
								</thead>
								<tbody>
									<x:set select="$output/NodeDetailInfo/softwareInfo" var="item"/>
									<tr id="bmcBlock"><td><strong><spring:message code="Node_Infomation_Software_BMCVersion"/></strong></td> <td><x:out select="$item/BMCVersion" /></td></tr>
									<tr id="biosBlock"><td><strong><spring:message code="Node_Infomation_Software_BIOSVersion"/></strong></td> <td><x:out select="$item/BIOSVersion" /></td></tr>
									<c:if test="${!fn:contains(ProductName, 'ThunderX')}">
										<tr id="lan1Block"><td><strong><spring:message code="Node_Infomation_Software_LAN_1_MAC"/></strong></td> <td><x:out select="$item/LAN1MAC" /></td></tr>
										<tr id="lan2Block"><td><strong><spring:message code="Node_Infomation_Software_LAN_2_MAC"/></strong></td> <td><x:out select="$item/LAN2MAC" /></td></tr>
										<tr id="lan3Block"><td><strong><spring:message code="Node_Infomation_Software_LAN_3_MAC"/></strong></td> <td><x:out select="$item/LAN3MAC" /></td></tr>
										<tr id="lan4Block"><td><strong><spring:message code="Node_Infomation_Software_LAN_4_MAC"/></strong></td> <td><x:out select="$item/LAN4MAC" /></td></tr>
									</c:if>
								</tbody>
							</table>
							<table id="caviumLanBlock" class="table table-striped table-bordered">
								<c:if test="${fn:contains(ProductName, 'ThunderX')}">
									<tbody>
										<tr><td><strong>LAN Group</strong></td><td><strong>LAN 1 MAC</strong></td><td><strong>LAN 2 MAC</strong></td><td><strong>LAN 3 MAC</strong></td><td><strong>LAN 4 MAC</strong></td></tr>
										<x:forEach select="$output/NodeDetailInfo/macList" var="item" varStatus="index">
											<tr><td>Group ${index.index+1}</td><td><x:out select="$item/LAN1MAC" /></td><td><x:out select="$item/LAN2MAC" /></td><td><x:out select="$item/LAN3MAC" /></td><td><x:out select="$item/LAN4MAC" /></td></tr>
										</x:forEach>
									</tbody>
								</c:if>
							</table>
						</div>
						
						<!-- BIOS Information -->
						<h1 id="smbiosRow_hide"><b>BIOS ...</b></h1>
						<div id="smbiosRow" class="row" style="display:none">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"></th></tr>
								</thead>
								<tbody>
									<tr><td style="padding:0px !important;">
										<div class="scroll-table">
											<c:set var="xmltext">${SMBIOSXMLString}</c:set>
											<x:parse xml="${xmltext}" var="smbiosOutput"/>
											<x:forEach select="$smbiosOutput/NodeSMBIOSInfo/InfoList" var="item" varStatus="index">
											<table class="table table-striped table-bordered table-hover">
												<thead>
													<tr>
														<th><x:out select="$item/title"/><br></th>
													</tr>
												</thead>
												<tbody>
													<x:forEach select="$item" begin="1" var="item2" varStatus="index">
													<tr>
														<td><x:out select="$item2"/><br></td>
													</tr>
													</x:forEach>
												</tbody>
											</table>
											</x:forEach>
										</div>
									</td></tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="loading_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="alert">
					<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		var sGpu_data;
		
		$(document).ready(function() {
			if("${IP}" != ""){
				checkNodeSupport();
				getRackNodeInfo("${IP}");
				parent.focusTargetNode("${IP}");
				
				/* Brian.Kung: GPU information only support AMI. */
				if(("${BmcType}" == "SMC") &&"${BMCFwType}" == "AMI") {
					getGpuInfo();
				}
			}
			
			/* Brian.K 2021/02/09: Display fru, hide psu fru. */
			if($("#select_fru_id").val() == 0) {
				for(var i = 0; i < 6; i++) {
					$("#psuFru0_tr" + i).hide();
					$("#psuFru1_tr" + i).hide();
					$("#psuFru2_tr" + i).hide(); 
				}
			}
			
			/* Brian.K 2021/02/09: Hide fru selector if empty psu fru. */
			for(var i = 0; i < 3; i++) {
				var psuProductName = $("#psuFru" + i + "_tr1").find('td:eq(1)').text();
				console.log("psuProductName_" + i + ": " + psuProductName);
				
				if(psuProductName == "Unknown" || psuProductName == "" || psuProductName == "N/A") {
					$("#select_fru_id").find("option[value='"+ (i+2) +"']").hide();
				}
			}
			
		});
		
		/* Brian.K 2021/02/09: Adjust fru table. */
		$("#fruRow").delegate("select[id^='select_fru_id']", "change", function(){
			var selectFru = $("#select_fru_id").val();
			
			if(selectFru == 0) {
				for(var i = 0; i < 14; i++) {
					$("#fru0_tr" + i).show();
					$("#psuFru0_tr" + i).hide();
					$("#psuFru1_tr" + i).hide();
					$("#psuFru2_tr" + i).hide(); 
				}
			}
			else if(selectFru == 2) {
				for(var i = 0; i < 14; i++) {
					$("#fru0_tr" + i).hide();
					$("#psuFru0_tr" + i).show();
					$("#psuFru1_tr" + i).hide();
					$("#psuFru2_tr" + i).hide(); 
				}
			}
			else if(selectFru == 3) {
				for(var i = 0; i < 14; i++) {
					$("#fru0_tr" + i).hide();
					$("#psuFru0_tr" + i).hide();
					$("#psuFru1_tr" + i).show();
					$("#psuFru2_tr" + i).hide(); 
				}
			}
			else if(selectFru == 4) {
				for(var i = 0; i < 14; i++) {
					$("#fru0_tr" + i).hide();
					$("#psuFru0_tr" + i).hide();
					$("#psuFru1_tr" + i).hide();
					$("#psuFru2_tr" + i).show(); 
				}
			}
		});
		
		$("h1[id$='_hide']").on("click", function() {
			var thisID = $(this).attr("id");
			
			if($("#" + thisID + " > b").text().indexOf(" ...") >= 0)
				$("#" + thisID + " > b").html($("#" + thisID + " > b").text().slice(0, -4));
			else
				$("#" + thisID + " > b").append(" ...");
			
			$("#" + thisID.replace("_hide", "")).slideToggle("slow");
		});
		
		$("h3[id$='_hide']").on("click", function() {
			var thisID = $(this).attr("id");
			
			if($("#" + thisID + " > b").text().indexOf(" ...") >= 0)
				$("#" + thisID + " > b").html($("#" + thisID + " > b").text().slice(0, -4));
			else
				$("#" + thisID + " > b").append(" ...");
			
			$("#" + thisID.replace("_hide", "")).slideToggle("slow");
		});
		
		function checkNodeSupport() {
			if(parent.connectionInterface == "Redfish") {
				$("#rackRow_hide").remove();
				$("#rackRow").remove();
				$("#fruRow_hide").remove();
				$("#fruRow").remove();
				$("#hardwareRow_hide").remove();
				$("#hardwareRow").remove();
				
				$("#biosBlock").remove();
				$("#lan1Block").remove();
				$("#lan2Block").remove();
				$("#lan3Block").remove();
				$("#lan4Block").remove();
				$("#caviumLanBlock").remove();

				$("#smbiosRow_hide").remove();
				$("#smbiosRow").remove();
			}
			
			if(("${BmcType}" == "CMC") || ("${BmcType}" == "RMC")) {
				$('#hardwareRow_hide').remove();
				$('#hardwareRow').remove();
				$("#smbiosRow_hide").remove();
				$("#smbiosRow").remove();
				$("#gpu_info").remove();
			}
			else {
				$("#rackRow_hide").remove();
				$("#rackRow").remove();
			}
			
			if("${BMCFwType}" != "AMI") $("#gpu_info").remove();
		}
		
		/* William 2019/01/14: Adjust the Loading message into a circle animation. */
		function getRackNodeInfo(ip) {
			$("#rackTable").html("<tr><td colspan='1' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			
			$.ajax({
				url: 'getRackNodeInfo',
				data: {IP:ip},
				dataType: 'json',
				success: function(_data, status, xhr) {
					$("#rackTable").empty();
					
					var htmlString = "";
					
					if(_data.RackInfo != null) {
						for(var i=0 ; i<_data.RackInfo.Node.length ; i+=2) {
							htmlString += "<tr>";
							htmlString += "<td><strong>" + _data.RackInfo.Node[i].id[1] + '</strong> ' + _data.RackInfo.Node[i].ip + "</td>";
							htmlString += "<td><strong>" + _data.RackInfo.Node[i+1].id[1] + '</strong> ' + _data.RackInfo.Node[i+1].ip + "</td>";
							htmlString += "</tr>";
						}
					}
					
					if(htmlString != "")
						$("#rackTable").append(htmlString);
					else
						$("#rackTable").append("<tr><td>No Data</td></tr>");
				},
				error: function(xhr, status, error) {
					$("#rackTable").html("<tr><td>N/A</td></tr>");
					console.log("Get rack node info failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
		
		/*William 2018/12/18: After setting the node description, update the description attribute of the HTML.*/
		function btn(click_id) {
			var IP, note, URL;
			IP = click_id;
			note = document.getElementById("note_"+click_id).value;
			parent.$("li[nodelisttag='node-control'][id='" + IP.replace(/\./g, "_") + "']").attr("description", note);
			URL = "./NodeEdit?IP=" + IP + "&note=" + note;
			//window.alert("Set description: " + note);
			window.location.href = URL;
		}
		
		$("#refreshInfo").on("click", function() {
			$('#loading_modal').modal('show');
			
			var ip = "${IP}";
			
			$.ajax({
				url: 'RefreshNodeInfo',
				data: {nodeIP:ip, nodeType:"BMC"},
				dataType: 'json',
				success: function(_data, status, xhr) {
					if(_data.status) {
						/* Brian 2019/07/23: First use host name, if unknown or empty then use product name */
						_data.nodeName = _data.hostName;
						if((_data.nodeName == "") || (_data.nodeName == "Unknown"))
							_data.nodeName = _data.productName;
						
						
						if (_data.nodeName != "Unknown") {
							window.parent.$("li[nodelisttag='node-control'][id='" + ip.replace(/\./g, "_") + "']").find("a")
								.html("<img nodelisttag=\"node-status\" src=\"/GSM/resources/img/icon_status_4.png\">" + 
									  "&nbsp;&nbsp;&nbsp;" + 
									  _data.nodeName + "&nbsp;(" + ip + ")");
						}
					}
					
					location.reload();
				},
				error: function(xhr, status, error) {
					console.log("Refresh node info failed: [" + xhr.status + "] " + xhr.statusText);
					location.reload();
				},
				cache: false
			});
		});
		
		/* Brian.Kung 2020/08/17: Update GPU information while change GPU device id. */
		$("#select_gpu_device_id").on("change", function() {
			var selectValue = $("#select_gpu_device_id").val();
			updateGpuInfo(selectValue);
			
		});
		
		/* Brian.Kung 2020/08/17: Get GPU information. */
		function getGpuInfo() {
			
			$.ajax({
				url: 'getGpuInfo',
				data: {IP:'${IP}'},
				dataType: 'json',
				success: function(_data, status, xhr) {
					
					if(_data.length > 0 && !_data[0].hasOwnProperty("Error")) {
						sGpu_data = _data;
						$("#select_gpu_device_id").empty();
						
						for(var i=0; i<_data.length; i++) {
							if(i == 0) $("#select_gpu_device_id").append($("<option selected></option>").attr("value", i).text(_data[i]["SlotNumber"]));
							else $("#select_gpu_device_id").append($("<option></option>").attr("value", i).text(_data[i]["SlotNumber"]));
						}

						updateGpuInfo(0);
						$("#gpu_info").show();
					}
				},
				error: function(xhr, status, error) {
					console.log("Get GPU information failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
		
		/* Brian.Kung 2020/08/17: Update GPU information while change GPU device id. */
		function updateGpuInfo(index) {
			
			$("#gpu_name").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["MarketingName"]);
			
/* 1. Information */
			// GPUInformation
			$("#gpu_info_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["BoardPartNumber"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["OEMInformation"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["SerialNumber"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(4)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["MarketingName"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(5)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["GPUPartNumber"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(6)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["MemoryVendor"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(7)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["MemoryPartNumber"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(8)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["BuildDate"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(9)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["FirmwareVersion"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(10)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["PCIConfigurationVendorID"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(11)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["PCIConfigurationDeviceID"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(12)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["PCIConfigurationSubsystemVendorID"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(13)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["PCIConfigurationSubsystemDeviceID"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(14)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["GPUGUID"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(15)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["InfoROMVersion"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(16)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["ProductLength"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(17)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["ProductWidth"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(18)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["ProductHeight"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(19)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["PCIeLinkSpeed"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(20)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["PCIeLinkWidth"]);
			$("#gpu_info_table").find("tbody").find("tr:eq(21)").find("td:eq(1)").html(sGpu_data[index]["Information"]["GPUInformation"]["TGPLimit"]);
			// Capabilities
			$("#gpu_cab_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PrimaryGPUTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SecondaryGPUTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SensorMonitoringBoard"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(4)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SensorMonitoringMemory"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(5)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["TotalBoardPowerConsumption"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(6)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ReadingGPUTargetTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(7)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ReadingGPUSlowdownTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(8)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ReadingGPUShutdownTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(9)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ReadingMemoryTargetTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(10)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ReadingGPUMaximumOperatingTemperature"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(11)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["BoardPartNumberV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(12)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["OEMInformationV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(13)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SerialNumberV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(14)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["MarketingNameV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(15)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GPUSiliconRevisionV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(16)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["MemoryVendorV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(17)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["MemoryPartNumberV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(18)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["BuildDateV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(19)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["FirmwareVersionV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(20)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PCIConfigurationVendorIDV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(21)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PCIConfigurationDeviceIDV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(22)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PCIConfigurationSubsystemVendorIDV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(23)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PCIConfigurationSubsystemDeviceIDV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(24)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GPUGUIDV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(25)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["InfoROMVersionV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(26)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ECCStatisticsDataV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(27)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ECCStatisticsDataV2"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(28)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ECCStatisticsDataV3"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(29)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ECCStatisticsDataV4"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(30)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ECCStatisticsDataV5"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(31)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["RetiredPageCountQuery"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(32)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["WriteProtectMode"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(33)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ECCEnabledState"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(34)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GPUResetRequiredStateFlag"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(35)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GPUAccumulatedSMUtilization"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(36)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["QueryNVLinkInformation"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(37)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["QueryNVLinkInformationErrorCounts"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(38)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["QueryClockFrequencyInformation"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(39)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["NvidiaGPUDriverNotLoaded"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(40)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["FanQueriesV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(41)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ProductLengthV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(42)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ProductWidthV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(43)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ProductHeightV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(44)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PCIeLinkSpeedV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(45)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["PCIeLinkWidthV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(46)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["TGPLimitV1"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(47)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["EnableDisablePowerSupply"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(48)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetPowerSupplyStatus"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(49)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["AssertDeassertPCIeFundamentalReset"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(50)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetPCIeFundamentalReset"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(51)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SetReleasePowerBrake"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(52)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetPowerBrake"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(53)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetThermalAlertState"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(54)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SetErrorLEDState"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(55)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetBoardPowerSupplyStatus"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(56)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["SetThermalAlert"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(57)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetSetMCUFWWriteProtect"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(58)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetHWViolationTimeValue"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(59)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetGlobalSWViolationTimeValue"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(60)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetPowerPolicyViolationTimeValue"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(61)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetThermalPolicyViolationTimeValue"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(62)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["GetCurrentSMMEMUtilizationValue"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(63)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["RequestBundling"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(64)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ScratchSpaceSize"]);
			$("#gpu_cab_table").find("tbody").find("tr:eq(65)").find("td:eq(1)").html(sGpu_data[index]["Information"]["Capabilities"]["ScratchSpaceBankSize"]);
			// NVLinkInfo
			$("#gpu_nvlink_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Information"]["NVLinkInfo"]["NVLinkNumber"]);
			$("#gpu_nvlink_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Information"]["NVLinkInfo"]["NVLinkStatus"]);
			$("#gpu_nvlink_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Information"]["NVLinkInfo"]["NVLinkSpeed"]);
			
/* 2. Temperature */
			// GpuTemperature
			$("#gpu_temp_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["GpuTemperature"]["PrimaryGPU"]);
			$("#gpu_temp_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["GpuTemperature"]["SecondaryGPU"]);
			$("#gpu_temp_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["GpuTemperature"]["SensorMonitoringBoard"]);
			$("#gpu_temp_table").find("tbody").find("tr:eq(4)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["GpuTemperature"]["SensorMonitoringMemory"]);
			// ExtendedPrecisionGpuTemperature
			$("#gpu_temp_extend_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["ExtendedPrecisionGpuTemperature"]["PrimaryGPU"]);
			$("#gpu_temp_extend_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["ExtendedPrecisionGpuTemperature"]["SecondaryGPU"]);
			$("#gpu_temp_extend_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["ExtendedPrecisionGpuTemperature"]["SensorMonitoringBoard"]);
			$("#gpu_temp_extend_table").find("tbody").find("tr:eq(4)").find("td:eq(1)").html(sGpu_data[index]["Temperature"]["ExtendedPrecisionGpuTemperature"]["SensorMonitoringMemory"]);
			
/* 3. Status */
			// AccumulatedUtilizationTime
			$("#gpu_status_accumulated_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Status"]["AccumulatedUtilizationTime"]["ContextUtilizationTime"]);
			$("#gpu_status_accumulated_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Status"]["AccumulatedUtilizationTime"]["SMUtilizationTime"]);
			// AccumulatedUtilizationTime
			$("#gpu_status_power_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Status"]["PowerSupply"]["SufficientExternalPower"]);
			$("#gpu_status_power_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Status"]["PowerSupply"]["PowerSupplyStatus"]);
			$("#gpu_status_power_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Status"]["PowerSupply"]["BoardPowerSupplyStatus"]);
			
/* 4. Power */
			// PowerConsumption
			$("#gpu_power_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Power"]["PowerConsumption"]["Power"]);
			
/* 5. Clock */
			// ClockFrequency Graphics
			$("#gpu_clock_graphics_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Clock"]["ClockFrequency"]["Graphics"]["Current"]);
			$("#gpu_clock_graphics_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Clock"]["ClockFrequency"]["Graphics"]["MinProgrammable"]);
			$("#gpu_clock_graphics_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Clock"]["ClockFrequency"]["Graphics"]["MaxProgrammable"]);
			// ClockFrequency Memory
			$("#gpu_clock_memory_table").find("tbody").find("tr:eq(1)").find("td:eq(1)").html(sGpu_data[index]["Clock"]["ClockFrequency"]["Memory"]["Current"]);
			$("#gpu_clock_memory_table").find("tbody").find("tr:eq(2)").find("td:eq(1)").html(sGpu_data[index]["Clock"]["ClockFrequency"]["Memory"]["MinProgrammable"]);
			$("#gpu_clock_memory_table").find("tbody").find("tr:eq(3)").find("td:eq(1)").html(sGpu_data[index]["Clock"]["ClockFrequency"]["Memory"]["MaxProgrammable"]);
			
		}
	</script>
</body>
</html>