<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<!-- William 2018/12/24: Modified to get the parameters of Lan config from GetController to BMC. -->
<!-- William 2019/01/15: Make DHCP event listener to set related actions. -->
<html>
<head>
	<title>Node Network Configuration</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<style type="text/css">
		.progress-circle {
    		margin-top: 260px !important;
			width: 95px !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
	    .btn-file {
	    position: relative;
	    overflow: hidden;
		}
		.btn-update {
	    position: relative;
	    overflow: hidden;
		}
		.btn-file input[type=file] {
		    position: absolute;
		    top: 0;
		    right: 0;
		    min-width: 100%;
		    min-height: 100%;
		    font-size: 100px;
		    text-align: right;
		    filter: alpha(opacity=0);
		    opacity: 0;
		    outline: none;
		    background: white;
		    cursor: inherit;
		    display: block;
		}
		input[readonly] {
		  background-color: white !important;
		  cursor: text !important;
		}
		#progress_bar {
			margin: 10px 0;
		    padding: 3px;
		    clear: both;
		    opacity: 1.0;
		}
		#restoreFile {
    		display: none;
		}
	</style>
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
	
	<style>
			.modal-dialog {
    			margin-top: 260px !important;
				width: 95px !important;
			}
			.alert {
				margin-bottom: 0px !important;
		    }	
	</style>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				
				<!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
				<!-- /.row -->
				<br>
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading" id="ipv4PanelHead">
								<h4><spring:message code="NodeNetwork1"/></h4>
							</div>
							<!-- /.panel-heading -->
							
							<div class="panel-body" id="ipv4PanelBody">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="ipv4Tables">
										<tbody>
											<tr id="ipv4_enable"><td><spring:message code="NodeNetwork3"/></td><td></td></tr>
											<tr><td><spring:message code="NodeNetwork4"/></td><td><input type=checkbox id="ipv4DHCPEnable" data-size="mini"></td></tr>
											<tr><td><spring:message code="NodeNetwork5"/></td><td><input type="text" id="ipv4_addr" value="" ></td></tr>
											<tr><td><spring:message code="NodeNetwork6"/></td><td><input type="text" id="ipv4_sub" value="" ></td></tr>
											<tr><td><spring:message code="NodeNetwork7"/></td><td><input type="text" id="ipv4_gate" value="" ></td></tr>
										</tbody>
									</table>
									<div>
										<button type="button" onclick="setIPv4()" class="btn btn-primary" ><spring:message code="Submit"/></button>
									</div>
								</div>
								<!-- /.dataTable_wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
						
						<div class="panel panel-default" id="ipv6Panel">
							<div class="panel-heading" id="ipv6PanelHead">
								<h4><spring:message code="NodeNetwork2"/></h4>
							</div>
							<!-- /.panel-heading -->
							
							<div class="panel-body" id="ipv6PanelBody">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" id="ipv6Tables">
										<tbody>
											<tr id="ipv6_enable"><td><spring:message code="NodeNetwork3"/></td><td></td></tr>
											<tr><td><spring:message code="NodeNetwork4"/></td><td><input type=checkbox id="ipv6DHCPEnable" data-size="mini" ></td></tr>
											<tr><td><spring:message code="NodeNetwork5"/></td><td><input type="text" id="ipv6_addr" value="" ></td></tr>
											<tr><td><spring:message code="NodeNetwork7"/></td><td><input type="text" id="ipv6_gate" value="" ></td></tr>
											<tr><td><spring:message code="NodeNetwork8"/></td><td id="ipv6_linkLocalAddress"></td></tr>
										</tbody>
									</table>
									<div>
										<button type="button" onclick="setIPv6()" class="btn btn-primary" ><spring:message code="Submit"/></button>
									</div>
								</div>
								<!-- /.dataTable_wrapper -->
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
				</sec:authorize>
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /#page-wrapper -->
	</div>
	<!-- /#wrapper -->
	
	<div class="modal fade" id="loading_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog progress-circle" role="document">
			<div class="modal-content">
				<div id="loading" class="alert">
					<i id="loading_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	<sec:authorize access="!hasAnyRole(${Access_Configuration})" var="var_not_Access_Configuration"/>
	<script>
		var ipv6Src;
		
		$(document).ready(function() {
			$('#loading_modal').modal('hide');
			getLanConfig(true);
			
			//document.getElementById('methods').style.visibility = 'hidden'; 
		});
		
		//$(".tbody[input[type=checkbox]]").bootstrapSwitch();
		
        $("#ipv4Tables>tbody").delegate("input[type=checkbox]", "switchChange.bootstrapSwitch", function() {
            var id = $(this).attr("id");
			if (document.getElementById(id).checked) {
				$("input[id=ipv4_addr]").prop("disabled", true);
				$("input[id=ipv4_sub]").prop("disabled", true);
				$("input[id=ipv4_gate]").prop("disabled", true);
			} else {
				$("input[id=ipv4_addr]").prop("disabled", false);
				$("input[id=ipv4_sub]").prop("disabled", false);
				$("input[id=ipv4_gate]").prop("disabled", false);
			}
		});
		
        $("#ipv6Tables>tbody").delegate("input[type=checkbox]", "switchChange.bootstrapSwitch", function() {
            var id = $(this).attr("id");
			if (document.getElementById(id).checked) {
				$("input[id=ipv6_addr]").prop("disabled", true);
				$("input[id=ipv6_gate]").prop("disabled", true);
			} else {
				$("input[id=ipv6_addr]").prop("disabled", false);
				$("input[id=ipv6_gate]").prop("disabled", false);
			}
		});
		
		function getLanConfig(first)
		{
			if(first) {
				lanConfigLoading(true);
			}
			
			$.ajax({
		        url: 'getLanConfig',
		        data: {nodeIP:'${IP}'},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	lanConfigLoading(false, _data);
		        },
		        error: function(xhr, status, error) {
		        	lanConfigLoading(false);
		        	console.log("Get the Lan configuration failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		function lanConfigLoading(start, data)
		{
			if(start) {
				$("#ipv4PanelHead").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
                $("#ipv4PanelBody").hide();
				$("#ipv6PanelHead").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
                $("#ipv6PanelBody").hide();
			}
			else {
				setTimeout(function() {
					if(data != null) {
						if(data.ipv4IPAddress !== 'N/A') {
							$("#ipv4PanelHead").html("<h4><spring:message code='NodeNetwork1'/></h4>");
	                        $("#ipv4_enable").html("<td><spring:message code='NodeNetwork3'/></td><td id='ipv4_enable'>" + data.ipv4Enabled + "</td>");
							$("#ipv4DHCPEnable").bootstrapSwitch('state', data.ipv4UseDHCP);
	                        $("#ipv4_addr").val(data.ipv4IPAddress);
	                        $("#ipv4_sub").val(data.ipv4SubnetMask);
	                        $("#ipv4_gate").val(data.ipv4Gateway);
							$("#ipv4PanelBody").show();
						}
						else {
							$("#ipv4PanelHead").html("<h4><spring:message code='webErrMsg16'/></h4>");
						}
						
						if(data.ipv6IPAddress !== 'N/A') {
							$("#ipv6PanelHead").html("<h4><spring:message code='NodeNetwork2'/></h4>");
							$("#ipv6_enable").html("<td><spring:message code='NodeNetwork3'/></td><td id='ipv6_enable'>" + data.ipv6Enabled + "</td>");
							$("#ipv6DHCPEnable").bootstrapSwitch('state', data.ipv6UseDHCP);
							$("#ipv6_addr").val(data.ipv6IPAddress);
							$("#ipv6_gate").val(data.ipv6Gateway);
							$("#ipv6_linkLocalAddress").html(data.ipv6LinkLocalAddress);
							$("#ipv6PanelBody").show();
						}
						else {
							$("#ipv6PanelHead").html("<h4><spring:message code='webErrMsg18'/></h4>");
						}
					}
					else {
						$("#ipv4PanelHead").html("<h4><spring:message code='webErrMsg16'/></h4>");
						$("#ipv6PanelHead").html("<h4><spring:message code='webErrMsg18'/></h4>");
					}
				}, 100);
			}
		}
		
		function setIPv4()
		{
			var ipv4DHCP = document.getElementById('ipv4DHCPEnable').checked;
			var ipv4Addr = document.getElementById('ipv4_addr').value;
			var ipv4Sub = document.getElementById('ipv4_sub').value;
			var ipv4Gate = document.getElementById('ipv4_gate').value;
			
			var ipv4Paras = "&ipv4Enable=" + ipv4DHCP + "&ipv4Address=" + ipv4Addr + "&ipv4Subnet=" + ipv4Sub + "&ipv4Gateway=" + ipv4Gate;
			
			$('#loading_modal').modal('show');
			parent.changeVariableValueManually("tabMenuSelected",  "NodeInformation");
			parent.unfocusTargetNode("${IP}");
			parent.$("#tabMenuSelect_SystemManager").prop('selectedIndex', 0);
			
			window.location.href = "./SetNetwork?IP=" + '${IP}' + "&Type=IPv4" + ipv4Paras;
		}
		
		function setIPv6()
		{
			var ipv6DHCP = document.getElementById('ipv6DHCPEnable').checked;
			var ipv6Addr = document.getElementById('ipv6_addr').value;
			var ipv6Gate = document.getElementById('ipv6_gate').value;
			
			var ipv6Paras = "&ipv6Enable=" + ipv6DHCP + "&ipv6Source=" + ipv6Src + "&ipv6Address=" + ipv6Addr + "&ipv6Gateway=" + ipv6Gate;
			
			$('#loading_modal').modal('show');
			parent.changeVariableValueManually("tabMenuSelected",  "NodeInformation");
			parent.unfocusTargetNode("${IP}");
			parent.$("#tabMenuSelect_SystemManager").prop('selectedIndex', 0);
			
			window.location.href = "./SetNetwork?IP=" + '${IP}' + "&Type=IPv6" + ipv6Paras;
		}
	</script>
</body>
</html>