<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<title>Scan List</title>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<!-- CSS -->
		<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
		<style>
			.group-input {
				display: inline;
			}
		</style>
		
		<!-- Javascript -->
		<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
		<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
		<script src="<c:url value="/resources/js/gsm_date.js"/>"></script>
	</head>
	
	<body>
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="container-fluid">
					<br>
					<div class="row">
						<div class="col-sm-12">
							<div class="panel panel-default">
								<div class="panel-body">
									<form action="javascript:scan();">
										<div class="col-sm-4">
											<div class="form-inline group-input">
												<label class="control-label">Start IP:&nbsp;</label>
												<input id="startIP" name="StartIP" type="text" class="form-control input-sm">
											</div>
										</div>
										<div class="col-sm-4">
											<div class="form-inline group-input">
												<label class="control-label">End IP:&nbsp;</label>
												<input id="endIP" name="EndIP" type="text" class="form-control input-sm">
											</div>
										</div>
										<div class="col-sm-4" style="text-align: center;">
											<div class="form-inline group-input">
												<button id="scan" type="submit" class="btn btn-primary input-sm" title="Scan">Scan</button>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-body">
									<div class="dataTable_wrapper">
										<table id="scanlistDataTable" class="table table-striped table-bordered table-hover">
											<thead>
												<tr>
													<th>IP</th>
													<th>MAC</th>
													<th>Type</th>
													<th>Vendor</th>
													<th>ASIC</th>
													<th>Platform</th>
													<th>ProductName</th>
												</tr>
											</thead>
											<tbody>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<script>
			$(document).ready(function() {
				loadingList(true);
				
				var scanlist = '${data}';
				if(scanlist !== "") {
					var scanlistObj = JSON.parse(scanlist);
					$("#startIP").val(scanlistObj.startIP);
					$("#endIP").val(scanlistObj.endIP);
					loadingList(false, scanlistObj.scanlist);
				}
				else {
					loadingList(false);
				}
			});
			
			var scanlistDataTable = $("#scanlistDataTable").DataTable({
				"aaSorting": [[ 0, "asc" ]], 
				"pageLength": 50, 
				"pagingType": "full_numbers", 
				"responsive": true, 
				"createdRow": function(row, data, dataIndex) {
					$(row).find('td:eq(0)').html("<a name='ip_link' href='#' ip='" + data[0] + "'>" + data[0] + "</a>");
				}
			});
			
			function scan()
			{
				if(($("#startIP").val() === "") && ($("#endIP").val() === "")) {
					alert("IP range is empty");
					return;
				}
				
				loadingList(true);
				
				$.ajax({
					url: '/GSM/scan?startIP=' + $("#startIP").val() + '&endIP=' + $("#endIP").val(),
				    data: {},
				    dataType: 'json',
				    success: function(_data, status, xhr) {
				    	location.reload();
				    },
				    error: function(xhr, status, error) {
				    	loadingList(false);
				    	console.log("Scan failed: [" + xhr.status + "] " + xhr.statusText);
					},
				    cache: false
				});
			}
			
			$("#scanlistDataTable").delegate("a[name='ip_link']", "click", function() {
				window.open('http://' + $(this).attr("ip"));
			});
			
			function loadingList(start, jsonArray)
			{
				if(start) {
					$("#scanlistDataTable>tbody").html("<tr><td colspan='7' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
				}
				else {
					setTimeout(function(){
						scanlistDataTable.clear().draw(false);
						
						if((jsonArray != null) && (jsonArray.length > 0)) {
							var dataArray = [];
							
							for(var i=0 ; i<jsonArray.length ; i++) {
								dataArray.push([jsonArray[i].ip, 
												jsonArray[i].mac, 
												jsonArray[i].type, 
												jsonArray[i].vendor, 
												jsonArray[i].asic, 
												jsonArray[i].platform, 
												jsonArray[i].productName]);
							}
							
							scanlistDataTable.rows.add(dataArray).draw(false);
	                    }
					}, 100);
				}
			}
		</script>
	</body>
</html>
