<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<link rel="shortcut icon" href="https://www.gigabyte.com/Images/favicon_b.ico" type="image/x-icon" />
	<head>
		<title>GSM Server</title>
		
		<!-- meta -->
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		
		<!-- CSS -->
		<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap-slider.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
		<style>
			#setupWizardTab .tab-content {
			  padding : 5px 15px;
			  margin-top: 15px;
			}
			
			#setupWizardTab .nav-pills > li > a {
			  border-radius: 0;
			}
			
			.modal-dialog {
   	 			//width: 800px;
    			margin-top: 160px !important;
			}
			
			body {
				background-color: #231815;
			}
			
			h3 {
				margin-top: 10px;
			}
			
			.form-control {
				display: inline;
				width: auto;
			}
			
			.form-control-sm {
			    height: 30px;
			    padding: 5px 7px;
			}
			
			.table {
				margin-bottom: 0px;
			}
			
			.half-table>tbody>tr>td {
				width: 50%;
			}
			.expand-grid>tbody>tr>td {
				padding: 8px !important;
			}
		</style>
		
		<!-- Java Script -->
		<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap-slider.js"/>"></script>
		<script src="<c:url value="/resources/js/gsm_main.js" />"></script>
	</head>
	
	<body id="header-body">
		<div id="wrapper">
			<!-- Navigation -->
			<nav class="navbar navbar-inverse navbar-fixed-top">
				<div class="container-fluid">
					<div class="navbar-header">
						<table border="0">
							<tr>
								<td class="topbar-logo">
									<a class="navbar-brand" rel="home" title="Gigabyte">
										<img src="/GSM/GSMLogo_Get/gsm_logo.png">
									</a>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</nav>
		</div>
		
		<!-- First setup wizard -->
		<div style="color:black" class="modal fade" id="setupWizardModal" tabindex="-1" role="dialog" aria-labelledby="setupWizardLabel" data-backdrop="static" data-keyboard="false">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h3 class="modal-title" id="updateLogoStatusLabel" style="display:inline-block;"><spring:message code="setupWizard"/></h3>
						<div width="100%" style="text-align: right; float: right;">
							<button id="stopSetupWizardModal" type="button" class="btn btn-primary"><i class="fa fa-times" aria-hidden="true"></i></button>
						</div>
					</div>
					
					<div class="modal-body">
						<div class="row">
							<div class="col-lg-12">
								<div id="setupWizardTab" class=""> 
									<ul class="nav nav-pills">
										<li class="active">
											<a id="setupWizardTab_0_link" href="#setupWizardTab_0" data-toggle="tab">Start</a>
										</li>
										<li>
											<a id="setupWizardTab_1_link" href="#setupWizardTab_1" data-toggle="tab">SNMP</a>
										</li>
										<li>
											<a id="setupWizardTab_2_link" href="#setupWizardTab_2" data-toggle="tab">SMTP</a>
										</li>
										<li>
											<a id="setupWizardTab_3_link" href="#setupWizardTab_3" data-toggle="tab">Schedule</a>
										</li>
										<li>
											<a id="setupWizardTab_4_link" href="#setupWizardTab_4" data-toggle="tab">Checking</a>
										</li>
										<li>
											<a id="setupWizardTab_5_link" href="#setupWizardTab_5" data-toggle="tab">IP Range</a>
										</li>
										<li>
											<a id="setupWizardTab_6_link" href="#setupWizardTab_6" data-toggle="tab">Password</a>
										</li>
										<li>
											<a id="setupWizardTab_7_link" href="#setupWizardTab_7" data-toggle="tab">Done</a>
										</li>
									</ul>
									
									<div class="tab-content clearfix">
										<div class="tab-pane active" id="setupWizardTab_0">
											<h4><spring:message code="setupWizardMsg0"/></h4>
											<div class="panel-body" style="text-align: center;">
												<select id="languageOption" class="form-control form-control-sm">
													<option><spring:message code="Language"/></option>
											        <option value="Chinese" <c:if test="${getLanguage == 'Chinese'}">selected</c:if>>繁體中文</option>
											        <option value="English" <c:if test="${getLanguage == 'English'}">selected</c:if>>English</option>
											        <option value="Auto detect">Auto detect</option>
										    	</select>
											</div>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_1">
											<c:set var="xmltext_snmp">${XMLString_snmp}</c:set>
											<x:parse xml="${xmltext_snmp}" var="outputSNMP"/>
											<x:set select="$outputSNMP/SNMPList/snmp" var="item_snmp"/>
											
											<h4><spring:message code="setupWizardMsg1"/></h4>
											<br>
											<div style="padding: 0px 15px;text-decoration:underline;">
												<h4><spring:message code="GSMSNMP1"/></h4>
											</div>
											<div class="dataTable_wrapper">
												<table class="table table-striped table-bordered table-hover half-table">
													<tbody>
														<tr>
															<td><spring:message code="GSMSNMP3"/></td>
															<td><input type="checkbox" id="check0" checked data-size="mini"></td>
														</tr>
														<tr>
															<td><spring:message code="GSMSNMP4"/></td>
															<td>
																<select id="localAddress" class="form-control form-control-sm">
																	<x:forEach select="$outputSNMP/SNMPList/localAddressList" var="ipList">
																	<option value="<x:out select="$ipList/ip" />" <x:if select="$item_snmp/localAddress = $ipList/ip">selected</x:if>> <x:out select="$ipList/ip" /> </option>
																	</x:forEach>
																</select>
															</td>
														</tr>
														<tr>
															<td><spring:message code="GSMSNMP5"/></td>
															<td>
																<select id="status" class="form-control form-control-sm">
																	<!-- <option id="level0" value="0"> DEBUG </option>
																	<option id="level1" value="1"> INFO </option>
																	<option id="level2" value="2"> WARN </option>
																	<option id="level3" value="3"> ERROR </option>
																	<option id="level4" value="4"> FATAL </option> -->
																	<option id="level3" value="3"> Unknown </option>
																	<option id="level2" value="2"> Non-Critical </option>
																	<option id="level1" value="1"> Critical </option>
																</select>
															</td>
														</tr>
													</tbody>
												</table>
												<h5><spring:message code="GSMSNMP7"/></h5>
											</div>
											
											<div style="padding: 10px 15px 0px 15px;text-decoration:underline;">
												<h4><spring:message code="NodeSetting3"/></h4>
											</div>
											<div class="dataTable_wrapper">
												<table class="table table-striped table-bordered table-hover half-table">
													<thead>
														<tr>
															<th><spring:message code="NodeSetting5"/></th>
															<th><spring:message code="NodeSetting6"/></th>
														</tr>
													</thead>
													<tbody>
														<tr>
															<td><input type="checkbox" id="check1" checked data-size="mini"></td>
															<td><input type="text" id="check1_addr" value="<x:out select="$item_snmp/ipv4Destination1" />" class="form-control form-control-sm"></td>
														</tr>
														<tr>
															<td><input type="checkbox" id="check2" checked data-size="mini"></td>
															<td><input type="text" id="check2_addr" value="<x:out select="$item_snmp/ipv4Destination2" />" class="form-control form-control-sm"></td>
														</tr>
														<tr>
															<td><input type="checkbox" id="check3" checked data-size="mini"></td>
															<td><input type="text" id="check3_addr" value="<x:out select="$item_snmp/ipv4Destination3" />" class="form-control form-control-sm"></td>
														</tr>
														<tr>
															<td><input type="checkbox" id="check4" checked data-size="mini"></td>
															<td><input type="text" id="check4_addr" value="<x:out select="$item_snmp/ipv4Destination4" />" class="form-control form-control-sm"></td>
														</tr>
													</tbody>
												</table>
											</div>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_2">
											<c:set var="xmltext_smtp">${XMLString_smtp}</c:set>
											<x:parse xml="${xmltext_smtp}" var="outputSMTP"/>
											<x:set select="$outputSMTP/SMTPList/Property" var="SMTPProp"/>
											
											<h4><spring:message code="setupWizardMsg2"/></h4>
											<br>
											<div class="dataTable_wrapper">
												<div style="padding: 0px 15px;text-decoration:underline;">
													<h4><spring:message code="GSMSNMP1"/></h4>
												</div>
												<table class="table table-striped table-bordered table-hover half-table">
													<tbody>
														<x:forEach select="$outputSMTP/SMTPList/List" end="0" var="item_smtp">
															<tr>
																<td><spring:message code="GSMSMTP2"/></td>
																<td><input id="smtpHost" name="Host" class="form-control form-control-sm" type="text" value="<x:out select="$item_smtp/Host" />"></td>
															</tr>
															<tr>
																<td><spring:message code="GSMSMTP3"/></td>
																<td><input id="smtpPort" name="Port" class="form-control form-control-sm" type="text" value="<x:out select="$item_smtp/Port" />"></td>
															</tr>
															<tr>
																<td><spring:message code="GSMSMTP4"/></td>
																<td><input id="smtpAccount" name="Account" class="form-control form-control-sm" type="text" value="<x:out select="$item_smtp/Account" />"></td>
															</tr>
															<tr>
																<td><spring:message code="GSMSMTP5"/></td>
																<td><input id="smtpPassword" name="Password" class="form-control form-control-sm" type="password" value="<x:out select="$item_smtp/Password" />"></td>
															</tr>
															<tr>
																<td><spring:message code="GSMSMTP7"/></td>
																<td><input id="smtpAddr" name="Addr" class="form-control form-control-sm" type="text" value="<x:out select="$item_smtp/Addr" />"></td>
															</tr>
															<tr>
																<td><spring:message code="GSMSMTP17"/></td>
																<td><input onchange="authChange(this.checked)" id="smtpAuth" name="Auth" class="form-control form-control-sm" type="checkbox"></td>
															</tr>
															<tr>
																<td><spring:message code="GSMSMTP16"/></td>
																<td><input id="smtpTLS" name="TLS" class="form-control form-control-sm" type="checkbox"></td>
															</tr>
														</x:forEach>
													</tbody>
												</table>
												
												<div style="padding: 10px 15px 0px 15px;text-decoration:underline;">
													<h4><spring:message code="GSMSMTP7"/> <spring:message code="GSMSNMP2"/></h4>
												</div>
												<table class="table table-striped table-bordered table-hover">
													<thead>
														<tr>
															<th><spring:message code="GSMSMTP8"/></th>
															<th><spring:message code="GSMSMTP7"/></th>
															<th><spring:message code="GSMSMTP9"/></th>
														</tr>
													</thead>
													<tbody>
														<x:forEach select="$outputSMTP/SMTPList/List" begin="1" var="item_smtp" varStatus="index">
															<tr>
																<td style="display: none;" id="smtp_des${index.index}_id"><x:out select="$item_smtp/ID"/></td>
																<td><input id="smtp_des${index.index}_enable" type="checkbox" name="Enable" value="<x:out select="$item_smtp/ID" />" <x:out select="$item_smtp/Enable" />></td>
																<td><input id="smtp_des${index.index}_addr" name="SubAddr" class="form-control form-control-sm" type="text" value="<x:out select="$item_smtp/SubAddr" />"></td>
																<td>
																	<select id="smtp_des${index.index}_level" name="eventLevel" class="form-control form-control-sm">
																		<!-- <option id="level0" value="0" <x:if select="$item_smtp/eventLevel = 0">selected</x:if>> DEBUG </option>
																		<option id="level1" value="1" <x:if select="$item_smtp/eventLevel = 1">selected</x:if>> INFO </option>
																		<option id="level2" value="2" <x:if select="$item_smtp/eventLevel = 2">selected</x:if>> WARN </option>
																		<option id="level3" value="3" <x:if select="$item_smtp/eventLevel = 3">selected</x:if>> ERROR </option>
																		<option id="level4" value="4" <x:if select="$item_smtp/eventLevel = 4">selected</x:if>> FATAL </option> -->
																		<option id="level3" value="3" <x:if select="$item_smtp/eventLevel >= 3">selected</x:if><x:if select="$item_smtp/eventLevel < 1">selected</x:if>> Unknown </option>
																		<option id="level2" value="2" <x:if select="$item_smtp/eventLevel = 2">selected</x:if>> Non-Critical </option>
																		<option id="level1" value="1" <x:if select="$item_smtp/eventLevel = 1">selected</x:if>> Critical </option>
																	</select>
																</td>
															</tr>
														</x:forEach>
													</tbody>
												</table>
											</div>
											
											<h5><spring:message code="GSMSNMP7"/></h5>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_3">
											<h4><spring:message code="setupWizardMsg3"/></h4>
											<br>
											<div style="padding: 0px 15px;text-decoration:underline;">
												<h4><spring:message code="SettingGSM2"/></h4>
											</div>
											<div class="panel panel-default">
												<div class="panel-body">
													<p><spring:message code="SettingGSM5"/></p>
													<div>
														<spring:message code="SettingGSM6"/> &nbsp;
														<select id="sche_SP" name="ScanPeriod" class="form-control form-control-sm">
															<c:forEach var="i" begin="1" end="12">
																<option value="${i}" ${i == scanPeriod ? 'selected' : ''}> ${i} </option>
															</c:forEach>
														</select>
														&nbsp;<spring:message code="SettingGSM12"/><br>
													</div>
												</div>
											</div>
											
											<div style="padding: 0px 15px;text-decoration:underline;">
												<h4><spring:message code="SettingGSM16"/></h4>
											</div>
											<div class="panel panel-default">
												<div class="panel-body">
													<p><spring:message code="SettingGSM17"/></p>
													<div>
													    <p>
													    <spring:message code="SettingGSM18"/><br>
													    <b>50</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="nodeSliderBar" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>300</b>
													    &nbsp;&nbsp;&nbsp;&nbsp;<input id="nodeSliderBarValue" name="BmcQuantity" type="text" class="form-control form-control-sm" maxlength="3" size="3" value="${bmcQuantity}">&nbsp;<b>nodes</b>
													    </p>
													</div>
													<div>
													    <p>
													    <spring:message code="SettingGSM19"/><br>
													    <b>3</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="periodSliderBar" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>10</b>
													    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input id="periodSliderBarValue" name="BmcPeriod" type="text" class="form-control form-control-sm" maxlength="2" size="2" value="${bmcPeriod}">&nbsp;<b>minutes</b>
													    </p>
													</div>
												</div>
											</div>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_4">
											<h4><spring:message code="setupWizardMsg4"/></h4>
												<br>
											<div style="padding: 0px 15px;text-decoration:underline;">
												<h4><spring:message code="SettingGSM3"/></h4>
											</div>
											<div class="panel panel-default">
												<div class="panel-body">
													<p>
														<spring:message code="SettingGSM7"/><br>
														<spring:message code="SettingGSM20"/>
													</p>
													<br>
													<div>
														<b>0%</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="limit" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>100%</b>
														&nbsp;<span id="ex6CurrentSliderValLabel"> <input id="limitValue" type=text class="form-control form-control-sm" maxlength="3" size="3" name="DBThreshold" value="${dbThreshold}"> %</span><br>
													</div>
													<br>
													<div>
														<br><spring:message code="SettingGSM9"/>
														<select id="DBE" name="DBExpiration" class="form-control form-control-sm">
															<c:forEach var="i" begin="1" end="365">
																<option value="${i}" ${i == dbExpiration ? 'selected' : ''}> ${i} </option>
															</c:forEach>
														</select>
														<spring:message code="SettingGSM13"/>
													</div>
												</div>
											</div>
											
											<div style="padding: 0px 15px;text-decoration:underline;">
												<h4><spring:message code="SettingGSM4"/></h4>
											</div>
											<div class="panel panel-default">
												<div class="panel-body">
													<p><spring:message code="SettingGSM10"/></p>
													<div>
														<spring:message code="SettingGSM11"/>
														<select id="LExp" name="LogExpiration" class="form-control form-control-sm">
															<c:forEach var="i" begin="1" end="7">
																<option value="${i}" ${i == logExpiration ? 'selected' : ''}> ${i} </option>
															</c:forEach>
														</select>
														<spring:message code="SettingGSM13"/><br>
													</div>
												</div>
											</div>
											
											<div style="display:${platformOS == true ? 'block' : 'none'}">
												<div style="padding: 0px 15px;text-decoration:underline;">
													<h4><spring:message code="SettingGSM22"/></h4>
												</div>
												<div class="panel panel-default">
													<div class="panel-body">
														<p><spring:message code="SettingGSM23"/></p>
														<div>
															<spring:message code="SettingGSM24"/>
															<select id="RotationPeriodExpiration" name="RotationPeriod" <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>>
																<option value="1" ${rotationPeriod == 1 ? 'selected' : ''}><spring:message code="hour"/></option>
																<option value="24" ${rotationPeriod == 24 ? 'selected' : ''}><spring:message code="day"/></option>
																<option value="168" ${rotationPeriod == 168 ? 'selected' : ''}><spring:message code="week"/></option>
																<option value="720" ${rotationPeriod == 720 ? 'selected' : ''}><spring:message code="month"/></option>
															</select>
														</div>
														<br>
														<div>
														    <p>
														    <spring:message code="SettingGSM25"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
														    <b>1</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="rotationSizeSliderBar" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>1024</b>
														    &nbsp;&nbsp;&nbsp;&nbsp;<input id="rotationSizeSliderBarValue" name="RotationSize" type="text" maxlength="4" size="3" value="${rotationSize}">
														    </p>
														</div>
													</div>
												</div>
											</div>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_5">
											<h4><spring:message code="setupWizardMsg5"/></h4>
											<br>
											<!-- <div class="panel panel-default">
												<div class="panel-heading">
													<h4 style="display:inline-block;"><spring:message code="connectionInterface"/></h4>&nbsp;
													<select id="CISelect" class="form-control form-control-sm">
														<option value="Auto" <c:if test="${connectionInterface == 'Auto'}">selected</c:if>> Auto </option>
														<option value="IPMI" <c:if test="${connectionInterface == 'IPMI'}">selected</c:if>> IPMI </option>
														<option value="Redfish" <c:if test="${connectionInterface == 'Redfish'}">selected</c:if>> Redfish </option>
													</select>
												</div>
											</div> -->
											
											<c:forEach var = "i" begin = "1" end = "3">
												<div class="panel panel-default">
						                            <div class="panel-body">
					                                    <div class="dataTable_wrapper">
					                                        <table class="table table-striped table-bordered table-hover half-table expand-grid">
																<tbody id="ipRange_${i}">
																	<tr>
																		<td><spring:message code="startIP"/>:&nbsp;<input type="text" id="startIP${i}" name="StartIP" class="form-control form-control-sm" maxlength="15" size="15"/></td>
																		<td><spring:message code="endIP"/>:&nbsp;<input type="text" id="endIP${i}" name="EndIP" class="form-control form-control-sm" maxlength="15" size="15"/></td>
																	</tr>
																	<tr>
																		<td>
																			<label class="checkbox-inline"><input type="checkbox" id="bmcChecked${i}" name="SMC" checked>BMC</label>
																			<!-- <label class="checkbox-inline"><input type="checkbox" id="rmcChecked${i}" name="RMC" checked>RMC</label> -->
																			<label class="checkbox-inline"><input type="checkbox" id="cmcChecked${i}" name="CMC" checked>CMC</label><br>
																			<label class="checkbox-inline"><input type="checkbox" id="esxChecked${i}" name="ESX" onchange="changeVM(${i})">ESX</label>
																			<label style="display:none" class="checkbox-inline"><input type="checkbox" id="hypervChecked${i}" name="HyperV" onchange="changeVM(${i})">HyperV</label>
																		</td>
																		<td><spring:message code="policyName"/>:&nbsp;<input type="text" id="name${i}" name="Name" class="form-control form-control-sm" maxlength="15" size="15" value="New policy"></td>
																	</tr>
																	<tr>
																		<td><spring:message code="UserName"/>:&nbsp;<input type="text" id="UserName${i}" name="UserName" class="form-control form-control-sm" maxlength="13" size="13" value="admin"></td>
																		<td><spring:message code="Password"/>:&nbsp;<input type="text" id="Password${i}" name="Password" class="form-control form-control-sm" maxlength="13" size="13" value="password"></td>
																	</tr>
																</tbody>
															</table>					
					                                    </div>
						                            </div>
						                        </div>
											</c:forEach>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_6">
											<h4><spring:message code="setupWizardMsg6"/></h4>
											<div class="panel-body" style="text-align: center;">
												<input type="password" name="login_password" placeholder=<spring:message code="password"/> class="form-password form-control" id="form-password">
												<input type="password" name="confirm_password" placeholder=<spring:message code="confirm-password"/> class="form-password form-control" id="confirm-password">
											</div>
										</div>
										
										<div class="tab-pane" id="setupWizardTab_7" style="text-align: center;">
											<h1 style="margin-top: 55px; margin-bottom: 55px;"><b><spring:message code="Done"/> !</b></h1>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					
					<div class="modal-footer">
						<button id="nextSetupWizardModal" type="button" class="btn btn-primary"><spring:message code="Next"/></button>
						<div width="100%" style="text-align: left; float: left;">
							<button id="prevSetupWizardModal" type="button" class="btn btn-primary" disabled><spring:message code="Previous"/></button>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<script>
			//Setup Wizard Modal
			var maxSetupWizardStep = 7;
			
			$(document).ready(function() {
				$("#setupWizardModal").modal("show");
			});
			
			function setupWizardOperation(action) {
				if(action == "Set") {
					$("#setupWizardTab_7").empty();
					$("#setupWizardTab_7").append('<i class="fa fa-circle-o-notch fa-spin fa-5x fa-fw" aria-hidden="true" style="margin-top: 35px; margin-bottom: 35px; background-color: rgba(255, 255, 255, 0); border-color: rgba(255, 255, 255, 0);"></i>');
					$("#stopSetupWizardModal").prop("disabled", true);
					$("#nextSetupWizardModal").prop("disabled", true);
					$("#prevSetupWizardModal").prop("disabled", true);
					$("a[id*=setupWizardTab][id$=link]").attr("disabled", "disabled"); //Disable the click action for IE
					$("a[id*=setupWizardTab][id$=link]").css("pointer-events", "none"); //Disable the click action for all browser
					$("a[id*=setupWizardTab][id$=link]").css("opacity", 0.7);
				}
				
				var password = $("#form-password").val();
				
				//SNMP
				var snmp_enable = $("#check0").is(":checked");
				var snmp_hostIP = $("#localAddress").val();
				var snmp_level  = $("#status").val();
				var snmp_des_enable = [$("#check1").is(":checked"), $("#check2").is(":checked"), $("#check3").is(":checked"), $("#check4").is(":checked")];
				var snmp_des_ip = [$("#check1_addr").val(), $("#check2_addr").val(), $("#check3_addr").val(), $("#check4_addr").val()];
				
				//SMTP
				var smtp_hostIP = $("#smtpHost").val();
				var smtp_Port = $("#smtpPort").val();
				var smtp_Account = $("#smtpAccount").val();
				var smtp_Password = $("#smtpPassword").val();
				var smtp_Addr = $("#smtpAddr").val();
				var smtp_Auth = $("#smtpAuth").is(":checked");
				var smtp_TLS = $("#smtpTLS").is(":checked");
				
				var smtp_des_id = [];
				var smtp_des_enable = [];
				var smtp_des_addr = [];
				var smtp_des_level = [];
				$("td[id^=smtp_des][id$=id]").each(function() {
					smtp_des_id.push($(this).text());
				});
				$("input[id^=smtp_des][id$=enable]").each(function() {
					smtp_des_enable.push($(this).is(":checked"));
				});
				$("input[id^=smtp_des][id$=addr]").each(function() {
					if ($(this).val() == "")
						$(this).val("null");
					smtp_des_addr.push($(this).val());
				});
				$("select[id^=smtp_des][id$=level]").each(function() {
					smtp_des_level.push($(this).val())
				});
				
				//Schedule
				var sche_sp = $("#sche_SP").val();
				var sche_bmc_nq = $("#nodeSliderBar").val();
				var sche_bmc_nup = $("#periodSliderBar").val();
				
				//Checking
				var check_db_usage = $("#limit").val();
				var check_db_keep = $("#DBE").val();
				var check_log_keep = $("#LExp").val();
				var check_logrotate_period = $("#RotationPeriodExpiration").val();
				var check_logrotate_size = $("#rotationSizeSliderBarValue").val();
				
				//IP Range
				//var iprange_interface = $("#CISelect").val(); //Not support the Redfish now
				var iprange_interface = "IPMI";
				var iprange_startIP = [$("#startIP1").val(), $("#startIP2").val(), $("#startIP3").val()];
				var iprange_endIP = [$("#endIP1").val(), $("#endIP2").val(), $("#endIP3").val()];
				/* Brian 2019/10/24: Add bmc username and password */
				var iprange_userName = [$("#UserName1").val(), $("#UserName2").val(), $("#UserName3").val()];
				var iprange_password = [$("#Password1").val(), $("#Password2").val(), $("#Password3").val()];
				var iprange_bmcChecked = [$("#bmcChecked1").is(":checked"), $("#bmcChecked2").is(":checked"), $("#bmcChecked3").is(":checked")];
				var iprange_rmcChecked = [$("#rmcChecked1").is(":checked"), $("#rmcChecked2").is(":checked"), $("#rmcChecked3").is(":checked")];
				var iprange_cmcChecked = [$("#cmcChecked1").is(":checked"), $("#cmcChecked2").is(":checked"), $("#cmcChecked3").is(":checked")];
				var iprange_esxChecked = [$("#esxChecked1").is(":checked"), $("#esxChecked2").is(":checked"), $("#esxChecked3").is(":checked")];
				var iprange_hypervChecked = [$("#hypervChecked1").is(":checked"), $("#hypervChecked2").is(":checked"), $("#hypervChecked3").is(":checked")];
				var iprange_vmUsername = ["", "", ""];
				var iprange_vmPassword = ["", "", ""];
				var iprange_name = [$("#name1").val(), $("#name2").val(), $("#name3").val()];
				for(var i=0 ; i<3 ; i++) {
					//Autofill the empty IP if another is exist
					if(iprange_startIP[i] == "" && iprange_endIP[i] != "")
						iprange_startIP[i] = iprange_endIP[i];
					else if(iprange_startIP[i] != "" && iprange_endIP[i] == "")
						iprange_endIP[i] = iprange_startIP[i];
					
					//VM Account
					if(iprange_esxChecked[i] || iprange_hypervChecked[i]) {
						iprange_vmUsername[i] = $("#ipRange_VM_" + (i+1)).find("[name='VmUsername']").val();
						iprange_vmPassword[i] = $("#ipRange_VM_" + (i+1)).find("[name='VmPassword']").val();
					}
				}
				
				$.ajax({
				    url: 'setupWizardOperation',
				    data: {
				    	action:action,
				    	password:password,
				    	
				    	snmp_enable:snmp_enable,
				    	snmp_hostIP:snmp_hostIP,
				    	snmp_level:snmp_level,
				    	snmp_des_enable:snmp_des_enable.toString(),
				    	snmp_des_ip:snmp_des_ip.toString(),
				    	
				    	smtp_hostIP:smtp_hostIP,
						smtp_Port:smtp_Port,
						smtp_Account:smtp_Account,
						smtp_Password:smtp_Password,
						smtp_Addr:smtp_Addr,
						smtp_Auth:smtp_Auth,
						smtp_TLS:smtp_TLS,
						smtp_des_id:smtp_des_id.toString(),
						smtp_des_enable:smtp_des_enable.toString(),
						smtp_des_addr:smtp_des_addr.toString(),
						smtp_des_level:smtp_des_level.toString(),
						
						sche_sp:sche_sp,
						sche_bmc_nq:sche_bmc_nq,
						sche_bmc_nup:sche_bmc_nup,
						
						check_db_usage:check_db_usage,
						check_db_keep:check_db_keep,
						check_log_keep:check_log_keep,
						check_logrotate_period:check_logrotate_period,
						check_logrotate_size:check_logrotate_size,
						
						iprange_interface:iprange_interface,
						iprange_startIP:iprange_startIP.toString(),
						iprange_endIP:iprange_endIP.toString(),
						/* Brian 2019/10/24: Add bmc username and password */
						iprange_userName:iprange_userName.toString(),
						iprange_password:iprange_password.toString(),
						iprange_bmcChecked:iprange_bmcChecked.toString(),
						iprange_rmcChecked:iprange_rmcChecked.toString(),
						iprange_cmcChecked:iprange_cmcChecked.toString(),
						iprange_esxChecked:iprange_esxChecked.toString(),
						iprange_hypervChecked:iprange_hypervChecked.toString(),
						iprange_vmUsername:iprange_vmUsername.toString(),
						iprange_vmPassword:iprange_vmPassword.toString(),
						iprange_name:iprange_name.toString()
				    },
				    dataType: 'json',
				    success: function(_data, status, xhr) {
				    	$("#setupWizardTab_7").empty();
						$("#setupWizardTab_7").append('<i class="fa fa-check fa-5x alert alert-success" aria-hidden="true" style="margin-top: 20px; background-color: rgba(255, 255, 255, 0); border-color: rgba(255, 255, 255, 0);"></i>');
						setTimeout(closeModal, 200);
				    },
				    error: function(xhr, status, error) {
				    	alert("Setup Wizard Failed...");
				        console.log("Setup Wizard failed: [" + xhr.status + "] " + xhr.statusText);
				    	closeModal();
				    },
				    cache: false
				});
			}
			
			$("#stopSetupWizardModal").on("click", function() {
				if ($("#form-password").val() != "") {
					if ($("#form-password").val() == $("#confirm-password").val()) {
						if(confirm('<spring:message code="setupWizardStop"/>')) {
							setupWizardOperation("Cancel");
						}
					} else {
						alert("The password is different from confirmed-password.");
						$("#setupWizardTab_6_link").trigger('click');
					}
				} else {
					alert("You should set the password of 'admin'.");
					$("#setupWizardTab_6_link").trigger('click');
				}
			});
			
			$("#nextSetupWizardModal").on("click", function() {
				var tabIDArray = $("#setupWizardTab").find("div.active").attr('id').split("_");
				var tabNextNumber = (parseInt(tabIDArray[1]) + 1);
				var tabNextLinkID = tabIDArray[0] + "_" + tabNextNumber + "_link";
				
				if(parseInt(tabIDArray[1]) < maxSetupWizardStep) {
					$("#" + tabNextLinkID).trigger('click');
				}
				else {
					if ($("#form-password").val() != "") {
						if ($("#form-password").val() == $("#confirm-password").val()) {
							setupWizardOperation("Set");
						} else {
							alert("The password is different from confirmed-password.");
							$("#setupWizardTab_6_link").trigger('click');
						}
					} else {
						alert("You should set the password of 'admin'.");
						$("#setupWizardTab_6_link").trigger('click');
					}
				}
			});
			
			$("#prevSetupWizardModal").on("click", function() {
				var tabIDArray = $("#setupWizardTab").find("div.active").attr('id').split("_");
				var tabPrevNumber = (parseInt(tabIDArray[1]) - 1);
				var tabPrevLinkID = tabIDArray[0] + "_" + tabPrevNumber + "_link";
				
				$("#" + tabPrevLinkID).trigger('click');
			});
			
			$("a[id*=setupWizardTab][id$=link]").on("click", function() {
				var idNumber = parseInt($(this).attr("id").split("_")[1]);
				
				if(idNumber <= 0)
					$("#prevSetupWizardModal").prop("disabled", true);
				if(idNumber > 0)
					$("#prevSetupWizardModal").prop("disabled", false);
				if(idNumber >= maxSetupWizardStep)
					//$("#nextSetupWizardModal").prop("disabled", true);
					$("#nextSetupWizardModal").text('<spring:message code="Done"/>');
				if(idNumber < maxSetupWizardStep)
					//$("#nextSetupWizardModal").prop("disabled", false);
					$("#nextSetupWizardModal").text('<spring:message code="Next"/>');
			});
			
			function closeModal() {
				$("#setupWizardModal").modal("hide");
				setTimeout(function(){
					window.location.href = "./MainDashboard";
		    	}, 200);
			}
			
			//Language
			$("#languageOption").on("change", function() {
    			var setLanguage = $(this).val();
    			
    			if(setLanguage == "Auto detect") {
    				var browserLanguage;
    				if(navigator.language != null)
    					browserLanguage = navigator.language.toLowerCase(); //Chrome, Firefox
	    			else if(navigator.browserLanguage != null)
    					browserLanguage = navigator.browserLanguage.toLowerCase(); //IE
    				
    				if((browserLanguage.indexOf("zh") != -1) || (browserLanguage.indexOf("tw") != -1)) //zh-TW
    					setLanguage = "Chinese";
    				else if((browserLanguage.indexOf("en") != -1) || (browserLanguage.indexOf("us") != -1)) //en-US
    					setLanguage = "English";
    				else
    					setLanguage = "Unknown";
    			}
    			
    			if((setLanguage == "Chinese") || (setLanguage == "English") || (setLanguage == "Unknown")) {
    				$.ajax({
	    				url: 'changeSessionLanauage',
	    			    data: {setLanguage: setLanguage},
	    			    dataType: 'json',
	    			    success: function(_data, status, xhr) {
	    			    	if(_data.status == "OK")
	    			    		window.location.href = "./MainDashboard";
	    			    	else
	    			    		alert("Change the language failed: " + _data.status);
	    			    },
	    			    error: function(xhr, status, error) {
	    			        console.log("Change the language failed: [" + xhr.status + "] " + xhr.statusText);
	    			    },
	    			    cache: false
	    			});
    			}
    		});
			
			//SNMP
			$(document).ready(function() {
				var statusArray = [];
				statusArray.push('<x:out select="$item_snmp/enabled" />');
				statusArray.push('<x:out select="$item_snmp/ipv4Enabled1" />');
				statusArray.push('<x:out select="$item_snmp/ipv4Enabled2" />');
				statusArray.push('<x:out select="$item_snmp/ipv4Enabled3" />');
				statusArray.push('<x:out select="$item_snmp/ipv4Enabled4" />');
				
				for(var i=0; i<statusArray.length; i++) {
					if( statusArray[i].localeCompare('true') == 0 ) {
						$("#check" + i).bootstrapSwitch('state', true);
					} else {
						$("#check" + i).bootstrapSwitch('state', false);
					}
				}
				
				var snmpLevel = '<x:out select="$item_snmp/actionLevel" />';
				snmpLevel = parseInt(snmpLevel);
				if((snmpLevel < 1) || (snmpLevel > 3))
					snmpLevel = 3;
				$('#status').val(snmpLevel);
			});
			
			$("input[type=checkbox]").on('switchChange.bootstrapSwitch',function () {
				var id = $(this).attr("id");
				var textID = id + "_addr";
				
				if($("#" + id).is(":checked")) {
					$("input[id=" + textID + "]").prop("disabled", false);
				} else {
					$("input[id=" + textID + "]").prop("disabled", true);
				}
			});
			
			//SMTP
			$(document).ready(function() {
				var isAuth = '<x:out select="$SMTPProp/Auth" />';
				var isTLS = '<x:out select="$SMTPProp/TLS" />';
				
				if (isAuth == "true") {
					$("#smtpAuth").prop("checked", true);
					$("#smtpAccount").prop("disabled", false);
					$("#smtpPassword").prop("disabled", false);
				} else {
					$("#smtpAuth").prop("checked", false);
					$("#smtpAccount").prop("disabled", true);
					$("#smtpPassword").prop("disabled", true);
				}
				
				if (isTLS == "true")
					$("#smtpTLS").prop("checked", true);
				else
					$("#smtpTLS").prop("checked", false);
			});
			
			//Schedule
			$("#nodeSliderBar").slider({
				value: 50,
				min: 50,
				max: 300
			});
			
			$("#periodSliderBar").slider({
				value: 3,
				min: 3,
				max: 10
			});
			
			$("#nodeSliderBar").on("slide", function(slideEvt) {
				var value = $(this).val()*1;
				$("#nodeSliderBar").slider("setValue", value);
				$("input[id=nodeSliderBarValue]").val(slideEvt.value);
				
			});
			
			$("#periodSliderBar").on("slide", function(slideEvt) {
				var value = $(this).val()*1;
				$("#periodSliderBar").slider("setValue", value);
				$("input[id=periodSliderBarValue]").val(slideEvt.value);
				
			});
			
			$("#nodeSliderBarValue").keyup(function() {
				if (/[^0-9\.-]/g.test(this.value)) {
		            this.value = this.value.replace(/[^0-9\.-]/g, '')*1;
		        }
				
				var value = $(this).val()*1;
				if(value < 50) {
					$("#nodeSliderBar").slider("setValue", 50);
				} else if(value > 300) {
					$("#nodeSliderBar").slider("setValue", 300);
				} else {
					$("#nodeSliderBar").slider("setValue", value);
				}
			}).keyup();
			
			$("#periodSliderBarValue").keyup(function() {
				if (/[^0-9\.-]/g.test(this.value)) {
		            this.value = this.value.replace(/[^0-9\.-]/g, '')*1;
		        }
				
				var value = $(this).val()*1;
				if(value < 3) {
					$("#periodSliderBar").slider("setValue", 3);
				} else if(value > 10) {
					$("#periodSliderBar").slider("setValue", 10);
				} else {
					$("#periodSliderBar").slider("setValue", value);
				}
			}).keyup();
			
			//Checking
			$("#limit").slider({
				value: 50,
			    ticks: [0, 10, 90, 100],
			    ticks_positions: [0, 10, 90, 100],
			    ticks_labels: ['', '10%', '90%', ''],
			    ticks_snap_bounds: 0
			});
			
			$("#limit").on("slide", function(slideEvt) {
				var value = $(this).val()*1;
				if(value < 10) {
					$("#limit").slider("setValue", 10);
					$("input[id=limitValue]").val(10);
				} else if(value > 90) {
					$("#limit").slider("setValue", 90);
					$("input[id=limitValue]").val(90);
				} else {
					$("#limit").slider("setValue", value);
					$("input[id=limitValue]").val(slideEvt.value);
				}
			});
			
			$("#limitValue").keyup(function() {
				var value = $(this).val()*1;
				if(value < 10) {
					$("#limit").slider("setValue", 10);
				} else if(value > 90) {
					$("#limit").slider("setValue", 90);
				} else {
					$("#limit").slider("setValue", value);
				}
			}).keyup();
			
			$("#rotationSizeSliderBar").slider({
				value: 100,
				min: 1,
				max: 1024
			});
			
			$("#rotationSizeSliderBar").on("slide", function(slideEvt) {
				var value = $(this).val()*1;
				$("#rotationSizeSliderBar").slider("setValue", value);
				$("input[id=rotationSizeSliderBarValue]").val(slideEvt.value);
				
			});
			
			$("#rotationSizeSliderBarValue").keyup(function() {
				if (/[^0-9\.-]/g.test(this.value)) {
					this.value = this.value.replace(/[^0-9\.-]/g, '')*1;
				}

				var value = $(this).val()*1;
				if (value < 1) {
					$("#rotationSizeSliderBar").slider("setValue", 1);
				}
				else if(value > 1024) {
					$("#rotationSizeSliderBar").slider("setValue", 1024);
				}
				else {
					$("#rotationSizeSliderBar").slider("setValue", value);
				}
			}).keyup();
			
			//IP Range
			var connectionInterface = $("#CISelect").val();
			$("#CISelect").on("change", function() {
        		if($(this).val() == "Redfish")
        			if(!window.confirm('<spring:message code="webAlert1"/>'))
        				$(this).val(connectionInterface);
        		
        		connectionInterface = $("#CISelect").val();
        	});
			
			function authChange(isAuth) {
				if (isAuth) {
					$("#smtpAccount").prop("disabled", false);
					$("#smtpPassword").prop("disabled", false);
				} else {
					$("#smtpAccount").prop("disabled", true);
					$("#smtpPassword").prop("disabled", true);
				}
			}
			
			function changeVM(id) {
				var thisTable = $("#ipRange_"+id);
	        	var checked = thisTable.find("[name='ESX']").is(':checked') || thisTable.find("[name='HyperV']").is(':checked');
				
	        	if(!checked) {
	        		$("#ipRange_VM_" + id).remove();
	        	}
	        	else if($("#ipRange_VM_" + id).length == 0) {
	        		thisTable.append(
	                	"<tr id=\"ipRange_VM_" + id + "\">" +
	               		"<td>VM Username: <input type=\"text\" class=\"form-control\" name=\"VmUsername\" value=\"root\" size=\"15\"/></td>" +
	               		"<td>VM Password: <input type=\"password\" class=\"form-control\" name=\"VmPassword\" value=\"password\" size=\"15\"/></td>" +
	                    "</tr>");
	        	}
	        }
		</script>
	</body>
</html>