<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<title><spring:message code="nav8"/></title>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<!-- CSS -->
		<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
		<style>
			#addDeploymentModal>.modal-dialog, #editDeploymentModal>.modal-dialog {
				margin-top: 5% !important;
				width: 70%;
			}
			#addDeploymentModal>.modal-dialog>.modal-content>.modal-body.option, #editDeploymentModal>.modal-dialog>.modal-content>.modal-body.option {
				border-bottom: 1px solid #e5e5e5;
			}
			table.deploy-detail {
				background-color: transparent !important;
			}
			table.deploy-detail>thead>tr>th {
				padding-top: 0px;
				padding-bottom: 0px;
			}
		</style>
		
		<!-- Javascript -->
		<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
		<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
		<script src="<c:url value="/resources/js/gsm_date.js"/>"></script>
	</head>
	
	<body>
		<div id="wrapper">
			<div id="page-wrapper">
				<div class="container-fluid">
					<br>
					<div class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-heading">
									<button id="addDeployment" type="button" class="btn btn-primary"><spring:message code="Add"/></button>
								</div>
								<div class="panel-body">
									<div class="dataTable_wrapper">
										<table id="deploymentDataTable" class="table table-striped table-bordered table-hover">
											<thead>
												<tr>
													<th width="1%"></th>
													<th><spring:message code="Name"/></th>
													<th><spring:message code="mainMenu12"/></th>
													<th><spring:message code="Status"/></th>
													<th><spring:message code="StartTime"/></th>
													<th><spring:message code="EndTime"/></th>
													<th><spring:message code="Information"/></th>
													<th></th>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
												</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Add Modal -->
		<div class="modal fade" id="addDeploymentModal" tabindex="-1" role="dialog" aria-labelledby="addDeploymentModalLabel">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">&times;</button>
						<h4 class="modal-title" id="addModalLabel"><spring:message code="Add"/> <spring:message code="nav8"/></h4>
					</div>
					
					<div class="modal-body option">
						<div class="container-fluid">
							<div class="row">
								<div class="col-xs-12">
									<div class="form-inline">
										<div class="form-group">
											<label for="deploymentName"><spring:message code="nav8"/> <spring:message code="Name"/>: </label>
											<input type="text" class="form-control" id="deploymentName" placeholder="New Deployment">
										</div>
									</div>
								</div>
							</div>
							<div class="row">
								<br>
								<div class="col-xs-4">
									<select name="classifySelect" class="form-control"><option>No classify</option></select>
								</div>
								<div class="col-xs-4">
									<select name="itemSelect" class="form-control"><option>No item</option></select>
								</div>
								<div class="col-xs-4">
									<select name="actionSelect" class="form-control"><option>No action</option></select>
								</div>
							</div>
						</div>
					</div>
					
					<div class="modal-body nodelist">
						<div class="container-fluid">
							<table id="nodeDataTable" class="table table-striped table-bordered table-hover">
								<thead>
									<tr>
										<th><input name="selectAllNodes" type="checkbox"></th>
										<th><spring:message code="Nodelist3"/></th>
										<th><spring:message code="Nodelist2"/></th>
										<th><spring:message code="Nodelist5"/></th>
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
					</div>
					
					<div class="modal-footer">
						<button id="submitNewDeployment" type="button" class="btn btn-primary"><spring:message code="Submit"/></button>
						<button id="resetDeployment" type="button" class="btn btn-primary"><spring:message code="Reset"/></button>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Edit Modal -->
		<div class="modal fade" id="editDeploymentModal" tabindex="-1" role="dialog" aria-labelledby="editDeploymentModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title" id="editModalLabel"><spring:message code="Edit"/> <spring:message code="nav8"/></h4>
                    </div>
                    
                    <div class="modal-body option">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-xs-12">
                                    <div class="form-inline">
                                        <div class="form-group" style="display:none;">
                                            <label for="databaseID"><spring:message code="nav8"/> <spring:message code="Database"/> ID: </label>
                                            <input type="text" class="form-control" id="databaseID" placeholder="Database ID">
                                        </div>
                                        <div class="form-group">
                                            <label for="deploymentNameEdit"><spring:message code="nav8"/> <spring:message code="Name"/>: </label>
                                            <input type="text" class="form-control" id="deploymentNameEdit" placeholder="New Deployment">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <br>
                                <div class="col-xs-4">
                                    <select name="classifySelect" class="form-control"><option>No classify</option></select>
                                </div>
                                <div class="col-xs-4">
                                    <select name="itemSelect" class="form-control"><option>No item</option></select>
                                </div>
                                <div class="col-xs-4">
                                    <select name="actionSelect" class="form-control"><option>No action</option></select>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal-body nodelist">
                        <div class="container-fluid">
                            <table id="memberDataTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th><input name="selectAllNodes" type="checkbox"></th>
                                        <th><spring:message code="Nodelist3"/></th>
                                        <th><spring:message code="Nodelist2"/></th>
                                        <th><spring:message code="Nodelist5"/></th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="modal-footer">
                        <button id="submitUpdateDeployment" type="button" class="btn btn-primary"><spring:message code="Submit"/></button>
                        <button id="deleteDeployment" type="button" class="btn btn-danger"><spring:message code="Delete"/></button>
                    </div>
                </div>
            </div>
        </div>
		
		<script>
			var DeploymentListStatusPeriod = 5; //Get status every 5 seconds
			var deploymentDataTable;
			var nodeDataTable;
			var memberDataTable;
			var deploymentDataMap = {}; //Deployment database ID mapped to its data
			var deploymentOptionObj = {
				"Remote Access": {
					"Power Control"   : {"Power on": 1, "Power off": 0, "Cycle": 2, "Reset": 3}, 
					"Chassis Identify": {}, //0~255
					"Boot Option"     : {"PXE": "pxe", "DISK": "disk", "CDROM": "cdrom", "BIOS": "bios"}, 
					"Reboot BMC"      : {"Reboot": "reboot"}
				}, 
				"Network": {
					"IPv4": {"DHCP": "dhcp"}, 
					"IPv6": {"DHCP": "dhcp"}
				}, 
				"Event Log": {
					"SEL": {"Clear": "clear"}
				}, 
				"Alert Management": {
					"Trap": {"Set": "set"}, 
					// "PEF" : {"Set": "set"}
				}, 
				"Power Consumption": {
					"Power Limit": {"Set": "set"}
				}
			};
			var addDeploymentMember = {};
			var editDeploymentMember = {};
			
			for(var i=0 ; i<=255 ; i++) deploymentOptionObj["Remote Access"]["Chassis Identify"][i] = i;
			
			$(document).ready(function() {
				deploymentDataTable = $('#deploymentDataTable').DataTable({
					"aaSorting": [[ 1, "asc" ]],
					"pagingType": "full_numbers",
					"responsive": true,
					"stateSave":  true,
				    "createdRow": function(row, data, dataIndex) {
				    	$(row).find('td:eq(0)').attr("database-id", data[0]);
				    	$(row).find('td:eq(0)').empty();
				    	$(row).find('td:eq(0)').addClass("details-control fa fa-plus-circle");
				    },
					language: {
						"emptyTable": <spring:message code="DataTable1"/>,
						"processing": <spring:message code="DataTable2"/>,
						"loadingRecords": <spring:message code="DataTable3"/>,
						"lengthMenu": <spring:message code="DataTable4"/>,
						"zeroRecords": <spring:message code="DataTable5"/>,
						"info": <spring:message code="DataTable6"/>,
						"infoEmpty": <spring:message code="DataTable7"/>,
						"infoFiltered": <spring:message code="DataTable8"/>,
						"infoPostFix": <spring:message code="DataTable9"/>,
						"search": <spring:message code="DataTable10"/>,
						"paginate": {
							"first": <spring:message code="DataTable11"/>,
							"previous": <spring:message code="DataTable12"/>,
							"next": <spring:message code="DataTable13"/>,
							"last": <spring:message code="DataTable14"/>
						},
						"aria": {
							"sortAscending": <spring:message code="DataTable15"/>,
							"sortDescending": <spring:message code="DataTable16"/>
						}
					}
				});
				
				nodeDataTable = $('#nodeDataTable').DataTable({
					"aaSorting": [[ 1, "asc" ]],
					"aoColumns": [{ "bSortable": false },
					              { "bSortable": true },
					              { "bSortable": true },
					              { "bSortable": true }],
					"pagingType": "full_numbers",
					"responsive": true,
					language: {
						"emptyTable": <spring:message code="DataTable1"/>,
						"processing": <spring:message code="DataTable2"/>,
						"loadingRecords": <spring:message code="DataTable3"/>,
						"lengthMenu": <spring:message code="DataTable4"/>,
						"zeroRecords": <spring:message code="DataTable5"/>,
						"info": <spring:message code="DataTable6"/>,
						"infoEmpty": <spring:message code="DataTable7"/>,
						"infoFiltered": <spring:message code="DataTable8"/>,
						"infoPostFix": <spring:message code="DataTable9"/>,
						"search": <spring:message code="DataTable10"/>,
						"paginate": {
							"first": <spring:message code="DataTable11"/>,
							"previous": <spring:message code="DataTable12"/>,
							"next": <spring:message code="DataTable13"/>,
							"last": <spring:message code="DataTable14"/>
						},
						"aria": {
							"sortAscending": <spring:message code="DataTable15"/>,
							"sortDescending": <spring:message code="DataTable16"/>
						}
					}
				});
				
				memberDataTable = $('#memberDataTable').DataTable({
					"aaSorting": [[ 1, "asc" ]],
					"aoColumns": [{ "bSortable": false },
					              { "bSortable": true },
					              { "bSortable": true },
					              { "bSortable": true }],
					"pagingType": "full_numbers",
					"responsive": true,
					language: {
						"emptyTable": <spring:message code="DataTable1"/>,
						"processing": <spring:message code="DataTable2"/>,
						"loadingRecords": <spring:message code="DataTable3"/>,
						"lengthMenu": <spring:message code="DataTable4"/>,
						"zeroRecords": <spring:message code="DataTable5"/>,
						"info": <spring:message code="DataTable6"/>,
						"infoEmpty": <spring:message code="DataTable7"/>,
						"infoFiltered": <spring:message code="DataTable8"/>,
						"infoPostFix": <spring:message code="DataTable9"/>,
						"search": <spring:message code="DataTable10"/>,
						"paginate": {
							"first": <spring:message code="DataTable11"/>,
							"previous": <spring:message code="DataTable12"/>,
							"next": <spring:message code="DataTable13"/>,
							"last": <spring:message code="DataTable14"/>
						},
						"aria": {
							"sortAscending": <spring:message code="DataTable15"/>,
							"sortDescending": <spring:message code="DataTable16"/>
						}
					}
				});
				
				getDeploymentList();
				getNodeList(true);
				
				initDeploymentSelect("#addDeploymentModal", deploymentOptionObj, "classifySelect");
			});
			
		    /* Button functions of Add/Run/Edit deployment */
		    $("#addDeployment").on("click", function() {
			    $('#addDeploymentModal').modal("show");
		    });
		    $('#deploymentDataTable>tbody').delegate("button[name=editDeployment]", "click", function() {
		    	var deployData = deploymentDataMap[$(this).parent().parent().find("td:eq(0)").attr("database-id")];
		    	
		    	//Basic option
		    	var optionField = $("#editDeploymentModal>.modal-dialog>.modal-content>.modal-body.option");
		    	optionField.find("input[id='databaseID']").val(deployData["_id"]["$oid"]);
		    	optionField.find("input[id^='deploymentName']").val(deployData.Name);
		    	
		    	initDeploymentSelect("#editDeploymentModal", deploymentOptionObj, "classifySelect");
		    	optionField.find("select[name='classifySelect']").val(deployData.Operation.Classify).change();
		    	optionField.find("select[name='itemSelect']").val(deployData.Operation.Item).change();
		    	optionField.find("select[name='actionSelect']").val(deployData.Operation.ActionValue).change();
		    	
		    	//Addition option - Trap
		    	if(deployData.Operation.Item == "Trap") {
		    		optionField = $("#editDeploymentModal>.modal-dialog>.modal-content>.modal-body.option>.container-fluid>.row:eq(2)");
		    		for(var i=0 ; i<deployData.Operation.TrapList.length ; i++) {
		    			var id = i + 1;
		    			if(i > 0) {
		    				optionField.find("tbody").append(createTrapInputTr(id, true));
		    			}
		    			optionField.find("tbody>tr:eq(" + i + ") select[name='id_" + id + "']").val(deployData.Operation.TrapList[i].ID);
		    			optionField.find("tbody>tr:eq(" + i + ") input[name='enable_" + id + "']").prop("checked", deployData.Operation.TrapList[i].Enable);
		    			optionField.find("tbody>tr:eq(" + i + ") input[name='ipType_" + id + "'][value='" + deployData.Operation.TrapList[i].IpType + "']").prop("checked", true);
		    			optionField.find("tbody>tr:eq(" + i + ") input[name='ipAddress_" + id + "']").val(deployData.Operation.TrapList[i].IP);
		    		}
		    	}
				//Addition option - PEF
		    	/*else if(deployData.Operation.Item == "PEF") {
		    		optionField = $("#editDeploymentModal>.modal-dialog>.modal-content>.modal-body.option>.container-fluid>.row:eq(2)");
		    		optionField.find("input[name^='global_action_']").each(function() {
		    			if((deployData.Operation.PEF.GlobalAction & parseInt($(this).val())) == parseInt($(this).val())) {
		    				$(this).prop("checked", true);
		    			}
		    			else {
		    				$(this).prop("checked", false);
		    			}
		    		});
		    		optionField.find("input[name='global_alert']").prop("checked", deployData.Operation.PEF.GlobalAlert);
		    		optionField.find("input[name='action_0'][value='" + (deployData.Operation.PEF.FilterAction[0] & 14) + "']").prop("checked", true); //(action & 1110) to remove 1b value, 1:PEF, 2:Power off, 4:Reboot, 8:Power cycle
		    		optionField.find("input[name='pet_0']").prop("checked", ((deployData.Operation.PEF.FilterAction[0] & 1) ? true : false));
		    	}*/
				//Addition option - Power Limit
		    	else if(deployData.Operation.Item == "Power Limit") {
		    		optionField = $("#editDeploymentModal>.modal-dialog>.modal-content>.modal-body.option>.container-fluid>.row:eq(2)");
		    		optionField.find("input[name='enable']").prop("checked", deployData.Operation.PowerLimit.PowerLimitEnable);
		    		optionField.find("input[name='powerLimit']").val(deployData.Operation.PowerLimit.PowerLimitValue);
		    		optionField.find("input[name='samplingPeriod']").val(deployData.Operation.PowerLimit.PowerLimitPeriod);
		    		optionField.find("input[name='correctionTimeLimit']").val(deployData.Operation.PowerLimit.PowerLimitCorrectTime);
		    		optionField.find("select[name='exceptionAction']").val(deployData.Operation.PowerLimit.PowerLimitException);
		    	}
		    	
		    	//Member list
		    	$("#editDeploymentModal div.modal-body.nodelist input[name='selectAllNodes']").prop('checked', false).change();
		    	if(deployData.MemberList.length == memberDataTable.rows().data().length) {
		    		$("#editDeploymentModal div.modal-body.nodelist input[name='selectAllNodes']").prop('checked', true).change();
		    	}
		    	else {
					$("td:eq(1)", memberDataTable.rows().nodes()).filter(function() {
						return deployData.MemberList.includes($(this).text());
					}).each(function() {
						$(this).parent().find("input[type='checkbox']").prop("checked", true);
						editDeploymentMember[$(this).text()] = "";
					});
		    	}
		    	
			    $('#editDeploymentModal').modal("show");
		    });
		    $('#deploymentDataTable>tbody').delegate("button[name=runDeployment]", "click", function() {
		    	$.ajax({
			        url: 'setDeployment',
			        type: 'POST',
			        data: {action:"run", databaseID:$(this).parents().eq(1).find("td:eq(0)").attr("database-id")},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	if(_data.status) {
			        		location.reload();
			        	}
			        	else {
			        		alert(_data.statusMsg);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	console.log("Run the deployment failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
		    });
		    /* Button functions of Add/Run/Edit deployment */
			
		    /* Button functions of show deployment detail */
		    $('#deploymentDataTable>tbody').delegate('tr>td.details-control', 'click', function() {
		    	var row = deploymentDataTable.row($(this).closest('tr'));
		    	if(row.child.isShown()) {
		    	    row.child.hide();
		    	    $(this).removeClass('fa fa-minus-circle');
		    	    $(this).addClass('fa fa-plus-circle');
		    	}
		    	else {
		    	    row.child(showDeployDetail(row.data()[0])).show();
		    	    $(this).removeClass('fa fa-plus-circle');
		    	    $(this).addClass('fa fa-minus-circle');
		    	}
		    });
		    /* Button functions of show deployment detail */
			
		    /* Button functions of submit new/update deployment */
		    $("#submitNewDeployment, #submitUpdateDeployment, #deleteDeployment").on("click", function() {
		    	var data;
		    	var action;
		    	
		    	if($(this).attr("id") == "submitNewDeployment") {
		    		var jsonData = getDeploymentJsonData("addDeploymentModal");
		    		if(jsonData.error != null) {
		    			alert(jsonData.error);
		    			return;
		    		}
		    		else {
		    			jsonData = JSON.stringify(jsonData);
		    			if((jsonData == null) || (jsonData == "null")) {
		    				alert("Something wrong... the input data is empty");
		    				return;
		    			}
		    		}
		    		
		    		action = "Add";
		    		data = {action:"add", json:jsonData};
		    	}
		    	else if($(this).attr("id") == "submitUpdateDeployment") {
		    		var jsonData = getDeploymentJsonData("editDeploymentModal");
		    		if(jsonData.error != null) {
		    			alert(jsonData.error);
		    			return;
		    		}
		    		else {
		    			jsonData = JSON.stringify(jsonData);
		    			if((jsonData == null) || (jsonData == "null")) {
		    				alert("Something wrong... the input data is empty");
		    				return;
		    			}
		    		}
		    		
		    		action = "Edit";
		    		data = {action:"edit", json:jsonData};
		    	}
		    	else if($(this).attr("id") == "deleteDeployment") {
		    		if(!confirm('<spring:message code="webAlert7"/>')) {
		    			return;
		    		}
		    		action = "Delete";
		    		data = {action:"delete", databaseID:$("#editDeploymentModal input[id='databaseID']").val()};
		    		if((data.databaseID == null) || (data.databaseID == "null")) {
		    			alert("Something wrong... the input data is empty");
		    			return;
		    		}
		    	}
		    	else {
		    		alert("Something wrong... submit button type is unrecognized");
		    		return;
		    	}
		    	
		    	$.ajax({
			        url: 'setDeployment',
			        type: 'POST',
			        data: data,
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	if(_data.status) {
			        		location.reload();
			        	}
			        	else {
			        		alert(_data.statusMsg);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	console.log(action + " the deployment failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
		    });
		    /* Button functions of submit new deployment */
		    
		    /* Button functions of reset input data */
		    $("#resetDeployment").on("click", function() {
		    	$("#addDeploymentModal input[id='deploymentName']").val("");
		    	initDeploymentSelect("#addDeploymentModal", deploymentOptionObj, "classifySelect");
				
				$("#addDeploymentModal input[name='selectAllNodes']").prop('checked', false).change();
		    });
		    /* Button functions of reset input data */
		    
		    /* Select functions of basic option */
		    $("div.modal div.modal-body.option select[name$='Select']").on("change", function() {
		    	var selectName = $(this).attr("name");
		    	var modalID = $(this).parents().eq(6).attr("id");
		    	
		    	if(selectName == "classifySelect") {
		    		initDeploymentSelect("#" + modalID, deploymentOptionObj[$(this).val()], "itemSelect");
		    	}
		    	else if(selectName == "itemSelect") {
		    		initDeploymentSelect("#" + modalID, deploymentOptionObj[$("#" + modalID).find("select[name='classifySelect']").val()][$(this).val()], "actionSelect");
		    	}
		    });
		    /* Select functions of basic option */
		    
		    /* Checkbox functions of select all nodes */
		    $("div.modal div.modal-body.nodelist input[name='selectAllNodes']").on("change", function() {
		    	var checked = $(this).prop("checked");
		    	var nodelistID = $(this).parents().eq(3).attr("id");
				
		    	if(nodelistID == "nodeDataTable") {
		    		$("input[type='checkbox']", nodeDataTable.rows().nodes()).prop("checked", checked); //Check/Uncheck all member
			    	if(checked) {
				    	var memberList = nodeDataTable.rows().data();
				    	for(var i=0 ; i<memberList.length ; i++) { //Add all member
				    		addDeploymentMember[memberList[i][1]] = "";
				    	}
			    	}
			    	else {
			    		addDeploymentMember = {}; //Remove all member
			    	}
		    	}
		    	else if(nodelistID == "memberDataTable") {
		    		$("input[type='checkbox']", memberDataTable.rows().nodes()).prop("checked", checked); //Check/Uncheck all member
			    	if(checked) {
				    	var memberList = memberDataTable.rows().data();
				    	for(var i=0 ; i<memberList.length ; i++) { //Add all member
				    		editDeploymentMember[memberList[i][1]] = "";
				    	}
			    	}
			    	else {
			    		editDeploymentMember = {}; //Remove all member
			    	}
		    	}
		    });
		    $("div.modal div.modal-body.nodelist>div>table>tbody").delegate("tr>td>input[type='checkbox']", "change", function() {
		    	var checked = $(this).prop("checked");
		    	var nodelistID = $(this).parents().eq(3).attr("id");
	    		var ip = $(this).parents().eq(1).find("td:eq(1)").text();
		    	
		    	if(nodelistID == "nodeDataTable") {
		    		if(checked) {
			    		addDeploymentMember[ip] = ""; //Add member
			    		if(Object.keys(addDeploymentMember).length == nodeDataTable.rows().data().length) { //Check the "Select All checkbox" if all member are checked
				    		$("#" + nodelistID + " input[type='checkbox'][name='selectAllNodes']").prop('checked', true);
			    		}
			    	}
			    	else {
			    		delete addDeploymentMember[ip]; //Remove member
			    		$("#" + nodelistID + " input[type='checkbox'][name='selectAllNodes']").prop('checked', false); //Uncheck the "Select All checkbox"
			    	}
		    	}
		    	else if(nodelistID == "memberDataTable") {
		    		if(checked) {
		    			editDeploymentMember[ip] = ""; //Add member
			    		if(Object.keys(editDeploymentMember).length == memberDataTable.rows().data().length) { //Check the "Select All checkbox" if all member are checked
			    			$("#" + nodelistID + " input[type='checkbox'][name='selectAllNodes']").prop('checked', true);
			    		}
			    	}
			    	else {
			    		delete editDeploymentMember[ip]; //Remove member
			    		$("#" + nodelistID + " input[type='checkbox'][name='selectAllNodes']").prop('checked', false); //Uncheck the "Select All checkbox"
			    	}
		    	}
		    });
		    /* Checkbox functions of select all nodes */
		    
		    /* Button functions of create the Trap input field */
		    $("#addDeploymentModal div.modal-body.option>.container-fluid, #editDeploymentModal div.modal-body.option>.container-fluid").delegate(".row:eq(2) a[name=add]", "click", function() {
		    	var modalID = $(this).parents().eq(7).attr("id");
		    	var lastID = $("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2) tbody>tr:last-child>td>select").attr("name");
		    	if((lastID.indexOf("_") > 0) && (lastID.split("_").length == 2)) {
		    		lastID = lastID.split("_")[1];
		    	}
		    	else {
		    		lastID = $("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2) tbody>tr").length;
		    	}
		    	
		    	if($("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2) tbody>tr").length < 8) {
		    		$("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2) tbody").append(createTrapInputTr((parseInt(lastID) + 1), true));
		    	}
		    });
		    $("#addDeploymentModal div.modal-body.option>.container-fluid, #editDeploymentModal div.modal-body.option>.container-fluid").delegate(".row:eq(2) a[name=remove]", "click", function() {
		    	$(this).parent().parent().remove();
		    });
		    /* Button functions of create the Trap input field */
		    
		    function initDeploymentSelect(modalID, optionObj, targetName)
		    {
		    	var optionArray = Object.keys(optionObj);
		    	if(optionArray.length > 0) {
		    		//Add basic option list into target select
		    		var optionHtmlString = "";
					for(var i=0 ; i<optionArray.length ; i++) {
						if(targetName == "actionSelect") {
							optionHtmlString += "<option value=\"" + optionObj[optionArray[i]] + "\">" + optionArray[i] + "</option>";
						}
						else {
							optionHtmlString += "<option value=\"" + optionArray[i] + "\">" + optionArray[i] + "</option>";
						}
					}
					$(modalID).find("select[name='" + targetName + "']").html(optionHtmlString);
					
					//Parse the basic option of next level
					if(targetName == "classifySelect") {
						initDeploymentSelect(modalID, deploymentOptionObj[optionArray[0]], "itemSelect");
					}
					else if(targetName == "itemSelect") {
						initDeploymentSelect(modalID, deploymentOptionObj[$(modalID).find("select[name='classifySelect']").val()][optionArray[0]], "actionSelect");
					}
					
					//Add text field for addition option - Trap / PEF / Power Limit
					else if(targetName == "actionSelect") {
						$(modalID).find("div.modal-body.option>.container-fluid>.row:eq(2)").remove();
						
						var itemSelect = $(modalID).find("select[name='itemSelect']").val();
						if(itemSelect == "Trap") {
							$(modalID).find("div.modal-body.option>.container-fluid").append(createTrapInputTable());
						}
						/*else if(itemSelect == "PEF") {
							$(modalID).find("div.modal-body.option>.container-fluid").append(createPefInputTable());
						}*/
						else if(itemSelect == "Power Limit") {
							$(modalID).find("div.modal-body.option>.container-fluid").append(createPowerLimitInputTable());
						}
					}
				}
				else {
					if(targetName == "classifySelect") {
						$(modalID).find("select[name='classifySelect']").html("<option>No classify</option>");
						$(modalID).find("select[name='itemSelect']").html("<option>No item</option>");
						$(modalID).find("select[name='actionSelect']").html("<option>No action</option>");
					}
					else if(targetName == "itemSelect") {
						$(modalID).find("select[name='itemSelect']").html("<option>No item</option>");
						$(modalID).find("select[name='actionSelect']").html("<option>No action</option>");
					}
					else if(targetName == "actionSelect") {
						$(modalID).find("select[name='actionSelect']").html("<option>No action</option>");
					}
				}
		    }
		    
		    function createTrapInputTable()
		    {
		    	var textHtmlString = '<div class="row">'
								   + '<br>'
								   + '<div class="col-lg-12">'
								   + '<table class="table table-striped table-bordered table-hover">'
								   + '<thead>'
								   + '<tr>'
								   + '<th><spring:message code="GSMSNMP2"/></th>'
								   + '<th><spring:message code="NodeSetting5"/></th>'
								   + '<th>IPv4 / IPv6</th>'
								   + '<th><spring:message code="NodeNetwork5"/></th>'
								   + '<th></th>'
								   + '</tr>'
								   + '</thead>'
								   + '<tbody>'
								   + createTrapInputTr(1)
								   + '</tbody>'
								   + '</table>'
								   + '<div style="text-align: left;">'
								   + '<a name="add" href="javascript:"><i class="fa fa-plus-circle fa-2x"></i></a>'
								   + '</div>'
								   + '</div>'
								   + '</div>';
				
				return textHtmlString;
		    }
		    
		    function createTrapInputTr(id, removeButton)
		    {
		    	var textHtmlString = '<tr>'
								   + '<td><select name="id_' + id + '" class="form-control input-sm">';
				for(var i=1 ; i<=8 ; i++) {
					textHtmlString += '<option value="' + i + '">' + i + '</option>';
				}
				textHtmlString    += '</select></td>'
								   + '<td><label class="checkbox-inline"><input type="checkbox" name="enable_' + id + '" checked></label></td>'
								   + '<td><label class="radio-inline"><input type="radio" name="ipType_' + id + '" value="IPv4" checked>IPv4</label><label class="radio-inline"><input type="radio" name="ipType_' + id + '" value="IPv6">IPv6</label></td>'
								   + '<td><input class="form-control input-sm" type="text" name="ipAddress_' + id + '" value=""></td>'
								   + '<td>' + (removeButton ? '<a name="remove" href="javascript:"><i class="fa fa-minus-circle fa-2x"></i></a>' : '') + '</td>'
								   + '</tr>';
				
				return textHtmlString;
		    }
		    
		    /*function createPefInputTable()
		    {
		    	var textHtmlString = '<div class="row">'
								   + '<br>'
								   + '<div class="col-lg-12">'
								   + '<table class="table table-striped table-bordered table-hover">'
								   + '<h4><spring:message code="NodePEF1"/></h4>'
								   + '<thead>'
								   + '<tr><th><spring:message code="NodePEF4"/></th></tr>'
								   + '</thead>'
								   + '<tbody>'
								   + '<tr><td><input type="checkbox" name="global_action_0" value="4" checked> <spring:message code="NodePEF7"/></td></tr>'
								   + '<tr><td><input type="checkbox" name="global_action_1" value="8" checked> <spring:message code="NodePEF8"/></td></tr>'
								   + '<tr><td><input type="checkbox" name="global_action_2" value="2" checked> <spring:message code="NodePEF9"/></td></tr>'
								   + '<tr><td><input type="checkbox" name="global_action_3" value="1" checked> <spring:message code="NodePEF10"/></td></tr>'
								   + '</tbody>'
								   + '</table>'
								   + '<table class="table table-striped table-bordered table-hover">'
								   + '<h4><spring:message code="NodePEF12"/></h4>'
								   + '<input type="checkbox" name="global_alert" checked> <spring:message code="NodePEF3"/><br>'
								   + '<thead>'
								   + '<tr>'
								   + '<th><spring:message code="NodePEF5"/></th>'
								   + '<th><spring:message code="NodePEF6"/></th>'
								   + '<th><spring:message code="NodePEF7"/></th>'
								   + '<th><spring:message code="NodePEF8"/></th>'
								   + '<th><spring:message code="NodePEF9"/></th>'
								   + '<th><spring:message code="NodePEF10"/></th>'
								   + '</tr>'
								   + '</thead>'
								   + '<tbody>'
								   + '<tr>'
								   + '<td>All Type, All Filter</td>'
								   + '<td><label class="radio-inline"><input type="radio" name="action_0" value="0" checked>None</label></td>'
								   + '<td><label class="radio-inline"><input type="radio" name="action_0" value="4">Reboot</label></td>'
								   + '<td><label class="radio-inline"><input type="radio" name="action_0" value="8">Power Cycle</label></td>'
								   + '<td><label class="radio-inline"><input type="radio" name="action_0" value="2">Power Off</label></td>'
								   + '<td><label class="checkbox-inline"><input type="checkbox" name="pet_0" checked></label></td>'
								   + '</tr>'
								   + '</tbody>'
								   + '</table>'
								   + '</div>'
								   + '</div>';
				
				return textHtmlString;
		    }*/
		    
		    function createPowerLimitInputTable()
		    {
		    	var textHtmlString = '<div class="row">'
								   + '<br>'
								   + '<div class="col-lg-12">'
								   + '<table class="table table-striped table-bordered table-hover">'
								   + '<tbody>'
								   + '<tr>'
								   + '<td><spring:message code="NodePower2"/></td>'
								   + '<td><input type="checkbox" name="enable" checked></td>'
								   + '</tr>'
								   + '<tr>'
								   + '<td><spring:message code="NodePower3"/> (1~32767)</td>'
								   + '<td><input type="text" name="powerLimit" maxlength="5"> <spring:message code="Watts"/></td>'
								   + '</tr>'
								   + '<tr>'
								   + '<td><spring:message code="NodePower8"/> (1~3600)</td>'
								   + '<td><input type="text" name="samplingPeriod" maxlength="4"> <spring:message code="Seconds"/></td>'
								   + '</tr>'
								   + '<tr>'
								   + '<td><spring:message code="NodePower9"/> (6000~600000)</td>'
								   + '<td><input type="text" name="correctionTimeLimit" maxlength="6"> <spring:message code="Milliseconds"/></td>'
								   + '</tr>'
								   + '<tr>'
								   + '<td><spring:message code="NodePower10"/></td>'
								   + '<td><select name="exceptionAction">'
								   + '<option value="0"><spring:message code="NodePower11"/></option>'
								   + '<option value="1"><spring:message code="NodePower12"/></option>'
								   + '<option value="17"><spring:message code="NodePower13"/></option>'
								   + '</select></td>'
								   + '</tr>'
								   + '</tbody>'
								   + '</table>'
								   + '</div>'
								   + '</div>';
				
				return textHtmlString;
		    }
		    
			function getDeploymentList()
			{
				deploymentListLoading(true);
				var isAllDone = true;
				
				$.ajax({
			        url: 'getDeploymentList',
			        data: {},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	_data.deployList = JSON.parse(_data.deployList);
			        	
		        		var deployArray = [];
			        	for(var i=0 ; i<_data.deployList.length ; i++) {
			        		deployArray.push([_data.deployList[i]["_id"]["$oid"],
			    		        			_data.deployList[i].Name,
			    		        			(_data.deployList[i].Status.isStart ? (_data.deployList[i].Status.isComplete ? "Completed" : "Running") : "-"),
			    		        			(_data.deployList[i].Status.isComplete ? (_data.deployList[i].Status.isSuccess ? "Success" : "Fail") : "-"),
			    		        			(_data.deployList[i].Status.isStart ? formatDate(new Date(_data.deployList[i].Status.StartTime["$date"]), _data.timestampFormat) : "-"), 
											(_data.deployList[i].Status.isComplete ? formatDate(new Date(_data.deployList[i].Status.EndTime["$date"]), _data.timestampFormat) : "-"), 
											_data.deployList[i].Status.statusMsg,
			    		        			'<button name="runDeployment" type="button" class="btn btn-primary"' + (_data.deployList[i].Status.isStart && !_data.deployList[i].Status.isComplete ? " disabled" : "") + '><spring:message code="Run"/></button>  <button name="editDeployment" type="button" class="btn btn-primary" ' + (_data.deployList[i].Status.isStart && !_data.deployList[i].Status.isComplete ? " disabled" : "") + '><spring:message code="Edit"/></button>']);
			        		
			        		if(_data.deployList[i].Status.isStart && !_data.deployList[i].Status.isComplete)
								isAllDone = false;
			        		
			        		//Mapper data for show the member node of each deployment info
			        		deploymentDataMap[_data.deployList[i]["_id"]["$oid"]] = _data.deployList[i];
			        	}
			        	
			        	deploymentListLoading(false, deployArray);
			        },
			        error: function(xhr, status, error) {
			        	deploymentListLoading(false);
			        	console.log("Get the deployment list failed: [" + xhr.status + "] " + xhr.statusText);
			        },
			        complete: function() {
						if(!isAllDone)
							setTimeout(getDeploymentList, (DeploymentListStatusPeriod * 1000));
					},
				    cache: false
			    });
			}
		    
			var nodelistIndex = 0;
			var nodelistLength = 25;
			function getNodeList(first)
			{
				if(first) {
					nodeListLoading(true);
					memberListLoading(true);
				}
				
				$.ajax({
			        url: 'getNodeList',
			        data: {dataIndex:nodelistIndex, dataLength:nodelistLength, dataType:'node'},
			        dataType: 'json',
			        success: function(_data, status, xhr) {
			        	if(_data.length > 0) {
			        		var nodeArray = [];
			        		for(var i=0 ; i<_data.length ; i++) {
				        		nodeArray.push(['<input type="checkbox">',
				    		        			_data[i].ip,
				    		        			_data[i].mac,
				    		        			_data[i].nodeType.replace("SMC", "BMC")]);
				        	}
				        	nodeListLoading(false, nodeArray);
				        	memberListLoading(false, nodeArray);
				        	
			        		nodelistIndex += nodelistLength;
			        		setTimeout(getNodeList, 50);
			        	}
			        	else {
			        		nodeListLoading(false);
			        		memberListLoading(false);
			        	}
			        },
			        error: function(xhr, status, error) {
			        	nodeListLoading(false);
		        		memberListLoading(false);
			        	console.log("Get the node list failed: [" + xhr.status + "] " + xhr.statusText);
			        },
				    cache: false
			    });
			}
			
			function showDeployDetail(id)
			{
				var deployData = deploymentDataMap[id];
				var htmlString = '';
				
				//Operation
				htmlString += '<table class="table table-hover deploy-detail" style="margin-bottom: 0px;">';
				htmlString += '<thead>';
				htmlString += '<th class="col-xs-4">Operation</th><th class="col-xs-4"></th><th class="col-xs-4"></th>';
				htmlString += '</thead>';
				htmlString += '<tbody>';
				//Basic option
				htmlString += '<tr><td>' + deployData.Operation.Classify + '</td><td>' + deployData.Operation.Item + '</td><td>' + deployData.Operation.Action + '</td></tr>';
				//Addition option - Trap
				if(deployData.Operation.Item == "Trap") {
					htmlString += '<table class="table table-hover deploy-detail" style="margin-bottom: 0px;">';
					htmlString += '<thead>';
					htmlString += '<th class="col-xs-3"><spring:message code="GSMSNMP2"/></th>';
					htmlString += '<th class="col-xs-3"><spring:message code="NodeSetting5"/></th>';
					htmlString += '<th class="col-xs-3">IP <spring:message code="Type"/></th>';
					htmlString += '<th class="col-xs-3"><spring:message code="NodeNetwork5"/></th>';
					htmlString += '</thead>';
					htmlString += '<tbody>';
					if(deployData.Operation.TrapList.length > 0) {
						for(var i=0 ; i<deployData.Operation.TrapList.length ; i++) {
							htmlString += '<tr><td>' + deployData.Operation.TrapList[i].ID +'</td>';
							htmlString += '<td>' + (deployData.Operation.TrapList[i].Enable ? "Enable" : "Disable") + '</td>';
							htmlString += '<td>' + deployData.Operation.TrapList[i].IpType + '</td>';
							htmlString += '<td>' + deployData.Operation.TrapList[i].IP + '</td></tr>';
						}
					}
					else {
						htmlString += '<tr><td>-</td><td>-</td><td>-</td><td>-</td></tr>';
					}
					htmlString += '</tbody>';
					htmlString += '</table>';
				}
				//Addition option - PEF
				/*else if(deployData.Operation.Item == "PEF") {
					htmlString += '<table class="table table-hover deploy-detail" style="margin-bottom: 0px;">';
					htmlString += '<thead></thead>';
					htmlString += '<tbody>';
					htmlString += '<tr><td class="col-xs-6">' + '<spring:message code="Global"/>' + ' <spring:message code="Action"/>: ' + '</td><td class="col-xs-6">';
					if((deployData.Operation.PEF.GlobalAction & 4) == 4) {
						htmlString += '<spring:message code="NodePEF7"/>, ';
					}
					if((deployData.Operation.PEF.GlobalAction & 8) == 8) {
						htmlString += '<spring:message code="NodePEF8"/>, ';
					}
					if((deployData.Operation.PEF.GlobalAction & 2) == 2) {
						htmlString += '<spring:message code="NodePEF9"/>, ';
					}
					if((deployData.Operation.PEF.GlobalAction & 1) == 1) {
						htmlString += '<spring:message code="NodePEF10"/>, ';
					}
					if(htmlString.substring(htmlString.length-2, htmlString.length) === ', ')
						htmlString = htmlString.substring(0, htmlString.length-2);
					else
						htmlString += 'None';
					htmlString += '</td></tr>';
					htmlString += '<tr><td class="col-xs-6">' + '<spring:message code="Global"/>' + ' <spring:message code="Alert"/>: ' + '</td><td class="col-xs-6">';
					htmlString += deployData.Operation.PEF.GlobalAlert ? "Enable" : "Disable";
					htmlString += '</td></tr>';
					htmlString += '<tr><td class="col-xs-6">' + '<spring:message code="Action"/>: ' + '</td><td class="col-xs-6">';
					switch(deployData.Operation.PEF.FilterAction[0] & 14) { //(action & 1110) to remove 1b value, 1:PEF, 2:Power off, 4:Reboot, 8:Power cycle
						case 0:
							htmlString += '<spring:message code="NodePEF6"/>';
							break;
						case 2:
							htmlString += '<spring:message code="NodePEF9"/>';
							break;
						case 4:
							htmlString += '<spring:message code="NodePEF7"/>';
							break;
						case 8:
							htmlString += '<spring:message code="NodePEF8"/>';
							break;
						default:
							htmlString += 'Unknown';
							break;
					}
					htmlString += '</td></tr>';
					htmlString += '<tr><td>' + '<spring:message code="NodePEF10"/>: ' + '</td><td>' + ((deployData.Operation.PEF.FilterAction[0] & 1) ? "Enable" : "Disable") + '</td></tr>';
					htmlString += '</tbody>';
					htmlString += '</table>';
				}*/
				//Addition option - Power Limit
				else if(deployData.Operation.Item == "Power Limit") {
					htmlString += '<table class="table table-hover deploy-detail" style="margin-bottom: 0px;">';
					htmlString += '<thead></thead>';
					htmlString += '<tbody>';
					htmlString += '<tr><td class="col-xs-6">' + '<spring:message code="NodePower2"/>: ' + '</td><td class="col-xs-6">' + (deployData.Operation["PowerLimit"].PowerLimitEnable ? "Enable" : "Disable") + '</td></tr>';
					htmlString += '<tr><td>' + '<spring:message code="NodePower3"/>: ' + '</td><td>' + deployData.Operation["PowerLimit"].PowerLimitValue + '</td></tr>';
					htmlString += '<tr><td>' + '<spring:message code="NodePower8"/>: ' + '</td><td>' + deployData.Operation["PowerLimit"].PowerLimitPeriod + '</td></tr>';
					htmlString += '<tr><td>' + '<spring:message code="NodePower9"/>: ' + '</td><td>' + deployData.Operation["PowerLimit"].PowerLimitCorrectTime + '</td></tr>';
					htmlString += '<tr><td>' + '<spring:message code="NodePower10"/>: ' + '</td><td>';
					switch(deployData.Operation["PowerLimit"].PowerLimitException) {
						case 0:
							htmlString += '<spring:message code="NodePower11"/>';
							break;
						case 1:
							htmlString += '<spring:message code="NodePower12"/>';
							break;
						case 17:
							htmlString += '<spring:message code="NodePower13"/>';
							break;
						default:
							htmlString += 'Unknown';
							break;
					}
					htmlString += '</td></tr>';
					htmlString += '</tbody>';
					htmlString += '</table>';
				}
				htmlString += '</tbody></table>';
				
				//Member list
				htmlString += '<table class="table table-hover deploy-detail" style="margin-top: 20px;">';
				htmlString += '<thead>'
				htmlString += '<th>Member node list</th>';
				htmlString += '</thead>';
				htmlString += '<tbody>';
				if(deploymentDataMap[id].MemberList.length > 0) {
					for(var i=0 ; i<deploymentDataMap[id].MemberList.length ; i++) {
						htmlString += '<tr><td>' + deploymentDataMap[id].MemberList[i] + '</td></tr>';
					}
				}
				else {
					htmlString += '<tr><td colspan="3">-</td></tr>';
				}
				htmlString += '</tbody>';
				htmlString += '</table>';
				
			    return htmlString;
			}
			
            function getDeploymentJsonData(modalID)
            {
                var dataObj = {};
                
                //Basic option
                if(modalID == "editDeploymentModal") {
                	dataObj["_id"] = {};
                	dataObj["_id"]["$oid"] = $("#" + modalID + " input[id='databaseID']").val();
                }
                dataObj["Name"] = $("#" + modalID + " input[id^='deploymentName']").val();
                if(dataObj["Name"] == "") {
                	dataObj["Name"] = "New Deployment";
                }
                dataObj["Operation"] = {};
                dataObj["Operation"]["Classify"]    = $("#" + modalID + " select[name='classifySelect']").val();
                dataObj["Operation"]["Item"]        = $("#" + modalID + " select[name='itemSelect']").val();
                dataObj["Operation"]["Action"]      = $("#" + modalID + " select[name='actionSelect']>option:selected").text();
                dataObj["Operation"]["ActionValue"] = $("#" + modalID + " select[name='actionSelect']").val();
                
				//Addition option - Trap
                if(dataObj["Operation"]["Item"] == "Trap") {
                    var trapList = [];
                    $("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2) tbody>tr").each(function() {
                        var trap = {};
                        trap["ID"]        = parseInt($(this).find("select[name^=id_]").val());
                        trap["Enable"]    = $(this).find("input[name^=enable_]").prop("checked");
                        trap["IpType"]    = $(this).find("input[name^=ipType_]:checked").val();
                        trap["IP"]        = $(this).find("input[name^=ipAddress_]").val();
                        trapList.push(trap);
                        
                        //Check empty
                        if(trap["IP"] == "") {
                        	dataObj["error"] = "Trap destination (" + trap["ID"] + ") IP cannot be empty";
                        	return dataObj;
                        }
                    });
                    dataObj["Operation"]["TrapList"] = trapList;
                }
				//Addition option - PEF
                /*else if(dataObj["Operation"]["Item"] == "PEF") {
                    var additionOption = $("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2)");
                    dataObj["Operation"]["PEF"] = {};
                    dataObj["Operation"]["PEF"]["GlobalAction"] = 0;
                    additionOption.find("input[name^=global_action_]:checked").each(function() {
                    	dataObj["Operation"]["PEF"]["GlobalAction"] += parseInt($(this).val());
                    });
                    dataObj["Operation"]["PEF"]["GlobalAlert"] = additionOption.find("input[name=global_alert]").prop("checked");
                    dataObj["Operation"]["PEF"]["FilterAction"] = [];
                    dataObj["Operation"]["PEF"]["FilterAction"].push(parseInt(additionOption.find("input[name=action_0]:checked").val()) + (additionOption.find("input[name=pet_0]").prop("checked") ? 1 : 0));
                }*/
				//Addition option - Power Limit
                else if(dataObj["Operation"]["Item"] == "Power Limit") {
                    var additionOption = $("#" + modalID + " div.modal-body.option>.container-fluid>.row:eq(2)");
                    dataObj["Operation"]["PowerLimit"] = {};
                    dataObj["Operation"]["PowerLimit"]["PowerLimitEnable"]      = additionOption.find("input[name=enable]").prop("checked");
                    dataObj["Operation"]["PowerLimit"]["PowerLimitValue"]       = parseInt(additionOption.find("input[name=powerLimit]").val());
                    dataObj["Operation"]["PowerLimit"]["PowerLimitPeriod"]      = parseInt(additionOption.find("input[name=samplingPeriod]").val());
                    dataObj["Operation"]["PowerLimit"]["PowerLimitCorrectTime"] = parseInt(additionOption.find("input[name=correctionTimeLimit]").val());
                    dataObj["Operation"]["PowerLimit"]["PowerLimitException"]   = parseInt(additionOption.find("select[name=exceptionAction]").val());
					
                    //Check empty
                    if(isNaN(dataObj["Operation"]["PowerLimit"]["PowerLimitValue"])) {
                    	dataObj["error"] = "Power Limit cannot be empty";
                    	return dataObj;
                    }
                    else if(isNaN(dataObj["Operation"]["PowerLimit"]["PowerLimitPeriod"])) {
                    	dataObj["error"] = "Sampling Period cannot be empty";
                    	return dataObj;
                    	
                    }
                    else if(isNaN(dataObj["Operation"]["PowerLimit"]["PowerLimitCorrectTime"])) {
                    	dataObj["error"] = "Correction Time Limit cannot be empty";
                    	return dataObj;
                    }
                    
                    //Check settings range
                    if((dataObj["Operation"]["PowerLimit"]["PowerLimitValue"] < 1) || (32767 < dataObj["Operation"]["PowerLimit"]["PowerLimitValue"])) {
                    	dataObj["error"] = "Power Limit exceeds the setting range: 1~32767";
                    	return dataObj;
                    }
                    else if((dataObj["Operation"]["PowerLimit"]["PowerLimitPeriod"] < 1) || (3600 < dataObj["Operation"]["PowerLimit"]["PowerLimitPeriod"])) {
                    	dataObj["error"] = "Sampling Period exceeds the setting range: 1~3600";
                    	return dataObj;
                    }
                    else if((dataObj["Operation"]["PowerLimit"]["PowerLimitCorrectTime"] < 6000) || (600000 < dataObj["Operation"]["PowerLimit"]["PowerLimitCorrectTime"])) {
                    	dataObj["error"] = "Correction Time exceeds the setting range: 6000~600000";
                    	return dataObj;
                    }
                }
                
                //Member list
                if(modalID == "addDeploymentModal") {
                	dataObj["MemberList"] = Object.keys(addDeploymentMember);
                }
               	else if(modalID == "editDeploymentModal") {
               		dataObj["MemberList"] = Object.keys(editDeploymentMember);
               	}
                
                return dataObj;
            }
			
			function deploymentListLoading(start, dataArray)
			{
				if(start) {
					$("#deploymentDataTable>tbody").html("<tr><td colspan='8' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
				}
				else {
					setTimeout(function(){
						if($("#deploymentDataTable>tbody>tr>td").attr("colspan") == 8)
							deploymentDataTable.clear().draw(false);
						if(dataArray != null)
							deploymentDataTable.rows.add(dataArray).draw(false);
					}, 100);
				}
			}
			
			function nodeListLoading(start, dataArray)
			{
				if(start) {
					$("#nodeDataTable>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
				}
				else {
					setTimeout(function(){
						if($("#nodeDataTable>tbody>tr>td").attr("colspan") == 4)
							nodeDataTable.clear().draw(false);
						if(dataArray != null)
							nodeDataTable.rows.add(dataArray).draw(false);
					}, 100);
				}
			}
			
			function memberListLoading(start, dataArray)
			{
				if(start) {
					$("#memberDataTable>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
				}
				else {
					setTimeout(function(){
						if($("#memberDataTable>tbody>tr>td").attr("colspan") == 4)
							memberDataTable.clear().draw(false);
						if(dataArray != null)
							memberDataTable.rows.add(dataArray).draw(false);
					}, 100);
				}
			}
		</script>
	</body>
</html>
