<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title>GSM Dashboard</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSS-->
    <link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
    <link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
    <style>
    	.modal-dialog {
    		margin-top: 260px !important;
			width: 95px !important;
		}
		.modal-backdrop {
			opacity: 0 !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
		.alert h1 {
			display: inline !important;
		}
		.slider-selection {
			background: #d9d9d9 !important;
		}
    </style>
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
    
    <!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
    <script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
    <script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
</head>

<body>
    <div id="wrapper">
        <div id="page-wrapper">
            <div class="container-fluid">
            	<br>
            	<!-- <sec:authorize access="hasAnyRole(${Access_Configuration})">
            	<div class="row">
            		<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 style="display:inline-block;"><spring:message code="Change"/>&nbsp;<spring:message code="connectionInterface"/></h4>&nbsp;
								<select id="CISelect">
									<option value="Auto"> Auto </option>
									<option value="IPMI"> IPMI </option>
									<option value="Redfish"> Redfish </option>
								</select>&nbsp;
								<button id="setCISelect" type="button" class="btn btn-primary btn-sm" onclick="setCISelect()"><spring:message code="Submit"/></button>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize> -->
				
            	<sec:authorize access="hasAnyRole(${Access_Configuration})">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4><spring:message code="IPRange"/></h4>
                            </div>
                            <!-- /.panel-heading -->
                            <div class="panel-body">
                                <form name="ipRangeData" action="javascript:setIPRange();">
                                    <button id="search_ip_range" type="submit" class="btn btn-primary"><spring:message code="Submit"/></button>
                                    <a id="add_row" class="btn btn-primary"><spring:message code="Create"/> row</a>
                                    <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover" id="ipRangeTable">
                                            <thead>
                                                <tr>
                                                    <th><spring:message code="GSMSMTP10"/></th>
                                                    <th><spring:message code="startIP"/></th>
                                                    <th><spring:message code="endIP"/></th>
                                                    <th><spring:message code="scanType"/></th>
                                                    <th><spring:message code="policyName"/></th>
                                                    <th><spring:message code="UserName"/></th>
                                                    <th><spring:message code="Password"/></th>
                                                    <th><spring:message code="Rescan"/></th>
                                                </tr>
                                            </thead>
                                            <tbody id="ipRangeList">
                                                <c:set var="xmltext">${XMLString}</c:set>
                                                <x:parse xml="${xmltext}" var="output"/>
                                                <x:forEach select="$output/ipRanges/ipRange" var="item" varStatus="index">
                                                    <tr id="ipRange_<x:out select="$item/policyID"/>">
                                                    	<td style="display:none;"><input type="hidden" name="ID" value="<x:out select="$item/policyID"/>"></td>
                                                    	<td><input type="checkbox" name="Delete"></td>
                                                        <td><input type="text" class="form-control" name="StartIP" value=<x:out select="$item/startIP" /> disabled></td>
                                                        <td><input type="text" class="form-control" name="EndIP" value=<x:out select="$item/endIP" /> disabled></td>
                                                        <td name="scanType">
                                                            <label class="checkbox-inline"><input type="checkbox" name="SMC" <x:out select="$item/scanSMC" /> disabled>BMC</label>
                                                            <label class="checkbox-inline"><input type="checkbox" name="CMC" <x:out select="$item/scanCMC" /> disabled>CMC</label>
                                                            <!-- <label class="checkbox-inline"><input type="checkbox" name="RMC" <x:out select="$item/scanRMC" /> disabled>RMC</label> -->
                                                            <label class="checkbox-inline"><input type="checkbox" name="ESX" <x:out select="$item/scanESX" /> disabled>ESX</label>
                                                            <!-- <label class="checkbox-inline"><input type="checkbox" name="HyperV" <x:out select="$item/scanHyperV" /> disabled>HyperV</label> -->
                                                        </td>
                                                        <td><input type="text" class="form-control" name="Name" value='<x:out select="$item/policyName" />'></td>
                                                        <td><input type="text" class="form-control" name="UserName" value='<x:out select="$item/UserName" />' disabled></td>
                                                        <td><input type="text" class="form-control" name="Password" value='<x:out select="$item/Password" />' disabled></td>
                                                        <td><input id="rescan_ip_range_<x:out select="$item/policyID"/>" policy-id="<x:out select="$item/policyID"/>" type="button" class="btn btn-primary" value='<spring:message code="Rescan"/>' disabled></input></td>
                                                    </tr>
                                                    <x:if select="$item/scanESX = 'checked' or $item/scanHyperV = 'checked'">
	                                                    <tr id="VM_<x:out select="$item/policyID"/>">
	                                                    	<td><b>VM</b></td>
	                                                    	<td colspan="2">Username: <input type="text" class="form-control" name="VmUsername" value=<x:out select="$item/vmUsername" /> disabled></td>
	                                                    	<td colspan="2">Password: <input type="password" class="form-control" name="VmPassword" value=<x:out select="$item/vmPassword" /> disabled></td>
	                                                    </tr>
                                                    </x:if>
                                                </x:forEach>
                                            </tbody>
                                        </table>
                                    </div>
                                </form>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                </sec:authorize>
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- /.page-wrapper -->
    </div>
    <!-- /#page-wrapper -->
    
    <div class="modal fade" id="setIPStatus_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div id="setIPStatus_div" class="alert">
					<i id="setIPStatus_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
    <script>
    	var ipRangeStatusPeriod = 5; //Get status every 5 seconds
    	
		$(document).ready(function() {
        	$("#CISelect").val(parent.connectionInterface);
        	$("#CISelect").on("change", function() {
        		if($(this).val() == "Redfish")
        			if(!window.confirm('<spring:message code="webAlert1"/>'))
        				$(this).val(parent.connectionInterface);
        		
        		parent.connectionInterface = $(this).val();
        	});
            
            $("#ipRangeTable").on('change', "input[type='checkbox']", function() {
            	if($(this).parent().parent().find("input[type=checkbox]:checked").length <= 0) {
                	alert('<spring:message code="webErrMsg27"/>');
            		$(this).prop("checked", true);
            	}
            });
        	
            var i=0;
            $("#add_row").click(function(){
                $("#ipRangeTable").append(
               		"<tr id=\"ipRange_new" + i + "\">" + 
                    "<td style=\"display:none;\"><input type=\"hidden\" name=\"ID\" value=\"new" + i + "\"></td>" + 
                    "<td><input type=\"checkbox\" name=\"Delete\"></td>" + 
                    "<td><input type=\"text\" name=\"StartIP\" class=\"form-control\"/></td>" + 
                    "<td><input type=\"text\" name=\"EndIP\" class=\"form-control\"/></td>" + 
                    "<td name=\"scanType\">" + 
                    "    <label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"SMC\" checked>BMC</label>" + 
                    "    <label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"CMC\" checked>CMC</label>" + 
                    //"    <label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"RMC\" checked>RMC</label>" + 
                    "    <label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"ESX\" onchange=\"changeVM('new" + i + "')\">ESX</label>" + 
                    //"    <label class=\"checkbox-inline\"><input type=\"checkbox\" name=\"HyperV\" onchange=\"changeVM('new" + i + "')\">HyperV</label>" + 
                    "</td>" + 
                    "<td><input type=\"text\" name=\"Name\" class=\"form-control\"/ value=\"New policy\"></td>" + 
                    "<td><input type=\"text\" name=\"UserName\" class=\"form-control\"/ value=\"admin\"></td>" + 
                    "<td><input type=\"text\" name=\"Password\" class=\"form-control\"/ value=\"password\"></td>" + 
                    "<td><input type=\"button\" class=\"btn btn-primary\" value=\"Rescan\" disabled></input></td>" + 
                    "</tr>");
                i++;
            });
            
            getExecuteIpRangeStatus();
        });
        
        function setCISelect()
        {
        	window.location.href = "./setCISelect?CISetting=" + parent.connectionInterface;
        }
        
        function setIPRange()
        {
        	var objArray = [];
        	$("#ipRangeList>tr[id^='ipRange_']").each(function() {
        		var newObj = new Object();
        		newObj["id"] = $(this).find("[name='ID']").val();
        		newObj["delete"] = $(this).find("[name='Delete']").is(':checked');
        		newObj["startIP"] = $(this).find("[name='StartIP']").val();
        		newObj["endIP"] = $(this).find("[name='EndIP']").val();
        		newObj["smc"] = $(this).find("[name='SMC']").is(':checked');
        		newObj["cmc"] = $(this).find("[name='CMC']").is(':checked');
        		newObj["rmc"] = $(this).find("[name='RMC']").is(':checked');
        		newObj["esx"] = $(this).find("[name='ESX']").is(':checked');
        		//newObj["hyperV"] = $(this).find("[name='HyperV']").is(':checked');
        		newObj["hyperV"] = false;
        		newObj["name"] = $(this).find("[name='Name']").val();
                newObj["userName"] = $(this).find("[name='UserName']").val();
                newObj["password"] = $(this).find("[name='Password']").val();
        		
        		if(newObj["esx"] || newObj["hyperV"]) {
        			newObj["vmUsername"] = $("#VM_" + newObj["id"]).find("[name='VmUsername']").val();
        			newObj["vmPassword"] = $("#VM_" + newObj["id"]).find("[name='VmPassword']").val();
        		}
        		
        		//Autofill the empty IP if another is exist
				if(newObj["startIP"] == "" && newObj["endIP"] != "")
					newObj["startIP"] = newObj["endIP"];
				else if(newObj["startIP"] != "" && newObj["endIP"] == "")
					newObj["endIP"] = newObj["startIP"];
        		
        		objArray.push(newObj)
        	});
        	
        	$('#setIPStatus_modal').modal('show');
		    $.ajax({
		    	url: 'setGSMIPRange',
		        type: 'POST',
		        data: {
		        	jsonArray:JSON.stringify(objArray)
		        },
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	$('#setIPStatus_modal').modal('hide');
		        	
		        	if(_data.status == "OK")
		        		window.location.href = "./GSMDashboard";
		        	else
			        	alert("The IP Range (" + _data.ipRange_1 + ") have some IP already exists in another IP Range (" + _data.ipRange_2 + ").");
				},
				error: function(xhr, status, error) {
					alert("Set IP Range Failed.");
			        console.log("Set IP Range failed: [" + xhr.status + "] " + xhr.statusText);
					window.location.href = "./GSMDashboard";
				},
		        cache: false
		    });
		}
		
        function changeVM(id)
        {
        	var checked = $('#ipRange_' + id).find("[name='ESX']").is(':checked') || $('#ipRange_' + id).find("[name='HyperV']").is(':checked');
			
        	if(!checked) {
        		$('#VM_' + id).remove();
        	}
        	else if($('#VM_' + id).length == 0) {
                $("#ipRange_" + id).after(
                	"<tr id=\"VM_" + id + "\">" + 
               		"<td><b>VM</b></td>" + 
               		"<td colspan=\"2\">Username: <input type=\"text\" class=\"form-control\" name=\"VmUsername\" value=\"root\"/></td>" + 
               		"<td colspan=\"2\">Password: <input type=\"password\" class=\"form-control\" name=\"VmPassword\" value=\"password\"/></td>" + 
               		"<td></td>" + 
                    "</tr>");
        	}
        }
        
        function getExecuteIpRangeStatus()
        {
        	$.ajax({
		    	url: 'executeIpRangeStatus',
		        dataType: 'json',
		        
		        success: function(_data) {
		        	try {
		        		if(_data != null) {
				        	for(key in _data) {
				        		if(_data[key] === "idle") {
				        			$("#rescan_ip_range_" + key).val('<spring:message code="Rescan"/>');
				        			$("#rescan_ip_range_" + key).prop("disabled", false);
				        		}
				        		else {
				        			$("#rescan_ip_range_" + key).val('<spring:message code="Running"/>');
				        			$("#rescan_ip_range_" + key).prop("disabled", true);
				        		}
				        	}
			        	}
		        	}
		        	catch(e) {
		        		console.log("Get IP Range execution status error: " + e);
		        	}
				},
				
				error: function(xhr, status, error) {
					console.log("Get IP Range execution status failed: [" + xhr.status + "] " + xhr.statusText + ": \n" + JSON.stringify(xhr));
				},
				
				complete: function() {
					setTimeout(getExecuteIpRangeStatus, (ipRangeStatusPeriod * 1000));
	            },
				
		        cache: false,
		        contentType: false,
		        processData: false
		    });
        }
        
        $("input[id^='rescan_ip_range_']").on("click", function() {
        	var thisElement = $(this);
        	
        	var formData = new FormData();
        	formData.append('policyID', thisElement.attr("policy-id"));
        	
        	$.ajax({
		    	url: 'executeIpRange',
		        type: 'POST',
		        data: formData,
		        dataType: 'json',
		        
		        success: function(_data) {
		        	if(_data.status == "true") {
		        		thisElement.prop("disabled", true);
		        		thisElement.val('<spring:message code="Running"/>');
		        	}
		        	else {
						alert("Rescan IP Range Failed.");
					}
				},
				
				error: function() {
					alert("Rescan IP Range Failed.");
					window.location.href = "./GSMDashboard";
				},
				
		        cache: false,
		        contentType: false,
		        processData: false
		    });
        });
    </script>
</body>
</html>
