<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>GSM Properties</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-slider.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-slider.js"/>"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<br>
				<%-- <div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<b><spring:message code="TFTPSettingMsg4"/></b>
							</div>
							<!-- /.panel-heading -->
							 <div class="panel-body">
								<form action="./SaveTFTP">
									<spring:message code="TFTPSettingMsg3"/><br>
									<input type="checkbox" id="enabletftp" name="enable" value="1" ${enableTFTP == 'true' ? 'checked' : ''} data-size="mini" data-handle-width=40><br><br>
									<div class="row">
										<div class="col-lg-6">
											<input type="text" name="ip" value="${TFTPAddress}" placeholder="<spring:message code="TFTPSettingMsg2"/>">
											<button type="submit" class="btn btn-primary"><spring:message code="Submit"/></button>
										</div><!-- /.col-lg-6 -->
									</div><!-- /.row -->
								</form>
								<br>
								<spring:message code="TFTPSettingMsg1"/>
							</div>
							<!-- /.panel-body -->
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div> <!-- /.row --> --%>
				
				<div class="row">
					<div class="col-lg-12">
						<%-- <div class="row">
							<spring:message code="SettingGSM1"/><br>
							<input type="checkbox" id="enable" checked data-size="mini" data-handle-width=40 <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>><br><br>
						</div> --%>
						<form action="./SaveParams">
							<!-- /.row -->
							<%-- <div class="panel panel-default">
								<div class="panel-heading">
									<b><spring:message code="SettingGSM2"/></b>
								</div>
								<!-- /.panel-heading -->
								<div class="panel-body">
									<blockquote>
										<p><spring:message code="SettingGSM5"/></p>
									</blockquote>
									<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
										<spring:message code="SettingGSM6"/> &nbsp;
										<select id="SP" name="ScanPeriod" <sec:authorize ifNotGranted="ROLE_ADMIN">disabled</sec:authorize>>
											<c:forEach var="i" begin="1" end="12">
												<option value="${i}" ${i == scanPeriod ? 'selected' : ''}> ${i} </option>
											</c:forEach>
										</select>
										&nbsp;<spring:message code="SettingGSM12"/><br>
									</div>
								</div>
								<!-- /.panel-body -->
							</div>
							<!-- /.panel --> --%>
							<sec:authorize access="hasAnyRole(${Access_Configuration})">
							<div class="panel panel-default">
								<div class="panel-heading">
									<b><spring:message code="SettingGSM3"/></b>
								</div>
								<!-- /.panel-heading -->
								
								<div class="panel-body">
									<blockquote>
										<p><spring:message code="SettingGSM7"/></p>
									</blockquote>
									<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
										<div>
											<br><spring:message code="SettingGSM20"/><br><br><br>
											<b>0%</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="limit" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>100%</b>
											&nbsp;<span id="ex6CurrentSliderValLabel"> <input id="limitValue" type=text name="DBThreshold" value="${dbThreshold}"> %</span><br>
										</div>
										<br><br>
										<div>
											<br><spring:message code="SettingGSM9"/>
											<select id="DBE" name="DBExpiration">
												<c:forEach var="i" begin="1" end="365">
													<option value="${i}" ${i == dbExpiration ? 'selected' : ''}> ${i} </option>
												</c:forEach>
											</select>
											<spring:message code="SettingGSM13"/>
										</div>
									</div>
								</div>
								<!-- /.panel-body -->
							</div>
							</sec:authorize>
							<!-- /.panel -->
							<sec:authorize access="hasAnyRole(${Access_Configuration})">
							<div class="panel panel-default">
								<div class="panel-heading">
									<b><spring:message code="SettingGSM4"/></b>
								</div>
								<!-- /.panel-heading -->
								
								<div class="panel-body">
									<blockquote>
										<p><spring:message code="SettingGSM10"/></p>
									</blockquote>
									<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
										<br><spring:message code="SettingGSM11"/>
										<select id="LExp" name="LogExpiration">
											<c:forEach var="i" begin="1" end="7">
												<option value="${i}" ${i == logExpiration ? 'selected' : ''}> ${i} </option>
											</c:forEach>
										</select>
										<spring:message code="SettingGSM13"/><br>
									</div>
								</div>
								<!-- /.panel-body -->
							</div>
							</sec:authorize>
							<!-- /.panel -->

							<sec:authorize access="hasAnyRole(${Access_Configuration})">
							<div class="panel panel-default" id="rotationSetting" style="display:${platformOS == true ? 'block' : 'none'}">
								<div class="panel-heading">
									<b><spring:message code="SettingGSM22"/></b>
								</div>
								<!-- /.panel-heading -->
								<div class="panel-body">
									<blockquote>
										<p><spring:message code="SettingGSM23"/></p>
									</blockquote>
									<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
										<div>
											<spring:message code="SettingGSM24"/>
											<select id="RotationPeriodExpiration" name="RotationPeriod">
												<option value="1" ${rotationPeriod == 1 ? 'selected' : ''}><spring:message code="hour"/></option>
												<option value="24" ${rotationPeriod == 24 ? 'selected' : ''}><spring:message code="day"/></option>
												<option value="168" ${rotationPeriod == 168 ? 'selected' : ''}><spring:message code="week"/></option>
												<option value="720" ${rotationPeriod == 720 ? 'selected' : ''}><spring:message code="month"/></option>
											</select>
										</div>
										<br>
										<div>
										    <p>
										    <spring:message code="SettingGSM25"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
										    <b>1</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="rotationSizeSliderBar" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>1024</b>
										    &nbsp;&nbsp;&nbsp;&nbsp;<input id="rotationSizeSliderBarValue" name="RotationSize" type="text" maxlength="4" size="3" value="${rotationSize}">
										    </p>
										</div>
									</div>
								</div>
								<!-- /.panel-body -->
							</div>
							</sec:authorize>
							<!-- /.panel -->

							<!-- Sean, Setting GSM Node update period and node -->
							<sec:authorize access="hasAnyRole(${Access_Configuration})">
							<div class="panel panel-default">
								<div class="panel-heading">
									<b><spring:message code="SettingGSM16"/></b>
								</div>
								<!-- /.panel-heading -->
								
								<div class="panel-body">
									<blockquote>
										<p><spring:message code="SettingGSM17"/></p>
									</blockquote>
									<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
										<div>
										    <p>
										    <spring:message code="SettingGSM18"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
										    <b>50</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="nodeSliderBar" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>300</b>
										    &nbsp;&nbsp;&nbsp;&nbsp;<input id="nodeSliderBarValue" name="BmcQuantity" type="text" maxlength="3" size="3" value="${bmcQuantity}">&nbsp;<b>nodes</b>
										    </p>
										</div>
										<br>
										<div>
										    <p>
										    <spring:message code="SettingGSM19"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
										    <b>3</b>&nbsp;&nbsp;&nbsp;&nbsp;<input id="periodSliderBar" type="text" />&nbsp;&nbsp;&nbsp;&nbsp;<b>10</b>
										    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input id="periodSliderBarValue" name="BmcPeriod" type="text" maxlength="3" size="3" value="${bmcPeriod}">&nbsp;<b>minutes</b>
										    </p>
										</div>
									</div>
								</div>
								<!-- /.panel-body -->
							</div>
							</sec:authorize>
							<!-- /.panel -->
							
							<button id="updBtn" class="btn btn-primary"><spring:message code="Submit"/></button>
						</form>
					</div>
					<!-- /.col-lg-12 -->
				</div>
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /#page-wrapper -->
	</div>
	<!-- /.wrapper -->
	<sec:authorize access="!hasAnyRole(${Access_Configuration})" var="var_not_Access_Configuration"/>
	<script>
		$(document).ready(function() {
			$("#enabletftp").bootstrapSwitch();
			
			var errCode = '${errCode}';
			if( errCode != 0 )
				alert("<spring:message code="webErrMsg${errCode}"/>");
			
		});
		
		//$("#enable").bootstrapSwitch();
		
		$("#limit").slider({
			value: 50,
		    ticks: [0, 10, 90, 100],
		    ticks_positions: [0, 10, 90, 100],
		    ticks_labels: ['', '10%', '90%', ''],
		    ticks_snap_bounds: 0
		});
		
		<c:if test="${var_not_Access_Configuration}">$("#limit").slider("disable");</c:if>
		
		$("#limit").on("slide", function(slideEvt) {
			var value = $(this).val()*1;
			if(value < 10) {
				$("#limit").slider("setValue", 10);
				$("input[id=limitValue]").val(10);
			} else if(value > 90) {
				$("#limit").slider("setValue", 90);
				$("input[id=limitValue]").val(90);
			} else {
				$("#limit").slider("setValue", value);
				$("input[id=limitValue]").val(slideEvt.value);
			}
			
		});
		
		$("#limitValue").keyup(function() {
			var value = $(this).val()*1;
			if(value < 10) {
				$("#limit").slider("setValue", 10);
			} else if(value > 90) {
				$("#limit").slider("setValue", 90);
			} else {
				$("#limit").slider("setValue", value);
			}
		}).keyup();
		
		/*$("#enable").on('switchChange.bootstrapSwitch',function () {
			if ($("#enable").is(":checked")) {
				$("#SP").prop("disabled", false);
				$("#DBE").prop("disabled", false);
				$("#LExp").prop("disabled", false);
				$("input[id=limitValue]").prop("disabled", false);
				$("#limit").slider("enable");
			} else {
				// close the selector
				$("#SP").prop("disabled", "disabled");
				$("#DBE").prop("disabled", "disabled");
				$("#LExp").prop("disabled", "disabled");
				
				$("#SP").prop("value", "disable");
				$("#DBE").prop("value", "disable");
				$("#LExp").prop("value", "disable");

				$("input[id=limitValue]").prop("disabled", true);
				$("#limit").slider("disable");
			}
		});*/

		$("#rotationSizeSliderBar").slider({
			value: 100,
			min: 1,
			max: 1024
		});

		/* Sean, 20170516 GSM update quantity and period */
		
		$("#nodeSliderBar").slider({
			value: 50,
			min: 50,
			max: 300
		});
		
		$("#periodSliderBar").slider({
			value: 3,
			min: 3,
			max: 10
		});

		$("#rotationSizeSliderBar").on("slide", function(slideEvt) {
			var value = $(this).val()*1;
			$("#rotationSizeSliderBar").slider("setValue", value);
			$("input[id=rotationSizeSliderBarValue]").val(slideEvt.value);
			
		});

		$("#nodeSliderBar").on("slide", function(slideEvt) {
			var value = $(this).val()*1;
			$("#nodeSliderBar").slider("setValue", value);
			$("input[id=nodeSliderBarValue]").val(slideEvt.value);
			
		});
		
		$("#periodSliderBar").on("slide", function(slideEvt) {
			var value = $(this).val()*1;
			$("#periodSliderBar").slider("setValue", value);
			$("input[id=periodSliderBarValue]").val(slideEvt.value);
			
		});
		
		$("#nodeSliderBarValue").keyup(function() {
			if (/[^0-9\.-]/g.test(this.value)) {
	            this.value = this.value.replace(/[^0-9\.-]/g, '')*1;
	        }
			
			var value = $(this).val()*1;
			if(value < 50) {
				$("#nodeSliderBar").slider("setValue", 50);
			} else if(value > 300) {
				$("#nodeSliderBar").slider("setValue", 300);
			} else {
				$("#nodeSliderBar").slider("setValue", value);
			}
		}).keyup();

		$("#rotationSizeSliderBarValue").keyup(function() {
			if (/[^0-9\.-]/g.test(this.value)) {
				this.value = this.value.replace(/[^0-9\.-]/g, '')*1;
			}

			var value = $(this).val()*1;
			if (value < 1) {
				$("#rotationSizeSliderBar").slider("setValue", 1);
			}
			else if(value > 1024) {
				$("#rotationSizeSliderBar").slider("setValue", 1024);
			}
			else {
				$("#rotationSizeSliderBar").slider("setValue", value);
			}
		}).keyup();

		$("#periodSliderBarValue").keyup(function() {
			if (/[^0-9\.-]/g.test(this.value)) {
	            this.value = this.value.replace(/[^0-9\.-]/g, '')*1;
	        }
			
			var value = $(this).val()*1;
			if(value < 3) {
				$("#periodSliderBar").slider("setValue", 3);
			} else if(value > 10) {
				$("#periodSliderBar").slider("setValue", 10);
			} else {
				$("#periodSliderBar").slider("setValue", value);
			}
		}).keyup();
	</script>
</body>
</html>