<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Group Remote Access</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<style type="text/css">
		.modal-dialog2 {
    		margin-top: 300px !important;
			width: 95px !important;
			position: absolute;
			top:0;
		    right:0;
		    bottom:0;
		    left:0;
		    margin:auto;
		}
		.alert2 {
			margin-bottom: 0px !important;
		}
		.use-flexbox{
			display:flex;
			align-items:center;
			justify-content:center;
			width:200px;
			height:150px;
			border:1px solid #000;
		}
		.use-flexbox div{
			width:100px;
			height:50px;
		}
	    .btn-file {
	    position: relative;
	    overflow: hidden;
		}
		.btn-update {
	    position: relative;
	    overflow: hidden;
		}
		.btn-file input[type=file] {
		    position: absolute;
		    top: 0;
		    right: 0;
		    min-width: 100%;
		    min-height: 100%;
		    font-size: 100px;
		    text-align: right;
		    filter: alpha(opacity=0);
		    opacity: 0;
		    outline: none;
		    background: white;
		    cursor: inherit;
		    display: block;
		}
		input[readonly] {
		  background-color: white !important;
		  cursor: text !important;
		}
		#progress_bar {
			margin: 10px 0;
		    padding: 3px;
		    clear: both;
		    opacity: 1.0;
		}
		.progress-circle {
    		margin-top: 260px !important;
			width: 95px !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
		.modal-content.success {
			background-color: #dff0d8;
			color: #449d44;
		}
		.modal-content.fail {
			background-color: #f2dede;
			color: #d9534f;
		}
		.modal_msg .modal-title {
			font-weight: bold;
		}
		.modal_msg .modal-header {
			padding: 15px 15px 5px 15px;
			border-bottom: none;
		}
		.modal_msg .modal-body {
			padding: 5px 15px;
		}
	</style>
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
</head>
<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            ${Name}
                        </h3>
                    </div>
                </div>
				<br>
				
				<div id="testtop">
					<!-- Power Control -->
					<sec:authorize access="hasAnyRole(${Access_PowerControl})">
					<div class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="NodeChassis1"/></h4>
								</div>
								<div class="panel-body">
									<div id="powerCtrl" class="btn-toolbar" sytle="margin: auto;" role="toolbar" aria-label="...">
										<div class="btn-group" role="group" aria-label="Power on">
											<button type="button" class="btn btn-success" data-toggle="modal" data-target="#member" value="1" title="Power on">
												<i class="fa fa-power-off fa-5x" aria-hidden="true"></i>
											</button>
										</div>
										<div class="btn-group" role="group" aria-label="Power off">
											<button type="button" class="btn btn-danger" data-toggle="modal" data-target="#member" value="0" title="Power off">
												<i class="fa fa-circle-o fa-5x" aria-hidden="true"></i>
											</button>
										</div>
										<div class="btn-group" role="group" aria-label="Power cycle">
											<button type="button" class="btn btn-warning" data-toggle="modal" data-target="#member" value="2" title="Power cycle">
												<i class="fa fa-repeat fa-5x" aria-hidden="true"></i>
											</button>
										</div>
										<div id="HardReset" class="btn-group" role="group" aria-label="Hard reset">
											<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#member" value="3" title="Hard reset">
												<i class="fa fa-refresh fa-5x" aria-hidden="true"></i>
											</button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Power Control -->
					
					<!-- Chassis Identify -->
					<sec:authorize access="hasAnyRole(${Access_Configuration})">
					<div id="ChassisIdentify" class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="NodeChassis2"/></h4>
								</div>
								<div class="panel-body">
									<spring:message code="NodeChassis3"/>
									<select id="Seconds">
										<c:forEach var="i" begin="0" end="255">
											<option value="${i}"> ${i} </option>
										</c:forEach>
										<option value="256"> <spring:message code="NodeChassis5"/> </option>
									</select>
									<spring:message code="NodeChassis4"/>
									<button class="btn btn-primary" data-toggle="modal" data-target="#member" value="4">
										<spring:message code="Submit"/>
									</button>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Chassis Identify -->
					
					<!-- Boot option -->
					<sec:authorize access="hasAnyRole(${Access_Configuration})">
					<div class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 style="display:inline-block;"><spring:message code="NodeChassis6"/></h4>
									&nbsp;&nbsp;
									<select id="BootMode">
										<option> Legacy </option>
										<option> UEFI </option>
									</select>
								</div>
								<div class="panel-body">
									<div id="powerCtrl" class="btn-toolbar" sytle="margin: auto;" role="toolbar" aria-label="...">
										<div class="btn-group" role="group" aria-label="pxe">
											<button type="button" id="pxe" onclick="getBootOption(this)" class="btn btn-primary" data-toggle="modal" data-target="#member" title="pxe" value="5">
												<spring:message code="BootOption2"/>
											</button>&nbsp;&nbsp;
										</div>
										<div class="btn-group" role="group" aria-label="disk">
											<button type="button" id="disk" onclick="getBootOption(this)" class="btn btn-primary" data-toggle="modal" data-target="#member" title="disk" value="5">
												<spring:message code="BootOption3"/>
											</button>&nbsp;&nbsp;
										</div>
										<div class="btn-group" role="group" aria-label="cdrom">
											<button type="button" id="cdrom" onclick="getBootOption(this)" class="btn btn-primary" data-toggle="modal" data-target="#member" title="cdrom" value="5">
												<spring:message code="BootOption6"/>
											</button>&nbsp;&nbsp;
										</div>
										<div class="btn-group" role="group" aria-label="bios">
											<button type="button" id="bios" onclick="getBootOption(this)" class="btn btn-primary" data-toggle="modal" data-target="#member" title="bios" value="5">
												<spring:message code="BootOption7"/>
											</button>&nbsp;&nbsp;
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Boot option -->
					
					<!-- Reboot BMC -->
					<sec:authorize access="hasAnyRole(${Access_PowerControl})">
					<div id="RebootBMC" class="row">
						<div class="col-lg-12">
						   	<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="groupRebootBMC"/></h4>
								</div>
								<div class="panel-body">								
									<div>
										<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#groupRebootBMC">
											<spring:message code="NodePEF7"/>BMC
										</button>&nbsp;&nbsp;
									</div>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Reboot BMC -->
					
					<!-- Backup/Restore BMC Configure -->
					<sec:authorize access="hasAnyRole(${Access_Configuration})">
					<div id="BMCBackup" class="row">
						<div class="col-lg-12">
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="NodePEF13"/></h4>
								</div>
								<div class="panel-body">								
									<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
										<form name="getData3" enctype="multipart/form-data" class="form-inline">
											<div class="well">
												<div>
													<label><spring:message code="NodePEF15"/> (<spring:message code="NodeUpdate9"/> .bin)</label>
												</div>
												<div class="form-group col-lg-10">
													<div class="input-group" style="width: 100%">
													    <div class="btn-group" style="width: 100%"> 
															<input type="text" class="form-control" style="width: 70%" readonly>
															<span class="btn btn-primary btn-file">
																<i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input id="bmcRestoreFile" type="file" name="file">
															</span>
															<button type="button" class="btn btn-danger" data-toggle="modal" data-target="#groupRestoreBMC">
																&nbsp;<spring:message code="Restore"/>
															</button>
															<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#groupBackupBMC">
																<spring:message code="Backup"/>
															</button>
													    </div>
													</div>
												</div>
												<div>
													<label style="font-weight: normal"><br/></label>
												</div>
											</div>
										</form> 
									</div>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					
					<!-- Restore BIOS settings -->
					<sec:authorize access="hasAnyRole(${Access_Configuration})">
					<div id="RestoreBIOS" class="row">
						<div class="col-lg-12">
						   	<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="NodeChassis7"/></h4>
								</div>
								<div class="panel-body">								
									<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
										<form name="getData" enctype="multipart/form-data" class="form-inline">
											<div class="well">
												<div>
												<label><spring:message code="BiosDefault4"/> (<spring:message code="NodeUpdate9"/> .log/.txt)</label>
												</div>
												<div class="form-group col-lg-10">
													<div class="input-group" style="width: 100%">
												    	<div class="btn-group" style="width: 100%">
												    		<input type="text" class="form-control" style="width: 70%" readonly>
												    		<span class="btn btn-primary btn-file">
												            	<i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input type="file" name="file" multiple >
												        	</span>
												        	<button type="button" class="btn btn-danger" data-toggle="modal" data-target="#member" title="Reset BIOS" value="6">
																<i class="fa fa-reply-all"></i>&nbsp;<spring:message code="Restore"/>
															</button>
												    	</div>
													</div>
												</div>
												<div>
													<label style="font-weight: normal">
														<spring:message code="BiosDefault5"/><br/>
													</label>
													<div style="padding-left:2em">
														<label style="font-weight: normal">
															<spring:message code="BiosDefault6"/><br/>
															<spring:message code="BiosDefault7"/><br/>
														</label>
													</div>
													<div id="progress_bar"><div class="status">&nbsp;</div></div>
												</div>
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Restore BIOS settings -->
					
					<!-- Import/Export BIOS Setup information -->
					<sec:authorize access="hasAnyRole(${Access_Configuration})">
					<div class="row">
						<div id="BIOSSetup" class="col-lg-12">
					   		<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="NodeChassis8"/></h4>
								</div>
								<div class="panel-body">								
									<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
										<form name="getData2" enctype="multipart/form-data" class="form-inline">
											<div class="well">
												<div>
													<label><spring:message code="BiosDefault8"/> (<spring:message code="NodeUpdate9"/> .json)</label>
												</div>
												<div class="form-group col-lg-10">
													<div class="input-group" style="width: 100%">
											    		<div class="btn-group" style="width: 100%">
											    			<input type="text" class="form-control" style="width: 70%" readonly>
											    			<span class="btn btn-primary btn-file">
											            		<i class="fa fa-globe"></i>&nbsp;<spring:message code="Browse"/><input id="biosSetupFile" type="file" name="file" multiple >
											        		</span>
											        		<button type="button" data-toggle="modal" data-target="#groupImportBios" class="btn btn-danger" title="Import BIOS Setup" disabled>
																<i class="fa fa-reply-all"></i>&nbsp;<spring:message code="Import"/>
															</button>
															<button type="button" data-toggle="modal" data-target="#groupExportBios" class="btn btn-primary"><spring:message code="Export"/></button>
											    		</div>
													</div>
												</div>
												<div>
													<div style="padding-left:2em">
													</div>
													<div id="progress_bar"><div class="status">&nbsp;</div></div>
												</div>
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Import/Export BIOS Setup information -->
					
					<!-- Virtual Media (Vmcli) -->
					<sec:authorize access="hasAnyRole(${Access_VirtualMedia})">
					<div id="VirtualMedia" class="row">
						<div class="col-lg-12">
					   		<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="navside17"/></h4>
									<small>( <spring:message code="NodeVmcli10"/> )</small>
								</div>
								<div class="panel-body">									
									<form id="imageFiles">
										<div>
											<h1 class="page-header">
												<small>
													<spring:message code="navside22"/> (.iso or img)
												</small>
											</h1>
										</div>
										<div id="selectByFile" class="dataTable_wrapper">
											<table class="table table-striped table-bordered table-hover" id="tab_logic">
		                                    	<thead>
		                                        	<tr>
		                                            	<th><spring:message code="NodeVmcli4"/></th>
		                                            	<th><spring:message code="NodeVmcli5"/></th>
		                                            	<th><spring:message code="NodeVmcli6"/></th>
		                                            	<th><spring:message code="NodeVmcli7"/></th>
		                                        	</tr>
		                                    	</thead>
			                                    <tbody>
			                                        <c:set var="xmltext">${XMLString_File}</c:set>
													<x:parse xml="${xmltext}" var="output"/>
													<x:forEach select="$output/NodeVmcli/files" var="item">
														<tr>
															<td>
																<input type="checkbox" name="file_select" value="<x:out select="$item/path" />">
															</td>
															<td>
																<x:out select="$item/name" />
															</td>
															<td>
																<x:out select="$item/size" />
															</td>
															<td>
																<x:out select="$item/path" />
															</td>
														</tr>
													</x:forEach>
			                                    </tbody>
			                                </table>
										</div>
										<div>
											<h1 class="page-header">
												<small>
													<spring:message code="navside21"/>
												</small>
											</h1>
										</div>
										<div id="selectByDevice" class="dataTable_wrapper_device">
											<table class="table table-striped table-bordered table-hover" id="tab_logic">
			                                    <thead>
			                                        <tr>
			                                            <th><spring:message code="NodeVmcli4"/></th>
			                                            <th><spring:message code="NodeVmcli13"/></th>
			                                            <th><spring:message code="NodeVmcli14"/></th>
			                                            <th><spring:message code="NodeVmcli15"/></th>
			                                            <th><spring:message code="NodeVmcli16"/></th>
			                                        </tr>
			                                    </thead>
			                                    <tbody>
													<c:set var="xmltext">${XMLString_Device}</c:set>
													<x:parse xml="${xmltext}" var="output"/>
													<x:forEach select="$output/DeviceList/node" var="item">
														<tr>
															<td>
																<input type="checkbox" name="deviceChoose" value="<x:out select="$item/name" />">
															</td>
															<td>
																<x:out select="$item/name" />
															</td>
															<td>
																<x:out select="$item/type" />
															</td>
															<td>
																<x:out select="$item/size" />
															</td>
															<td>
																<x:out select="$item/model" />
															</td>
														</tr>
													</x:forEach>
			                                    </tbody>
			                                </table>
										</div>
										<div>
											<spring:message code="NodeVmcli12"/> :
											<input type="text" id="port" value="2068" onkeyup="return ValidateNumber($(this),value)" size="6" maxlength="6">
											<br/><br/>
										</div>
										<div>
											<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#vmcliMount" value="mount"><i class="fa fa-fw fa-link"></i> <spring:message code="NodeVmcli2"/></button>&nbsp&nbsp
											<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#vmcliMount" value="umount"><i class="fa fa-fw fa-chain-broken"></i> <spring:message code="NodeVmcli3"/></button>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
					<!-- Virtual Media (Vmcli) -->
					
					<!-- NTP -->
					<sec:authorize access="hasAnyRole(${Access_Configuration})">
					<div id="NetworkTime" class="row">
						<div class="col-lg-12">
						   	<div class="panel panel-default">
								<div class="panel-heading">
									<h4><spring:message code="NTP"/></h4>
								</div>
								<div class="panel-body">	
									<table class="table table-striped table-bordered table-condenseds">
										<tbody id="NTPsetting">
											<tr><td><strong><spring:message code="OpMode"/></strong></td> 
												<td> 
													<select class="form-control" id="OperationMode"> 
															<option value="0">Disabled</option>
															<option value="2">Requested Mode</option>
															<option value="1">Daemon Mode</option> 
													</select>
												</td>
											</tr>
											<tr><td><strong><spring:message code="NTP"/> Server 1</strong></td> 
												<td>
													<input id="NTP_1" type="text" class="form-control" placeholder="xxx.xxx.xxx.xxx">
												</td>
											</tr>
											<tr>
												<td><strong><spring:message code="NTP"/> Server 2</strong></td> 
												<td>
													<input id="NTP_2" type="text" class="form-control" placeholder="xxx.xxx.xxx.xxx" disabled>
												</td>
											</tr>
											<tr>
												<td><strong><spring:message code="NTP"/> Server 3</strong></td> 
												<td>
													<input id="NTP_3" type="text" class="form-control" placeholder="xxx.xxx.xxx.xxx" disabled>
												</td>
											</tr>
											<tr>
												<td><strong><spring:message code="ReqModeUpdateFreq"/></strong></td> 
												<td>
													<input id="UpdateFrequency" type="text" onkeypress='return event.charCode >= 48 && event.charCode <= 57' class="form-control" placeholder="integer">
												</td>
											</tr>
											<tr style="display:none;">
												<td><strong><spring:message code="TimeSyncMethod"/></strong></td> 
												<td>
													<label class="radio-inline">
														<input id="TSMethod" type="radio" name="TimeSynchronizationMethod" value="1" checked> Step Mode
													</label>
													<label class="radio-inline">
														<input id="TSMethod" type="radio" name="TimeSynchronizationMethod" value="0"> Slew Mode
													</label>								
												</td>
											</tr>
										</tbody>
									</table>
									<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#applyNTP"><spring:message code="setting"/></button>
								</div>
							</div>
						</div>
					</div>
					</sec:authorize>
				</div>
			</div>
		</div>
	</div>
	
	<!-- Setting NTP dialog -->
	<div style="color:black" class="modal fade" id="applyNTP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><spring:message code="NodeRemote7"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="addIP" value=<x:out select="$item/bmcIP" />
											<x:if select="$item/bmcType = 'AMI' or $item/bmcType = 'OpenBMC' or $item/asicType = 'AST2400'">disabled</x:if>
										></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="setNTP()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- Setting NTP dialog -->
	
	<!-- Vmcli mount dialog -->
	<div style="color:black" class="modal fade" id="vmcliMount" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote6"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
								<x:if select="$item/bmcType != 'AMI'">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="mountIP" value=<x:out select="$item/bmcIP" />
											<x:if select="$item/bmcType = 'AMI' or $item/bmcType = 'OpenBMC'">disabled</x:if>
										></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:if>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="setting()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- Vmcli mount dialog -->
	
	<!-- reboot bmc dialog -->
	<div style="color:black" class="modal fade" id="groupRebootBMC" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote4"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="rebootIP" value=<x:out select="$item/bmcIP" />
											<x:if select="$item/bmcType = 'AMI' or $item/bmcType = 'OpenBMC'">disabled</x:if>
										></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="bmcUtil('Reboot')" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- reboot bmc dialog -->
	
	<!-- backup BMC dialog -->
	<div style="color:black" class="modal fade" id="groupBackupBMC" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote10"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="backupIP" value=<x:out select="$item/bmcIP" />
											<x:if select="$item/bmcType = 'AMI' or $item/bmcType = 'OpenBMC' or $item/asicType = 'AST2400'">disabled</x:if>
										></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="bmcUtil('Backup')" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- backup BMC dialog -->
		
	<!-- restore BMC dialog -->
	<div style="color:black" class="modal fade" id="groupRestoreBMC" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote10"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="restoreIP" value=<x:out select="$item/bmcIP" />
											<x:if select="$item/bmcType = 'AMI' or $item/bmcType = 'OpenBMC' or $item/asicType = 'AST2400'">disabled</x:if>
										></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>	
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="bmcUtil('Restore')" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- restore BMC dialog -->
	
	<!-- export BIOS dialog -->
	<div style="color:black" class="modal fade" id="groupExportBios" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote9"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="exportIP" value=<x:out select="$item/bmcIP" />
											<x:if select="$item/bmcType = 'OpenBMC' or $item/asicType = 'AST2400'">disabled</x:if>
										></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="bmcUtil('BIOSexport')" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- export BIOS dialog -->
	
	<!-- import BIOS dialog -->
	<div style="color:black" class="modal fade" id="groupImportBios" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote9"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td>
											<div class="checkbox">
												<label>
													<input type="checkbox" name="importIP" 
														 bmc-type=<x:out select="$item/bmcType" /> 
														 value=<x:out select="$item/bmcIP" /> 
													     <x:if select="$item/bmcType = 'AMI' or $item/bmcType = 'OpenBMC' or $item/asicType = 'AST2400'">disabled</x:if>>
												</label>
											</div>
										</td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="bmcUtil('BIOSimport')" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
				</div>
			</div>
		</div>
	</div>
	<!-- import BIOS dialog -->
	
	<div style="color:black" class="modal fade" id="member" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="NodeRemote1"/>/<spring:message code="NodeRemote2"/>/<spring:message code="NodeRemote3"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="dataTables-example2">
							<thead>
								<tr>
									<th><spring:message code="Select"/></th>
									<th><spring:message code="Nodelist2"/></th>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Nodelist5"/></th>
								</tr>
							</thead>
							<tbody>
								<c:set var="xmltext">${XMLString}</c:set>
								<x:parse xml="${xmltext}" var="output"/>
								<x:forEach select="$output/NodeList/node" var="item">
									<tr class="gradeA">
										<td><div class="checkbox"><label><input type="checkbox" name="addIP" value=<x:out select="$item/bmcIP" />></label></div></td>
										<td><x:out select="$item/bmcMAC" /></td>
										<td><x:out select="$item/bmcIP" /></td>										
										<x:choose>
											<x:when select="$item/nodeType = 'SMC'">
												<td>BMC</td>
											</x:when>
											<x:otherwise>
												<td><x:out select="$item/nodeType" /></td>
											</x:otherwise>
										</x:choose>
									</tr>
								</x:forEach>
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="action()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="groupStatus" tabindex="-1" role="dialog" aria-labelledby="groupStatusLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="groupStatusLabel"><spring:message code="GroupStatus"/></h4>
				</div>
				<div class="modal-body">
					<div id="modalCheckBox" class="dataTable_wrapper">
						<table class="table table-striped table-bordered table-hover" id="groupStatusTables">
							<thead>
								<tr>
									<th><spring:message code="Nodelist3"/></th>
									<th><spring:message code="Status"/></th>
									<th><spring:message code="Information"/></th>
								</tr>
							</thead>
							<tbody id="groupStatusTablesBody">
							</tbody>
						</table>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="modal_loading" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog progress-circle" role="document">
			<div class="modal-content">
				<div id="modal_loading_div" class="alert">
					<i id="modal_loading_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade modal_msg" id="modal_msg" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 name="modal_msg_title" class="modal-title">modal title</h4>
				</div>
				<div class="modal-body">
					<p name="modal_msg_msg">modal message</p>
				</div>
			</div>
		</div>
	</div>
	
	<!-- Javascript -->
	<script>
		var option;
		var bootOption;
		var vmcliBehavior;
		var groupStatus = "";
		var showStatusModal = false;
		var biosSetupType = "";
		
		var checkSupport = function() {
			/** GbtUtility has not supported yet */
			$("#RestoreBIOS").remove();
			$("#VirtualMedia").remove();
			/** GbtUtility has not support yet */
			
			if (parent.connectionInterface === "Redfish") {
				$("#HardReset").remove();
				$("#ChassisIdentify").remove();
				$("#BootMode").remove();
				$("#RestoreBIOS").remove();
				$("#BIOSSetup").remove();
				$("#VirtualMedia").remove();
				$("#NetworkTime").remove();
				$("#BMCBackup").remove();
			}
			
            <%--
                Bit 1: Vertiv exist
                Bit 2: AMI exist
                Bit 3: OpenBMC exist
            --%>
            switch ("${GroupCombination}") {
                <%-- pure Vertiv BMC type --%>
                case "1":
                    break;
                <%-- pure AMI BMC type --%>
                case "2":
                	$("#RebootBMC").remove();
                    $("#BMCBackup").remove();
                    $("#RestoreBIOS").remove();
                    $("#BIOSSetup").remove();
                    $("#VirtualMedia").remove();
                    $("#NetworkTime").remove();
                    break;
                <%-- pure OBMC type --%>
                case "4":
                	$("#RebootBMC").remove();
                	$("#BMCBackup").remove();
                    $("#RestoreBIOS").remove();
                    $("#BIOSSetup").remove();
                    $("#VirtualMedia").remove();
                    $("#NetworkTime").remove();
                    break;
                <%-- Vertiv and OBMC --%>
                case "5":
                    break;
                <%-- AMI and OBMC --%>
                case "6":
                    $("#VirtualMedia").remove();
                    break;
                <%-- default --%>
                default:
                    break;
            }
		};
		
		/*William 2018/12/11: remove the alert message of the boot mode.*/
		var startSetBootOption = function(ip) {
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData(document.forms.namedItem("getData"));
		    
			formData.append('IP', ip);
		    formData.append('Type', bootOption);
		    formData.append('Mode', $('#BootMode').find(":selected").text());
		    
		    $.ajax({
		    	url: 'SetGroupBootOption?' + csrfParameter + '=' + csrfToken,
		        type: 'POST',
		        data: formData,
		        success: function(_data, status, xhr) {
		        	$('#modal_loading').modal('hide');
		        	//alert("Boot Mode : [" + $('#BootMode').find(":selected").text() + "]\n" + "Setting Boot Option successfully.");
		        },
		        error: function(xhr, status, error) {
		        	$('#modal_loading').modal('hide');
		        	//alert("Boot Mode : [" + $('#BootMode').find(":selected").text() + "]\n" + "Setting Boot Option failed, please try again.");
		            console.log("Set group boot option failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
		    
		    showStatusModal = true;
		};
		
		var restoreBiosDefault = function(selectIP) {
			var r = confirm('<spring:message code="BiosDefault1"/>' + "\n" + '<spring:message code="BiosDefault2"/>' + "\n\n" + '<spring:message code="BiosDefault3"/>');
			
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData(document.forms.namedItem("getData"));
			
			$('#member').modal('hide');
			
			if (r) {
				showLoadingDialog(true);
				
			    formData.append('IP', selectIP);
			    formData.append('ID', '${ID}');
			    
			    $.ajax({
			    	url: 'RestoreGroupBiosDefault?' + csrfParameter + '=' + csrfToken,
			        type: 'POST',
			        data: formData,
			        success: function(_data, status, xhr) {
			        	var jsonObj = JSON.parse(xhr.responseText);
			        	showMsgDialog("Restore BIOS default", jsonObj.statusMsg, jsonObj.status);
			        },
			        error: function(xhr, status, error) {
			        	showMsgDialog("Upload file failed:", "[" + xhr.status + "] " + xhr.statusText, false);
					},
			        cache: false,
			        contentType: false,
			        processData: false
			    });
			}
			
			showStatusModal = true;
		};
		
		var action = function() {
			var selectIP = [];
			var seconds = $("#Seconds option:selected").val();
			
			$("#member").modal("hide");
			
			for (var i = 0;i < $('[name="addIP"]').length;i++) {
				if ($('[name="addIP"]')[i].checked)
					selectIP.push($('[name="addIP"]')[i].value);
			}
			
			/*William 2018/12/11: Make it judge the correct data type.*/
			var optionNum = parseInt(option)
			if (optionNum < 4) {
				$('#modal_loading').modal('show');
				window.location.href = "./SetGroupChassis?ID=" + '${ID}' + "&Type=power&IP=" + selectIP + "&Option=" + option;
			} else if (optionNum === 4) {
				$('#modal_loading').modal('show');
				window.location.href = "./SetGroupChassis?ID=" + '${ID}' + "&Type=identify&IP=" + selectIP + "&Time=" + seconds;
			} else if (optionNum === 5)  {
				$('#modal_loading').modal('show');
				startSetBootOption(selectIP);
			} else if (optionNum === 6)
				restoreBiosDefault(selectIP);
		};
		
		var getBootOption = function(objButton) {
			bootOption = objButton.id;
		};
		
		var showLoadingDialog = function(show, delay) {
			if (!delay)
				delay = 0;
			
			setTimeout(function() {
				if (show)
					$('#modal_loading').modal('show');
				else
					$('#modal_loading').modal('hide');
			}, delay);
		};
		
		var randomID = function(idLength) {
		    var id = "";
		    
		    if (!idLength || idLength === "")
		    	idLength = 10;
			
		    for (var i = 0;i < idLength;i++) {
		    	switch (Math.floor(Math.random() * 3 + 1)) {
			    	case 1:
			    		//0~9
			    		id += Math.floor((Math.random() * 10));
			    		break;
			    	case 2:
			    		//A~Z
			    		id += String.fromCharCode(Math.floor((Math.random() * 26) + 65));
			    		break;
			    	case 3:
			    		//a~z
			    		id += String.fromCharCode(Math.floor((Math.random() * 26) + 97));
			    		break;
			    }
		    }
		    
		    return id;
		};
		
		var showMsgDialog = function(title, msg, success, delay) {
			if (!delay)
				delay = 0;
			
			setTimeout(function() {
				var id = randomID(8);
				
				showLoadingDialog(false);
				
				$("body").append('<div class="modal fade modal_msg" id="' + id + '" tabindex="-1" role="dialog">' + $("#modal_msg").html() + '</div>');
				$("#" + id).find("h4[name='modal_msg_title']").text(title);
				$("#" + id).find("p[name='modal_msg_msg']").text(msg);
				
				if (success)
					$("#" + id + ">div>div").addClass("success");
				else
					$("#" + id + ">div>div").addClass("fail");
				
				$("#" + id).on("hidden.bs.modal", function() {
					$("#" + id).remove();
					$("body").css("padding-right", "");
				});
				
				$("#" + id).modal("show");
			}, delay);
		};
		
		var bmcUtil =  function(option) {
			var selectIP = [];
			var url = "";
			var fileData = "";
			var bmcFwType = "";
			
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData;
			
			switch (option) {
				case "Reboot":
					$("#groupRebootBMC").modal("hide");
					
					url = "SetGroupBMCUtil";
					
					for (var i = 0;i < $('[name="rebootIP"]').length; i++) {
						if ($('[name="rebootIP"]')[i].checked)
							selectIP.push($('[name="rebootIP"]')[i].value);
					}
					
					break;
				case "Restore":
					$("#groupRestoreBMC").modal("hide");
					
					url = "UploadGroupBMCUtil";
					fileData = "getData3";
					
					for(var i = 0;i < $('[name="restoreIP"]').length; i++) {
						if ($('[name="restoreIP"]')[i].checked)
							selectIP.push($('[name="restoreIP"]')[i].value);
					}
					
					break;
				case "Backup":
					$("#groupBackupBMC").modal("hide");
					
					url = "SetGroupBMCUtil";
					
					for(var i = 0;i < $('[name="backupIP"]').length; i++) {
						if ($('[name="backupIP"]')[i].checked)
							selectIP.push($('[name="backupIP"]')[i].value);
					}
					
					break;
				case "BIOSimport":
					$("#groupImportBios").modal("hide");
					
					url = "UploadGroupBMCUtil";
					fileData = "getData2";
					bmcFwType = biosSetupType;
					
					for(var i = 0;i < $('[name="importIP"]').length; i++) {
						if ($('[name="importIP"]')[i].checked)
							selectIP.push($('[name="importIP"]')[i].value);
					}
					
					break;
				case "BIOSexport":
					$("#groupExportBios").modal("hide");
					
					url = "SetGroupBMCUtil";
					
					for(var i = 0;i < $('[name="exportIP"]').length; i++) {
						if ($('[name="exportIP"]')[i].checked)
							selectIP.push($('[name="exportIP"]')[i].value);
					}
					
					break;
			}
			
			if (url === "")
				return;
			
			showLoadingDialog(true);
			
			if(fileData === "")
				formData = new FormData();
			else
				formData = new FormData(document.forms.namedItem(fileData));
		    formData.append("IP", selectIP);
		    formData.append("ID", "${ID}");
		    formData.append("Option", option);
		    formData.append("bmcFwType", bmcFwType);
		    
			$.ajax({
		        url: url + "?" + csrfParameter + "=" + csrfToken,
		        type: 'POST',
		        data: formData,
				dataType: 'json',
		        success: function(_data, status, xhr) {
		        	var jsonObj = JSON.parse(xhr.responseText);
		        	
		        	if (jsonObj.status)
		        		showMsgDialog(option + " " + "success", "", jsonObj.status);
		        	else
		        		showMsgDialog(option + " " + "fail", jsonObj.statusMsg, jsonObj.status);
		        },
		        error: function(xhr, status, error) {
		        	showMsgDialog(option + " failed:", "[" + xhr.status + "] " + xhr.statusText, false);
		            console.log(option + " failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
			
			showStatusModal = true;
		};
		
		var SetNodeVmcli = function(selectIP) {
			var port = $("#port").val();
			var files = [];
			
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData();
			
			showLoadingDialog(true);
			
			$("input[name='file_select']:checked").each(function() {
		    	files.push($(this).val());
		    });
			
			$("input[name='deviceChoose']:checked").each(function() {
		    	files.push($(this).val());
		    });
		   
			formData.append('ID', '${ID}');
		    formData.append('IP', selectIP);
		    formData.append('Action', vmcliBehavior);
		    formData.append('Port', port);
		    formData.append('Files', files);
		    
		    $.ajax({
		    	url: 'SetGroupVmcli?' + csrfParameter + '=' + csrfToken,
		        type: 'POST',
		        data: formData,
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	var jsonObj = JSON.parse(xhr.responseText);
		        	showMsgDialog(vmcliBehavior, jsonObj.statusMsg, jsonObj.status);
		        },
		        error: function(xhr, status, error) {
		        	showMsgDialog("Set Virtual Media failed:", "[" + xhr.status + "] " + xhr.statusText, false);
		            console.log("Set Virtual Media failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false,
		        contentType: false,
		        processData: false
		    });
		    
		    showStatusModal = true;
		};
		
		var setting = function() {
			var selectIP = [];
			
			for (var i = 0;i < $('[name="mountIP"]').length;i++) {
				if ($('[name="mountIP"]')[i].checked)
					selectIP.push($('[name="mountIP"]')[i].value);
			}
			
			if (!($('input[name=file_select]:checked', '#imageFiles').val()) && 
					!($('input[name=deviceChoose]:checked', '#imageFiles').val()) && 
					vmcliBehavior !== "umount")
				alert("<spring:message code="NodeVmcli8"/>");	  
			else if (escape($('input[name=file_select]:checked', '#imageFiles').val()).indexOf("%u") !== -1 || 
					escape($('input[name=deviceChoose]:checked', '#imageFiles').val()).indexOf("%u") !== -1)
				alert("<spring:message code="NodeVmcli9"/>");
			else
				SetNodeVmcli(selectIP);
			
			$('#vmcliMount').modal('hide');
		};
		
		var setNTP = function() {
			var selectIP = [];
			for (var i = 0;i < $('[name="addIP"]').length;i++) {
				if ($('[name="addIP"]')[i].checked)
					selectIP.push($('[name="addIP"]')[i].value);
			}
			
	    	var operationMode = parseInt($("#OperationMode").val());
	    	var ntp_1 = $("#NTP_1").val();
	    	var ntp_2 = $("#NTP_2").val();
    		var ntp_3 = $("#NTP_3").val();
    		var updateFrequency = parseInt($("#UpdateFrequency").val());
	    	var timeSynchronizationMethod = parseInt($("input[name='TimeSynchronizationMethod']:checked").val());
	    	
	    	switch(operationMode) {
		    	default:
		    	case 0: {
		    		ntp_1 = "";
	    	    	ntp_2 = "";
	        		ntp_3 = "";
	    			updateFrequency = 3;
	    			timeSynchronizationMethod = 1;
		    		break;
		    	}
		    	case 2: {
		    		if((ntp_1 === "") && (ntp_2 === "") && (ntp_3 === "")) {
	    	    		alert("At least one NTP server must be set");
	    	    		return;
	    	    	}
		    		
		    		if((operationMode === 2) && !(updateFrequency > 0)) {
	    	    		alert("Update Frequency can't be empty or 0");
	    	    		return;
	    	    	}
		    		break;
		    	}
		    	case 1: {
		    		if((ntp_1 === "") && (ntp_2 === "") && (ntp_3 === "")) {
	    	    		alert("At least one NTP server must be set");
	    	    		return;
	    	    	}
	    	    	
		    		updateFrequency = 3;
		    		break;
		    	}
	    	}
			
			window.location.href = "./SetGroupTimeSetting?" + 
									"IP=" + selectIP.toString() + 
									"&operationMode=" + operationMode + 
									"&ntp_1=" + ntp_1 + 
									"&ntp_2=" + ntp_2 + 
									"&ntp_3=" + ntp_3 + 
									"&updateFrequency=" + updateFrequency + 
									"&timeSynchronizationMethod=" + timeSynchronizationMethod + 
									"&ID=" + ${ID};
	    };
		
		var checkStatus = function() {
			$.ajax({
		        url: 'GroupRemoteAccessStatus',
		        dataType: 'json',
		        data: {"ID": "${ID}"},
		        success: function(_data, status, xhr) {
		        	var i = 0;
		        	var htmlString;
		        	
					$("#groupStatusTablesBody").empty();
					$('#groupStatusTablesBody').append('<tr id="new0"></tr>');
					
					for (var ip in _data) {
						if (_data.hasOwnProperty(ip)) {
							htmlString = "<td>" + ip + "</td>";
							htmlString += "<td>" + _data[ip].action + "</td>";
							
							if (_data[ip].status.indexOf("Success") !== -1) {
								if (_data[ip].action === "BIOSexport" || _data[ip].action === "Backup")
									htmlString += "<td><button type=\"button\" onclick=\"downloadFile('" + ip + "', '" + _data[ip].action + "')\" class=\"btn btn-primary\">" + 
										'<spring:message code="Download"/>' + "</button></td>";
								else
									htmlString += "<td><b><i><font color=\"green\">" + _data[ip].status + "</font></i></b></td>";
							} else if (_data[ip].status.indexOf("Failed") !== -1) {
								if (_data[ip].action === "BIOSexport" || _data[ip].action === "Backup")
									htmlString += "<td><button type=\"button\" onclick=\"downloadFile('" + ip + "', '" + _data[ip].action + "')\" class=\"btn btn-primary\" disabled>" + 
										'<spring:message code="Download"/>' + "</button></td>";
								else
									htmlString += "<td><b><i><font color=\"red\">" + _data[ip].status + "</font></i></b></td>";
							} else {
								if (_data[ip].action === "BIOSexport" || _data[ip].action === "Backup")
									htmlString += "<td><button type=\"button\" onclick=\"downloadFile('" + ip + "', '" + _data[ip].action + "')\" class=\"btn btn-primary\" disabled>" + 
										_data[ip].status + "</button></td>";
								else
									htmlString += "<td><b><i><font>" + _data[ip].status + "</font></i></b></td>";
							}
							
							$('#new' + i).html(htmlString);
							$('#groupStatusTablesBody').append('<tr id="new' + (i + 1) + '"></tr>');
							i++;
						}
					}
					
					if (showStatusModal) {
						$('#groupStatus').modal('show');
						showStatusModal = false;
					}
					
					setTimeout(checkStatus, 1000);
		        },
		        error: function(xhr, status, error) {
		            console.log("Get group remote access status failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		};
		
		var downloadFile = function(ip, option) {
			window.location.href = "./DownloadBMCUtil?IP=" + ip + "&Option=" + option;
		};
	
		$(document).ready(function() {
			checkStatus();
			checkSupport();
			
			if($("#OperationMode option:selected").text() === "Disabled"){
				$("#NTPsetting input[type=radio]").attr('disabled', true);
				$("#NTPsetting input[type=text]").attr('disabled', true);
			}
		});
		
		$("#modalCheckBox input[type='checkbox']").click(function() {
			if ($("#modalCheckBox input[type='checkbox']").is(":checked"))
				$("button[ID=addBtn]").prop('disabled', false);
			else
				$("button[ID=addBtn]").prop('disabled', true);
		});
		
		$('#testtop button').click(function() {
			option = this.value;
		});
		
		$('#imageFiles button').click(function() {
			vmcliBehavior = this.value;
		});
		
		$("#OperationMode").on('change', function(){
			var mode = $("#OperationMode option:selected").text(); 
			
			switch (mode) {
				case "Daemon Mode":
					$("#NTPsetting input[type=radio]").attr('disabled', true);
					$("#NTPsetting input[type=text]").attr('disabled', false);
					$("#NTPsetting input[type=text][id=UpdateFrequency]").attr('disabled', true);
					break;
				case "Disabled":
					$("#NTPsetting input[type=radio]").attr('disabled', true);
					$("#NTPsetting input[type=text]").attr('disabled', true);
					break;
				case "Requested Mode":
					$("#NTPsetting input[type=radio]").attr('disabled', false);
					$("#NTPsetting input[type=text]").attr('disabled', false);
					break;
			}
		});
		
		$('.btn-file :file').on({
			'change': function() {
       			biosSetupType = "";
				var numFiles = $(this).get(0).files ? $(this).get(0).files.length : 1;
				var label = $(this).val().replace(/\\/g, '/').replace(/.*\//, '');
				$(this).trigger('fileselect', [numFiles, label]);
				
				if(numFiles > 0) {
	       			var filenameExt = "";
	           		var filenameArray = $(this).get(0).files[0].name.split("\.");
	           		if(filenameArray.length > 0)
	           			filenameExt = filenameArray[filenameArray.length-1];
	           		
	           		if((filenameExt.toLowerCase() !== "json") || ($(this).get(0).files[0].type != "application/json")) {
	           			alert('<spring:message code="NodeRemoteBIOSSetup8"/>');
	           			$(this).parents('.btn-group').find('button[data-target="#groupImportBios"]').prop("disabled", true);
	           			return;
	           		}
	           		
	           		var that = $(this);
	           		var reader = new FileReader();
	                reader.onload = function(e) {
	                	try {
	                    	var jsonObj = JSON.parse(this.result);
	                   		if(('@odata.id' in jsonObj) && 
	                   		   ('Attributes' in jsonObj) && 
	                   		   (Object.keys(jsonObj.Attributes).length > 0))
	                   		{
	                   			biosSetupType = "AMI";
	                   		}
	                   		else if(!('@odata.id' in jsonObj) && 
	                   				('RegistryEntries' in jsonObj) && 
	                   				('Attributes' in jsonObj.RegistryEntries) && 
	 	                   			(Object.keys(jsonObj.RegistryEntries.Attributes).length > 0))
                   			{
	                   			biosSetupType = "Vertiv";
                   			}
	                    }
	                    catch(e) {
	                    	console.log("Parse the JSON file fail: " + e);
	                    }
	                    
	                    if(biosSetupType !== "") {
	                    	that.parents('.btn-group').find('button[data-target="#groupImportBios"]').prop("disabled", false);
	                    	$("#groupImportBios>.modal-dialog>.modal-content>.modal-body>div>table>tbody>tr").find("input[type='checkbox']").each(function() {
	                    		$(this).prop("checked", false);
	                    		$(this).prop("disabled", !($(this).attr("bmc-type") === biosSetupType));
	                    	})
	                    }
	                    else {
	                    	alert('<spring:message code="NodeRemoteBIOSSetup8"/>');
	                    	that.parents('.btn-group').find('button[data-target="#groupImportBios"]').prop("disabled", true);
	                    }
	                    
	                    console.log("Upload BIOS file type: " + biosSetupType);
	                }
	                reader.readAsText($(this).get(0).files[0]);
	       		}
	       		else {
	       			$(this).parents('.btn-group').find('button[data-target="#groupImportBios"]').prop("disabled", true);
	       		}
			},
			'fileselect': function(event, numFiles, label) {
				var input = $(this).parents('.input-group').find(':text');
				var log = numFiles > 1 ? numFiles + ' files selected' : label;
				        
				if (input.length)
					input.val(log);
				else {
					if (log) 
						alert(log);
				}
			}
		});
	</script>
</body>
</html>