<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <title>Node Alert Management</title>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <!-- CSS -->
        <link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
        <link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
        
        <!-- Javascript -->
        <script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
        <script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
        <script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
    </head>
    
    <body>
        <div id="wrapper">
            <div id="page-wrapper">
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="row page-title">
                        <div class="col-lg-12">
                            <h3 class="page-header">
                                <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>  
                            </h3>
                        </div>
                    </div>
                    <br>
                    
                    <!-- Trap -->
                    <sec:authorize access="hasAnyRole(${Access_Configuration})">
                    <div id="NodeTrap" class="row">
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4><spring:message code="NodeSetting11"/></h4>
                                </div>
                                <div class="panel-body">
                                    <!-- <div class="dataTable_wrapper">-->
                                        <table class="table table-striped table-bordered table-hover" id="trapDataTables">
                                            <thead>
                                                <tr>
                                                   <th><spring:message code="NodeSetting16"/></th>
                                                   <th><spring:message code="NodeSetting5"/></th>
                                                   <th><spring:message code="NodeSetting17"/></th>
                                                   <th><spring:message code="NodeSetting18"/></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                         </table>
                                    <button id="setTrap" type="button" onclick="setTrap()" class="btn btn-primary"><spring:message code="Submit"/></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    </sec:authorize>
                    <!-- Trap -->
                    
                    <!-- PEF -->
                    <!-- <sec:authorize access="hasAnyRole(${Access_Configuration})">
                    <div id="NodePEF" class="row">
                        <div class="col-lg-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4><spring:message code="NodePEF11"/> (PEF)</h4>
                                </div>
                                <div class="panel-body"> -->
                                    <!--<h4><spring:message code="NodePEF1"/></h4>-->
                                    <!--<div class="dataTable_wrapper">-->
                                        <!-- <table class="table table-striped table-bordered table-hover" style="display:none;">
                                            <thead>
                                                <tr><th><spring:message code="NodePEF4"/></th></tr>
                                            </thead>
                                            <tbody>
                                                <c:choose>
                                                    <c:when test="${BmcType == 'RMC'}">
                                                        <tr style="display:none;"><td><input type="checkbox" id="action1" value="0"> <spring:message code="NodePEF7"/></td></tr>
                                                        <tr style="display:none;"><td><input type="checkbox" id="action2" value="1"> <spring:message code="NodePEF8"/></td></tr>
                                                        <tr style="display:none;"><td><input type="checkbox" id="action3" value="2"> <spring:message code="NodePEF9"/></td></tr>
                                                    </c:when>
                                                    <c:otherwise>
                                                        <tr><td><input type="checkbox" id="action1" value="0"> <spring:message code="NodePEF7"/></td></tr>
                                                        <tr><td><input type="checkbox" id="action2" value="1"> <spring:message code="NodePEF8"/></td></tr>
                                                        <tr><td><input type="checkbox" id="action3" value="2"> <spring:message code="NodePEF9"/></td></tr>
                                                    </c:otherwise>
                                                </c:choose>
                                                <tr><td><input type="checkbox" id="action4" value="3"> <spring:message code="NodePEF10"/></td></tr>
                                            </tbody>
                                        </table> -->
                                    <!--</div>-->
                                    <!--<br>-->
                                    <!-- <h4><spring:message code="NodePEF12"/></h4>
                                    <input type="checkbox" id="enable"> <spring:message code="NodePEF3"/><br>
                                    <div class="dataTable_wrapper">
                                        <table class="table table-striped table-bordered table-hover" id="pefDataTables">
                                            <thead>
                                                <tr>
                                                    <th><spring:message code="NodePEF5"/></th>
                                                    <c:choose>
                                                        <c:when test="${BmcType == 'RMC'}">
                                                            <th style="display:none;"><spring:message code="NodePEF6"/></th>
                                                            <th style="display:none;"><spring:message code="NodePEF7"/></th>
                                                            <th style="display:none;"><spring:message code="NodePEF8"/></th>
                                                            <th style="display:none;"><spring:message code="NodePEF9"/></th>
                                                            <th width="50%"><spring:message code="NodePEF10"/></th>
                                                        </c:when>
                                                        <c:otherwise>
                                                            <th><spring:message code="NodePEF6"/></th>
                                                            <th><spring:message code="NodePEF7"/></th>
                                                            <th><spring:message code="NodePEF8"/></th>
                                                            <th><spring:message code="NodePEF9"/></th>
                                                            <th><spring:message code="NodePEF10"/></th>
                                                        </c:otherwise>
                                                    </c:choose>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                    <br>
                                    <button type="button" onclick="setPEF()" class="btn btn-primary"><spring:message code="Submit"/></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    </sec:authorize> -->
                    <!-- PEF -->
                </div>
            </div>
        </div>
        
        <sec:authorize access="!hasAnyRole(${Access_Configuration})" var="var_not_Access_Configuration"/>
        <script>
            /* Trap */
            var trapDataTables;
            var changeTrapIpType = true;
            $(document).ready(function() {
                trapDataTables = $('#trapDataTables').DataTable({
                    "searching": false, 
                     "bFilter": false,
                     "bSort": false,
                     "paging": false,
                     info: false,
                     responsive: true,
                     "scrollX": false
                });
                getNodeTrap(true);
            });
            
            /*William 2018/11/29: Avoid setting related parameters when Enable is off*/
            $("#trapDataTables>tbody").delegate("input[name=trapCheckbox]", "switchChange.bootstrapSwitch", function() {
                var id = $(this).attr("id");
                var textID = id + "_addr";
                var radioIpv4ID = id + "_trapIpv4";
                var radioIpv6ID = id + "_trapIpv6";
                var noIPv4 = "0.0.0.0";
                var noIPv6 = "::";
                if ($("#" + id).is(":checked")) {
                    $("input[id=" + textID + "]").prop("disabled", false);
                    if(changeTrapIpType) {
                        $("input[id=" + radioIpv4ID + "]").prop("disabled", false);
                        $("input[id=" + radioIpv6ID + "]").prop("disabled", false);
                    }
                }
                else {
                    if (document.getElementById(radioIpv4ID).checked) {
                        $("input[id=" + textID + "]").val(noIPv4);
                    } else {
                        $("input[id=" + textID + "]").val(noIPv6);
                    }
                    $("input[id=" + textID + "]").prop("disabled", true);
                    if(changeTrapIpType) {
                        $("input[id=" + radioIpv4ID + "]").prop("disabled", true);
                        $("input[id=" + radioIpv6ID + "]").prop("disabled", true);
                    }
                }
            });
            
            $("#trapDataTables>tbody").delegate("input[type='radio'][name^='trapRadios']", "change", function() {
                if($(this).val() === "IPv4")
                    $("#" + $(this).attr("id").replace("_trapIpv4", "") + "_addr").val("0.0.0.0");
                else
                    $("#" + $(this).attr("id").replace("_trapIpv6", "") + "_addr").val("::");
            });
            
            function getNodeTrap(first) {
                if(first) {
                    nodeTrapListLoading(true);
                }
                
                $.ajax({
                    url: 'getNodeTrap',
                    data: {nodeIP:'${IP}'},
                    dataType: 'json',
                    success: function(_data, status, xhr) {
                        if(_data.dataArray.length > 0) {
                            changeTrapIpType = !_data.isAST2400;
                            
                            var trapArray = [];
                            for(var i=0 ; i<_data.dataArray.length ; i++) {
                                trapArray.push([_data.dataArray[i].trapID,
                                                '<input name="trapCheckbox" type="checkbox" id="check' + (i+1) + '" data-size="mini" ' + (_data.dataArray[i].trapEnabled === 'true' ? 'checked' : '') + '>',
                                                '<input type="radio" name="trapRadios' + (i+1) + '" id="check' + (i+1) + '_trapIpv4" value="IPv4" ' + (_data.dataArray[i].trapIpType === 'IPv4' ? 'checked' : '') + ' ' + ((changeTrapIpType && (_data.dataArray[i].trapEnabled === 'true')) ? '' : 'disabled') + '>&nbsp;&nbsp;&nbsp;' + 
                                                '<input type="radio" name="trapRadios' + (i+1) + '" id="check' + (i+1) + '_trapIpv6" value="IPv6" ' + (_data.dataArray[i].trapIpType === 'IPv6' ? 'checked' : '') + ' ' + ((changeTrapIpType && (_data.dataArray[i].trapEnabled === 'true')) ? '' : 'disabled') + '>',
                                                '<input type="text" id="check' + (i+1) + '_addr" value="' + _data.dataArray[i].trapDestination + '" ' + (_data.dataArray[i].trapEnabled === 'true' ? '' : 'disabled') + '>']);
                            }
                            
                            nodeTrapListLoading(false, trapArray);
                        }
                        else {
                            nodeTrapListLoading(false);
                        }
                    },
                    error: function(xhr, status, error) {
                        nodeTrapListLoading(false);
                        console.log("Get the node IP trap failed: [" + xhr.status + "] " + xhr.statusText);
                    },
                    cache: false
                });
            }
            
            function nodeTrapListLoading(start, dataArray) {
                if(start) {
                    $("#trapDataTables>tbody").html("<tr><td colspan='4' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
                }
                else {
                    setTimeout(function(){
                        if($("#trapDataTables>tbody>tr>td").attr("colspan") == 4)
                            trapDataTables.clear().draw(false);
                        if((dataArray != null) && (dataArray.length > 0)) {
                            trapDataTables.rows.add(dataArray).draw(false);
                            for(var i=0 ; i<dataArray.length ; i++)
                                $("#check" + (i+1)).bootstrapSwitch();
                        }
                        else {
                            $("#trapDataTables>tbody").html("<tr><td colspan='4'>Get Trap destination failed</td></tr>");
                            $("#setTrap").remove();
                        }
                    }, 100);
                }
            }
            
            /*William 2018/11/29: Avoid empty strings and add the setting value of IP Type*/
            function setTrap() {
                var ipEnable = [], trapIpRadios = [], ipDestination = [];
                for (var i=1; i<=$('#trapDataTables>tbody>tr').length ; i++) {
                    var id = "check" + i;
                    var textID = id + "_addr";
                    var radioIpv4ID = id + "_trapIpv4";
                    var radioIpv6ID = id + "_trapIpv6";
                    var noIP = "0.0.0.0";
                    var ip = document.getElementById(textID).value;
                    
                    if (ip == "") {
                        ip = noIP;
                    }
                    
                    if (document.getElementById(radioIpv4ID).checked) {
                        trapIpRadios.push("IPv4");
                    }
                    else {
                        trapIpRadios.push("IPv6");
                    }
                    
                    if ( /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\-]*[A-Za-z0-9])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ip) ) {
                        if (ip == noIP) {
                            ipEnable.push(false);
                        }
                        else {
                            ipEnable.push(document.getElementById(id).checked);
                        }
                        ipDestination.push(ip);
                    }
                    else {
                        alert("<spring:message code="NodeSetting3"/>" + i + ": <spring:message code="NodeSetting8"/>");
                        return;
                    }
                }
                
                var Paras = "&ipEnable=" + ipEnable + "&ipType=" + trapIpRadios + "&ipDestination=" + ipDestination;
                window.location.href = "./NodeAlertManagement_SetTrap?IP=" + '${IP}' + Paras;
            }
            
            /* PEF */
            /*var pefErrCode;
            var pefGlobalAlert;
            var pefGlobalAction;
            var sensorAction = [];
            var numOfFilter;
            var pefDataTables;
            $(document).ready(function() {
                pefDataTables = $('#pefDataTables').DataTable({
                     "searching": false, 
                     "bFilter": false,
                     "bSort": false,
                     "paging": false,
                     info: false,
                     responsive: true,
                     "scrollX": false,
                     "createdRow": function( row, data, dataIndex ) {
                        $(row).attr('id', 'filters');
                     }
                });
                
                if("${BmcFirmwareType}" != "Vertiv") {
                    $("#NodePEF").remove();
                    console.log("${BmcFirmwareType} not support the PEF function");
                    return;
                }
                getNodePEF(true);
            });
            
            $("#NodePEF").delegate("input[type=checkbox]", "change", function() {
                var id = $(this).attr("id");
                if( id.indexOf("action") != -1 ) {
                    var index;
                    
                    if( id.localeCompare('action1') == 0 ) {
                        index = "1";
                    }
                    else if( id.localeCompare('action2') == 0 ) {
                        index = "2";
                    }
                    else if( id.localeCompare('action3') == 0 ) {
                        index = "3";
                    }
                    else {
                        index = "4";
                    }
                    for (var i = 0; i<numOfFilter; i++) {
                        if(this.checked) {
                            $("input[id=radios" + index + (i+1)).prop("disabled", false);
                        } else {
                            $("input[id=radios" + index + (i+1)).prop("disabled", true);
                        }
                    }
                }
            });
            
            function setGlobalAction() {
                if( (pefGlobalAction & 0x04) == 0x04 )
                    document.getElementById("action1").checked = true;
                
                if( (pefGlobalAction & 0x08) == 0x08 )
                    document.getElementById("action2").checked = true;
                
                if( (pefGlobalAction & 0x02) == 0x02 )
                    document.getElementById("action3").checked = true;
                
                if( (pefGlobalAction & 0x01) == 0x01 )
                    document.getElementById("action4").checked = true;  
            }
            
            function setFilterAction() {
                for (var i = 0; i < numOfFilter; i++) {
                    <sec:authorize ifAnyGranted="${Access_Configuration}">
                        for (var j = 0; i < 4; i ++) {
                        var tag = "action" + i;
                        if (document.getElementById(tag).checked == true) {
                            $("input[id=radios" + (i+1) + (i+1)).prop("disabled", false);
                        }
                        else {
                            $("input[id=radios" + (i+1) + (i+1)).prop("disabled", true);
                        }
                    }
                    </sec:authorize>
                if( sensorAction[i] <= 0x01 )
                    document.getElementById("radios0" + (i+1)).checked = true;
                
                if( (sensorAction[i] & 0x04) == 0x04 )
                    document.getElementById("radios1" + (i+1)).checked = true;
                
                if( (sensorAction[i] & 0x08) == 0x08 )
                    document.getElementById("radios2" + (i+1)).checked = true;
                
                if( (sensorAction[i] & 0x02) == 0x02 )
                    document.getElementById("radios3" + (i+1)).checked = true;
                
                if( (sensorAction[i] & 0x01) == 0x01 )
                    document.getElementById("radios4" + (i+1)).checked = true;
                }
            }
            
            function getNodePEF(first) {
                if(first) {
                    nodePEFListLoading(true);
                }
                
                $.ajax({
                    url: 'getNodePEF',
                    data: {nodeIP:'${IP}'},
                    dataType: 'json',
                    success: function(_data, status, xhr) {
                        if(_data.length > 0) {
                            var rmcPEFArray = [];
                            var pefArray = [];
                            numOfFilter = _data.length;
                            pefErrCode = _data[0].errCode;
                            pefGlobalAlert = _data[0].globalAlert;
                            pefGlobalAction = _data[0].globalAction;
                            if( pefErrCode != 0 )
                                alert("<spring:message code="webErrMsg20"/>");
                            
                            if ((pefGlobalAlert & 0x20) == 0x20) {
                                document.getElementById("enable").checked = false;
                            }
                            else {
                                document.getElementById("enable").checked = true;
                            }
                            setGlobalAction();
                            
                            for(var i=0 ; i<_data.length ; i++) {
                                sensorAction[i] = _data[i]["sensorAction" + (i+1)];
                                rmcPEFArray.push([_data[i]["sensorName" + (i+1)],
                                                 '<input type="radio" name="radios' + (i+1) + '" id="radios0' + (i+1) + '" style="display:none;"> None',
                                                 '<input type="radio" name="radios' + (i+1) + '" id="radios1' + (i+1) + '" style="display:none;"> Reboot',
                                                 '<input type="radio" name="radios' + (i+1) + '" id="radios2' + (i+1) + '" style="display:none;"> Power Cycle',
                                                 '<input type="radio" name="radios' + (i+1) + '" id="radios3' + (i+1) + '" style="display:none;"> Power Off',
                                                 '<input type="checkbox" id="radios4' + (i+1) + '" width="50%">']);
                                pefArray.push([_data[i]["sensorName" + (i+1)],
                                              '<input type="radio" name="radios' + (i+1) + '" id="radios0' + (i+1) + '"> None',
                                              '<input type="radio" name="radios' + (i+1) + '" id="radios1' + (i+1) + '"> Reboot',
                                              '<input type="radio" name="radios' + (i+1) + '" id="radios2' + (i+1) + '"> Power Cycle',
                                              '<input type="radio" name="radios' + (i+1) + '" id="radios3' + (i+1) + '"> Power Off',
                                              '<input type="checkbox" id="radios4' + (i+1) + '">']);
                            }
                            if ("${BmcType}" == "RMC") {
                                nodePEFListLoading(false, rmcPEFArray);
                            }
                            else {
                                nodePEFListLoading(false, pefArray);
                            }
                        }
                        else {
                            nodePEFListLoading(false);
                        }
                    },
                    error: function(xhr, status, error) {
                        nodePEFListLoading(false);
                        console.log("Get the node PEF failed: [" + xhr.status + "] " + xhr.statusText);
                    },
                    cache: false
                });
            }
            
            function nodePEFListLoading(start, dataArray) {
                var nextId = "filter";
                if(start) {
                    $("#pefDataTables>tbody").html("<tr><td colspan='6' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
                }
                else {
                    setTimeout(function(){
                        if($("#pefDataTables>tbody>tr>td").attr("colspan") == 4)
                            pefDataTables.clear().draw(false);
                        if(dataArray != null){
                            pefDataTables.rows.add(dataArray).draw(false);
                            setFilterAction();
                            //Terry, 20170818, Don't show the items with "Unknown Filter"
                            for (var i = 0;i < numOfFilter;i++) {
                                $("#filters").attr('id', 'filters' + i);
                                if ($("#filters" + i).text().indexOf("Unknown Filter") > 0)
                                    $("#filters" + i).hide();
                            }
                        }
                    }, 100);
                }
            }
            
            function setPEF() {
                var action = [];
                for(var i=1; i<=4; i++) {
                    var tag = "action" + i;
                    if( document.getElementById(tag).checked == true )
                        action.push(document.getElementById(tag).value);
                }
                
                var value = 0x00;
                for(var i=0; i<action.length; i++) {
                    if( action[i] == 0 )
                        value = value + 0x04;
                    else if( action[i] == 1 )
                        value = value + 0x08;
                    else if( action[i] == 2 )
                        value = value + 0x02;
                    else
                        value = value + 0x01;
                }
                
                var enable = $("#enable").is(":checked");
                
                var filterAction = [];
                for (var i = 0; i<numOfFilter; i++) {
                    var filterValue = 0x00;
                    if( document.getElementById("radios0" + (i+1)).checked == true )
                        filterValue = filterValue + 0x00;
                    else if( document.getElementById("radios1" + (i+1)).checked == true )
                        filterValue = filterValue + 0x04;
                    else if( document.getElementById("radios2" + (i+1)).checked == true )
                        filterValue = filterValue + 0x08;
                    else if( document.getElementById("radios3" + (i+1)).checked == true )
                        filterValue = filterValue + 0x02;
                    
                    if( document.getElementById("radios4" + (i+1)).checked == true )
                        filterValue = filterValue + 0x01;
                    
                    filterAction.push(filterValue);
                }
                var Paras = "&globalEnable=" + enable + "&globalAction=" + value + "&filterAction=" + filterAction;
                window.location.href = "./NodeAlertManagement_SetPEF?IP=" + '${IP}' + Paras;
            }*/
        </script>
    </body>
</html>
