<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=BIG5">
	<title>Node Software</title>
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	
	<style>
		td {
			width: 50%;
		}
	</style>
</head>

<body>
	<div id="wrapper">
        <div id="page-wrapper">
            <div class="container-fluid">
                <!-- Page Heading -->
                <div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
				<br>
				
                <sec:authorize access="hasAnyRole(${Access_GetInfo})">
				<div class="row">
				   	<div id="mainFrame" class="col-lg-12">
				   		<div id="NodeAgentStatus" class="row">
							<div class="col-lg-12">
								<div class="panel panel-default">
									<div class="panel-body">
										<h4><spring:message code="NodeInformation4"/>:&nbsp;<span id="statusStr"></span></h4>
									</div>
								</div>
							</div>
						</div>
				   	
				   		<div id="systemRow" class="row" style="display:none;">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1><spring:message code="NodeInformation1"/></h1></th></tr>
								</thead>
								<tbody id="systemBody">
									<tr><td></td></tr>
								</tbody>
							</table>
						</div>
						
						<div id="networkRow" class="row" style="display:none;">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1><spring:message code="NodeInformation2"/></h1></th></tr>
								</thead>
								<tbody id="networkBody">
									<tr><td></td></tr>
								</tbody>
							</table>
						</div>
						
						<div id="pciRow" class="row" style="display:none;">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1><spring:message code="NodeInformation3"/></h1></th></tr>
								</thead>
								<tbody id="pciBody">
									<tr><td></td></tr>
								</tbody>
							</table>
						</div>
						
						<div id="raidHWRow" class="row" style="display:none;">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1>RAID Card <spring:message code="Information"/></h1></th></tr>
								</thead>
								<tbody id="raidHWInfo">
									<tr><td></td></tr>
								</tbody>
							</table>
						</div>
				   	
						<div id="smartRow" class="row" style="display:none;">
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1>RAID <spring:message code="Information"/></h1></th></tr>
								</thead>
								<tbody id="raidInfo">
									<tr><td></td></tr>
								</tbody>
							</table>
							<table class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1>SMART <spring:message code="Information"/></h1></th></tr>
								</thead>
								<tbody id="hddInfo">
									<tr><td></td></tr>
								</tbody>
							</table>
						</div>
					</div>
		 		</div>
		 		</sec:authorize>
		 	</div>
		 </div>
	</div>
	
	<script>
		$(document).ready(function() {
			checkAgentServiceAlive();
		});
		
		function checkAgentServiceAlive()
		{
			$("#statusStr").html("<i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw' style='font-size: 18px;'></i>");
			
			$.ajax({
				url: 'getAgentInfo',
				data: {bmcIP:'${IP}'},
				dataType: 'json',
				success: function(_data, status, xhr) {
					if(_data.isAlive) {
						getAgentData(_data.agentIP);
						getWebuiData(_data.agentIP);
					}
					else {
						getAgentData();
						getWebuiData();
					}
				},
				error: function(xhr, status, error) {
					getAgentData();
					getWebuiData();
		        	console.log("Get the Agent info failed: [" + xhr.status + "] " + xhr.statusText);
				}
			});
		}
		
		function getAgentData(agentIP)
		{
			if(agentIP != null) {
				$("#statusStr").html("On-line");
				$("#systemRow").show();
				$("#networkRow").show();
				$("#pciRow").show();
				getAgentSystem(agentIP);
				getAgentNetwork(agentIP);
				getAgentPCI(agentIP);
			}
			else {
				$("#statusStr").html("Off-line");
				$("#systemRow").remove();
				$("#networkRow").remove();
				$("#pciRow").remove();
			}
		}
		
		function getWebuiData(agentIP)
		{
			if("${BmcFirmwareType}" != "AMI") {
				$("#raidHWRow").remove();
				
				//Vertiv web UI data is sent from GSM Agent
				if(agentIP != null) {
					$("#smartRow").show();
					getSmartRAID("${IP}");
				}
				else {
					$("#smartRow").remove();
				}
			}
			else {
				$("#raidHWRow").show();
				$("#smartRow").remove();
				getRaidHWInfo("${IP}");
			}
		}
		
		function transferDate(longtime)
		{
			if (longtime != "") {
				var d = new Date(longtime * 1000),	// Convert the passed timestamp to milliseconds
					yyyy = d.getFullYear(),
					mm = ('0' + (d.getMonth() + 1)).slice(-2),	// Months are zero based. Add leading 0.
					dd = ('0' + d.getDate()).slice(-2),			// Add leading 0.
					hh = d.getHours(),
					h = hh,
					min = ('0' + d.getMinutes()).slice(-2),		// Add leading 0.
					time;
			
		
				// ie: 2013-02-18, 8:35 AM	
				time = yyyy + '-' + mm + '-' + dd + ', ' + h + ':' + min;
			
				return time;
			} else 
				return "";
		}
		
		function getAgentSystem(agentIP)
		{
			$("#systemBody").html("<tr><td style='padding-left: 8px !important; text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			
			$.ajax({
				url: 'getAgentSystem',
				data: {bmcIP:'${IP}', agentIP:agentIP, isAlive:true},
				dataType: 'json',
				success: function(_data, status, xhr) {
					try {
						var sys = '';
						if(!_data.hasOwnProperty("AccountError")) {
							sys += '<tr><td><strong><spring:message code="NodeInformation1-1"/></strong></td><td>' + _data.AgentSystem.system.os + '</td></tr>';
							sys += '<tr><td><strong><spring:message code="NodeInformation1-5"/></strong></td><td>' + _data.AgentSystem.system.cpu + '</td></tr>';
							sys += '<tr><td><strong><spring:message code="NodeInformation1-6"/></strong></td><td>' + _data.AgentSystem.system.memory + '</td></tr>';
							sys += '<tr><td><strong><spring:message code="NodeInformation1-2"/></strong></td><td>' + _data.AgentSystem.system.hostname + '</td></tr>';
							sys += '<tr><td><strong><spring:message code="NodeInformation1-7"/></strong></td><td>' + _data.AgentSystem.system.bmc + '</td></tr>';
							sys += '<tr><td><strong><spring:message code="NodeInformation1-3"/></strong></td><td>' + _data.AgentCPU.cpu.cpuUsage + '</td></tr>';
							sys += '<tr><td><strong><spring:message code="NodeInformation1-4"/></strong></td><td>' + _data.AgentMemory.memory.memoryUsage + '</td></tr>';
						}
						else {
							sys = '<tr><td><strong><spring:message code="NodeInformation5"/></strong></td></tr>';
						}
						$("#systemBody").html(sys);
					}
					catch(err) {
						$("#systemBody").html("<tr><td>N/A</td></tr>");
			        	console.log("Get the Agent system failed: " + err);
					}
				},
				error: function(xhr, status, error) {
					$("#systemBody").html("<tr><td>N/A</td></tr>");
		        	console.log("Get the Agent system failed: [" + xhr.status + "] " + xhr.statusText);
				}
			});
		}
		
		function getAgentNetwork(agentIP)
		{
			$("#networkBody").html("<tr><td style='padding-left: 8px !important; text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			
			$.ajax({
				url: 'getAgentNetwork',
				data: {bmcIP:'${IP}', agentIP:agentIP, isAlive:true},
				dataType: 'json',
				success: function(_data, status, xhr) {
					try {
						var net = '';
						if(!_data.hasOwnProperty("AccountError")) {
							if (typeof _data.AgentNetwork.network.length == "undefined") {
								net += '<tr><td colspan="2"><strong>' + _data.AgentNetwork.network.nic + '</strong></td></tr>';
								net += '<tr><td><spring:message code="NodeInformation2-2"/></td><td>' + _data.AgentNetwork.network.nicIPv4 + '</td></tr>';
								net += '<tr><td><spring:message code="NodeInformation2-3"/></td><td>' + _data.AgentNetwork.network.nicIPv6 + '</td></tr>';
								net += '<tr><td><spring:message code="NodeInformation2-4"/></td><td>' + _data.AgentNetwork.network.nicMAC + '</td></tr>';
								net += '<tr><td><spring:message code="NodeInformation2-5"/></td><td>' + _data.AgentNetwork.network.nicDes + '</td></tr>';
							} else {
								for (var i = 0;i < _data.AgentNetwork.network.length;i++) {
									net += '<tr><td colspan="2"><strong>' + _data.AgentNetwork.network[i].nic + '</strong></td></tr>';
									net += '<tr><td><spring:message code="NodeInformation2-2"/></td><td>' + _data.AgentNetwork.network[i].nicIPv4 + '</td></tr>';
									net += '<tr><td><spring:message code="NodeInformation2-3"/></td><td>' + _data.AgentNetwork.network[i].nicIPv6 + '</td></tr>';
									net += '<tr><td><spring:message code="NodeInformation2-4"/></td><td>' + _data.AgentNetwork.network[i].nicMAC + '</td></tr>';
									net += '<tr><td><spring:message code="NodeInformation2-5"/></td><td>' + _data.AgentNetwork.network[i].nicDes + '</td></tr>';
								}
								net = addScrollbar(net);
							}
						}
						else {
							net = '<tr><td><strong><spring:message code="NodeInformation5"/></strong></td></tr>';
						}
						$("#networkBody").html(net);
					}
					catch(err) {
						$("#networkBody").html("<tr><td>N/A</td></tr>");
			        	console.log("Get the Agent network failed: " + err);
					}
				},
				error: function(xhr, status, error) {
					$("#networkBody").html("<tr><td>N/A</td></tr>");
		        	console.log("Get the Agent network failed: [" + xhr.status + "] " + xhr.statusText);
				}
			});
		}
		
		function getAgentPCI(agentIP)
		{
			$("#pciBody").html("<tr><td style='padding-left: 8px !important; text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			
			$.ajax({
				url: 'getAgentPCI',
				data: {bmcIP:'${IP}', agentIP:agentIP, isAlive:true},
				dataType: 'json',
				success: function(_data, status, xhr) {
					try {
						var pci = '';
						if(!_data.hasOwnProperty("AccountError")) {
							if (typeof _data.AgentPCI.pci.length == "undefined") {
								pci += '<tr><td colspan="2"><strong>' + _data.AgentPCI.pci.pci + '</strong></td></tr>';
								pci += '<tr><td><spring:message code="NodeInformation3-2"/></td><td>' + _data.AgentPCI.pci.pciManu + '</td></tr>';
								pci += '<tr><td><spring:message code="NodeInformation3-3"/></td><td>' + _data.AgentPCI.pci.pciType + '</td></tr>';
							} else {
								for (var i = 0;i < _data.AgentPCI.pci.length;i++) {
									pci += '<tr><td colspan="2"><strong>' + _data.AgentPCI.pci[i].pci + '</strong></td></tr>';
									pci += '<tr><td><spring:message code="NodeInformation3-2"/></td><td>' + _data.AgentPCI.pci[i].pciManu + '</td></tr>';
									pci += '<tr><td><spring:message code="NodeInformation3-3"/></td><td>' + _data.AgentPCI.pci[i].pciType + '</td></tr>';
								}
							}
						}
						else {
							pci = '<tr><td><strong><spring:message code="NodeInformation5"/></strong></td></tr>';
						}
						$("#pciBody").html(addScrollbar(pci));
					}
					catch(err) {
						$("#pciBody").html("<tr><td>N/A</td></tr>");
			        	console.log("Get the Agent pci failed: " + err);
					}
				},
				error: function(xhr, status, error) {
					$("#pciBody").html("<tr><td>N/A</td></tr>");
		        	console.log("Get the Agent pci failed: [" + xhr.status + "] " + xhr.statusText);
				}
			});
		}
		
		function getRaidHWInfo(bmcIP)
		{
			$("#raidHWInfo").html("<tr><td style='padding-left: 8px !important; text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			
			$.ajax({
				url: 'getRaidHWInfo',
				data: {bmcIP:bmcIP},
				dataType: 'json',
				success: function(_data, status, xhr) {
					try {
						if((_data["Status"] != null) && _data["Status"] && (_data["RAIDInfo"].length > 0)) {
							var raidInfoObj = _data["RAIDInfo"][0];
							var appendInfoString = '';
							
							appendInfoString += '<tr><td><strong>Contoller ID</strong></td><td>'      + raidInfoObj.controller_id    + '</td></tr>';
							appendInfoString += '<tr><td><strong>Controller Name</strong></td><td>'   + raidInfoObj.controller_name  + '</td></tr>';
							appendInfoString += '<tr><td><strong>Serial Number</strong></td><td>'     + raidInfoObj.serial_number    + '</td></tr>';
							appendInfoString += '<tr><td><strong>Package Version</strong></td><td>'   + raidInfoObj.package_version  + '</td></tr>';
							appendInfoString += '<tr><td><strong>BIOS Version</strong></td><td>'      + raidInfoObj.bios_version     + '</td></tr>';
							appendInfoString += '<tr><td><strong>UEFI Version</strong></td><td>'      + raidInfoObj.uefi_version     + '</td></tr>';
							appendInfoString += '<tr><td><strong>Expander Version</strong></td><td>'  + raidInfoObj.expander_version + '</td></tr>';
							appendInfoString += '<tr><td><strong>Seeprom Version</strong></td><td>'   + raidInfoObj.seeprom_version  + '</td></tr>';
							appendInfoString += '<tr><td><strong>CPLD Version</strong></td><td>'      + raidInfoObj.cpld_version     + '</td></tr>';
							appendInfoString += '<tr><td><strong>PCI Vendor ID</strong></td><td>'     + raidInfoObj.pci_vendor_id    + '</td></tr>';
							appendInfoString += '<tr><td><strong>PCI Device ID</strong></td><td>'     + raidInfoObj.pci_device_id    + '</td></tr>';
							appendInfoString += '<tr><td><strong>PCI Sub-Vendor ID</strong></td><td>' + raidInfoObj.pci_subvendor_id + '</td></tr>';
							appendInfoString += '<tr><td><strong>PCI Sub-System ID</strong></td><td>' + raidInfoObj.pci_subsystem_id + '</td></tr>';
							appendInfoString += '<tr><td><strong>ROC Temp (C)</strong></td><td>'      + raidInfoObj.roc_temp         + '</td></tr>';
							appendInfoString += '<tr><td><strong>Expander Temp (C)</strong></td><td>' + raidInfoObj.expander_temp    + '</td></tr>';
							appendInfoString += '<tr><td><strong>Control Health</strong></td><td>'    + raidInfoObj.ctrl_health      + '</td></tr>';
							appendInfoString += '<tr><td><strong>TMM Size (MB)</strong></td><td>'     + raidInfoObj.tmm_status       + '</td></tr>';
							
							$("#raidHWInfo").html(appendInfoString);
						}
						else {
							$("#raidHWInfo").html("<tr><td>N/A</td></tr>");
						}
					}
					catch(err) {
						$("#raidHWInfo").html("<tr><td>N/A</td></tr>");
			        	console.log("Get the Raid HW failed: " + err);
					}
				},
				error: function(xhr, status, error) {
					$("#raidHWInfo").html("<tr><td>N/A</td></tr>");
		        	console.log("Get the Raid HW failed: [" + xhr.status + "] " + xhr.statusText);
				}
			});
		}
		
		function getSmartRAID(bmcIP)
		{
			$("#raidInfo").html("<tr><td style='padding-left: 8px !important; text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			$("#hddInfo").html("<tr><td style='padding-left: 8px !important; text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			
			$.ajax({
				url: 'getSmartRAID',
				data: {bmcIP:bmcIP},
				dataType: 'json',
				success: function(_data, status, xhr) {
					try {
						if (_data.MDU.length > 0 && (_data.MDU != null) && (JSON.stringify(_data.MDU) != '[]')) {
							var appendInfoString = '';
							for (var i=0 ; i<_data.MDU.length ; i++) {
								appendInfoString += '<tr><td colspan="2"><strong>' + "RAID " + _data.MDU[i].name + '</strong></td></tr>';
								for (key in _data.MDU[i]) {
									if (key != 'disks') {
										appendInfoString += '<tr><td>' + key.capitalize().replaceAll("_", " ") + '</td><td>' + _data.MDU[i][key] + '</td></tr>';
									}
									else {
										for (var j = 0;j < _data.MDU[i][key].length;j++) {
											appendInfoString += '<tr>';
											appendInfoString += '<td colspan="2">';
											appendInfoString += '<strong>' + 'Disk ' + _data.MDU[i][key][j].number + '</strong><br>';
											appendInfoString += '<table class="table table-striped table-bordered table-hover">';
											appendInfoString += '<tbody>';
											for (subKey in _data.MDU[i][key][j]) {
												appendInfoString += '<tr><td>' + subKey.capitalize().replaceAll("_", " ") + '</td><td>' + _data.MDU[i][key][j][subKey] + '</td></tr>';
											}
											appendInfoString += '</tbody>';
											appendInfoString += '</table>';
											appendInfoString += '</td>';
											appendInfoString += '</tr>';
										}
									}
								}
							}
							
							$("#raidInfo").html(addScrollbar(appendInfoString));
						}
						else {
							$("#raidInfo").html("<tr><td>N/A</td></tr>");
						}
					}
					catch(err) {
						$("#raidInfo").html("<tr><td>N/A</td></tr>");
			        	console.log("Get the RAID failed: " + err);
					}
					
					try {
						//Terry, 20170103, add SMART information
						if (_data.HDD.length > 0 && (_data.HDD != null) && (JSON.stringify(_data.HDD) != '[]')) {
							var appendString = '';
							for (var i=0 ; i<_data.HDD.length ; i++) {
								appendString += '<tr><td colspan="2"><strong>' + "Disk " + _data.HDD[i].name + '</strong></td></tr>';
								for (key in _data.HDD[i]) {
									appendString += '<tr><td>' + key.capitalize().replaceAll("_", " ") + '</td><td>' + _data.HDD[i][key] + '</td></tr>';
								}
							}
							
							$("#hddInfo").html(addScrollbar(appendString));
						}
						else {
							$("#hddInfo").html("<tr><td>N/A</td></tr>");
						}
					}
					catch(err) {
						$("#hddInfo").html("<tr><td>N/A</td></tr>");
			        	console.log("Get the SMART failed: " + err);
					}
				},
				error: function(xhr, status, error) {
					$("#raidInfo").html("<tr><td>N/A</td></tr>");
					$("#hddInfo").html("<tr><td>N/A</td></tr>");
		        	console.log("Get the Smart RAID failed: [" + xhr.status + "] " + xhr.statusText);
				}
			});
		}
		
		function addScrollbar(htmlString)
		{
			return '<tr>'
				 + '<td style="padding:0px !important;">'
				 + '<div class="scroll-table">'
				 + '<table class="table table-striped table-bordered table-hover">'
				 + htmlString
				 + '</table>'
				 + '</div>'
				 + '</td>'
				 + '</tr>';
		}
		
		//Change first character to upper case.
		String.prototype.capitalize = function() {
			return this.charAt(0).toUpperCase() + this.slice(1);
		}
		
		//Change "_" to " ".
		String.prototype.replaceAll = function(search, replacement) {
			return this.split(search).join(replacement);
		}
	</script>
</body>
</html>
