<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=BIG5">
	<title>Node Software</title>
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	
	<style>
		#guestInfo h3 {
			margin-top: 10px;
			font-weight: bold;
		}
		
		#loading_modal>.modal-dialog {
    		margin-top: 20% !important;
			width: 95px !important;
		}
		
		#loading_modal .alert {
			margin-bottom: 0px !important;
	    }
	</style>
</head>

<body>
	<div id="wrapper">
        <div id="page-wrapper">
            <div class="container-fluid">
                <!-- Page Heading -->
                <div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            ${IP}
                        </h3>
                    </div>
                </div>
                
                <div class="row" style="margin-top: 20px;">
				   	<div class="col-lg-12">
						<div style="float: right;">
							<button id="refreshInfo" class="btn btn-primary">Refresh</button>
						</div>
				   	</div>
				</div>
                
				<div class="row">
				   	<div id="VM" class="col-lg-12">
						<div class="row">
							<table id="vmTable" class="table table-striped table-bordered">
								<thead>
									<tr><th colspan="2"><h1>Virtual Machine <spring:message code="Information"/></h1></th></tr>
								</thead>
								<tbody id="vmInfo">
									<c:if test="${(empty XMLString)}">
										<tr><td><strong>VM IP</strong></td> <td>unknown</td></tr>
										<tr><td><strong>System Name</strong></td> <td>unknown</td></tr>
										<tr><td><strong>System Type</strong></td> <td>unknown</td></tr>
										<tr><td><strong>VM Type</strong></td> <td>unknown</td></tr>
										<tr><td><strong>Version</strong></td> <td>unknown</td></tr>
										<tr><td><strong>Guest Name</strong></td> <td>unknown</td></tr>
										<tr><td><strong>Guest OS Type</strong></td> <td>unknown</td></tr>
										<tr><td><strong>Guest Memory Size (MB)</strong></td> <td>unknown</td></tr>
										<tr><td><strong>Guest State</strong></td> <td>unknown</td></tr>
									</c:if>
								</tbody>
								<thead>
									<tr><th colspan="2"><h1>Guest OS <spring:message code="Information"/></h1></th></tr>
								</thead>
								<tbody id="guestInfo">
								</tbody>
							</table>
						</div>
					</div>
		 		</div>
		 		
		 		<br>
		 		
		 		<div class="row">
					<div id="VMAccount" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title"><spring:message code="NodeSetting12"/></h3>
							</div>
							<div class="panel-body">
								<p class="bg-info"><spring:message code="NodeSetting13"/></p>
								<form action="./NodeVirtualMachine_SetVMAccount" class="form-horizontal login-form">
									<div class="form-group">
										<label for="username" class="col-sm-2 control-label"><spring:message code="userName"/></label>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<label class="sr-only" for="username"><spring:message code="userName"/></label>
					                      	<input type="text" id="username" class="form-control form-username" name="username" value='${User}' placeholder=<spring:message code="userName"/>>
									    </div>
									</div>
									<div class="form-group">
									  	<label for="password" class="col-sm-2 control-label"><spring:message code="password"/></label>
									    <div class="col-sm-10 col-md-4 col-lg-4">
									    	<label class="sr-only" for="password"><spring:message code="password"/></label>
					                       	<input type="password" id="password" class="form-control form-password" name="password" value='${Pwd}' placeholder=<spring:message code="password"/>>
									    </div>
									</div>
									<div class="form-group">
									 	<input type="hidden" name="IP" value='${IP}'/>
										<div class="col-sm-10 col-md-4 col-lg-4">
											<button type="submit" class="btn btn-primary" onclick="UserAndPwd()"><spring:message code="Submit"/></button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		 	</div>
		 </div>
	</div>
	
	<div class="modal fade" id="loading_modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="alert">
					<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		$(document).ready(function(){
			if ('${XMLString}' != null && '${XMLString}'.length != 0){
				var xmlDoc = $.parseXML('${XMLString}'),
				      $xml = $(xmlDoc);
				
				var	appendInfoString =  '<tr><td><strong>VM IP</strong></td><td>${VMIP}</td></tr>';
					appendInfoString += '<tr><td><strong>System Name</strong></td><td>' + $xml.find("SystemName").text() + '</td></tr>';
					appendInfoString += '<tr><td><strong>System Type</strong></td><td>' + $xml.find("SystemType").text() + '</td></tr>';
					appendInfoString += '<tr><td><strong>VM Type</strong></td><td id = "type">' + $xml.find("VMType").text() + '</td></tr>';
					appendInfoString += '<tr id = "version"><td><strong>Version</strong></td><td>' + $xml.find("Version").text() + '</td></tr>';
				
				$("#vmInfo").append(appendInfoString);
				
				var appendString = '';
				
				$xml.find("guestInfo").each(function(i) {
					appendString += '<tr><th colspan="2"><h3>' + $(this).children("GuestName").text() +'</h3></th></tr>';
					appendString += '<tr id = "os"><td><strong>Guest OS Type</strong></td><td>' + $(this).children("GuestOSType").text() + '</td></tr>';
					appendString += '<tr><td><strong>Guest Memory Size (MB)</strong></td><td>' + $(this).children("GuestMemorySize").text() + '</td></tr>';
					appendString += '<tr><td><strong>Guest State</strong></td><td>' + $(this).children("GuestState").text() + '</td></tr>';
				});
				
				$("#guestInfo").append(appendString);
				
				if ($("#type").text() == 'HyperV') {
					$("#version").remove();
					$("#os").remove()
				}
			}

			if ('${isConn}' == "false")
				$("#VM").hide();
		});
		
		function UserAndPwd() {
			alert("The new username & password will be available after a few minutes.");
		}
		
		$("#refreshInfo").on("click", function() {
			$('#loading_modal').modal('show');
			
			$.ajax({
				url: 'RefreshNodeInfo',
			    data: {nodeIP:"${VMIP}", nodeType:"VM"},
			    dataType: 'json',
			    success: function(_data, status, xhr) {
			    	location.reload();
			    },
			    error: function(xhr, status, error) {
			        console.log("Refresh node info failed: [" + xhr.status + "] " + xhr.statusText);
			    	location.reload();
			    },
			    cache: false
			});
		})
	</script>
</body>

</html>