<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Group Dashboard</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS-->
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<style type="text/css">
		h3, h4 {
			display:inline-block;
		}
	</style>
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
	
	<style>
		.modal-dialog{
			overflow-y: initial !important
		}
		#biosInfo-modal-body{
			overflow-y: auto;
		}
		.progress-circle {
			margin-top: 260px !important;
			width: 95px !important;
		}
		.alert {
			margin-bottom: 0px !important;
		}
		.modal-content.success {
			background-color: #dff0d8;
			color: #449d44;
		}
		.modal-content.fail {
			background-color: #f2dede;
			color: #d9534f;
		}
		.modal_msg .modal-title {
			font-weight: bold;
		}
		.modal_msg .modal-header {
			padding: 15px 15px 5px 15px;
			border-bottom: none;
		}
		.modal_msg .modal-body {
			padding: 5px 15px;
		}
	</style>
	
	<sec:authorize access="!hasAnyRole(${Access_Configuration})" var="notADMIN"></sec:authorize>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<!-- Page Heading -->
				<div class="row page-title">
					<div class="col-lg-12">
						<h3 class="page-header">
							${Name}
						</h3>
						&nbsp;
						<h4>
							${Description}
						</h4>
					</div>
				</div>
				<!-- /.row -->
				<br>
				
				<div class="row">
					<div class="col-lg-12">
						<div class="panel panel-default">
							<form action="javascript:deleteNodesFROMGroup()">
								<div class="panel-heading">
									<sec:authorize access="hasAnyRole(${Access_Configuration})">
									<button type="button" id="addBtn" class="btn btn-primary" data-toggle="modal" data-target="#create"><spring:message code="Add"/>&nbsp;IP</button>
									<button type="submit" id="delBtn" class="btn btn-primary" disabled><spring:message code="Delete"/>&nbsp;IP</button>
									<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#rename">Group <spring:message code="Rename"/></button>
									</sec:authorize>
								</div>
								<!-- /.panel-heading -->
								<div class="panel-body">
									<div id="panelCheckBox" class="dataTable_wrapper">
										<table class="table table-striped table-bordered table-hover" id="dataTables">
											<thead>
												<tr>
													<th><spring:message code="Select"/></th>
													<th><spring:message code="Nodelist2"/></th>
													<th><spring:message code="Nodelist3"/></th>
													<th><spring:message code="Nodelist4"/></th>
													<th><spring:message code="Nodelist8"/></th>
													<th><spring:message code="Nodelist5"/></th>
													<!-- <th><spring:message code="Nodelist7"/></th> -->
													<th><spring:message code="navside2-2"/></th>
													<!-- <th><spring:message code="navside19"/></th> -->
												</tr>
											</thead>
											<tbody>
											</tbody>
										</table>
									</div>
								</div>
								<!-- /.panel-body -->
								<input type="hidden" name="ID" value="${ID}">
								<input type="hidden" name="Filter" value="GroupList">
							</form>
						</div>
						<!-- /.panel -->
					</div>
					<!-- /.col-lg-12 -->
				</div>
				<!-- /.row -->
			</div>
			<!-- /.container-fluid -->
		</div>
		<!-- /.page-wrapper -->
	</div>
	
	<div style="color:black" class="modal fade" id="viewDialog" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel">Last Crash Image</h4>
				</div>
				
				<div class="modal-body">
					<img id="displayCrashImage" height="600" width="800"/>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>

	<!-- /#page-wrapper -->
	<div style="color:black" class="modal fade" id="create" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<form action="javascript:addNodesTOGroup()">
					<div class="modal-header">
						<h4 class="modal-title" id="myModalLabel"><spring:message code="Add"/></h4>
						(<spring:message code="All"/>&nbsp;&nbsp;<input type="checkbox" id="selectAll">)
					</div>
					
					<div class="modal-body">
						<div id="modalCheckBox" class="dataTable_wrapper">
							<table class="table table-striped table-bordered table-hover col-lg-12" id="dataTables2">
								<thead>
									<tr>
										<th><spring:message code="Select"/></th>
										<th><spring:message code="Nodelist2"/></th>
										<th><spring:message code="Nodelist3"/></th>
										<th><spring:message code="Nodelist5"/></th>
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
					</div>
					
					<div class="modal-footer">
						<button type="submit" id="subBtn" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
						<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
					</div>
					<input type="hidden" name="ID" value="${ID}">
					<input type="hidden" name="Filter" value="GroupList">
				</form>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="rename" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<form action="./RenameGroup">
					<div class="modal-header">
						<h4 class="modal-title" id="myModalLabel"><spring:message code="Rename"/></h4>
					</div>
					
					<div class="modal-body">
						<spring:message code="Grouplist3"/>:<input type=text id="groupName" class="form-control" name="groupname" value="">
					</div>
					
					<div class="modal-footer">
						<button type="submit" id="renameGroupBtn" class="btn btn-primary" ><spring:message code="Submit"/></button>
						<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
					</div>
					<input type="hidden" name="ID" value="${ID}">
					<input type="hidden" name="Filter" value="GroupList">
				</form>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="biosInfoStatus" tabindex="-1" role="dialog" aria-labelledby="biosInfoLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="biosInfoLabel"><spring:message code="navside2-2"/></h4>
				</div>
				
				<div id="biosInfo-modal-body" class="modal-body">
					<div id="biosInfoBox">
					</div>
				</div>
				
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="modal_loading" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
		<div class="modal-dialog progress-circle" role="document">
			<div class="modal-content">
				<div id="modal_loading_div" class="alert">
					<i id="modal_loading_icon" class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade modal_msg" id="modal_msg" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 name="modal_msg_title" class="modal-title">modal title</h4>
				</div>
				<div class="modal-body">
					<p name="modal_msg_msg">modal message</p>
				</div>
			</div>
		</div>
	</div>
	
	<!-- <sec:authorize access="!hasAnyRole(${Access_RemoteAccess})" var="var_not_Access_RemoteAccess"/> -->
	<sec:authorize access="!hasAnyRole(${Access_GetInfo})" var="var_not_Access_GetInfo"/>
	
	<script>
	
		//Sean, 2016/08/18, auto refresh crash image newly if image exist 
		
		var count = 0;
		var image = document.getElementById("displayCrashImage");
		//var timer_id = setInterval(autoUpdate, 4000); // every 4 second refresh
		var nodeListIndex = 0;
		var nodeListIndex_withoutGroupID = 0;
		var nodeListLength = 100;
		var nodeList_ADD = [];
		var nodeList_DELETE = [];
		
		function autoUpdate()
		{
			if($('#viewDialog').is(':visible')){
				count ++;
				if(count == 5){
					window.clearInterval(timer_id);
					return;
				}
				var IP = this.id;
				var image = document.getElementById("displayCrashImage");
				image.src = "./GetSingleNodeCrashImage?IP="+ IP;
			}
		}
		
		function updateNodeListWithGroupID() {
			$.ajax({
				url: 'getNodeListWithGroupID',
				data: {dataIndex:nodeListIndex, dataLength:nodeListLength, groupID:"${ID}"},
				dataType: 'json',
				success: function(_data, status, xhr) {
					var nodelistArray = [];
					
					for(var i=0 ; i<_data.NodeList.length ; i++) {
						var ikvmSupport = "";
						var biosSupport = "";
						var dumpSupport = "";
						if((_data.NodeList[i].Type != "SMC") || !_data.NodeList[i].Connection || _data.NodeList[i].isJBOD || (parent.connectionInterface == "Redfish")) {
							ikvmSupport = "disabled";
							biosSupport = "disabled";
							dumpSupport = "disabled";
						}
						if(_data.NodeList[i].FirmwareType != "Vertiv") {
							ikvmSupport = "disabled";
							dumpSupport = "disabled";
						}
						
						nodelistArray.push(["<div class=\"checkbox\"><label><input type=\"checkbox\" name=\"deleteIP\" id=\"del\" value=" + _data.NodeList[i].IP + " " + ((("${notADMIN}" == "true") || (_data.NodeList[i].Type != "SMC")) ? "disabled" : "") + "></label></div>",
										_data.NodeList[i].MAC,
										_data.NodeList[i].IP,
										_data.NodeList[i].Connection,
										_data.NodeList[i].BMCVersion,
										((_data.NodeList[i].Type == "SMC") ? "BMC" : _data.NodeList[i].Type),
										//"<button type=\"button\" id=" + _data.NodeList[i].IP + " class=\"btn btn-primary\" onclick=\"launch(this.id)\" " + ikvmSupport + ">" + '<spring:message code="Download"/>' + "</button>",
										"<button type=\"button\" id=" + _data.NodeList[i].IP + " class=\"btn btn-primary\" onclick=\"view(this.id)\" " + biosSupport + ">" + '<spring:message code="View"/>' + "</button>"
										//"<button type=\"button\" id=" + _data.NodeList[i].IP + " class=\"btn btn-primary\" onclick=\"downloadLastCrashScreen(this.id)\" " + dumpSupport + ">" + '<spring:message code="Download"/>' + "</button>"
										]);
					}
					
					$('#dataTables').DataTable().rows.add(nodelistArray).draw(false);
					
					if(_data.NodeList.length != 0) {
						setTimeout(updateNodeListWithGroupID, 50);
						nodeListIndex += nodeListLength;
					}
					else {
						nodeListIndex = 0;
						$('#dataTables_filter>label>input').prop("disabled", false);
					}
				},
				error: function(xhr, status, error) {
					console.log("Get the Node List With Group ID (${ID}) failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
		
		function updateNodeListWithoutGroupID() {
			$.ajax({
				url: 'getNodeListWithoutGroupID',
				data: {dataIndex:nodeListIndex_withoutGroupID, dataLength:nodeListLength, groupID:"${ID}"},
				dataType: 'json',
				success: function(_data, status, xhr) {
					var nodelistArray = [];
					
					for(var i=0 ; i<_data.NodeList.length ; i++) {
						nodelistArray.push(["<div class=\"checkbox\"><label><input type=\"checkbox\" name=\"addIP\" value=\"" + _data.NodeList[i].IP + "\"></label></div>",
					        			_data.NodeList[i].MAC,
					        			_data.NodeList[i].IP,
					        			((_data.NodeList[i].Type == "SMC") ? "BMC" : _data.NodeList[i].Type)
						                ]);
					}
					
					$('#dataTables2').DataTable().rows.add(nodelistArray).draw(false);
					
					if(_data.NodeList.length != 0) {
						setTimeout(updateNodeListWithoutGroupID, 50);
						nodeListIndex_withoutGroupID += nodeListLength;
					}
					else {
						nodeListIndex_withoutGroupID = 0;
					    $('#dataTables2_filter>label>input').prop("disabled", false);
					}
				},
				error: function(xhr, status, error) {
				    console.log("Get the Node List Without Group ID (${ID}) failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
		
		function downloadLastCrashScreen(ip) {
			var csrfParameter= "${_csrf.parameterName}";
			var csrfToken = "${_csrf.token}";
			var formData = new FormData();
			
			formData.append("IP", ip);
			formData.append("Option", "Dump");
			$('#modal_loading').modal('show');
			
			$.ajax({
				url: 'SetBMCUtil?' + csrfParameter + '=' + csrfToken,
				type: 'POST',
				data: formData,
				dataType: 'json',
				success: function(_data, status, xhr) {
					var jsonObj = JSON.parse(xhr.responseText);
					
					if (jsonObj.status) {
						showMsgDialog("Dump success", "", jsonObj.status);
						window.location.href = './DownloadBMCUtil?IP=' + ip + '&Option=Dump';
					} else
						/*William 2018/12/10: Make the content of the fail message correct.*/
						showMsgDialog("Dump fail", "Last crash image is unavailable", jsonObj.status);
				},
				error: function(xhr, status, error) {
					showMsgDialog("Download file failed:", "[" + xhr.status + "] " + xhr.statusText, false);
					console.log("Download last crash screen (" + ip + ") failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false,
				contentType: false,
				processData: false
			});
		}
		
		
		$(document).ready(function() {
			$('#dataTables').DataTable({
				"scrollX":  true
			});
			
			$('#dataTables2').DataTable({
				"responsive": true
			});
			
			var value = '${RackType}';
			if( (value.indexOf("OpenRack") > -1) || (value.indexOf("Standard with CMM") > -1) || (value.indexOf("Standard with CMC") > -1) ) {
				$("button[ID=addBtn]").prop('disabled', true);
			}
			
			$('tbody:first > tr').each(function() {
				if($(this).find('td:eq(3)').text()=="false") {
					$(this).find('button:eq(0)').attr("disabled", true);
					$(this).find('button:eq(0)').removeClass().addClass("btn btn-default");
				}
			});
			
			$('#dataTables_filter>label>input').prop("disabled", true);
			$('#dataTables2_filter>label>input').prop("disabled", true);
			updateNodeListWithGroupID();
			updateNodeListWithoutGroupID();
			<c:if test="${var_not_Access_RemoteAccess}">//$('#dataTables').DataTable().columns([ 6, 8 ]).visible(false);</c:if>
			<c:if test="${var_not_Access_GetInfo}">$('#dataTables').DataTable().columns([ 7 ]).visible(false);</c:if>
		});
		
		$("#panelCheckBox").delegate("input[type='checkbox']", "click", function() {
			var checked_ip = $(this).parent().parent().parent().parent().find('td:eq(2)').text();
			if(nodeList_DELETE.indexOf(checked_ip) == -1) {
				nodeList_DELETE.push(checked_ip);
			}
			else {
				nodeList_DELETE.splice(nodeList_DELETE.indexOf(checked_ip), 1);
			}
			
			if(nodeList_DELETE.length > 0) {
				$("button[ID=delBtn]").prop('disabled', false);
			} else {
				$("button[ID=delBtn]").prop('disabled', true);
			}
		});
		
		$("#modalCheckBox").delegate("input[type='checkbox']", "click", function() {
			var checked_ip = $(this).parent().parent().parent().parent().find('td:eq(2)').text();
			if(nodeList_ADD.indexOf(checked_ip) == -1) {
				nodeList_ADD.push(checked_ip);
			}
			else {
				nodeList_ADD.splice(nodeList_ADD.indexOf(checked_ip), 1);
			}
			
			if(nodeList_ADD.length > 0) {
				$("button[ID=subBtn]").prop('disabled', false);
			} else {
				$("button[ID=subBtn]").prop('disabled', true);
			}
		});
		
		function deleteNodesFROMGroup() {
			window.location.href = "./DeleteMember?deleteIP=" + nodeList_DELETE.toString() + "&ID=${ID}";
		}
		
		function addNodesTOGroup() {
			window.location.href = "./AddMember?addIP=" + nodeList_ADD.toString() + "&ID=${ID}";
		}
		
		function launch(ip) {
			window.location.href = "./DownloadIkvmFile?IP=" + ip;
		}
		
		function view(ip) {
			$.ajax({
				url: 'viewBIOSInfo',
				data: {IP:ip},
				dataType: 'json',
				success: function(_data, status, xhr) {
					viewModal(_data);
				},
				error: function(xhr, status, error) {
					//alert("Update failed, please try again.");
					console.log("View the SMBIOS info (" + ip + ") failed: [" + xhr.status + "] " + xhr.statusText);
				},
				cache: false
			});
		}
		function viewModal(_data) {
			$('#biosInfo-modal-body').css("height", getWindowsHeight()*0.8);
			$('#biosInfoBox').empty();
			
			var htmlString = ""
			
			for(var i=0 ; i<_data.biosInfo.length ; i ++) {
				htmlString += '<table class=\"table table-striped table-bordered table-hover\" id=\"biosInfoTables\">'
						   + '<thead><tr><th>' + _data.biosInfo[i][0] + '<\/th><\/tr><\/thead>'
						   + '<tbody>';
				for(var j=1 ; j<_data.biosInfo[i].length ; j++) {
					htmlString += '<tr><td>' + _data.biosInfo[i][j] + '<\/td><\/tr>';
				}
				htmlString += '<\/tbody>'
						   + '<\/table>';
				
				$('#biosInfoBox').append(htmlString);
				htmlString = "";
			}
			
			$('#biosInfoStatus').modal('show');
		}
		
		function getWindowsHeight() {
			var myWidth = 0, myHeight = 0;
			if( typeof( window.innerWidth ) == 'number' ) {
				//Non-IE
				myWidth = window.innerWidth;
				myHeight = window.innerHeight;
			} else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
				//IE 6+ in 'standards compliant mode'
				myWidth = document.documentElement.clientWidth;
				myHeight = document.documentElement.clientHeight;
			} else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
				//IE 4 compatible
				myWidth = document.body.clientWidth;
				myHeight = document.body.clientHeight;
			}
			return myHeight;
		}
		
		// Terry, 2018/01/19, add checkbox to let user select all nodes.
		$("#selectAll").click(function() {
			var rows = $("#dataTables2").DataTable().rows().nodes();
			$("input[type='checkbox']", rows).prop("checked", this.checked);
			
			var row_num = $("#dataTables2").DataTable().rows().data().length;
			for (var i = 0;i < row_num;i++) {
				var row_ip = $("#dataTables2").DataTable().rows(i).data()[0][2];
				if(nodeList_ADD.indexOf(row_ip) == -1)
					nodeList_ADD.push(row_ip);
				else
					nodeList_ADD.splice(nodeList_ADD.indexOf(row_ip), 1);
			}
			
			if (this.checked)
				$("button[ID=subBtn]").prop('disabled', false);
			else
				$("button[ID=subBtn]").prop('disabled', true);
		});
		
		function showMsgDialog(title, msg, success)
		{
			setTimeout(function() {
				$('#modal_loading').modal('hide');
				
				var id = randomID(8);
				
				$("body").append('<div class="modal fade modal_msg" id="' + id + '" tabindex="-1" role="dialog">' + $("#modal_msg").html() + '</div>');
				$("#" + id).find("h4[name='modal_msg_title']").text(title);
				$("#" + id).find("p[name='modal_msg_msg']").text(msg);
				
				if(success)
					$("#" + id + ">div>div").addClass("success");
				else
					$("#" + id + ">div>div").addClass("fail");
				
				$("#" + id).on("hidden.bs.modal", function() {
					$("#" + id).remove();
					$("body").css("padding-right", "");
				});
				
				$("#" + id).modal("show");
			}, 0);
		}
		
		function randomID(idLength) {
			var id = "";
			
			if (idLength == null || idLength == "")
				idLength = 10;
			
			for (var i = 0;i < idLength;i++) {
				switch (Math.floor((Math.random() * 3) + 1)) {
					case 1:
						id += Math.floor((Math.random() * 10));
						break;
					case 2:
						id += String.fromCharCode(Math.floor((Math.random() * 26) + 65));
						break;
					case 3:
						id += String.fromCharCode(Math.floor((Math.random() * 26) + 97));
						break;
				}
			}
			
			return id;
		}
	</script>
</body>
</html>
