<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="x" uri="http://java.sun.com/jsp/jstl/xml" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Group Power Consumption</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link href="<c:url value="/resources/css/bootstrap/dataTables.bootstrap.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/dataTables.responsive.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/jquery.dataTables.min.js"/>"></script>
	<script src="<c:url value="/resources/js/bootstrap/dataTables.bootstrap.min.js"/>"></script>
	
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            ${Name}
                        </h3>
                    </div>
                </div>
				<br>
				
				<div class="row">
					<div  id="Policy" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4><spring:message code="Policy"/></h4>
							</div>		
							<div class="panel-body">
								<sec:authorize access="hasAnyRole(${Access_Configuration})">
									<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#create"><spring:message code="Add"/></button>
									<button type="submit" id="delBtn" onclick="clickedDelete()" class="btn btn-primary" disabled><spring:message code="Delete"/></button><br><br>
								</sec:authorize>
								<div class="dataTable_wrapper" id="panelCheckBox" >
									<table class="table table-striped table-bordered table-hover" id="dataTables">
										<thead>
											<tr>
												<th><spring:message code="Select"/></th>
												<th><spring:message code="NodePower3"/></th>
												<th><spring:message code="StartTime"/></th>
												<th><spring:message code="EndTime"/></th>
											</tr>
										</thead>
										<tbody>
											<c:set var="xmltext1">${XMLString1}</c:set>
											<x:parse xml="${xmltext1}" var="output1"/>
											<x:forEach select="$output1/PolicyList/policy" var="item1" varStatus="index">
												<tr class="gradeA" id="col${index.count}">
													<td><div class="checkbox"><label><input type="checkbox" name="deletePolicy" value=<x:out select="$item1/startTime" />-<x:out select="$item1/endTime" /> <sec:authorize access="!hasAnyRole(${Access_Configuration})">disabled</sec:authorize>></label></div></td>
													<td><x:out select="$item1/powerLimit" /></td>
													<td><x:out select="$item1/startTime" />:00</td>
													<td><x:out select="$item1/endTime" />:00</td>
												</tr>
											</x:forEach>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div id="CurrentWatts" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 id="powerTotal"><spring:message code="NodePower5"/>:</h4>
							</div>
							<div class="panel-body">
								<table class="table table-striped table-bordered table-hover" id="dataTables2">
									<thead>
										<tr>
											<th><spring:message code="Nodelist2"/></th>
											<th><spring:message code="Nodelist3"/></th>
											<th><spring:message code="NodeDetail7"/></th>
											<th><spring:message code="NodePower6"/></th>
											<th><spring:message code="NodePower3"/></th>
										</tr>
										<tbody>
										</tbody>
									</thead>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div style="color:black" class="modal fade" id="create" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel"><spring:message code="Add"/></h4>
				</div>
				<div class="modal-body">
					<table class="table table-striped table-bordered table-hover" id="dataTables3">
						<thead>
							<tr>
								<th id="TotalAverage"><spring:message code="NodePower3"/></th>
								<th><spring:message code="StartTime"/></th>
								<th><spring:message code="EndTime"/></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>
									<input id="value" type=text name="DBThreshold" value="${dbThreshold}">
								</td>
								<td>
									<select id="start">
										<c:forEach var="i" begin="0" end="23">
											<option value="${i}">${i < 10 ? '0' : ''}${i}:00</option>
										</c:forEach>
									</select>
								</td>
								<td>
									<select id="end">
										<c:forEach var="i" begin="1" end="24">
											<option value="${i}">${i < 10 ? '0' : ''}${i}:00</option>
										</c:forEach>
									</select>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<div class="modal-footer">
					<button type="submit" id="addBtn" onclick="clickedSubmit()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
					<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		var totalAverage = 0;
		
		var clickedDelete = function() {
			var checkboxes = document.getElementsByName("deletePolicy");
			var selectPolicy = [];
			
			for (var i = 0;i < checkboxes.length;i++) {
				if(checkboxes[i].checked)
					selectPolicy.push(checkboxes[i].value);
			}
			
			window.location.href = "./SetGroupPowerLimit?ID=" + '${ID}' + "&Action=delete&SelectPolicy=" + selectPolicy + "&Filter=GroupList";
		};
		
		var clickedSubmit = function() {
			var enable = "true";
			var value = document.getElementById('value').value;
			var startTime = document.getElementById('start').value;
			var endTime = document.getElementById('end').value;
			var Paras = "&Enable=" + enable + "&Value=" + value + "&StartTime=" + startTime + "&EndTime=" + endTime;
			
			if (Number(value) < Number(totalAverage)) {
				alert('<spring:message code="NodePower7"/>'+ totalAverage);
				$("#value").select();
			} else
				window.location.href = "./SetGroupPowerLimit?ID=" + '${ID}' + "&Action=add" + Paras + "&Filter=GroupList";
		};
		
		var powerListLoading = function(start, dataArray) {
			if (start) {
				$("#dataTables2>tbody").html("<tr><td colspan='5' style='text-align: center; padding-left:8px !important;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></td></tr>");
			} else {
				setTimeout(function(){
					$('#dataTables2').DataTable().clear().draw(false);
					
					if (dataArray)
						$('#dataTables2').DataTable().rows.add(dataArray).draw(false);
				}, 1000);
			}
		};
		
		var getPowerConsumption = function() {
			var appendHtmlString = "";
			
			powerListLoading(true)
    		
    		$.ajax({
		    	url: 'getPowerConsumption',
		        type: 'GET',
		        data: {
		        	GroupID: '${ID}'
		        },
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	var powerlistArray = [];
		        	totalAverage = _data.TotalAverage;
		        	
		        	if (_data.PowerConsumptionList.length > 0){
		        		for(var i = 0;i <  _data.PowerConsumptionList.length;i++){
		        			if (_data.PowerConsumptionList[i].Value === "-1") {
		        				_data.PowerConsumptionList[i].Value ="Unsupport";
		        				_data.PowerConsumptionList[i].Limit ="Unsupport"
		        			}
		        			if(_data.PowerConsumptionList[i].Average === "-1"){
		        				_data.PowerConsumptionList[i].Average ="Unsupport";
		        				_data.PowerConsumptionList[i].Limit ="Unsupport"
		        			}
		        			
		        			powerlistArray.push([_data.PowerConsumptionList[i].BMCMAC,
		        								 _data.PowerConsumptionList[i].BMCIP,
		        								 _data.PowerConsumptionList[i].Value,
		        								 _data.PowerConsumptionList[i].Average,
		        								 _data.PowerConsumptionList[i].Limit
		        			])	
		        		}	
		        	}
		        	
		        	powerListLoading(false, powerlistArray);
		        	$("#powerTotal").text('<spring:message code="NodePower5"/>'+": " + _data.Total);
		        	$("#TotalAverage").text('<spring:message code="NodePower3"/>'+" (>=" + _data.TotalAverage+")");
				},
				error: function(xhr, status, error) {
					powerListLoading(false);
			        console.log("Get power consumption failed: [" + xhr.status + "] " + xhr.statusText);
				},
		        cache: false
		    });
		};
		
		$(document).ready(function() {
			var rackType = '${RackType}';
			var errorCode = '${errCode}';
			
			var xml = '${XMLString1}',
				xmlDoc = $.parseXML(xml),
				$xml = $(xmlDoc);
			var policy = $xml.find("PolicyList").find("policy");
			
			var inProcess;
			
			if (rackType === "Standard with CMM" || rackType === "Standard with CMC") {
				$("#Policy").remove();
				$("#CurrentWatts").remove();
			}
			
			/*William 2018/12/05: Make the Message display correctly*/
			if (errorCode != 0)
				alert("<spring:message code="webErrMsg${errCode}"/>");
			
			$("#dataTables").DataTable({
				"scrollX": true
			});
			$("#dataTables2").DataTable({
				"scrollX": true
			});
			
			for (var i = 1;i <= policy.length;i++) {
				inProcess = policy.eq(i - 1).find("inProcess").text();
				
				if (inProcess.localeCompare("true") === 0)
					$("#col" + i).css("background-color", "#FFFF00");
			}
			
			getPowerConsumption();
		});
		
		$("#start").on("change", function() {
			var selectHtml = '';
			var startHour = $(this).find('option:selected').val();
			
			for (var i = Number(startHour) + 1;i <= 24;i++)
				selectHtml += '<option value="' + i + '">' + (i < 10 ? '0' : '') + i + ':00</option>';
				
			$("#end").html(selectHtml);
		});
		
		$("#panelCheckBox input[type='checkbox']").click(function() {
			if($("#panelCheckBox input[type='checkbox']").is(":checked"))
				$("button[ID=delBtn]").prop('disabled', false);
			else
				$("button[ID=delBtn]").prop('disabled', true);
		});
		
		$('#value').bind('input', function() {
			var content = $('#value').val();
			
			if (content !== "")
				$("button[ID=addBtn]").prop('disabled', false);
			else
				$("button[ID=addBtn]").prop('disabled', true);
		});
	</script>
</body>
</html>