<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Node Power Consumption</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<!-- CSS -->
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-switch.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap-datetimepicker.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/bootstrap.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/metisMenu.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/sb-admin.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
	<link href="<c:url value="/resources/css/bootstrap/style_2016.css" />" rel="stylesheet">
	<style>
		table>tbody tr>td:first-child {
			width: 50%;
		}
	</style>
	
	<!-- Javascript -->
	<script src="<c:url value="/resources/js/bootstrap/jquery.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/raphael.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/moment.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-switch.min.js" />"></script>
	<script src="<c:url value="/resources/js/bootstrap/bootstrap-datetimepicker.js" />"></script>
	<script src="<c:url value="/resources/js/Chart.min.js" />"></script>
</head>

<body>
	<div id="wrapper">
		<div id="page-wrapper">
			<div class="container-fluid">
				<div class="row page-title">
                    <div class="col-lg-12">
                        <h3 class="page-header">
                            <A onclick='window.open("https://${IP}", "_blank", "scrollbars=yes,resizable=yes,top=300,left=500,width=800,height=600")'> ${IP} </A>
                        </h3>
                    </div>
                </div>
                
				<br>
				
				<div class="row">
					<div id="PowerReading" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading" id="powerReadingHead">
								<h3 class="panel-title"><i class="fa fa-area-chart fa-fw"></i><spring:message code="NodePower14"/></h3>
							</div>
							<div class="panel-body" id="powerReadingBody">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover" style="margin-bottom: 0px;">
										<tbody>
											<tr><td><spring:message code="NodePower15"/></td><td><div id="currPower"></div></td></tr>
											<tr><td><spring:message code="NodePower16"/></td><td><div id="maxPower"></div></td></tr>
											<tr><td><spring:message code="NodePower17"/></td><td><div id="minPower"></div></td></tr>
											<tr><td><spring:message code="NodePower18"/></td><td><div id="avgPower"></div></td></tr>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<sec:authorize access="hasAnyRole(${Access_Configuration})">
				<div class="row">
					<div id="PowerLimit" class="col-lg-12">
						<div class="panel panel-default">
							<div class="panel-heading" id="powerLimitHead">
								<h3 class="panel-title"><i class="fa fa-area-chart fa-fw"></i><spring:message code="NodePower1"/></h3>
							</div>
							<div class="panel-body" id="powerLimitBody">
								<div class="dataTable_wrapper">
									<table class="table table-striped table-bordered table-hover">
										<tbody>
											<tr><td><spring:message code="NodePower2"/></td><td><input type=checkbox id="enablePowerlimit" data-size="mini"></td></tr>
											<tr><td><spring:message code="NodePower3"/> (1~32767)</td><td><input type=text id="powerLimitValue" maxlength="5"> <spring:message code="Watts"/></td></tr>
											<tr><td><spring:message code="NodePower8"/> (1~3600)</td><td><input type=text id="samplingPeriodValue" maxlength="4"> <spring:message code="Seconds"/></td></tr>
											<tr><td><spring:message code="NodePower9"/> (6000~600000)</td><td><input type=text id="correctionTimeLimitValue" maxlength="6"> <spring:message code="Milliseconds"/></td></tr>
											<tr><td><spring:message code="NodePower10"/></td><td><select id="exceptionActionValue">
												<option value="0"><spring:message code="NodePower11"/></option>
												<option value="1"><spring:message code="NodePower12"/></option>
												<option value="17"><spring:message code="NodePower13"/></option>
											</select></td></tr>
										</tbody>
									</table>
									<div>
										<button type="button" onclick="setPowerLimit()" class="btn btn-primary"><spring:message code="Submit"/></button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				</sec:authorize>
				
				<div class="row">
                    <div id="chartjsMonitor" class="col-lg-12">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3 class="panel-title"><i class="fa fa-area-chart fa-fw"></i><spring:message code="monitor"/></h3>
                            </div>
                            <div class="panel-body">
                                <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseChartjsSetting" aria-expanded="false" aria-controls="collapseChartjsSetting">
                                    <i class="fa fa-gear"></i>
                                </button>
                                <div class="collapse" id="collapseChartjsSetting">
                                    <div class="well">
                                        <div class="row">
                                            <div class="col-xs-6 col-sm-4 col-md-2 col-lg-2"> 
                                                <div>
                                                    <p><spring:message code="Display"/>:</p>  
                                                    <select id="powerChartRangeOption" class="form-control">
                                                        <option value="5"><spring:message code="year"/></option>
                                                        <option value="4"><spring:message code="month"/></option>
                                                        <option value="3"><spring:message code="week"/></option>
                                                        <option value="2"><spring:message code="day"/></option>
                                                        <option value="1" selected><spring:message code="hour"/></option>
                                                        <option value="0"><spring:message code="manual"/></option>
                                                    </select>
                                                </div>
                                                <br>
                                                <div>
                                                    <spring:message code="Refresh"/><input type=checkbox id="powerChartRefresh" data-size="mini" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4">
                                                <div class="form-group">
                                                    <p><spring:message code="Manualdate"/>:</p>
                                                    <div class='input-group date' id='monitorDateTimePickerStart'>
                                                        <input type='text' class="form-control" id="monitorDateTimePickerStartValue"/>
                                                        <span class="input-group-addon"><span class="fa fa-calendar"></span></span>
                                                    </div>
                                                    <div class="input-group date">
                                                        <span class="input-group-addon"><span class="fa fa-arrow-down"></span></span>
                                                    </div>
                                                    <div class="input-group date" id="monitorDateTimePickerEnd">
                                                        <input type="text" class="form-control" id="monitorDateTimePickerEndValue"/>
                                                        <span class="input-group-addon"><span class="fa fa-calendar"></span></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                </div> 
                                <div class="row">
                                    <div style="width:100%; height:300px;">
										<canvas id="chartjs-area-chart"></canvas>
									</div>
                                </div> 
                            </div> 
                        </div> 
                    </div> 
                </div> 
			</div>
		</div>
	</div>
	
	<script>
		var bmcIP = "${IP}";
		
        var powerChartStartTime = "";
        var powerChartEndTime = "";
        var powerChartMinPeriod = Date.now();
        var powerChartMaxPeriod = Date.now();
		var powerChartLatestData;
        var powerChartSelectedRange = 1;
        var powerChartRefreshEnabled = true;
        var powerChartRefreshInterval = 10000;
        var powerChartjsChart;
		var powerChartjsDatasetMap = {};
		var powerChartjsColor = ['rgb(11,  98,  164)',
								 'rgb(77,  167, 77)',
								 'rgb(255, 99,  132)',
								 'rgb(230, 115, 0)',
								 'rgb(153, 102, 255)',
								 'rgb(255, 209, 102)',
								 'rgb(54,  162, 235)',
								 'rgb(255, 205, 86)',
								 'rgb(201, 203, 207)'];
		
		$(document).ready(function()
		{
			getPowerReading();
            getPowerLimit();
            
            $('#monitorDateTimePickerStart').datetimepicker({
                showTodayButton : true,
                format : "YYYY-MM-DD HH:mm"
            }).datetimepicker("setDate", new Date());
            
            $('#monitorDateTimePickerEnd').datetimepicker({
                showTodayButton : true,
                format : "YYYY-MM-DD HH:mm",
                useCurrent: false
            });
            
			initPowerChartjsChart();
            $("#powerChartRefresh").bootstrapSwitch('state', true);
	    	$("#powerChartRangeOption").change();
	    	
	    	setTimeout(refreshPowerChartjsChart, powerChartRefreshInterval);
		});
		
		$("#enablePowerlimit").on('switchChange.bootstrapSwitch', function()
		{
			if ($("#enablePowerlimit").is(":checked")) {
				//Enable
				$("#powerLimitValue").prop("disabled", false);
				$("#samplingPeriodValue").prop("disabled", false);
				$("#correctionTimeLimitValue").prop("disabled", false);
				$("#exceptionActionValue").prop("disabled", false);
				if($("#samplingPeriodValue").val() == "")
					$("#samplingPeriodValue").val("2");
				if($("#correctionTimeLimitValue").val() == "")
					$("#correctionTimeLimitValue").val("6000");
			} else {
				//Disable
				$("#powerLimitValue").prop("disabled", true);
				$("#samplingPeriodValue").prop("disabled", true);
				$("#correctionTimeLimitValue").prop("disabled", true);
				$("#exceptionActionValue").prop("disabled", true);
				$("#powerLimitValue").val("");
				$("#samplingPeriodValue").val("");
				$("#correctionTimeLimitValue").val("");
				$("#exceptionActionValue").val("0");
			}
		});
        
        $("#powerChartRefresh").on('switchChange.bootstrapSwitch', function()
        {
        	powerChartRefreshEnabled = $("#powerChartRefresh").is(":checked");
        });
        
        $("#powerChartRangeOption").change(function()
        {
            powerChartSelectedRange = this.value;
            powerChartMaxPeriod = Date.now();
            powerChartMinPeriod = Date.now();
            if(powerChartSelectedRange == 0) {
				$('#monitorDateTimePickerStart').show();
				$('#monitorDateTimePickerEnd').show();
				$("#powerChartRefresh").bootstrapSwitch('state', false);
				$("#powerChartRefresh").bootstrapSwitch("disabled", true);
            }
            else {
				$("#powerChartRefresh").bootstrapSwitch("disabled", false);
				$('#monitorDateTimePickerStart').hide();
				$('#monitorDateTimePickerEnd').hide();
				$('#monitorDateTimePickerStart').data("DateTimePicker").date(null);
				$('#monitorDateTimePickerEnd').data("DateTimePicker").date(null);
				$('#monitorDateTimePickerStartValue').val("");
				$('#monitorDateTimePickerEndValue').val("");
                powerChartStartTime = "";
                powerChartEndTime = "";
                updatePowerChartjsChart();
            }
        });
        
        $("#monitorDateTimePickerStart").on("dp.change", function(e)
        {
            powerChartStartTime = new Date($('#monitorDateTimePickerStartValue').val()).valueOf();
            $('#monitorDateTimePickerEnd').data("DateTimePicker").minDate(e.date);
            
            if((powerChartStartTime != "") && (powerChartEndTime != ""))
				updatePowerChartjsChart();
        });
        
        $("#monitorDateTimePickerEnd").on("dp.change", function(e)
        {
            powerChartEndTime = new Date($('#monitorDateTimePickerEndValue').val()).valueOf();
            $('#monitorDateTimePickerStart').data("DateTimePicker").maxDate(e.date);
            
            if((powerChartStartTime != "") && (powerChartEndTime != ""))
				updatePowerChartjsChart();
        });
		
		function getPowerReading()
		{
			powerReadingLoading(true);
			
			$.ajax({
		        url: 'getPowerReading',
		        data: {nodeIP:'${IP}'},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	powerReadingLoading(false, _data);
		        },
		        error: function(xhr, status, error) {
		        	powerReadingLoading(false);
		        	console.log("Get power reading failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
		
		function powerReadingLoading(start, data)
		{
			if(start) {
				$("#powerReadingHead").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
                $("#powerReadingBody").hide();
			}
			else {
				setTimeout(function(){
					$("#powerReadingHead").html('<h3 class="panel-title"><i class="fa fa-area-chart fa-fw"></i><spring:message code="NodePower14"/></h3>');
                    $("#powerReadingBody").show();
                    
                    if((data != null) && (data.CurrentPower != null)) {
                    	$("#currPower").html(data.CurrentPower);
                    	$("#maxPower").html(data.MaximumPower);
                    	$("#minPower").html(data.MinimumPower);
                    	$("#avgPower").html(data.AveragePower);
                    }
                    else {
                    	$("#powerReadingBody").html("Get power reading failed");
                    }
				}, 100);
			}
		}
		
        function getPowerLimit()
		{
        	powerLimitLoading(true);
        	
			$.ajax({
		        url: 'getPowerLimit',
		        data: {nodeIP:'${IP}'},
		        dataType: 'json',
		        success: function(_data, status, xhr) {
		        	powerLimitLoading(false, _data);
		        },
		        error: function(xhr, status, error) {
		        	powerLimitLoading(false);
		        	console.log("Get power limit failed: [" + xhr.status + "] " + xhr.statusText);
		        },
			    cache: false
		    });
		}
        
        function powerLimitLoading(start, data)
		{
			if(start) {
				$("#powerLimitHead").html("<div style='text-align: center;'><i class='fa fa-circle-o-notch fa-spin fa-2x fa-fw'></i></div>");
                $("#powerLimitBody").hide();
			}
			else {
				setTimeout(function(){
					$("#powerLimitHead").html("<h3 class='panel-title'><i class='fa fa-area-chart fa-fw'></i><spring:message code='NodePower1'/></h3>");
                    $("#powerLimitBody").show();
                    
                    if((data != null) && (data.plValue != -1)) {
	                    <c:if test="${var_not_Access_Configuration}">$("#enablePowerlimit").prop("checked", true);</c:if>
                        $("#enablePowerlimit").bootstrapSwitch('state', true);
                        <sec:authorize ifAnyGranted="${Access_Configuration}">$("input[id=powerLimitValue]").prop("disabled", false);</sec:authorize>
                        <sec:authorize ifAnyGranted="${Access_Configuration}">$("input[id=samplingPeriodValue]").prop("disabled", false);</sec:authorize>
                        <sec:authorize ifAnyGranted="${Access_Configuration}">$("input[id=correctionTimeLimitValue]").prop("disabled", false);</sec:authorize>
                        <sec:authorize ifAnyGranted="${Access_Configuration}">$("select[id=exceptionActionValue]").prop("disabled", false);</sec:authorize>
                        $("#powerLimitValue").val(data.plValue);
                        $("#samplingPeriodValue").val(data.spValue);
                        $("#correctionTimeLimitValue").val(data.ctlValue);
                        $("#exceptionActionValue").val(data.eaValue);
		        	}
                    else {
                    	<c:if test="${var_not_Access_Configuration}">$("#enablePowerlimit").prop("checked", false);</c:if>
                        $("#enablePowerlimit").bootstrapSwitch('state', false);
                        $("input[id=powerLimitValue]").prop("disabled", true);
                        $("input[id=samplingPeriodValue]").prop("disabled", true);
                        $("input[id=correctionTimeLimitValue]").prop("disabled", true);
                        $("select[id=exceptionActionValue]").prop("disabled", true);
                    }
				}, 100);
			}
		}
        
		function setPowerLimit()
		{
			var enable = $("#enablePowerlimit").is(":checked");
			var plValue = $("#powerLimitValue").val();
			var spValue = $("#samplingPeriodValue").val();
			var ctlValue = $("#correctionTimeLimitValue").val();
			var eaValue = $("#exceptionActionValue").val();
			
			if(enable && (plValue == "")) {
				alert("Please set power limit value.");
				return;
			}
			if(plValue == "0") {
				alert("Power limit cannot set to 0.");
				return;
			}
			
			window.location.href = "./SetPowerLimit?IP=" + '${IP}' + "&Enable=" + enable + "&Value=" + plValue + "," + spValue + "," + ctlValue + "," + eaValue;
		}
        
        function initPowerChartjsChart()
        {
       		powerChartjsChart = new Chart(document.getElementById("chartjs-area-chart").getContext("2d"), {
   	            type: 'line',
   	            data: {
   	                labels: [],
   	                datasets: []
   	            },
   	            options: {
   	                responsive: true,
   					maintainAspectRatio: false,
   	                legend: {
   	                	display: true,
   	                	position: "right"
   	                },
   	                title: {
   	                    display: false
   	                },
   	                hover: {
   	                    mode: "point"
   	                },
   	                tooltips: {
   	                	mode: "point"
   	                },
   	                scales: {
   	                    xAxes: [{
   	                        display: true,
   	                        type: "time",
   	                        scaleLabel: {
   	                            display: false
   	                        },
   	                        ticks: {
   	                        },
   	                        gridLines: {
   	                        	display:false
   	                        }
	                        ,time: {
	                        	unit: 'minutes',
	                        	stepSize: 1,
			                    displayFormats: {
			                    	'minutes': 'YYYY-MM-DD HH:mm',
			                    	'hours': 'YYYY-MM-DD HH:mm',
			                    	'days': 'YYYY-MM-DD',
			                    	'months': 'YYYY-MM-DD'
			                    }
	                        }
   	                    }],
   	                    yAxes: [{
   	                    	id: "y-axis-power",
   	                        position: "left",
   	                        display: true,
   	                        scaleLabel: {
   	                            display: true,
   	                            labelString: "Power Consumption"
   	                        },
   	                        ticks: {
   	                        	min: 0
   	                        },
   	                        gridLines: {
   	                        	display:true
   	                        }
   	                   	}, {
   	                    	id: "y-axis-cups",
   	                        position: "right",
   	                        display: true,
   	                        scaleLabel: {
   	                            display: true,
   	                            labelString: "CUPS Value"
   	                        },
   	                        ticks: {
   	                        	min: 0,
   	                        	max: 100
   	                        },
   	                        gridLines: {
   	                        	display:false
   	                        }
   	                    }]
   	                },
   	                animation: false
   	            }
   	        });
        }
		
		function refreshPowerChartjsChart()
		{
			if(powerChartRefreshEnabled)
				updatePowerChartjsChart();
			
			setTimeout(refreshPowerChartjsChart, powerChartRefreshInterval);
		}
        
        function updatePowerChartjsChart()
        {
            //Avoid variables that are illegal
            if(isNaN(powerChartStartTime)) {
                powerChartStartTime = "";
                powerChartEndTime = "";
            }
            
            $.ajax({
                url: "getSensorHistory",
                data: {ip: bmcIP, start: powerChartStartTime, end: powerChartEndTime, type: "CUPS", range: powerChartSelectedRange},
                dataType: "json",
                success: function(_data, status, xhr) {
                    if(_data.data.length > 0) {
                        //Sort the source data by date
                        _data.data = _data.data.sort(function(a, b) {
                            a = JSON.parse(a);
                            b = JSON.parse(b);
                            return a.period > b.period ? 1 : -1;
                        });

                        //Clone soruce data for calculate median value.
                        var source_data = jQuery.extend(true, {}, _data);

                        //Adjust some data.
                        for(var i=0; i<_data.data.length ; i++) {
                            var dataObj = JSON.parse(_data.data[i]);
                            var tempPeriod = 0;
                            var dataChanged = false;

                            for(var data in dataObj) {
                                //Connect or Hide the none data part (value is -1 or < 0).
                                if(dataObj[data] < 0) {
                                    //If previous data and next data not null, then calculate median value and use it, otherwise set to null.
                                    if((i>0) && (i<(_data.data.length-1))) {
                                        var preData = JSON.parse(source_data.data[i-1])[data];
                                        var nextData = JSON.parse(source_data.data[i+1])[data];
                                        if((preData == null) || (preData < 0) || (nextData == null) || (nextData < 0)) {
                                            dataObj[data] = null;
                                        }
                                        else {
                                            dataObj[data] = (preData + nextData) / 2;
                                        }
                                    }
                                    else {
                                        dataObj[data] = null;
                                    }

                                    dataChanged = true;
                                }
                                //Get the Minimum period and maximum period
                                if (data == "period" && powerChartSelectedRange != 0) {
                                    tempPeriod = dataObj["period"];
                                    if (tempPeriod < powerChartMinPeriod){
                                        powerChartMinPeriod = tempPeriod;
                                    }
                                    else if(tempPeriod > powerChartMaxPeriod) {
                                            powerChartMaxPeriod = tempPeriod;
                                    }
                                }

                                //Convert the CPU/Memory/IO value to percentage values.
                                if((data == "CPU") || (data == "Memory") || (data == "I/O")) {
                                    if((dataObj[data] != null) && (dataObj[data] != 0)) {
                                        dataObj[data] = (dataObj[data] / 255) * 100;

                                        dataChanged = true;
                                    }
                                }
                            }

                            if(dataChanged)
                                _data.data[i] = JSON.stringify(dataObj);
                        }

                        var temp;
                        var diffPeriod = powerChartMaxPeriod - powerChartMinPeriod;
                        powerChartLatestData = JSON.parse(_data.data[0]);
                        for (var data in powerChartLatestData) {
                            if (powerChartLatestData[data] != null)
                                powerChartLatestData[data] = null;
                        }
                        if (powerChartSelectedRange == 1) {
                            if (diffPeriod < 3600000) {                         //1 hour
                                temp = 3600000 - (diffPeriod);
                                powerChartLatestData["period"] = powerChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(powerChartLatestData)); 
                            }
                        }
                        else if (powerChartSelectedRange == 2) {
                            if (diffPeriod < 86400000) {                        //1 day
                                temp = 86400000 - (diffPeriod);
                                powerChartLatestData["period"] = powerChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(powerChartLatestData)); 
                            }
                        }
                        else if (powerChartSelectedRange == 3) {
                            if (diffPeriod < 604800000) {                       //1 week
                                temp = 604800000 - (diffPeriod);
                                powerChartLatestData["period"] = powerChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(powerChartLatestData));
                            }
                        } 
                        else if (powerChartSelectedRange == 4) {
                            if (diffPeriod < 2592000000) {                      //1 month
                                temp = 2592000000 - (diffPeriod);
                                powerChartLatestData["period"] = powerChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(powerChartLatestData));
                            }
                        }
                        else if (powerChartSelectedRange == 5) {
                            if (diffPeriod < 31557600000) {                     //1 year
                                temp = 31557600000 - (diffPeriod);
                                powerChartLatestData["period"] = powerChartMinPeriod - temp;
                                _data.data.push(JSON.stringify(powerChartLatestData));
                            }
                        }

                        setPowerChartjsChart(_data);
                    }
                    else {
                    	console.log("There is no power consumption information data of ${IP} in the database.");
                    	if(powerChartSelectedRange == 0) {
                    		setPowerChartjsChart({});
                    	}
                    }
                },
                error: function(xhr, status, error) {
                    alert("Load chart failed.");
                    console.log("Load chart failed: [" + xhr.status + "] " + xhr.statusText);
                },
                cache: false
            });
        }
        
        function setPowerChartjsChart(dataset)
        {
            //Reset data
			powerChartjsChart.config.data.datasets = [];
			powerChartjsChart.config.data.labels = [];
			powerChartjsDatasetMap = {};
			
			//Add new dataset config and label of each source data
			if('y_keys' in dataset) {
				var count = 0;
				for(var key in dataset.y_keys) {
					//Power or CUPS use different y-axis, and Power and CUPS-Index use bold line.
					if(dataset.y_keys[key] == "Power")
		    			powerChartjsChart.config.data.datasets.push({label:dataset.y_keys[key], borderColor:powerChartjsColor[count%powerChartjsColor.length], borderWidth:3, backgroundColor:powerChartjsColor[count%powerChartjsColor.length], data:[], fill:false, yAxisID:"y-axis-power"});
					else if(dataset.y_keys[key] == "Index")
		    			powerChartjsChart.config.data.datasets.push({label:"CUPS " + dataset.y_keys[key], borderColor:powerChartjsColor[count%powerChartjsColor.length], borderWidth:3, backgroundColor:powerChartjsColor[count%powerChartjsColor.length], data:[], fill:false, yAxisID:"y-axis-cups"});
					else
		    			powerChartjsChart.config.data.datasets.push({label:dataset.y_keys[key], borderColor:powerChartjsColor[count%powerChartjsColor.length], borderWidth:1, backgroundColor:powerChartjsColor[count%powerChartjsColor.length], data:[], fill:false, yAxisID:"y-axis-cups"});
		    		powerChartjsDatasetMap[dataset.y_keys[key]] = count;
		    		count++;
	    		}
			}
			
			if('data' in dataset) {
				//Sort the source data by date
				dataset.data = dataset.data.sort(function(a, b) {
					a = JSON.parse(a);
					b = JSON.parse(b);
					return a.period > b.period ? 1 : -1;
				});
				
				//Add source data to dataset.
				for(var i=0; i<dataset.data.length ; i++) {
		    		var dataObj = JSON.parse(dataset.data[i]);
		    		
		    		for(var data in dataObj) {
			    		if(data == "period")
			    			powerChartjsChart.config.data.labels.push(new Date(dataObj["period"]));
			    		else
			    			powerChartjsChart.config.data.datasets[powerChartjsDatasetMap[data]].data.push(dataObj[data]);
		    		}
		    	}
			}
			
			var powerChartSelectedRangeTemp = -1;
			if((powerChartSelectedRange == 0) && (powerChartStartTime !== "") && (powerChartEndTime !== "")) {
				powerChartSelectedRangeTemp = powerChartSelectedRange;
				var diffTime = powerChartEndTime - powerChartStartTime;
                if (diffTime >= 31557600000) { //year
                	powerChartSelectedRange = 5;
                }
                else if (diffTime >= 2592000000) { //month
                	powerChartSelectedRange = 4;
                }
                else if (diffTime >= 604800000) { //week
                	powerChartSelectedRange = 3;
                }
                else if (diffTime >= 86400000) { //day
                	powerChartSelectedRange = 2;
                }
        		else { //hour
        			powerChartSelectedRange = 1;
                }
			}
			
			//Change the x-axis scale label unit and period
			switch(parseInt(powerChartSelectedRange)) {
				default:
				//manual
				case 0:
				//hour
				case 1: {
					powerChartjsChart.config.options.scales.xAxes[0].time.unit = "minutes";
					powerChartjsChart.config.options.scales.xAxes[0].time.stepSize = 5;
					break;
				}
				//day
				case 2: {
					powerChartjsChart.config.options.scales.xAxes[0].time.unit = "hours";
					powerChartjsChart.config.options.scales.xAxes[0].time.stepSize = 1;
					break;
				}
				//week
				case 3: {
					powerChartjsChart.config.options.scales.xAxes[0].time.unit = "days";
					powerChartjsChart.config.options.scales.xAxes[0].time.stepSize = 1;
					break;
				}
				//month
				case 4: {
					powerChartjsChart.config.options.scales.xAxes[0].time.unit = "days";
					powerChartjsChart.config.options.scales.xAxes[0].time.stepSize = 2;
					break;
				}
				//year
				case 5: {
					powerChartjsChart.config.options.scales.xAxes[0].time.unit = "months";
					powerChartjsChart.config.options.scales.xAxes[0].time.stepSize = 1;
					break;
				}
			}
			
			if(powerChartSelectedRangeTemp !== -1)
				powerChartSelectedRange = powerChartSelectedRangeTemp;
			
			powerChartjsChart.update();
        }
	</script>
</body>
</html>
