<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<link rel="shortcut icon" href="https://www.gigabyte.com/Images/favicon_b.ico" type="image/x-icon" />
	<head>
		<title>GIGABYTE GSM</title>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<!-- CSS -->
		<link href="<c:url value="/resources/css/bootstrap/bootstrap.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/font-awesome/css/font-awesome.min.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/form-elements.css" />" rel="stylesheet">
		<link href="<c:url value="/resources/css/bootstrap/style1.css" />" rel="stylesheet" >
	</head>
	
	<body style="background-image:none; background-color:black;>
		<nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
			<div class="navbar-brand">
				<img src="/GSM/GSMLogo_Get/gsm_logo.png">
			</div>
			<!--
			<ul class="nav navbar-nav navbar-right">
				<li class="dropdown">
					<a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-globe"></i> Language <b class="caret"></b></a>
					<ul class="dropdown-menu">
						<li><a href="login?language=tw">繁體中文</a></li>
						<li><a href="login?language=en">English</a></li>
						<li class="divider"></li>
						<li><a href="#">Auto detect</a></li>
					</ul>
				</li>
			</ul>
			-->
		</nav>
		
		<nav class="navbar"></nav>
		
		<!-- Top content -->
		<div class="top-content">
			<div class="inner-bg">
				<div class="container">
					<div class="row">
						<div class="col-sm-6 col-sm-offset-3 form-box">
							<div class="form-top">
								<div class="form-top-left">
									<h3><spring:message code="loginMsg1"/></h3>
									<p><spring:message code="loginMsg2"/></p>
									<c:if test="${not empty error}">
										<c:choose>
											<c:when test="${error==3}">
												<a href="#" data-toggle="modal" data-target="#modify"><font color="red"><div class="error"><spring:message code="loginErrMsg${error}"/></div></font></a>
											</c:when>
											<c:otherwise>
												<font color="red"><div class="error"><spring:message code="loginErrMsg${error}"/></div></font>
											</c:otherwise>
										</c:choose>
									</c:if>
									<c:if test="${not empty msg}">
										<font color="red"><div class="msg"><spring:message code="loginErrMsg${msg}"/></div></font>
									</c:if>
								</div>
								<div class="form-top-right">
									<i class="fa fa-lock"></i>
								</div>
							</div>
							<div class="form-bottom">
								<form action="<c:url value='/j_spring_security_check' />" name="auth" id="auth" method="post" class="login-form">
									<div class="form-group">
										<label class="sr-only" for="username">Username</label>
										<input type="text" name="login_user" placeholder=<spring:message code="userName"/> class="form-username form-control" id="form-username">
									</div>
									<div class="form-group">
										<label class="sr-only" for="userpass">Password</label>
										<input type="password" name="login_password" placeholder=<spring:message code="password"/> class="form-password form-control" id="form-password">
									</div>
									<button type="submit" class="btn"><spring:message code="loginBtn"/></button>
									<input type="hidden" name="${_csrf.parameterName}" value="${_csrf.token}" />
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div style="color:black" class="modal fade" id="modify" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title" id="myModalLabel"><spring:message code="dbAccount"/></h4>
					</div>
					<div class="modal-body">
						<table class="table table-striped table-bordered table-hover">
							<tbody>
								<tr>
									<td><spring:message code="SettingGSM3"/> <spring:message code="userName"/></td>
									<td><input type=text id="db_user" class="form-control" value=""></td>
								</tr>
								<tr>
									<td><spring:message code="SettingGSM3"/> <spring:message code="password"/></td>
									<td><input type=password id="db_password" class="form-control" value=""></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="modal-footer">
						<button type="submit" id="subBtn" onclick="clickedSubmit()" class="btn btn-primary" disabled><spring:message code="Submit"/></button>
						<button type="button" class="btn btn-primary" data-dismiss="modal"><spring:message code="Close"/></button>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Javascript -->
		<script src="<c:url value="/resources/js/bootstrap/jquery.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/bootstrap.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/jquery.backstretch.min.js" />"></script>
		<script src="<c:url value="/resources/js/bootstrap/scripts.js" />"></script>
		<script>
			$(document).ready(function() {
				var errCode = '${errCode}';
				if( errCode == 5 )
					alert("<spring:message code="loginMsg3"/>");
			});
			
			$('#db_user').bind('input', function() {
				var username = $('#db_user').val();
				var password = $('#db_password').val();
				if( username != "" && password != "" )
					$("button[ID=subBtn]").prop('disabled', false);
				else
					$("button[ID=subBtn]").prop('disabled', true);
			});
			
			$('#db_password').bind('input', function() {
				var username = $('#db_user').val();
				var password = $('#db_password').val();
				if( username != "" && password != "" )
					$("button[ID=subBtn]").prop('disabled', false);
				else
					$("button[ID=subBtn]").prop('disabled', true);
			});
			
			function clickedSubmit() {
				var username = document.getElementById('db_user').value;
				var password = document.getElementById('db_password').value;
				window.location.href = "./ChangeProperty?db_user=" + username + "&db_password=" + password;
			}
		</script>
	</body>
</html>