#!/bin/bash
#
#set -x
# getinfo V7
if [ -f cygrunsrv.exe ];then
	CMD_IPMITOOL="./ipmitool.exe"
	CMD_RM="./rm.exe"
	CMD_MKDIR="./mkdir.exe"
	else
	CMD_IPMITOOL="./ipmitool"
	CMD_RM="rm"
	CMD_MKDIR="mkdir"
fi
MOD=$4
if [ ! $MOD ];then 
	MOD=0
	echo "!!!!!!!!!! Module number not specified, forcing module number to 0 !!!!!!!!"
	echo " "
fi
if [ $MOD -gt 3 ] ; then
	echo "!!!!!!!!!! Module number must be between 0 and 3 !!!!!!!!"
	exit
fi
if [ $MOD -lt 0 ] ; then
	echo "!!!!!!!!!! Module number must be between 0 and 3 !!!!!!!!"
	exit
fi
# MAIN
if [ ! -d $1 ];then
	$CMD_MKDIR $1
fi

if [ -f $1/outfile ];then
	$CMD_RM $1/outfile
fi
echo " getinfo V7 " > $1/versions.txt
echo " Module number =  " $MOD >> $1/versions.txt
echo " BMC address =  " $1 >> $1/versions.txt
$CMD_IPMITOOL -V >> $1/versions.txt
echo " getting SEL"
$CMD_IPMITOOL -H $1 -U $2 -P $3 sel list > $1/SEL.txt
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error SEL " >> $1/outfile
fi
echo " getting SDR"
$CMD_IPMITOOL -H $1 -U $2 -P $3 sdr list > $1/sdr.txt
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error SDR " >> $1/outfile
fi
echo " getting FRU"
$CMD_IPMITOOL -H $1 -U $2 -P $3 fru list > $1/fru.txt
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error FRU " >> $1/outfile
fi
# EMM mini 11.09 required for following requests
echo " getting FW versions"
$CMD_IPMITOOL -H $1 -U $2 -P $3 bulloem ver all $MOD  >> $1/versions.txt
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error versions " >> $1/outfile
fi
echo " getting BIOS version"
$CMD_IPMITOOL -H $1 -U $2 -P $3 bulloem biosinfo  >> $1/versions.txt
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error biosinfo " >> $1/outfile
fi
echo " getting BMC configuration"
$CMD_IPMITOOL -H $1 -U $2 -P $3 bulloem backupcfg $1
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error BMC configuration " >> $1/outfile
fi
echo " getting Messages Log"
$CMD_IPMITOOL -H $1 -U $2 -P $3 bulloem getlogs $1 .txt
ret_cmd=$?
if [ $ret_cmd -ne 0 ] ; then
echo " error MsgLog " >> $1/outfile
fi
echo " getting Bios Log"
for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 
do  
$CMD_IPMITOOL -H $1 -U $2 -P $3 bulloem getmel $i $1/Bios_Log$i.bin > /dev/null
done
if [ -f $1/outfile ];then
echo " ====================================================="
echo " Error(s) occured , but the directory $1 may contains valid data. "
echo " Please check the platform to fix error(s)"
echo " Command usage: getinfo7.bat BMC_IP@    user    password   Module_number"
echo " Example : getinfo7.bat 10.10.10.1  super  pass  0 "
echo " ====================================================="
fi
echo " ====================================================="
echo " 'Task done , please zip the directory $1'"
echo " ====================================================="
exit


 
